#include <stdio.h>

main()
{
	FILE *patchfile,*output;

	patchfile=fopen("/bin/su","r");

	if (patchfile==NULL)
	{
		fputs("Unable to open: /bin/su for reading - exiting\n",stderr);

		return 1;
	}

	output=fopen("/bin/su.new","w");

	if (output==NULL)
	{
		fputs("Unable to open: /bin/su.new for writing - exiting\n",stderr);

		return 1;
	}

	patch(patchfile,output);

	fclose(patchfile);

	fclose(output);

	patchfile=fopen("/bin/passwd","r");

	if (patchfile==NULL)
	{
		fputs("Unable to open: /bin/passwd for reading - exiting\n",stderr);

		return 1;
	}

	output=fopen("/bin/passwd.new","w");

	if (output==NULL)
	{
		fputs("Unable to open: /bin/passwd.new for writing - exiting\n",stderr);

		return 1;
	}

	patch(patchfile,output);

	fclose(patchfile);

	fclose(output);
}

patch(input,output)
FILE *input,*output;
{
	int done=0;

	while (!done)
	{
		char c,passwd_file[12];

		int char_pos;

		c=getc(input);

		if (feof(input))
		{
			done=1;
			continue;
		}

		if (c!='/')
		{
			putc(c,output);
			continue;
		}

		passwd_file[0]=c;

		for (char_pos=1;char_pos<11;char_pos++)
		{
			passwd_file[char_pos]=getc(input);

			if (feof(input))
			{
				done=1;
				break;
			}
		}

		passwd_file[11]=0;

		if (!strcmp("/etc/passwd",passwd_file))
		{
			strcpy(passwd_file,"/etc/shadow");
		}

		for (char_pos=0;char_pos<11;char_pos++)
		{
			putc(passwd_file[char_pos],output);
		}
	}
}
