#ifndef COFF_H
#define COFF_H

#ifdef COHERENT
#undef COFF_H
#include <coff.h>
#define FILHDR	FILEHDR
#define I386MAGIC	C_386_MAGIC
#define FILHSZ	sizeof(FILHDR)
#define SCNHSZ	sizeof(SCNHDR)
#else
#include <filehdr.h>
#include <aouthdr.h>
#include <scnhdr.h>
#include <storclass.h>
#include <linenum.h>
#include <syms.h>
#include <reloc.h>
#endif

#include "machine.h"
#include "stack.h"

/* Tag to validate coff object file format processing */
#define coff

/* Define some processor dependent values according to the processor we are
   on. */
#if defined(PROCESSOR_68000)

#define BYTE_ORDERING		F_AR32W    /* See filehdr.h for more info. */
#ifndef FILE_HEADER_MAGIC
#define FILE_HEADER_MAGIC	MC68MAGIC  /* ... */
#endif /* FILE_HEADER_MAGIC */

#elif defined(PROCESSOR_i386)

#define BYTE_ORDERING		F_AR32WR   /* See filehdr.h for more info. */
#ifndef FILE_HEADER_MAGIC
#define FILE_HEADER_MAGIC	I386MAGIC  /* ... */
#endif /* FILE_HEADER_MAGIC */

#elif
you lose
#endif 

/* Magic number of paged executable. */
#define OMAGIC	0413

/* Add these definitions to have a consistent convention for all the
   types used in COFF format. */
#define AOUTHDR			struct aouthdr
#define AOUTHDRSZ		sizeof(AOUTHDR)

/* RELOCATION INFORMATION */

#define relocation_type RELOC	/* Relocation table entry */
 
/* SYMBOL TABLE */

/* Symbol table entry data type */

#define symbol_type SYMENT	/* Symbol table entry */

/* If compiler generate leading underscores, remove them. */

#ifndef STRIP_UNDERSCORE
#define STRIP_UNDERSCORE 0
#endif /* STRIP_UNDERSCORE */
#define DO_NOT_STRIP	0
#define DO_STRIP	1

/* Double linked list manipulations macros. */
/* See struc-symbol.h for a definition of symbolS. */

/* Remove the argument from the list. */
#define DL_REMOVE(p)	\
    (((p)->sy_next && ((p)->sy_next->sy_previous = (p)->sy_previous)),\
     ((p)->sy_previous && ((p)->sy_previous->sy_next = (p)->sy_next)))

/* Set the chain symbols to null. */
#define DL_CLEAR(p)	\
    ((p)->sy_next = (symbolS*)0, (p)->sy_previous = (symbolS*)0)

/* Link symbol p after symbol w in the chain. */
#define DL_APPEND(p,w)	\
    (((w)->sy_next && ((w)->sy_next->sy_previous = (p))),	\
     ((p)->sy_next = (w)->sy_next),				\
     ((w)->sy_next = (p)),       				\
     ((p)->sy_previous = (w)))

/* Link symbol p before symbol w in the chain. */
#define DL_INSERT(p,w)	\
    (((w)->sy_previous && ((w)->sy_previous->sy_next = (p))),	\
     ((p)->sy_previous = (w)->sy_previous),			\
     ((w)->sy_previous = (p)),					\
     ((p)->sy_next = (w)))

/* Symbol table macros and constants */

/* Possible and usefull section number in symbol table 
 * The values of TEXT, DATA and BSS may not be portable.
 */

#define C_TEXT_SECTION		1
#define C_DATA_SECTION		2
#define C_BSS_SECTION		3
#define C_ABS_SECTION		N_ABS
#define C_UNDEF_SECTION		N_UNDEF
#define C_DEBUG_SECTION		N_DEBUG
#define C_NTV_SECTION		N_TV
#define C_PTV_SECTION		P_TV

/*
 *  Macros to extract information from a symbol table entry.
 *  This syntaxic indirection allows independence regarding a.out or coff.
 *  The argument (s) of all these macros is a pointer to a symbol table entry.
 */

/* Predicates */
/* True if in text segment */
#define S_IS_TEXT(s)		((s)->sy_scnum == C_TEXT_SECTION)
/* True if in data segment */
#define S_IS_DATA(s)		((s)->sy_scnum == C_DATA_SECTION)
/* True if in bss segment */
#define S_IS_BSS(s)		((s)->sy_scnum == C_BSS_SECTION)
/* True if in bss segment */
#define S_IS_ABS(s)		((s)->sy_scnum == C_ABS_SECTION)
/* True if the symbol is external */
#define S_IS_EXTERNAL(s)        ((s)->sy_scnum == C_UNDEF_SECTION)
/* True if symbol has been defined, ie :
  section > 0 (DATA, TEXT or BSS)
  section == 0 and value > 0 (external bss symbol) */
#define S_IS_DEFINED(s)         ((s)->sy_scnum > C_UNDEF_SECTION || \
				 ((s)->sy_scnum == C_UNDEF_SECTION && \
				  (s)->sy_value > 0))
/* True if a debug special symbol entry */
#define S_IS_DEBUG(s)		((s)->sy_scnum == C_DEBUG_SECTION)
/* True if a symbol is local symbol name */
/* A symbol name whose name begin with ^A is a gas internal pseudo symbol */
#define S_IS_LOCAL(s)		(S_GET_NAME(s)[0] == '\001' || \
				 (S_LOCAL_NAME(s) && !flagseen['L']))
/* True if a symbol is not defined in this file */
#define S_IS_EXTERN(s)		((s)->sy_scnum == 0 && (s)->sy_value == 0)
/*
 * True if a symbol can be multiply defined (bss symbols have this def
 * though it is bad practice)
 */
#define S_IS_COMMON(s)		((s)->sy_scnum == 0 && (s)->sy_value != 0)
/* True if a symbol name is in the string table, i.e. its length is > 8. */
#define S_IS_STRING(s)		(strlen(S_GET_NAME(s)) > 8 ? 1 : 0)

/* Accessors */
/* The name of the symbol */
#define S_GET_NAME(s)		((char*)(s)->sy_offset)
/* The pointer to the string table */
#define S_GET_OFFSET(s)         ((s)->sy_offset)
/* The zeroes if symbol name is longer than 8 chars */
#define S_GET_ZEROES(s)		((s)->sy_zeroes)
/* The value of the symbol */
#define S_GET_VALUE(s)		((s)->sy_value)
/* The numeric value of the segment */
#define S_GET_SEGMENT(s)        ((s)->sy_scnum)
/* The data type */
#define S_GET_DATA_TYPE(s)	((s)->sy_type)
/* The storage class */
#define S_GET_STORAGE_CLASS(s)	((s)->sy_sclass)
/* The number of auxiliary entries */
#define S_GET_NUMBER_AUXILIARY(s)	((s)->sy_numaux)

/* Modifiers */
/* Set the name of the symbol */
#define S_SET_NAME(s,v)		((s)->sy_offset = (unsigned long)(v))
/* Set the offset of the symbol */
#define S_SET_OFFSET(s,v)	((s)->sy_offset = (v))
/* The zeroes if symbol name is longer than 8 chars */
#define S_SET_ZEROES(s,v)		((s)->sy_zeroes = (v))
/* Set the value of the symbol */
#define S_SET_VALUE(s,v)	((s)->sy_value = (v))
/* The numeric value of the segment */
#define S_SET_SEGMENT(s,v)        ((s)->sy_scnum = (v))
/* The data type */
#define S_SET_DATA_TYPE(s,v)	((s)->sy_type = (v))
/* The storage class */
#define S_SET_STORAGE_CLASS(s,v)	((s)->sy_sclass = (v))
/* The number of auxiliary entries */
#define S_SET_NUMBER_AUXILIARY(s,v)	((s)->sy_numaux = (v))

/* Additional modifiers */
/* Assume that a symbol cannot be simultaneously in more than on segment */
/* Set the segment to text */
#define S_SET_TEXT(s)		((s)->sy_scnum = C_TEXT_SECTION)
/* Set the segment to data */
#define S_SET_DATA(s)		((s)->sy_scnum = C_DATA_SECTION)
/* Set the segment to bss */
#define S_SET_BSS(s)		((s)->sy_scnum = C_BSS_SECTION)
/* Set the segment to abs */
#define S_SET_ABS(s)		((s)->sy_scnum = C_ABS_SECTION)
/* The symbol is external (does not mean undefined) */
#define S_SET_EXTERNAL(s)       S_SET_STORAGE_CLASS(s,C_EXT)

/* Auxiliary entry macros. SA_ stands for symbol auxiliary */
/* Omit the tv related fields */
/* Accessors */
#define SA_GET_SYM_TAGNDX(s)	((s)->sy_auxent.x_sym.x_tagndx)
#define SA_GET_SYM_LNNO(s)	((s)->sy_auxent.x_sym.x_misc.x_lnsz.x_lnno)
#define SA_GET_SYM_SIZE(s)	((s)->sy_auxent.x_sym.x_misc.x_lnsz.x_size)
#define SA_GET_SYM_FSIZE(s)	((s)->sy_auxent.x_sym.x_misc.x_fsize)
#define SA_GET_SYM_LNNOPTR(s)	((s)->sy_auxent.x_sym.x_fcnary.x_fcn.x_lnnoptr)
#define SA_GET_SYM_ENDNDX(s)	((s)->sy_auxent.x_sym.x_fcnary.x_fcn.x_endndx)
#define SA_GET_SYM_DIMEN(s,i)	((s)->sy_auxent.x_sym.x_fcnary.x_ary.x_dimen[(i)])
#define SA_GET_FILE_FNAME(s)	((s)->sy_auxent.x_file.x_fname)
#define SA_GET_SCN_SCNLEN(s)	((s)->sy_auxent.x_scn.x_scnlen)
#define SA_GET_SCN_NRELOC(s)	((s)->sy_auxent.x_scn.x_nreloc)
#define SA_GET_SCN_NLINNO(s)	((s)->sy_auxent.x_scn.x_nlinno)

/* Modifiers */
#define SA_SET_SYM_TAGNDX(s,v)	((s)->sy_auxent.x_sym.x_tagndx=(v))
#define SA_SET_SYM_LNNO(s,v)	((s)->sy_auxent.x_sym.x_misc.x_lnsz.x_lnno=(v))
#define SA_SET_SYM_SIZE(s,v)	((s)->sy_auxent.x_sym.x_misc.x_lnsz.x_size=(v))
#define SA_SET_SYM_FSIZE(s,v)	((s)->sy_auxent.x_sym.x_misc.x_fsize=(v))
#define SA_SET_SYM_LNNOPTR(s,v)	((s)->sy_auxent.x_sym.x_fcnary.x_fcn.x_lnnoptr=(v))
#define SA_SET_SYM_ENDNDX(s,v)	((s)->sy_auxent.x_sym.x_fcnary.x_fcn.x_endndx=(v))
#define SA_SET_SYM_DIMEN(s,i,v)	((s)->sy_auxent.x_sym.x_fcnary.x_ary.x_dimen[(i)]=(v))
#define SA_SET_FILE_FNAME(s,v)	strncpy((s)->sy_auxent.x_file.x_fname,(v),FILNMLEN)
#define SA_SET_SCN_SCNLEN(s,v)	((s)->sy_auxent.x_scn.x_scnlen=(v))
#define SA_SET_SCN_NRELOC(s,v)	((s)->sy_auxent.x_scn.x_nreloc=(v))
#define SA_SET_SCN_NLINNO(s,v)	((s)->sy_auxent.x_scn.x_nlinno=(v))

/* Internal use only definitions. SF_ stands for symbol flags. */

/* These values can be assigned to sy_flags field of a symbolS */
/* The first 16 bits are general purpose. The last 16 bits are debug info */

#define SF_STATICS		0x00000001 /* Mark the .text & all symbols */
#define SF_DEFINED		0x00000002 /* Symbol is defined in this file */
#define SF_STRING		0x00000004 /* Symbol name length > 8 */
#define SF_LOCAL		0x00000008 /* Symbol must not be emitted */

#define SF_FUNCTION		0x00010000 /* The symbol is a function */
#define SF_PROCESS		0x00020000 /* Process symbol before write */
#define SF_TAGGED		0x00040000 /* Is associated with a tag */
#define SF_TAG			0x00080000 /* Is a tag */
#define SF_DEBUG		0x00100000 /* Is in debug or abs section */
#define SF_GET_SEGMENT		0x00200000 /* Get the section of the forward
					      symbol. */
#define SF_FORWARD_TAG		0x00400000 /* Is associated with a tag that
					      is a forward reference. */


/* Masks */
#define SF_NORMAL_MASK		0x0000ffff /* Non debug information */
#define SF_DEBUG_MASK		0xffff0000 /* Debug information */

/* Accessors */
#define SF_GET(s)		((s)->sy_flags)
#define SF_GET_NORMAL_FIELD(s)	((s)->sy_flags & SF_NORMAL_MASK)
#define SF_GET_DEBUG_FIELD(s)	((s)->sy_flags & SF_DEBUG_MASK)
#define SF_GET_FILE(s)		((s)->sy_flags & SF_FILE)
#define SF_GET_STATICS(s)	((s)->sy_flags & SF_STATICS)
#define SF_GET_DEFINED(s)	((s)->sy_flags & SF_DEFINED)
#define SF_GET_STRING(s)	((s)->sy_flags & SF_STRING)
#define SF_GET_LOCAL(s)		((s)->sy_flags & SF_LOCAL)
#define SF_GET_FUNCTION(s)      ((s)->sy_flags & SF_FUNCTION)
#define SF_GET_PROCESS(s)	((s)->sy_flags & SF_PROCESS)
#define SF_GET_DEBUG(s)		((s)->sy_flags & SF_DEBUG)
#define SF_GET_TAGGED(s)	((s)->sy_flags & SF_TAGGED)
#define SF_GET_FORWARD_TAG(s)	((s)->sy_flags & SF_FORWARD_TAG)
#define SF_GET_TAG(s)		((s)->sy_flags & SF_TAG)
#define SF_GET_GET_SEGMENT(s)	((s)->sy_flags & SF_GET_SEGMENT)

/* Modifiers */
#define SF_SET(s,v)		((s)->sy_flags = (v))
#define SF_SET_NORMAL_FIELD(s,v)((s)->sy_flags |= ((v) & SF_NORMAL_MASK))
#define SF_SET_DEBUG_FIELD(s,v)	((s)->sy_flags |= ((v) & SF_DEBUG_MASK))
#define SF_SET_FILE(s)		((s)->sy_flags |= SF_FILE)
#define SF_SET_STATICS(s)	((s)->sy_flags |= SF_STATICS)
#define SF_SET_DEFINED(s)	((s)->sy_flags |= SF_DEFINED)
#define SF_SET_STRING(s)	((s)->sy_flags |= SF_STRING)
#define SF_SET_LOCAL(s)		((s)->sy_flags |= SF_LOCAL)
#define SF_SET_FUNCTION(s)      ((s)->sy_flags |= SF_FUNCTION)
#define SF_SET_PROCESS(s)	((s)->sy_flags |= SF_PROCESS)
#define SF_SET_DEBUG(s)		((s)->sy_flags |= SF_DEBUG)
#define SF_SET_TAGGED(s)	((s)->sy_flags |= SF_TAGGED)
#define SF_SET_FORWARD_TAG(s)	((s)->sy_flags |= SF_FORWARD_TAG)
#define SF_SET_TAG(s)		((s)->sy_flags |= SF_TAG)
#define SF_SET_GET_SEGMENT(s)	((s)->sy_flags |= SF_GET_SEGMENT)

/* File header macro and type definition */

/*
 * File position calculators. Beware to use them when all the
 * appropriate fields are set in the header.
 */

#define H_GET_FILE_SIZE(h) \
    (long)(FILHSZ + H_GET_SIZEOF_OPTIONAL_HEADER(h) + \
	   H_GET_NUMBER_OF_SECTIONS(h) * SCNHSZ + \
	   H_GET_TEXT_SIZE(h) + H_GET_DATA_SIZE(h) + \
	   H_GET_RELOCATION_SIZE(h) + H_GET_LINENO_SIZE(h) + \
	   H_GET_SYMBOL_TABLE_SIZE(h) * SYMESZ + \
	   (h)->string_table_size)
#define H_GET_TEXT_FILE_OFFSET(h) \
    (long)(FILHSZ + H_GET_SIZEOF_OPTIONAL_HEADER(h) + \
	   H_GET_NUMBER_OF_SECTIONS(h) * SCNHSZ)
#define H_GET_DATA_FILE_OFFSET(h) \
    (long)(FILHSZ + H_GET_SIZEOF_OPTIONAL_HEADER(h) + \
	   H_GET_NUMBER_OF_SECTIONS(h) * SCNHSZ + \
	   H_GET_TEXT_SIZE(h))
#define H_GET_BSS_FILE_OFFSET(h) 0
#define H_GET_RELOCATION_FILE_OFFSET(h) \
    (long)(FILHSZ + H_GET_SIZEOF_OPTIONAL_HEADER(h) + \
	   H_GET_NUMBER_OF_SECTIONS(h) * SCNHSZ + \
	   H_GET_TEXT_SIZE(h) + H_GET_DATA_SIZE(h))
#define H_GET_LINENO_FILE_OFFSET(h) \
    (long)(FILHSZ + H_GET_SIZEOF_OPTIONAL_HEADER(h) + \
	   H_GET_NUMBER_OF_SECTIONS(h) * SCNHSZ + \
	   H_GET_TEXT_SIZE(h) + H_GET_DATA_SIZE(h) + \
	   H_GET_RELOCATION_SIZE(h))
#define H_GET_SYMBOL_TABLE_FILE_OFFSET(h) \
    (long)(FILHSZ + H_GET_SIZEOF_OPTIONAL_HEADER(h) + \
	   H_GET_NUMBER_OF_SECTIONS(h) * SCNHSZ + \
	   H_GET_TEXT_SIZE(h) + H_GET_DATA_SIZE(h) + \
	   H_GET_RELOCATION_SIZE(h) + H_GET_LINENO_SIZE(h))

/* Accessors */
/* aouthdr */
#define H_GET_MAGIC_NUMBER(h)           ((h)->aouthdr.magic)
#define H_GET_VERSION_STAMP(h)		((h)->aouthdr.vstamp)
#define H_GET_TEXT_SIZE(h)              ((h)->aouthdr.tsize)
#define H_GET_DATA_SIZE(h)              ((h)->aouthdr.dsize)
#define H_GET_BSS_SIZE(h)               ((h)->aouthdr.bsize)
#define H_GET_ENTRY_POINT(h)            ((h)->aouthdr.entry)
#define H_GET_TEXT_START(h)		((h)->aouthdr.text_start)
#define H_GET_DATA_START(h)		((h)->aouthdr.data_start)
/* filehdr */
#define H_GET_FILE_MAGIC_NUMBER(h)	((h)->filehdr.f_magic)
#define H_GET_NUMBER_OF_SECTIONS(h)	((h)->filehdr.f_nscns)
#define H_GET_TIME_STAMP(h)		((h)->filehdr.f_timdat)
#define H_GET_SYMBOL_TABLE_POINTER(h)	((h)->filehdr.f_symptr)
#define H_GET_SYMBOL_TABLE_SIZE(h)	((h)->filehdr.f_nsyms)
/* The trick is here to solve assignement order problems in write.c
   We want to use H_GET_SIZEOF_OPTIONAL_HEADER macro even if f_opthdr
   has not been set. This leads to cleaner code in write.c */
#ifdef NO_OPTIONAL_HEADER
#define H_GET_SIZEOF_OPTIONAL_HEADER(h)	0
#else /* NO_OPTIONAL_HEADER */
#define H_GET_SIZEOF_OPTIONAL_HEADER(h)	(AOUTHDRSZ)
#endif /* NO_OPTIONAL_HEADER */
#define H_GET_FLAGS(h)			((h)->filehdr.f_flags)
/* Extra fields to achieve bsd a.out compatibility and for convinience */
#define H_GET_RELOCATION_SIZE(h)   	((h)->relocation_size)
#define H_GET_STRING_SIZE(h)            ((h)->string_table_size)
#define H_GET_LINENO_SIZE(h)            ((h)->lineno_size)

/* Modifiers */
/* aouthdr */
#define H_SET_MAGIC_NUMBER(h,v)         ((h)->aouthdr.magic = (v))
#define H_SET_VERSION_STAMP(h,v)	((h)->aouthdr.vstamp = (v))
#define H_SET_TEXT_SIZE(h,v)            ((h)->aouthdr.tsize = (v))
#define H_SET_DATA_SIZE(h,v)            ((h)->aouthdr.dsize = (v))
#define H_SET_BSS_SIZE(h,v)             ((h)->aouthdr.bsize = (v))
#define H_SET_ENTRY_POINT(h,v)          ((h)->aouthdr.entry = (v))
#define H_SET_TEXT_START(h,v)		((h)->aouthdr.text_start = (v))
#define H_SET_DATA_START(h,v)		((h)->aouthdr.data_start = (v))
/* filehdr */
#define H_SET_FILE_MAGIC_NUMBER(h,v)	((h)->filehdr.f_magic = (v))
#define H_SET_NUMBER_OF_SECTIONS(h,v)	((h)->filehdr.f_nscns = (v))
#define H_SET_TIME_STAMP(h,v)		((h)->filehdr.f_timdat = (v))
#define H_SET_SYMBOL_TABLE_POINTER(h,v)	((h)->filehdr.f_symptr = (v))
#define H_SET_SYMBOL_TABLE_SIZE(h,v)    ((h)->filehdr.f_nsyms = (v))
#define H_SET_SIZEOF_OPTIONAL_HEADER(h,v) ((h)->filehdr.f_opthdr = (v))
#define H_SET_FLAGS(h,v)		((h)->filehdr.f_flags = (v))
/* Extra fields to achieve bsd a.out compatibility and for convinience */
#define H_SET_RELOCATION_SIZE(h,t,d) 	((h)->relocation_size = (t)+(d))
#define H_SET_STRING_SIZE(h,v)          ((h)->string_table_size = (v))
#define H_SET_LINENO_SIZE(h,v)          ((h)->lineno_size = (v))

/* Output the file(s) header(s) in a character array */
#define H_OUTPUT(h,where) c_header_append(&(h)->aouthdr, &(h)->filehdr,(where))

/* Output a symbol entry */
#define SYMBOL_OUTPUT(s,w)	c_symbol_append((s), (w))

typedef struct {
    AOUTHDR	   aouthdr;             /* a.out header */
    FILHDR	   filehdr;		/* File header, not machine dep. */
    long int       string_table_size;   /* names + '\0' + sizeof(int) */
    long int	   relocation_size;	/* Cumulated size of relocation
					   information for all sections in
					   bytes. */
    long int	   lineno_size;		/* Size of the line number information
					   table in bytes */
} object_headers;

/* Format independent interface functions */
extern void             emit_relocations();
extern void		emit_symbols();
extern void		c_symbol_merge();
extern void             c_header_append();
extern void             c_symbol_append();
extern void		c_section_header_append();
extern char*		c_section_symbol();
extern void		c_section_header();

/* --------------  Line number handling ------- */
extern int		text_lineno_number;

typedef struct internal_lineno {
    LINENO line;			/* The lineno structure itself */
    char* frag;				/* Frag the line number is related to*/
    struct internal_lineno* next;	/* Forward chain pointer */
} lineno;

extern lineno* c_new_file();
extern void    emit_lineno();
extern lineno* lineno_rootP;
extern lineno* lineno_lastP;
#endif /* COFF_H */


