#ifndef AOUT_H
#define AOUT_H

#include "machine.h"

#ifndef		VMS
#include "a.out.gnu.h"		/* Needed to define struct nlist. Sigh. */
#else
#include "a_out.h"
#endif

/* Tag to validate a.out object file format processing */
#define aout

/* RELOCATION INFORMATION */

#define relocation_type struct relocation_info	/* Relocation table entry */
#define RELSZ sizeof(relocation_type)		/* For coff compatibility */
 
/* SYMBOL TABLE */
/* Symbol table entry data type */

#define symbol_type struct nlist	/* Symbol table entry */

/* If compiler generate leading underscores, remove them. */

#ifndef STRIP_UNDERSCORE
#define STRIP_UNDERSCORE 0
#endif /* STRIP_UNDERSCORE */

/* Symbol table macros and constants */

/*
 *  Macros to extract information from a symbol table entry.
 *  This syntaxic indirection allows independence regarding a.out or coff.
 *  The argument (s) of all these macros is a pointer to a symbol table entry.
 */

/* Predicates */
/* True if in text segment */
#define S_IS_TEXT(s)		(((s)->sy_type & N_TYPE) == N_TEXT)
/* True if in data segment */
#define S_IS_DATA(s)		(((s)->sy_type & N_TYPE) == N_DATA)
/* True if in bss segment */
#define S_IS_BSS(s)		(((s)->sy_type & N_TYPE) == N_BSS)
/* True if in abs segment */
#define S_IS_ABS(s)		(((s)->sy_type & N_TYPE) == N_ABS)
/* True if the symbol is external */
#define S_IS_EXTERNAL(s)	((s)->sy_type & N_EXT)
/* True if symbol has been defined, ie is in N_{TEXT,DATA,BSS,ABS} or N_EXT */
#define S_IS_DEFINED(s)		(((s)->sy_type & N_TYPE) != N_UNDF)
/* True if a debug special symbol entry */
#define S_IS_DEBUG(s)		((s)->sy_type & N_STAB)
/* True if a symbol is local symbol name */
/* A symbol name whose name begin with ^A is a gas internal pseudo symbol
   nameless symbols come from .stab directives. */
#define S_IS_LOCAL(s)		(S_GET_NAME(s) && \
				 !S_IS_DEBUG(s) && \
				 (S_GET_NAME(s)[0] == '\001' || \
				  (S_LOCAL_NAME(s) && !flagseen['L'])))
/* True if a symbol is not defined in this file */
#define S_IS_EXTERN(s)		((s)->sy_type & N_EXT)
/* True if the symbol has been generated because of a .stabd directive */
#define S_IS_STABD(s)		((s)->sy_name == (char *)0)

/* Accessors */
/* The value of the symbol */
#define S_GET_VALUE(s)		((s)->sy_value)
/* The name of the symbol */
#define S_GET_NAME(s)		((s)->sy_name)
/* The pointer to the string table */
#define S_GET_OFFSET(s)		((s)->sy_strx)
/* The numeric value of the segment */
#define S_GET_SEGMENT(s)	((s)->sy_type & N_TYPE)
/* The n_other expression value */
#define S_GET_OTHER(s)		((s)->sy_other)
/* The n_desc expression value */
#define S_GET_DESC(s)		((s)->sy_desc)

/* Modifiers */
/* Set the value of the symbol */
#define S_SET_VALUE(s,v)	((s)->sy_value = (v))
/* Assume that a symbol cannot be simultaneously in more than on segment */
/* Set the segment to text */
#define S_SET_TEXT(s)		((s)->sy_type &= ~N_TYPE,(s)->sy_type|=N_TEXT)
/* Set the segment to data */
#define S_SET_DATA(s)		((s)->sy_type &= ~N_TYPE,(s)->sy_type|=N_DATA)
/* Set the segment to bss */
#define S_SET_BSS(s)		((s)->sy_type &= ~N_TYPE,(s)->sy_type|=N_BSS)
/* Set the segment to abs */
#define S_SET_ABS(s)		((s)->sy_type &= ~N_TYPE,(s)->sy_type|=N_ABS)
/* The symbol is external */
#define S_SET_EXTERNAL(s)	((s)->sy_type |= N_EXT)
/* The symbol is not external */
#define S_CLEAR_EXTERNAL(s)	((s)->sy_type &= ~N_EXT)
/* Set the name of the symbol */
#define S_SET_NAME(s,v)		((s)->sy_name = v)
/* Set the offset in the string table */
#define S_SET_OFFSET(s,v)	((s)->sy_strx = v)
/* Set the n_other expression value */
#define S_SET_OTHER(s,v)	((s)->sy_other = (v))
/* Set the n_desc expression value */
#define S_SET_DESC(s,v)		((s)->sy_desc = (v))

/* File header macro and type definition */

#define H_GET_FILE_SIZE(h)	(sizeof(struct exec) + \
				 H_GET_TEXT_SIZE(h) + H_GET_DATA_SIZE(h) + \
				 H_GET_SYMBOL_TABLE_SIZE(h) + \
				 H_GET_TEXT_RELOCATION_SIZE(h) + \
				 H_GET_DATA_RELOCATION_SIZE(h) + \
				 (h)->string_table_size)

#define H_GET_TEXT_SIZE(h)		((h)->header.a_text)
#define H_GET_DATA_SIZE(h)		((h)->header.a_data)
#define H_GET_BSS_SIZE(h)		((h)->header.a_bss)
#define H_GET_TEXT_RELOCATION_SIZE(h)	((h)->header.a_trsize)
#define H_GET_DATA_RELOCATION_SIZE(h)	((h)->header.a_drsize)
#define H_GET_SYMBOL_TABLE_SIZE(h)	((h)->header.a_syms)
#define H_GET_MAGIC_NUMBER(h)		((h)->header.a_info)
#define H_GET_ENTRY_POINT(h)		((h)->header.a_entry)
#define H_GET_STRING_SIZE(h)		((h)->string_table_size)
#ifdef EXEC_MACHINE_TYPE
#define H_GET_MACHINE_TYPE(h)		((h)->header.a_machtype)
#endif /* EXEC_MACHINE_TYPE */
#ifdef EXEC_VERSION
#define H_GET_VERSION(h)		((h)->header.a_version)
#endif /* EXEC_VERSION */

#define H_SET_TEXT_SIZE(h,v)		((h)->header.a_text = (v))
#define H_SET_DATA_SIZE(h,v)		((h)->header.a_data = (v))
#define H_SET_BSS_SIZE(h,v)		((h)->header.a_bss = (v))
#define H_SET_RELOCATION_SIZE(h,t,d)	(H_SET_TEXT_RELOCATION_SIZE((h),(t)),\
					 H_SET_DATA_RELOCATION_SIZE((h),(d)))
#define H_SET_TEXT_RELOCATION_SIZE(h,v)	((h)->header.a_trsize = (v))
#define H_SET_DATA_RELOCATION_SIZE(h,v)	((h)->header.a_drsize = (v))
#define H_SET_SYMBOL_TABLE_SIZE(h,v)	((h)->header.a_syms = (v) * \
					 sizeof(struct nlist))
#define H_SET_MAGIC_NUMBER(h,v)		((h)->header.a_info = (v))
#define H_SET_ENTRY_POINT(h,v)		((h)->header.a_entry = (v))
#define H_SET_STRING_SIZE(h,v)		((h)->string_table_size = (v))
#ifdef EXEC_MACHINE_TYPE
#define H_SET_MACHINE_TYPE(h,v)		((h)->header.a_machtype = (v))
#endif /* EXEC_MACHINE_TYPE */
#ifdef EXEC_VERSION
#define H_SET_VERSION(h,v)		((h)->header.a_version = (v))
#endif /* EXEC_VERSION */

/* Output the file(s) header(s) in a character array */
#define H_OUTPUT(h,where)	a_header_append(&(h)->header,(where))

/* Output a symbol entry */
#define SYMBOL_OUTPUT(s,w)	a_symbol_append((s), (w))

typedef struct {
    struct exec	header;			/* a.out header */
    long int	string_table_size;	/* names + '\0' + sizeof(int) */
} object_headers;

/* Format independent interface functions */
extern void		emit_relocations();
extern void		emit_symbols();
extern void		a_header_append();
extern void		a_symbol_append();

#endif /* AOUT_H */
