.\" ::[[ @(#) flip.1 1.3 89/07/04 16:30:40 ::]]
.\"
.TH FLIP local "Jul 4, 1989"
.SH NAME
flip \- do newline conversions between **IX and MS\-DOS
.SH SYNOPSIS
.B flip \-h
.sp  0
.B flip 
\-umvtsbz
.B file ...
.SH DESCRIPTION
.PP
.I Flip
is a file interchange program that converts text file formats
between **IX and MS\-DOS.  It converts lines ending with carriage\-return
(CR) and linefeed (LF) to lines ending with just linefeed, or vice versa.
.PP
.I Flip
has the following features.
.TP
o
If a file contains isolated CR characters for underlining or
overprinting,
.I flip
does not change them.
.TP
o
When asked to convert a file to the same format that it
already has,
.I flip
causes no change to the file.  Thus to
convert all files to **IX format you can type
.IP "" 10
.I flip
.B \-u
*.*  (under MS\-DOS)
.sp 0
.I flip
.B \-u
*    (under **IX)
.IP "" 5
and all files will end up right, regardless of whether they
were in MS-DOS or in **IX format to begin with.  This also
works in the opposite direction.
.TP
o
.I Flip
preserves file timestamps.  You can override this.
.TP
o
.I Flip
is written in C and will compile and run under
MS-DOS/Turbo C, 4.3BSD, and System V.
.TP
o
.I Flip
accepts wildcards and multiple filenames on the
command line.
.TP
o
If a user interrupt aborts
.IR Flip ,
it does not leave behind
any garbage files or cause corruption of the files being
converted.
.TP
o
.I Flip
will normally refuse to convert binary files.  You can
override this.
.TP
o
When converting from MS-DOS to **IX format,
.I flip
removes any
trailing control Z (the last character in the file), but
leaves embedded control Z characters unchanged.  This minimizes
the possibility of accidentally converting a binary file that
contains a control Z near the beginning.  You can override this
and ask
.I flip
to recognize the first control Z found as end-of-file.
.TP
o
.I Flip
can be asked to strip the high (parity) bit as it converts
a file.
.PP
.I Flip
is normally invoked as:
.IP "" 5
.I flip
.B \-umhvtb
file ...
.IP "" 0
One of
.BR \-u ,
.BR \-m ,
or
.B \-h
is required.  Switches may be given separately or
combined together after a dash.  For example, the three command lines given
below are equivalent:
.IP "" 5
.I flip
.B \-uvt
*.c
.sp 0
.I flip
.B "-u -v -t"
*.c
.sp 0
.I flip
.B "-u -vt"
*.c
.PP
The meanings of the switches are as follows.
.TP
\-u
convert to **IX format (CR LF => LF, lone CR or LF unchanged,
trailing control Z removed, embedded control Z unchanged)
.TP
\-m
convert to MS-DOS format (lone LF => CR LF, lone CR unchanged)
.TP
\-h
give a help message
.TP
\-v
be verbose, print filenames as they are processed
.TP
\-t
touch files (don't preserve timestamps)
.TP
\-s
strip high bit
.TP
\-b
convert binary files too (else binary files are left unchanged)
.TP
\-z
truncate file at first control Z encountered
.PP
On systems that allow a program to know its own name,
.I flip
may be renamed (or
linked) to a file called
.I toix
(or
.I toix.exe
under MS-DOS) for conversion
to **IX format, or to a file called
.I toms
(or
.I toms.exe
under MS-DOS) for
conversion to MS-DOS format.  When invoked with the name
.I toix
or
.IR toms,
.I flip
will act as if it were invoked with the
.B \-u
or
.B \-m
option respectively.
.SH COPYRIGHT
Both this documentation and
.I flip
are Copyright 1989 Rahul Dhesi, all
rights reserved.  Permission is granted to copy, use, and distribute for any
commercial or noncommercial purpose in accordance with the requirements of
version 1.0 of the
.I GNU General Public license.
.PP
Note:  This software has not been endorsed by the Free Software Foundation,
the creator of the GNU license, and I am not affiliated with that
organization.
.SH AUTHOR
Rahul Dhesi
