/*
** keys.h - contains definitions of all the keyboard keys which
**          invoke commands.
**
** keys.h 1.15   Delta'd: 16:24:39 1/4/92   Mike Lijewski, CNSF
**
** Copyright (c) 1991 Cornell University
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that: (1) source distributions retain this entire copyright
** notice and comment, and (2) distributions including binaries display
** the following acknowledgement:  ``This product includes software
** developed by Cornell University'' in the documentation or other
** materials provided with the distribution and in all advertising
** materials mentioning features or use of this software. Neither the
** name of the University nor the names of its contributors may be used
** to endorse or promote products derived from this software without
** specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef __KEYS_H
#define __KEYS_H

//
// display help
//
const int KEY_QM    = '?';
const int KEY_H     = 'H';

//
// pop previous directory off stack, or quit if last
//
const int KEY_q     = 'q';

//
// quit
//
const int KEY_Q     = 'Q';

//
// forward one line
//
const int KEY_j     = 'j';
const int KEY_n     = 'n';
const int KEY_CTL_N = 0xE;   // ASCII CTL-N
const int KEY_SPC   = ' ';
const int KEY_CR    = '\r';  // carriage return

//
// backward one line
//
const int KEY_k     = 'k';
const int KEY_p     = 'p';
const int KEY_CTL_P = 0x10; // ASCII CTL-P
const int KEY_CTL_Y = 0x19; // ASCII CTL-Y

//
// forward one window
//
const int KEY_CTL_F = 6;    // ASCII CTL-F
const int KEY_CTL_V = 0x16; // ASCII CTL-V

//
// backward one window
//
const int KEY_b     = 'b';
const int KEY_CTL_B = 2;   // ASCII CTL-B

//
// forward half window
//
const int KEY_CTL_D = 4;   // ASCII CTL-D

//
// backward half window
//
const int KEY_CTL_U = 0x15; // ASCII CTL-U

//
// go to first file in listing
//
const int KEY_TOP   = '<';

//
// go to last file in listing
//
const int KEY_BOT   = '>';

//
// repaint screen - CTR-L
//
const int KEY_CTL_L = '\f';

//
// abort from a prompt - CTL-G
//
// can't use '\a' here due to bug in Cfront 2.0
//
const int KEY_ABORT = 0x7;

//
// copy current file
//
const int KEY_c     = 'c';

//
// delete current file w/affirmation
//
const int KEY_d     = 'd';

//
// delete current file
//
const int KEY_D     = 'D';

//
// edit current file or directory
//
const int KEY_e     = 'e';
const int KEY_f     = 'f';

//
// prompt for a directory and edit it
//
const int KEY_E     = 'E';

//
// view current file
//
const int KEY_m     = 'm';
const int KEY_v     = 'v';

//
// rename current file
//
const int KEY_r     = 'r';

//
// compress current file
//
const int KEY_C     = 'C';

//
// change group of current file
//
const int KEY_G     = 'G';

//
// link current file to another
//
const int KEY_L     = 'L';

//
// change mode of current file
//
const int KEY_M     = 'M';

//
// print current file
//
const int KEY_P     = 'P';

//
// reread current directory
//
const int KEY_g     = 'g';
const int KEY_R     = 'R';

//
// symbolically link current file to another
//
const int KEY_S     = 'S';

//
// uncompress current file
//
const int KEY_U     = 'U';

//
// print out version string
//
const int KEY_V     = 'V';

//
// backspace works as expected while in a prompt
//
const int KEY_BKSP  = '\b';

//
// for searching forward
//
const int KEY_SLASH   = '/';

//
// for searching backward
//
const int KEY_BKSLASH = '\\';

//
// for simulating SIGINT and SIGQUIT
//
const int KEY_INT   = 0x3;  // ASCII CTL-C
const int KEY_QUIT  = 0x1C; // ASCII CTL-\

//
// for shell commands
//
const int KEY_BANG  = '!';

//
// prefix key used in couple places
// for GNU Emacs compatibility
//
const int KEY_ESC   = 0x1B;  // ASCII-ESC

//
// change sort order
//
const int KEY_O = 'O';

#endif /* __KEYS_H */
