#define TAKER
#include "dink_sym.h"
#include "dink_glb.h"
 
void taker(n)
/*********************************************************/
/*                                                       */
/*           --- Object Taking Subroutine ---            */
/*                                                       */
/*      Program by Gary A. Allen, Jr.   20 May 1990      */
/*        (c) Copywrite 1990 by Gary A. Allen, Jr.       */
/*                                                       */
/*********************************************************/
int n ;
{
#ifdef __TURBOC__
void clip_in(int), clip_out(int), ender(int), eater(int) ;
#endif

register int i, j ;
int  sw_done, gleep_holder, ammo_flag ;

/* Alias in the object for the single word "take" command */
if (tag[V_VERB_ONLY]) {
	j = 0 ;
	/* See if there is only one object on the floor */
	for (i = 0; i <= objcnt; i++) if (n == object[i][J_loc]) {
		j++ ;
		tag[object[i][J_parse_id]] = TRUE ;
	}

	if (room[n][M_gleep] != 0) {
		j++ ;
		tag[V_gleep] = TRUE ;
		if (room[n][M_gleep] > 1) tag[V_PLURAL] = TRUE ;
	}

	/* Complain if there isn't a single object on the ground */
	if (j > 1) {
		printf ("What exactly do you want me to take? \n");
		return ;
	}
}

ammo_flag = F_no_clip ;
if (tag[V_clip]) ammo_flag = F_normal_clip ;
if (tag[V_org_clip]) ammo_flag = F_org_clip ;

/* deal with special case of "orange clip" implied by its being alone */
if (tag[V_clip]&&(object[O_clip][J_loc] != n)&&
   (object[O_org_clip][J_loc] == n)) {
	tag[V_org_clip] = TRUE ;
	tag[V_clip] = FALSE ;
	if (V_clip == sent[1]) sent[1] = V_org_clip ;
}

/* deal with the verb "attach" */
if (verb == V_attach) {
	if (tag[V_rifle]&&(ammo_flag != F_no_clip)) {
		clip_in(ammo_flag) ;
		return ;
	}
	if ((n != R_office_mang)&&(room[n][M_obj_cnt] <= 0)) {
		printf ("There is nothing here that I can attach!\n");
		return ;
	}
}

/* Check to see if player already has the item */
for (i = 0; i <= objcnt; i++) { 
	if (object[i][J_parse_id] == sent[1]) {
		if (object[i][J_loc] == B_have) {
printf ("You already have a %s in your possession.\n",vocab[sent[1]-1]);
			return ;
		}
		else break ;
	}
}

sw_done = FALSE ;

if (tag[V_safe]) {
	if (n != R_office_mang) {
		printf("There is no safe here. \n") ;
		return ;
	}
	if (room[R_office_mang][M_rm_status] != S_open) {
		printf("I can't do it because the safe is closed. \n") ;
		return ;
	}
}

/* Special case of "take pill" */
if ((tag[V_pill])&&(object[O_pills][J_loc] == B_have)) {
	eater(n) ;
	return ;
}

/* Reject "take" command when there is nothing to take */
if ((n != R_office_mang)&&(verb != V_attach)&&(verb != V_remove)&&
	(room[n][M_obj_cnt] <= 0)&&(room[n][M_gleep] == 0)&&
	(!((n == R_gleep_tank)&&(gleep_score > 0)))&&
	(room[n][M_rm_type] != T_unmovable_obj)) {
	printf ("There is nothing here that you can take! \n");
	return ;
}

/* player takes something from the gleep tank */
if (tag[V_tank]) {
	if (n != R_gleep_tank) {
printf("I see no gleep tank to take anything from. \n") ;
		return ;
	}
printf("\nYou climb up onto the edge of the gleep tank and reach\n");
printf("into the dark blue fluid.  Suddenly the fluid begins a\n");
printf("furious boiling that instantly reduces your hand into\n") ;
printf("bleached white bones.  The shock and pain disturbs your\n");
printf("balance and you fall into the horrible stuff!!  There is\n");
printf("once again a furious boiling.  Eventually the fluid stills\n");
printf("and becomes clear again.  On the bottom of the tank can\n") ;
printf("be seen a white, clean, \"medical school quality\" human\n");
printf("skeleton.\n") ;
	ender(F_died) ;
}
 
/* gleep taking routine */
if (tag[V_gleep]) {
if (!tag[V_safe]) {

	/* This block is for inaccessible or nonexistant gleeps */
	if ((room[n][M_gleep] == 0)&&(!((n == R_office_mang)&&
(room[R_office_mang][M_rm_status] == S_open)&&(gleep_safe != 0)))) {

		if ((n != R_gleep_tank)||(gleep_score==0)) {
printf("There are no gleeps here to take!\n") ;
			return ;
		}
		else {
printf("There are no gleeps on the floor but I see ") ;
			if (gleep_score == 1) 
				printf("a gleep in the gleep tank.\n");
			else
printf("%d gleeps in the gleep tank.\n",gleep_score) ;
			return ;
		}
	}

	/* This block is for accessible gleeps */
	if ((n == R_office_mang)&&
(room[R_office_mang][M_rm_status] == S_open)&&(gleep_safe != 0)) {
		gleep_holder = gleep_safe ;
	}
	else gleep_holder = 0 ;

	if ((!tag[V_PLURAL])||
		(room[n][M_gleep]+gleep_holder == 1)) {
		printf("Gleep taken. \n") ; 
		++gleep_count ;
		if (gleep_holder == 0) --room[n][M_gleep] ;
		else --gleep_holder ;
	}
	else {
		printf("Gleeps taken. \n") ; 
		gleep_count += room[n][M_gleep]+gleep_holder ;
		room[n][M_gleep] = 0 ;
		gleep_holder = 0 ;
	}
	gleep_safe = gleep_holder ;
	return ;
}
else {
	if ((n == R_office_mang)&&
(room[R_office_mang][M_rm_status] == S_open)&&(gleep_safe != 0)) { 
		if (tag[V_PLURAL]) {
			printf("Gleeps taken from safe. \n") ; 
			gleep_count += gleep_safe ;
			gleep_safe = 0 ;
		}
		else {
			printf("Gleep taken from safe. \n") ; 
			++gleep_count ;
			--gleep_safe ;
		}
	}
	else printf("There are no gleeps in the safe!\n") ;
	return ;
}
} /* end of the gleep taking block */

/* deal with the special case of the platypus picture */
if ((n == R_office_mang) && tag[V_picture]) {
printf("The picture can not be removed.  It appears to be hinged ");
printf("to the wall. \n");
	return ;
}

/* treat the verb "remove" in the context of "remove clip from rifle" */
if (verb == V_remove) {
	if ((!tag[V_safe])&&(ammo_flag != F_no_clip)) {
		clip_out(n) ;
		return ;
	}
}

if (carry_count > 5) {
printf("I can't do it!\n") ;
printf("I'm holding so many things that I can't take anymore!\n") ;
	return ;
}

if (carry_weight >= 800) {
printf("I can't do it!\n") ;
printf("This junk I'm carrying is too heavy! I can't carry anymore!\n");
	return ;
}


/* find the object(s) in this room */
for (i = 0; i <= objcnt; i++) {

	if ((carry_count > 5)||(carry_weight >= 800)) break ;

	/* See if the object is in the safe and was requested */
	if ((n == R_office_mang)&&(object[i][J_loc] == B_in_safe)&&
        (tag[object[i][J_parse_id]]||tag[V_all])&&
	(room[R_office_mang][M_rm_status] == S_open)&&
	((!tag[V_treasure])||(object[i][J_value] > 0))) {
		object[i][J_loc]= B_have; 
		carry_count++ ;
		carry_weight += object[i][J_weight] ; 
		sw_done = TRUE ;
	} 
	
	/* See if the object is in the room and was requested */
	if ((object[i][J_loc]==n)&&(tag[object[i][J_parse_id]]||
		tag[V_all])&&
		((!tag[V_treasure])||(object[i][J_value] > 0))) {
		/* see if the object can be taken */
		if ((object[i][J_type] == Z_normal)||
			(object[i][J_type] == Z_alias)) {
			--room[n][M_obj_cnt] ;
			carry_count++ ;
			carry_weight += object[i][J_weight] ; 
			object[i][J_loc] = B_have; 
			sw_done = TRUE ;
		} 

		/* see if this is a nonmovable, nonacting object */
		if ((object[i][J_type] == Z_unmovable) &&
			(object[i][J_loc]==n) && (!tag[V_all])) {

			switch(object[i][J_parse_id]) {
			case V_bulldust:
printf("The bulldust is so fine that it wafts away with a touch.\n") ;
				return ;

			/* Cockroach(es) */
			case V_cockroach:
printf("I will not touch the filthy things!\n") ;
				return ;

			/* Kangaroo(s) */
			case V_kangaroo:
printf("You make a grab for the kangaroo but it leaps away!\n") ;
				return ;

			case V_poster:
printf("I think this sort of poster is best left on the wall.\n") ;
				return ;

			/* Spinifex(es) */
			case V_spinifex:
printf("The thorns on the spinifex are large and nasty.\n") ;
printf("I'll just leave them to roll about.\n") ;
				return ;
			} /* end of switch block */
		} /* end of nonmovable object block */ 

		/* see if taking the object causes special action */
		if (object[i][J_type] == Z_transform) {
			switch(object[i][J_parse_id]) {
			/* ACME doormat */
			case V_mat:
printf("As you lift up the dirty old doormat, you find half \n") ;
printf("hidden in the dust....  a large brass key. \n") ;
				object[O_mat][J_type] = Z_normal ;
				carry_count++ ;
				carry_weight += object[O_mat][J_weight];
				object[O_mat][J_loc]= B_have;
				object[O_key][J_loc]=R_office_entr ;
				sw_done = TRUE ;
				return ;

			/* Map of the ACME Mine */
			case V_map:
printf("As you picked up the old map from the floor, most of it");
printf(" crumbled into \ndust leaving only one small piece. \n") ;
				object[O_map][J_loc] = B_unmade ;
				object[O_map_frag][J_loc] = B_have ;
				carry_count++ ;
			carry_weight += object[O_map_frag][J_weight] ;
				--room[n][M_obj_cnt] ;
				sw_done = TRUE ;
				return ;
			}
		} /* end of the special action block */ 
	} 
} /* end of the object scan loop */

/* take all gleeps if any */
if (tag[V_all]&&(!tag[V_treasure])) {
	if (room[n][M_gleep] > 0) { 
		gleep_count += room[n][M_gleep] ;
		room[n][M_gleep] = 0 ;
		sw_done = TRUE ;
	}
	if ((gleep_safe != 0)&&(n == R_office_mang)&&
		(room[R_office_mang][M_rm_status] == S_open)) {
		gleep_count +=  gleep_safe ;
		gleep_safe = 0 ;
		sw_done = TRUE ;
	}
}

/* Announce the "take" was successful */
if (sw_done) {
	if (((carry_count > 5)||(carry_weight >= 800))&&(tag[V_all])) 
		printf("You've taken as much as you can.\n") ;
	else printf ("Done \n");
}
/* --or-- announce the "take" was unsuccessful */
else  {
	if (tag[V_all]) printf("I see nothing which I can take.\n") ;
	else { 
		if (tag[V_VERB_ONLY]) 
			printf("What exactly should I take?\n") ;
		else {
			printf ("I don't see a") ;
			if (tag[V_PLURAL]) printf("ny") ;
			printf (" %s around here. \n",vocab[sent[1]-1]);
		}
	}
}
return ;

} /* --- end of the "taker" subroutine --- */

void loader()
/*********************************************************/
/*                                                       */
/*           --- Rifle Loading Subroutine ---            */
/*                                                       */
/*      Program by Gary A. Allen, Jr.  29 April 1990     */
/*        (c) Copywrite 1990 by Gary A. Allen, Jr.       */
/*                                                       */
/*********************************************************/
{

#ifdef __TURBOC__
void clip_in(int) ;
#endif

int ammo_flag ;

/* Reject single verb load command */
if (tag[V_VERB_ONLY]) {
printf("What exactly do you want me to load?\n") ;
	return ;
}
if (!tag[V_rifle]) {
printf("I don't know how I could load that.\n") ;
	return ;
}

/* Deal with implied clip type command */
if (!tag[V_clip]) {
if ((object[O_clip][J_loc] != B_have)&&
	(object[O_org_clip][J_loc] == B_have)) ammo_flag = F_org_clip ;
if ((object[O_clip][J_loc] == B_have)&&
     (object[O_org_clip][J_loc] != B_have)) ammo_flag = F_normal_clip ;
	/* the case were there is no clip is found in clip_in */
}

/* Deal with specific "load [orange] clip" command */
else {
	if (tag[V_orange]) {
		if (object[O_org_clip][J_loc] == B_have) 
			ammo_flag = F_org_clip ;
		else {
printf("You don't possess the orange ammunition clip.\n") ;
			return ;
		}
	}
	else {
		if (object[O_clip][J_loc] == B_have)
			ammo_flag = F_normal_clip ;

/* assume "load clip" with no normal clip implies orange clip */
		else {
			if (object[O_org_clip][J_loc] == B_have) 
				ammo_flag = F_org_clip ;
			else{
printf("You don't possess an ammunition clip to load.\n") ;
				return ;
			}
		}
	}
}

clip_in(ammo_flag) ;
} /* --- end of the "loader" subroutine --- */

void unloader(n)
/*********************************************************/
/*                                                       */
/*          --- Rifle Unloading Subroutine ---           */
/*                                                       */
/*      Program by Gary A. Allen, Jr.  29 April 1990     */
/*        (c) Copywrite 1990 by Gary A. Allen, Jr.       */
/*                                                       */
/*********************************************************/
int n ;
{
#ifdef __TURBOC__
void clip_out(int) ;
#endif

/* Reject single verb load command */
if (tag[V_VERB_ONLY]) {
printf("What exactly do you want me to unload?\n") ;
	return ;
}
if (!tag[V_rifle]) {
printf("I don't know how I could unload that.\n") ;
	return ;
}
clip_out(n) ;
} /* --- end of the "unloader" subroutine --- */

void dropper(n)
/*********************************************************/
/*                                                       */
/*          --- Object Dropping Subroutine ---           */
/*                                                       */
/*      Program by Gary A. Allen, Jr.  21 May 1990       */
/*        (c) Copywrite 1990 by Gary A. Allen, Jr.       */
/*                                                       */
/*********************************************************/
int n ;
{
#ifdef __TURBOC__
void clip_in(int), clip_out(int), boom(void) ;
void objlooker(int), gleeper(int), unlocker(int) ;
#endif

register int i, k ;
int sw_possess, sw_done, ammo_flag, sw_object, i_10, i_fract, sw_shot ;

/* respond to "verb only" command */
if (tag[V_VERB_ONLY]) {
	printf ("You'll have to be more specific. \n");
	return ;
}

/* deal with special case of "orange clip" implied by its being alone */
if (tag[V_clip]&&(object[O_clip][J_loc] != B_have)&&
	(clip_flag != F_normal_clip)&&
   ((object[O_org_clip][J_loc] == B_have)||(clip_flag == F_org_clip))) {
	tag[V_org_clip] = TRUE ;
	tag[V_clip] = FALSE ;
	if (V_clip == sent[1]) sent[1] = V_org_clip ;
}

ammo_flag = F_no_clip ;
if (tag[V_clip])  ammo_flag = F_normal_clip ;
if (tag[V_org_clip])  ammo_flag = F_org_clip ;

/* deal with special cases of the verbs */
switch(verb) {
case V_put:
	/* special case of putting (destroying) an object in water */
	if (tag[V_tank]||tag[V_gleep]||tag[V_safe]||
		tag[V_river]||tag[V_billabong]||tag[V_stream]) break ;

	/* special case of "put key in door(lock)" */
	if (tag[V_key] && tag[V_door]) {
		unlocker(n) ;
		return ;
	}

	if (!tag[V_cap]) {
		if ((!tag[V_rifle])&&(ammo_flag != F_no_clip)) {
			printf("What am I to put the clip into? \n") ;
			return ;
		}
		if (tag[V_rifle]&&(ammo_flag != F_no_clip))  
				clip_in(ammo_flag) ;
		else 
printf("I don't understand what this is to be put into. \n") ;
		return ;
	}

case V_insert:
	if (tag[V_safe]) break ;
	if (ammo_flag != F_no_clip) {
		if (!tag[V_rifle]) {
printf("What am I to insert the clip into? \n") ;
		}
		else {
			clip_in(ammo_flag) ;
		}
		return ;
	}
	if (tag[V_cap]) {
		if (!tag[V_dynamite]) {
printf("I see no reason why I should put a blasting cap into that.\n") ;
			return ;
		}
		else goto cap_in ;
	}
printf("I can think of some interesing places to insert this. \n") ;
printf("However I shall not reduce myself to such vulgarity.\n");
	return ;
	
case V_eject:
/* Command "eject clip" ejects clip from rifle no matter what type*/
	if ((ammo_flag == F_normal_clip)&&(clip_flag == F_org_clip)) 
		ammo_flag = F_org_clip ; 
case V_drop:
	if (((ammo_flag == F_org_clip)&&(clip_flag == F_org_clip))|| 
	((ammo_flag == F_normal_clip)&&(clip_flag == F_normal_clip))) { 
		clip_out(n) ;
		return ;
	}
	break ;

} /* end of switch */

/* Deal with "drop" when user has no objects */
if (tag[V_all]&&(carry_count == 0)&&(gleep_count == 0)) {
	printf("You dill!  You have nothing to drop!\n") ;
	return ;
}

/* deal with "drop in safe ..." errors */
if (tag[V_safe]) {
/* see if this is the managers office */
	if (n != R_office_mang) {    	
		printf("There is no safe here! \n");
		return ;
	}
/* See if the safe is open */
	if (room[R_office_mang][M_rm_status] != S_open) {
		printf ("I can't do it!  The safe is closed. \n");
		return ;
	}
}
 
/* gleep droping routine */
if (tag[V_gleep]||tag[V_tank]) {
	/* drop gleeps in a normal way */
	if (!tag[V_tank]) {
		if (gleep_count == 0) { 
			printf("You have no gleeps to drop! \n") ;
			return ;
		}
		if ((!tag[V_PLURAL])||(gleep_count == 1)) {
			if (tag[V_safe]) {
				printf("Gleep put into safe.\n") ;
				++gleep_safe ;
				--gleep_count ;
			}
			else {
				printf("Gleep dropped. \n") ; 
				--gleep_count ;
				++room[n][M_gleep] ;
			}
		}
		else {
			if (tag[V_safe]) {
				printf("Gleeps put into safe.\n") ;
				gleep_safe += gleep_count ;
				gleep_count = 0 ;
			}
			else {
				printf("Gleeps dropped. \n") ; 
				room[n][M_gleep] += gleep_count ;
				gleep_count = 0 ;
			}
		}
		gleep_drop = TRUE ;
		return ;
	}
	/* drop objects(including gleeps) into a gleep tank */
	else {
		if (n != R_gleep_tank) {
			printf("I don't see a gleep tank here. \n") ;
			return ;
		}
		if (tag[V_gleep]) {
			if (gleep_count <= 0) {
printf("You have no gleeps to put in the tank. \n") ; 
				return ;
			}
			if ((!tag[V_PLURAL])||(gleep_count == 1)) {
printf("Your gleep falls into the tank with a \"plonk\".\n") ;
				++gleep_score ;
				--gleep_count ;
			}
			if (tag[V_PLURAL]&&(gleep_count > 1)) {
printf("Your gleeps fall into the tank causing a splash.\n") ;
				gleep_score += gleep_count ;
				gleep_count = 0 ;
			}
		}
		/* drop non-gleeps into the tank */

		/* the "drop all" routine */
		if (tag[V_all]) {
			sw_possess = FALSE ;
			for (i = 0; i <= objcnt; i++) {
				if ((object[i][J_loc] == B_have)&&
					((!tag[V_treasure])||
					(object[i][J_value] > 0))) {
					sw_possess = TRUE ;
					object[i][J_loc] = B_destroyed; 
					carry_count-- ;
				carry_weight -= object[i][J_weight] ;
				}
			}
			if (gleep_count == 0) {
				if (sw_possess) {
printf("You dump everything into the gleep tank. There is a furious\n");
printf("bubbling as the corrosive fluid of the tank turns the\n");
printf("objects into NOTHING.\n") ;
				}
				else 
printf("You've got nothing to throw into the tank.\n") ;
			}
			else {
				if (sw_possess) {
printf("You fling everything into the gleep tank.  The gleep");
				if (gleep_count > 1) {
printf("s\nsplash into the tank and settle to the bottom of the\n") ;
				}
				else {
printf("\nplonks into the tank and settles to the bottom of the\n") ;
				}
printf("tank.  However the other objects begin to dissolve the\n");
printf("moment the tank's fluid touches them.  Time passes and\n");
printf("the objects dissolve into NOTHING.\n") ;
				}
				/* you possess no non-gleeps */
				else {
				if (gleep_count == 1) 
printf("Your gleep falls into the tank with a \"plonk\".\n") ;
				else
printf("Your gleeps fall into the tank causing a splash.\n") ;
				}
			gleep_score += gleep_count ;
			gleep_count = 0 ;
			return ;
			}
		} /* end of the "drop all" if block */
		/* Individual non-gleeps are dropped into the tank */

		/* see if your are holding the object(s) */
		for (i=0; i <= objcnt; i++) {
 			if (tag[object[i][J_parse_id]]) {
				if (object[i][J_loc]== B_have) {
printf ("You fling the %s into the gleep tank.  As soon as it\n",
	vocab[object[i][J_parse_id]-1]);
printf ("touched the tank's fluid there was a furious effervescence\n");
printf ("as it began to dissolve.  With the passage of time, the\n") ;
printf ("fluid stills and there is NOTHING left.\n") ;
					carry_count-- ;
				carry_weight -= object[i][J_weight] ;
					object[i][J_loc] = B_destroyed; 
					return ;
				}
				else {
printf("You don't have a %s to toss into the gleep tank.\n",
	vocab[object[i][J_parse_id]-1]);
					return ;
				}
			}
		} /* object scan "for" loop */
		return ;
	}
}

sw_done = FALSE ;

/* the "drop all" routine */
if (tag[V_all]) {

	/* Deal with throwing stuff into water */
	if(tag[V_stream]) {
		if (n == R_stream) {
printf("You fling everything into the stream.\n");
			goto destroy_all ;
		}
		else
printf("I see no stream to toss stuff into.\n") ;
		return ;
	}
	if(tag[V_billabong]) {
		if ((n == R_stream)||(n == R_slime)||
			(n == R_billabong)) { 
printf("You fling everything into the billabong.\n");
			goto destroy_all ;
		}
		else
printf("I see no billabong to toss stuff into.\n") ;
		return ;
	}
	if(tag[V_river]) {
		if ((n == R_dike)||(n == R_river_edge)||
			(n == R_river_exit)) {
printf("You fling everything into the river.\n");
			goto destroy_all ;
		}
		else
printf("I see no river to toss stuff into.\n") ;
		return ;
	}

	if (!tag[V_safe]) {
		/* normal drop */
		if (room[n][M_rm_type] != T_looping) {
			/* normal room */
			for (i = 0; i <= objcnt; i++) {
				if ((object[i][J_loc] == B_have)&&
					((!tag[V_treasure])||
					(object[i][J_value] > 0))) {

					sw_done = TRUE ;

/* see if the blasting cap was hard dropped */
if ((i == O_cap)&&(verb != V_slow_drop)) {
cap_drop:
printf("Bang!! The blasting cap you were carrying detonated when\n") ;
printf("it hit the ground.  Fortunately no damage was caused.\n") ;  
	object[O_cap][J_loc] = B_destroyed; 
	carry_count-- ;
	carry_weight -= object[O_cap][J_weight] ;
	return ;
}

/* see if the dynamite with blasting cap was hard dropped */
if ((i == O_dynamite)&&(object[O_dynamite][J_type] == Z_alias)&&
	(verb != V_slow_drop)) {
dynamite_drop:
	boom () ;
printf("Dropping a stick of dynamite with a blasting cap in it\n");
printf("ranks high as one of the dumbest things a person can do.\n") ;
printf("Needless to say you were blown to bits.\n") ;
	ender(F_died) ;
}
					++room[n][M_obj_cnt] ;
					carry_count-- ;
				carry_weight -= object[i][J_weight] ;
					object[i][J_loc] = n; 
/* set valuable switch if valuable object dropped in Ned's area */
					if (object[i][J_value] > 0) {
					for (k = 22; k <= 41; k++) 
					if (k == n) sw_valuable = TRUE;
					for (k = 144; k <= 146; k++) 
				 	if (k == n) sw_valuable = TRUE;
					}
				}
			}
			/* drop all gleeps */
			if ((gleep_count > 0)&&
					(!tag[V_treasure])) {
				room[n][M_gleep] += gleep_count ;
				gleep_count = 0 ;
				sw_done = TRUE ;
				gleep_drop = TRUE ;
			}

			if (sw_done) {
				printf ("Done\n");
				objlooker(n) ;
				gleeper(n) ; 
			} 
			else printf("Don't have it to drop.\n") ;
			return ;
		}
		/* object destroyer room */
		else {
		/* Code assumes that user has something to drop */
printf ("You dropped everything you had in a heap, which \n");
printf ("promptly vaporized into a bright blue flash followed \n");
printf ("by a low \"BOOM\". \n") ; 
printf ("       --- You've blown it Bozo!! ---\n") ;
destroy_all:
			gleep_count = 0 ;
			carry_count = 0 ;
			carry_weight = 0 ;
			for (i = 0; i <= objcnt; i++) {
				if (object[i][J_loc] == B_have) 
					object[i][J_loc] = B_destroyed; 
			}
			return ;
		}
	}
	/* "drop all into the safe" routine */
	else {
		for (i = 0; i <= objcnt; i++) {
			if ((object[i][J_loc] == B_have) &&
				((!tag[V_treasure])||
				(object[i][J_value] > 0))) {
				object[i][J_loc] = B_in_safe ;	
				carry_count-- ;
				carry_weight -= object[i][J_weight] ;
				sw_done = TRUE ;
			}
		}
		if (!tag[V_treasure]) {
			gleep_safe += gleep_count ;
			gleep_count = 0 ;
			sw_done = TRUE ;
		}
		if (sw_done) printf ("Done \n");
		else printf("You don't have it to put in the safe!\n") ;
		return ;
	}
}

/* see if your are holding the object(s) */
for (i=0; i <= objcnt; i++) {
	sw_object = FALSE ;
	if (tag[object[i][J_parse_id]]) {
		sw_object = TRUE ;
 		if (object[i][J_loc] == B_have) {
			/* Safe storage routine */
			if (tag[V_safe]) {
				object[i][J_loc] = B_in_safe ;	
printf ("The %s is now inside the safe. \n", 
	vocab[object[i][J_parse_id]-1]);
				sw_done = TRUE ;
				carry_count-- ;
				carry_weight -= object[i][J_weight] ;
				continue ;
			}
 
			/* Single 'drop' routine */
			if (tag[V_river]||tag[V_billabong]||
				tag[V_stream]) {
		/* The object is to be dropped in water */
				if(tag[V_stream]) {
					if (n == R_stream) {
printf("You fling the %s into the stream.\n", 
	vocab[object[i][J_parse_id]-1]);
					carry_count-- ;
				carry_weight -= object[i][J_weight] ;
					object[i][J_loc] = B_destroyed; 
					return ;
					}
					else
printf("I see no stream to toss it into.\n") ;
					return ;
				}
			if(tag[V_billabong]) {
				if ((n == R_stream)||
				(n == R_slime)||(n == R_billabong)) { 
printf("You fling the %s into the billabong.\n",
	vocab[object[i][J_parse_id]-1]);
					carry_count-- ;
				carry_weight -= object[i][J_weight] ;
					object[i][J_loc] = B_destroyed; 
					return ;
				}
				else
printf("I see no billabong to toss it into.\n") ;
				return ;
			}
			if(tag[V_river]) {
				if ((n == R_dike)||(n == R_river_edge)||
					(n == R_river_exit)) {
printf("You fling the %s into the river.\n", 
	vocab[object[i][J_parse_id]-1]);
					carry_count-- ;
				carry_weight -= object[i][J_weight] ;
					object[i][J_loc] = B_destroyed; 
					return ;
				}
				else
printf("I see no river to toss it into.\n") ;
				return ;
			}
		}
		/* Normal Drop */
		else if (room[n][M_rm_type] != T_looping) {
			if ((i == O_cap)&&(verb != V_slow_drop)) 
				goto cap_drop ;
			if ((i==O_dynamite)&&(verb != V_slow_drop)&&
			(object[O_dynamite][J_type] == Z_alias)) 
				goto dynamite_drop ;

/* If the he rifle is dropped.  See if it kills the player */
if (i==O_rifle) {
	sw_shot = FALSE ;
	if ((clip_flag != F_no_clip) && 
(object[O_rifle][J_property] > 0)) switch(rifle_flag) {
	case F_safety:
		break ;
			
	case F_single:
		printf("\nBam!\n\n") ;
		sw_shot = TRUE ;
		break ;

	case F_triple:
		printf("\n") ;
		if (object[O_rifle][J_property] >= 3) {
			printf("Bam! Bam! Bam! \n\n") ;
		}
		else {
		for (i = 1; i <= object[O_rifle][J_property]; i++) 
			printf("Bam! ") ;
		}
		printf("\n") ;
		sw_shot = TRUE ;
		break ;

	case F_auto:
		printf("\n") ;
		if (object[O_rifle][J_property] >= 30) {
			for (i = 1; i <= 3; i++) 
printf("Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! \n") ;
		}
		else {
			i_10 = object[O_rifle][J_property]/10 ;
		i_fract = object[O_rifle][J_property]-(i_10*10) ;
			for (i = 1; i <= i_10; i++) 
printf("Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! \n") ;
			for (i = 1; i <= i_fract; i++) 
				printf("Bam! ") ;
		}
		printf("\n") ;
		sw_shot = TRUE ;
		break ;
	} /* end of the switch block */

	if (sw_shot) {
printf("Dropping a loaded and armed automatic rifle is a stupid way\n");
		if ((object[O_rifle][J_property] == 1) || 
			(rifle_flag == F_single)) {
printf("to commit suicide.  Needless to say you were hit by the\n") ;
printf("bullet after the rifle went off.\n") ;
		}
		else {
printf("to commit suicide.  The bullets shot from the rifle fly\n") ;
printf("around.  One of them bounces back and hits you!\n") ;
		}
		ender(F_died) ;
	}
} /* end of "drop rifle" block */

			carry_count-- ;
			carry_weight -= object[i][J_weight] ;
			++room[n][M_obj_cnt] ;
			object[i][J_loc] = n; 
			sw_done = TRUE ;
/* set valuable switch if valuable object dropped in Ned's area */
			if (object[i][J_value] > 0) {
				for (k = 22; k <= 41; k++) 
					if (k == n) sw_valuable = TRUE ;
				for (k = 144; k <= 146; k++) 
					if (k == n) sw_valuable = TRUE ;
			}
			continue ;
		}
		else {
printf ("As the %s left your possession there was a bright \n",
	vocab[object[i][J_parse_id]-1]);
printf ("blue flash, followed by a low \"BOOM\" as it vaporized \n");
printf ("into nonexistence. \n");
			carry_count-- ;
			carry_weight -= object[i][J_weight] ;
			object[i][J_loc] = B_destroyed; 
			return ;
		}
		}
 		if (object[i][J_loc] == B_unmade) continue ;
	} /* end of the object requested block */
	if ((!sw_done)&&sw_object) {
printf("You do not possess a %s.\n", vocab[object[i][J_parse_id]-1]);
		return ;
	}
} /* end of the object scan loop */
if (sw_done) {
	printf ("Done \n");
	objlooker(n) ;
	gleeper(n) ; 
} 
else 
printf("I don't understand what it is I'm supposed to drop.\n") ;

return ;

/* cap insertion routine */
cap_in:
/* see if your are holding the dynamite or the cap */
	if ((object[O_cap][J_loc] != B_have)&&
		(object[O_dynamite][J_loc] != B_have)) {
printf("You bloody dill!  You have neither the dynamite or a ");
printf("blasting cap.\n") ;
		return ;
	}
	if (object[O_cap][J_loc] != B_have) {
printf("You've got the dynamite but you need a blasing cap.\n") ;
		return ;
	}
	if (object[O_dynamite][J_loc] != B_have) {
printf("You've got the blasting cap but you need some dynamite.\n") ;
		return ;
	}
/* transform the two objects into one */
printf("With some trepidation, you slide the blasting cap into\n");
printf("the dynamite.  What you are now holding is VERY dangerous.\n");
	object[O_cap][J_loc] = B_unmade ; 
	object[O_dynamite][J_type] = Z_alias ;
	carry_weight -= object[O_cap][J_weight] ;
	carry_count-- ;

} /* --- end of the "dropper" subroutine --- */
