#define OPNR
#include "dink_sym.h"
#include "dink_glb.h"

void dialer(n)
/*****************************/
/*      "dial" command"      */
/*     Version:  Mk 1.1      */
/*      29 October 1989      */
/*****************************/
int n ;
{

/* deal with the question of "What is the combination?" */
if (tag[V_what]) {
printf("I really don't know.  You might try looking around for a\n") ;
printf("series of numbers. Sometimes that can be a clue to the\n") ;
printf("actual combination.\n") ;
	return ;
}

/* See if the combination was dialed in the right place */
if ((n == R_office_mang)&&
	(room[R_office_mang][M_rm_status] >= S_revealed)) {
	if (tag[V_0] && tag[V_49] && tag[V_67] && tag[V_82]) {
		printf ("Click!! \n");
		room[R_office_mang][M_rm_status] = S_dialed ;
		return ; 
	}
printf ("You turned the dial but nothing happened.  I think you \n");   
printf ("dialed the wrong thing. \n");
	return ; 
}
printf ("How am I supposed to dial that? \n");
} /* --- end of the "dialer" subroutine --- */

 
void inventer()
/*****************************/
/*   "inventory" command     */
/*     Version:  Mk 1.0      */
/*       11 March 1989       */
/*****************************/
{
#ifdef __TURBOC__
void objector(int) ;
#endif

register int i;
int i_ws, j_ws ;
 
i_ws = 0 ;
j_ws = 0 ;
for (i = 0; i <= objcnt; i++) if (object[i][J_loc] == B_have)  {
	++j_ws;
	i_ws = i ;
	} ;
if ((j_ws == 0)&&(gleep_count == 0)) {
	printf("You've got NOTHING!! \n") ;
	return ;
}
if (j_ws >= 1) {
	if (j_ws == 1) {
		printf("You are carrying ") ;
		objector(i_ws);
		printf ("\n") ;
	}
	else {
		printf ("You are carrying the following: \n");
		for (i = 0; i <= objcnt; i++) {
			if (object[i][J_loc] == B_have) {
				printf ("        ") ;
				objector(i);
				printf ("\n") ;
			}
		}
	}
}
if (gleep_count > 0) {
	if (gleep_count == 1) {
		printf("You have one gleep.\n") ;
		return ;
	}
	printf("You are carrying %d gleeps. \n",gleep_count) ;
}

} /* --- end of the "inventor" subroutine --- */
 
void drinker()
/*****************************/
/*     "drink" command       */
/*     Version:  Mk 1.0      */
/*       11 March 1989       */
/*****************************/
{

if (tag[V_can]) {
	if (object[O_can][J_loc] == B_have) {
		printf("The XXXX keeps on coming on ? \n") ;
printf("I think not, for there is no Fourex left for me to drink!\n") ;
	}
	else goto no_booze ;
	return ;
}

if (tag[V_bottle]) {
	if (object[O_bottle][J_loc] == B_have) {
printf("Some greedy larrikin has drunk up all of the Black Swan! \n") ;
	printf("Bad on Him! There is none left for me! \n") ;
	return ;
	}
no_booze:
	printf ("You don't have it in your possession to drink!\n");
	return ;
}

if (tag[V_water]) {
	printf("There is no water here that I am willing to drink.\n") ;
	return ;
}
	
printf ("What exactly do you want me to drink? \n");
return; 

} /* --- end of the "drinker" subroutine --- */
 
void reader()
/*****************************/
/*      "read" command       */
/*     Version:  Mk 1.1      */
/*        21 April 1989      */
/*****************************/
{
#ifdef __TURBOC__
void rdtxt(int) ;
#endif

int k ;

/* reject an isolated "read" command */
if (tag[V_VERB_ONLY]) { 
		printf ("What exactly do you want me to read? \n");
		return;
}

for (;;) {
	/* map from the manager's office */
	if (tag[V_map]) {
		k = O_map_frag ;
		break;
	}

	/* Qadaffi's letter */
	if (tag[V_letter]) {
		k = O_letter ;
		break ;
	}

	/* paper from the safe */
	if (tag[V_paper]) {
		k = O_paper ;
		break;
	}

	/* Deal with unreadable objects */
	printf("There is no way in which I can read that. \n");
		return ;
} /* end of the infinite for loop */

if (object[k][J_loc] == B_have) rdtxt(k) ;
else printf ("I can't read it because it isn't in my possession. \n");
}         /* --- end of the subroutine "reader" --- */

void unlocker(n)
/*****************************/
/*     "unlock" command      */
/*      Version: Mk 1.1      */
/*      16 September 1989    */
/*****************************/
int n ;
{
 
if (tag[V_VERB_ONLY]) {
	printf ("What do you want me to unlock? \n");
	return; 
}

if (room[n][M_rm_type] == T_action_obj) {
	switch (n) {

	/* Managers office */
	case R_office_mang:
		if (tag[V_safe]) {
printf("This is a combination type safe (no key hole).  You must\n");
printf("dial a combination in order to open this safe. \n");
		}
		else 
printf("You're wasting your time.  You can't unlock that! \n");
		return;

	/* office entrance */
	case R_office_entr:
	if (tag[V_door]) {
		if (room[R_office_entr][M_rm_status] == S_open) {
			printf("The door is already open! \n");
			return;
		}
		if (room[R_office_entr][M_rm_status] == S_kicked) {
			printf("The door has been kicked in! \n");
			return;
		}
		if (room[R_office_entr][M_rm_status] == S_unlocked) {
printf("The door is already unlocked.  However it is still closed! \n");
			return;
		}
		/* The door has to still be unlocked */
		if (tag[V_key]) {
		if (object[O_key][J_loc] != B_have) {
printf("You don't have the key to this door in your possession! \n");
		}
		else {
			printf("You turn the key in the lock and ") ;
			printf("hear a satisfying \"click\".\n");
			room[R_office_entr][M_rm_status] = S_unlocked ;
		}
		}
		else printf ("With what shall I unlock the door? \n");
		return; 
	}

	default:
printf("I don't think that is the sort of thing one unlocks.\n") ;
	}  /* end of "unlock" room scan switch */
} /* end of "unmovable action device" block */
else printf("There is nothing here that can be unlocked! \n");
return ;
}  /* --- end of the "unlocker" subroutine --- */

void closer(n)
/*****************************/
/*     "close" command       */
/*     Version:  Mk 1.0      */
/*     12 November 1988      */
/*****************************/
int n ;
{
 
/* scan "close" sentence */
if (room[n][M_rm_type] != T_action_obj) {
printf("There is nothing here that can be closed! \n");
	return; 
}

if (tag[V_VERB_ONLY]) {
	printf ("What exactly do you want me to close? \n");
	return; 
}

switch (n) {
	/* office door */
	case R_office_entr:
		if (!tag[V_door]) break ;
		if (room[R_office_entr][M_rm_status] == S_kicked) {
printf("The door has been kicked in!  It'll never be closed again.\n");
			return;
		}
		if (room[R_office_entr][M_rm_status] == S_open) {
		printf("The office door closes with a slam. \n");
			room[R_office_entr][2] = -1 ;
			room[R_office_entr][M_rm_status] = S_closed ;
			return ;
		}
		else printf("The office door is already closed! \n");
		return ;

	/* managers office */
	case R_office_mang:
	if ((!tag[V_picture])&&(!tag[V_safe])) break;
	if (tag[V_safe]) {
		if (room[R_office_mang][M_rm_status] < S_dialed) 
		printf("The safe is already closed. \n");
		else {
	printf("The safe door closes and locks with a \"click\". \n");
			room[R_office_mang][M_rm_status] = S_revealed ;
		}
	}
	if (tag[V_picture]) {
		if (room[R_office_mang][M_rm_status] == S_closed) 
		printf("The platypus picture is already closed. \n");
		else  {
printf("The picture swings flush against the wall, hiding the safe.\n");
			room[R_office_mang][M_rm_status] = S_closed ;
		}
	}
	return ;

} /* end of the "close" switch */
printf ("I really don't see how one would close that? \n");
return; 
} /* --- end of the "closer" subroutine --- */

void opener(n)
/*****************************/
/*      "open" command       */
/*     Version:  Mk 2.1      */
/*     25 April 1990         */
/*****************************/
int n ;
{
#ifdef __TURBOC__
void boom(void), ender(int), objector(int) ;
#endif

register int i ;

/* deal with a terse command */
if (tag[V_VERB_ONLY]) {
	printf ("What exactly do you want me to open? \n");
	return; }
 
if (tag[V_can]) {
	if (object[O_can][J_loc] == B_have) 
printf("Some bugger has already drunk it up. The stubee is empty!\n");
	else printf("You don't have a can to open! \n") ;
	return; 
}

if (tag[V_letter]) {
	if (object[O_letter][J_loc] == B_have) {
		boom() ; /* cause an explosion */
printf("It's not polite to read other people's mail!!  As you lay\n") ;
printf("bleeding on the floor with your hands and arms blown away,\n") ;
printf("you realize that envelope actually contained a letter bomb!\n");
printf("(A trick widely used by terrorists in the 1970s).  However\n");
printf("the knowledge does you little good since your spirit soon\n");
printf("departs this mortal coil.\n");
		ender(F_died) ;
	}
	else printf("You don't have a letter to open!\n") ;
	return ;
}

if (tag[V_bottle]) {
	if (object[O_bottle][J_loc] == B_have)
printf("Some bugger has already drunk it up. The bottle is Empty! \n");
	else printf("You don't have a bottle to open! \n") ;
	return; 
}

if (tag[V_umbrella]) {
	if (object[O_umbrella][J_loc] == B_have) {
printf("You open the umbrella but find it's full of holes and\n");
printf("its clasp is broken.  As soon as you release it, the\n");
printf("umbrella snaps shut.\n") ;
	}
	else printf("You don't have an umbrella to open! \n") ;
	return; 
}
 
/* Now check to see if the location is consistent with the command */
if (room[n][M_rm_type] != T_action_obj) { 
	printf ("I don't understand what you want me to open. \n") ;
	return ;
}

switch (n) {
	/* office entrance (door) */
	case R_office_entr:
		if (tag[V_door]) {
		switch (room[R_office_entr][M_rm_status]) {
			case S_kicked:
printf("The door has been kicked in!  You don't need to open it.\n");
				return;
		
			case S_open:
				printf("The door is already open! \n");
				return ;
		
			case S_unlocked:
printf("As you push open the office door, the rusty hinges creak \n");
printf("from long disuse.  Darkness and stale air seem to exude \n");
printf("from the vacant office.  The way is free for you to enter. \n");
				room[R_office_entr][2] = R_office_hall ;
			room[R_office_entr][M_rm_status] = S_open ;
				return ;
		
			case S_closed:
printf("The office door is locked tight.");
printf("  You need to unlock it with a key. \n");
				return ;
		} /* end of room status switch */
		} /* end of the door "if" block */
		break ;

	/* managers office */
	case R_office_mang:
		if ((!tag[V_picture])&&(!tag[V_safe])) {
printf("I don't understand how I would open that.\n") ;
			return ;
		}

		if (tag[V_picture]) {
		switch (room[R_office_mang][M_rm_status]) {
		case S_closed:
printf("You swing open the platypus picture revealing a large wall \n");
printf("safe with a combination dial. \n");
			room[R_office_mang][M_rm_status] = S_revealed ;
			break ;
		default:
printf("The picture is already swung out.  The problem is to open \n");
printf("the safe!!  Hint:  Dial in a combination. \n");
			return ;
		}
		} /* end of the picture "if" block */

		if (tag[V_safe]) {
		switch (room[R_office_mang][M_rm_status]) {
		case S_closed:
printf("I can see no safe in this office for me to open.  Perhaps\n");
printf("there is a safe hidden in this office somewhere.\n");
			return ;

		case S_revealed:
printf("The safe is locked.  You must first dial the combination\n");
printf("in order to open it.  See if you can find the combination. \n");
			return ;
		
		case S_dialed:
	printf("The safe door swings open smoothly and easily. \n");
			room[R_office_mang][M_rm_status] = S_open ;
			sw_active = TRUE ;
			for (i=0; i <= objcnt; i++) 
			if (object[i][J_loc] == B_in_safe) {
printf ("Inside the safe, you see the following: \n");
				for (i=0; i <= objcnt; i++) {
				if (object[i][J_loc] == B_in_safe) {
					printf ("        ") ;
					objector(i);
					printf ("\n") ;
				}
				}				
				return ;
			}
		printf("---The safe is empty.--- \n");
			return ;

		case S_open:
			printf("The safe is already open! \n");
			return ;
		} /* end of the "safe" status switch */
		} /* end of the safe "if" block */
		return ; /* this return statement must remain */

	/* Lift door(s) */
	case R_lift_entr:
		if (tag[V_door]||tag[V_lift]) {
printf("It is not exactly clear how I would open these doors.\n") ;
printf("However I see a push button next to the lift doors.\n") ;
printf("Perhaps if I pressed the button something would happen.\n") ;
		}
		else printf("I'm confused about what I should open.\n");
		return ;
		
} /* end of the "open" room switch */
printf ("I see nothing here that I can open. \n") ;
} /* --- end of the "opener" subroutine --- */

void boom()
{
printf("\n\n");
printf("BBBBBB      OOOOO        OOOOO      MM        MM      !!!\n");
printf("B    BB   OO     OO    OO     OO    M M      M M      !!!\n");
printf("B    BB   OO     OO    OO     OO    M  M    M  M      !!!\n");
printf("BBBBBB    OO     OO    OO     OO    M   M  M   M      !!!\n");
printf("B    BB   OO     OO    OO     OO    M    MM    M      !!!\n");
printf("B    BB   OO     OO    OO     OO    M          M\n");
printf("BBBBBB      OOOOO        OOOOO      M          M      !!!\n\n");
} /* --- end of the "boom" subroutine --- */
