#define GLPR
#include "dink_sym.h"
#include "dink_glb.h"

void gleeper(n) 
/********************************************/
/*                                          */
/*           Gleeper Subroutine             */
/*                                          */
/*     Software by Gary A. Allen, Jr.       */
/*           Version: Mk 1.00               */
/* (c) Copyright 1989 by Gary A. Allen, Jr. */
/*                                          */
/********************************************/
int n ;
{
register int i ;
int count ;
static int sw_glp_st = FALSE, cnt_down = 0 ;

/* Gleep display routine */
count = room[n][M_gleep] ;

if (((object[O_torch][J_loc] == B_have)&&object[O_torch][J_property])|| 
	(n < 186)||(n > 202)) { 
	if (count != 0) {
		sw_glp_st = TRUE ; /*  gleeps can now multiply */
		if (count != 1) 
	    	   printf("There are %d gleeps here. \n",count) ;
		else printf("There is a gleep here. \n") ;
		return ;
	}
}

/* Gleep reproduction routine */
if (sw_glp_st == TRUE) {
	if (++cnt_down > 5) {
		cnt_down = 0 ;
		for (i = 0; i <= 9; i++) {
			if (room[gleep_spot[i]][M_gleep] == 0) continue;
			if (room[gleep_spot[i]][M_gleep] > 10000) 
				++room[gleep_spot[i]][M_gleep] ;
			else room[gleep_spot[i]][M_gleep] <<= 1 ;
		}
	}
}
} /* --- end of "gleeper" subroutine --- */

void ender(i_quit)
/********************************************/
/*                                          */
/*            Ender Subroutine              */
/*                                          */
/*     Software by Gary A. Allen, Jr.       */
/*           Version: Mk 1.00               */
/* (c) Copyright 1989 by Gary A. Allen, Jr. */
/*                                          */
/********************************************/
 
int i_quit ;
{
#ifdef __TURBOC__
void hold_it(void), new_score(void), exit(int) ;
#endif

/* get last score */
new_score() ;

if (gleep_score != 0) sw_active = TRUE ; 

if (i_quit == F_died) { 
	hold_it() ;
	score -= 100 ;
printf ("\nOh Dear!  You've just turned yourself into a corpse! \n\n");
printf ("For getting killed you lose 100 points. \n\n") ;
}

if (!sw_active) {
	if (score == 0) { 
		printf("You concluded the game with no points.  ") ; 
		printf("What a pitiful performance!!\n") ;
	}
	else {
printf("You concluded the game with a miserable negative score\n") ;
printf("of %d points.  Your score was better BEFORE you \n",score);
printf("started playing (need I say more on how this reflects\n");
printf("upon your limited aptitude at Dinkum).\n") ;
	}
	goto all_done ;
}

if (score == 0)  {
printf("You concluded the game with no points ") ;
	if (gleep_score == 0) { 
printf("and didn't drop a single gleep\n") ;
printf("into the gleep tank. What a pitiful performance!!\n") ;
	}
	else {
		if (gleep_score > 1) {
printf("but you did put %d gleeps\n",gleep_score) ;
printf("into the gleep tank.\n") ;
		}
		else {
printf("but you did manage to find a gleep\n") ;
printf("and put it in the gleep tank, (Hah!! What an achievement!).\n");
		}
	}
}

else {
if (score > 0)
printf ("You concluded the game with %d points",score);
else {
printf("You concluded the game with a miserable negative score\n") ;
printf("of %d points.  Your score was better BEFORE you \n",score);
printf("started playing (need I say more on how this reflects\n");
printf("upon your limited aptitude at Dinkum).  You ") ;
	if (gleep_score == 0) { 
printf("also failed to\nget any gleeps into the tank.  At least ");
printf("you're consistent.\n\n") ;
	}
	else {
printf("managed\nto get something into the gleep tank.  However ");
printf("it hardly\nmatters, considering your poor score.\n\n") ;
	}
	goto all_done ;
}
	if (gleep_score == 0) 
printf(".\nHowever you placed no gleeps in the gleep tank.\n") ;
	else {
		if (gleep_score > 1) {
printf (" and placed %d gleeps\n",gleep_score) ;
printf ("in the gleep tank.  Good on you, Mate!\n") ;
		}
		else {
printf(" but you did manage to find a gleep\n") ;
printf("and put it in the gleep tank.  ") ;
printf("However any idiot could do that!\n") ;
		}
	}
}
all_done:
printf("\nDinkum has ended.  If you are interested in more ") ;
printf("information\nabout this program type:    dinkum -h\n") ;
exit(0);
} /* --- end of "ender" routine --- */
 
void clip_in(ammo_flag)
/********************************************/
/*                                          */
/*            Clip_In Subroutine            */
/*                                          */
/*     Software by Gary A. Allen, Jr.       */
/*           Version: Mk 2.00               */
/* (c) Copyright 1990 by Gary A. Allen, Jr. */
/*                                          */
/********************************************/

int ammo_flag ;
{
/* ammo clip insertion routine */
if (object[O_rifle][J_loc] != B_have) {
printf("Galah!!  You don't have a rifle to put an ammo clip into.\n");
	return ;
}
if (clip_flag != F_no_clip) {
printf("There is already an ammo clip in the rifle. \n") ;
	return ;
}
if (((object[O_clip][J_loc] != B_have)&&(ammo_flag == F_normal_clip))||
((object[O_org_clip][J_loc] != B_have)&&(ammo_flag == F_org_clip))) {
printf("You don't possess an ammo clip to put into the rifle.\n");
	return ;
}
/* actually load the clip into the rifle */
object[O_rifle][J_type] = Z_alias ;
carry_count-- ;
carry_weight -= object[O_clip][J_weight]  ;
if (ammo_flag == F_normal_clip) {
	object[O_clip][J_loc] = B_unmade ;
	clip_flag = F_normal_clip ;
	object[O_rifle][J_property]  = object[O_clip][J_property] ;
}
else {
	object[O_org_clip][J_loc] = B_unmade ;
	clip_flag = F_org_clip ;
	object[O_rifle][J_property] = object[O_org_clip][J_property] ;
}
printf("The ammunition clip slides into the rifle with a \"click\".\n");
printf("You have %d bullets in the clip \n",
			object[O_rifle][J_property]) ;
if (object[O_rifle][J_property] > 0) 
	printf("You cycle the M16's bolt once to chamber a round.\n");
return ;
}

void clip_out(n)
/********************************************/
/*                                          */
/*           Clip_Out Subroutine            */
/*                                          */
/*     Software by Gary A. Allen, Jr.       */
/*           Version: Mk 1.00               */
/* (c) Copyright 1989 by Gary A. Allen, Jr. */
/*                                          */
/********************************************/
int n ;
{
int ammo_flag ; 

/* remove clip from rifle */
if (object[O_rifle][J_loc] != B_have) {
	printf("You Bloody Galah!  ") ;
	printf("You don't have a rifle in your possession!\n");
return ;
}
if (clip_flag == F_no_clip) {
	printf("There is no clip in the rifle. \n") ;
return ;
}
/* eject the clip from the rifle */
object[O_rifle][J_type] = Z_normal ;
if (clip_flag == F_normal_clip) {
	object[O_clip][J_loc] = n ;
	ammo_flag = F_normal_clip ;
}
else {
	object[O_org_clip][J_loc] = n ;
	ammo_flag = F_org_clip ;
}
++room[n][M_obj_cnt] ;
clip_flag = F_no_clip ;
printf("You press the \"eject\" button on the rifle and the ") ;
printf("magazine falls to the ground.\n") ;
if (object[O_rifle][J_property] > 0) {
printf("You then cycle the M16's bolt once to clear the chamber. ");
printf("The unfired round\n") ;
printf("is ejected from the breech and rolls out of sight. \n") ;
	if (ammo_flag == F_normal_clip) 
		object[O_clip][J_property] = 
			--object[O_rifle][J_property] ;
		else object[O_org_clip][J_property] = 
				--object[O_rifle][J_property] ;
	object[O_rifle][J_property] = 0 ;
}
return ;
}

void igniter(n)
/********************************************/
/*                                          */
/*           Igniter Subroutine             */
/*                                          */
/*     Software by Gary A. Allen, Jr.       */
/*           Version: Mk 1.00               */
/* (c) Copyright 1989 by Gary A. Allen, Jr. */
/*                                          */
/********************************************/

int n ;
{
#ifdef __TURBOC__
void switcher(int) ;
long time(int) ;
#endif

/* reject single verb command */
if (tag[V_VERB_ONLY]) {
	printf("What exactly do you want me to set alight?\n") ;
	return ;
}

/* deal with 'light torch' command */
if (tag[V_torch]) {
	switcher(n) ;
	return ;
}

/* see if the user has or requested matches */
if (!tag[V_match]) {
printf("What am I to light it with?\n") ;
printf("(I am not prepared to rub two sticks together.)\n") ;
	return ;
}
if (object[O_matches][J_loc] != B_have) {
printf("I have no matches!\n") ;
	return ;
}
else {
/* reject spurious "ignite" command */
	if ((!tag[V_cap])&&(!tag[V_dynamite])&&
		(sent[2] != V_LINE_END)) {
printf("It would be a fire hazard to set that alight.\n");
		return ;
	}

/* deal with spurious "light dynamite with match" */
if (tag[V_dynamite]&&(object[O_dynamite][J_loc] != B_have)) {
printf("You have no dynamite to ignite.\n") ;
	return ;
}

/* deal with spurious "light cap with match" */
if (tag[V_cap]&&(object[O_dynamite][J_loc] != B_have)&& 
	(object[O_cap][J_loc] != B_have)) {
printf("You don't have one to ignite.\n") ;
	return ;
}

/* light up the match(es) */
	if (tag[V_PLURAL]) {
printf("You open up the match box and strike ALL of the matches.\n");
		object[O_matches][J_loc] = B_destroyed ;
	}
	else {
printf("You take one match from the match box and ignite it.\n") ;
	}
}

/* see if user selected burnable objects */
if (tag[V_cap]&&(object[O_cap][J_loc] == B_have)) {
printf("You then ignite the fuse of the blasting cap.\n\n"); 
printf("Ssssssssssssssssssssssss........\n");
	clock_explode = time(0) + 11 ;
	sw_clock = TRUE ;
	flag_clock = V_cap ;
	return ;
}

if ((tag[V_cap]||tag[V_dynamite])&&
	(object[O_dynamite][J_loc] == B_have)) {
	if (object[O_dynamite][J_type] == Z_alias) {
printf("You then ignite the fuse of the dynamite's blasting cap....\n");
printf("You need to very quickly get very far away from this thing!!");
printf("\n\nSsssssssssssssssssssssss........\n");
		clock_explode = time(0) + 11 ;
		sw_clock = TRUE ;
		flag_clock = V_dynamite ;
	 	return ;
	}
	else {
printf("You then ignite the dynamite. Which is an odd thing\n"); 
printf("to do since it doesn't have a blasting cap in it.  The\n");
printf
  ("\"dynamite\" (which is actually a very safe mining explosive)\n");
printf("burns for a few minutes, billowing out smelly black smoke\n");
printf("and eventually goes out leaving a few scant ashes behind.\n") ;
		object[O_dynamite][J_loc] = B_destroyed ;
	 	return ;
	}
}

} /* -- end of the "igniter" subroutine --- */

void hold_it()
/********************************************/
/*                                          */
/*            Wait Subroutine               */
/*                                          */
/*     Software by Gary A. Allen, Jr.       */
/*           Version: Mk 1.00               */
/* (c) Copyright 1989 by Gary A. Allen, Jr. */
/*                                          */
/********************************************/

{
#ifdef __TURBOC__
char getch(void) ;

/* Stop scrolling the screen until the user is ready */
printf("               [Press any key to continue]\r") ;
getch() ;
printf("                                          \n") ;
#endif

#ifndef __TURBOC__
printf("               [Press RETURN to continue]\n") ;
getchar() ;
#endif

} /* --- end of the "hold_it" subroutine --- */

void eater()
/********************************************/
/*                                          */
/*            Eater Subroutine              */
/*                                          */
/*     Software by Gary A. Allen, Jr.       */
/*           Version: Mk 1.00               */
/* (c) Copyright 1989 by Gary A. Allen, Jr. */
/*                                          */
/********************************************/
{

#ifdef __TURBOC__
void ender(int) ;
#endif

/* reject single verb command */
if (tag[V_VERB_ONLY]) {
	printf("What exactly do you want me to swallow?\n") ;
	return ;
}

/* deal with "eat (atropine) pill(s)" command */
if (tag[V_pill]) {
	if (object[O_pills][J_loc] != B_have) {
printf("You don't have the atropine pills in your possesion!\n") ;
		return ;
	}
	if (tag[V_PLURAL]) {
printf("You remove ALL of the pills from the packet and swallow\n");
printf("the lot.  For a couple of minutes nothing happens, then you\n");
printf("start seeing double and have nervous twitches. You then\n");
printf("start shaking violently and collapse to the ground.\n") ;
printf("Eventually you pass out and expire from atropine poisoning.\n");
		ender(F_died) ;
	}
	if (--pill_count <= 0 ) {
		object[O_pills][J_loc] = B_destroyed ;
		carry_count-- ;
		carry_weight -= object[O_pills][J_weight]  ;
printf("You swallow the last atropine pill and throw away the empty\n");
printf("packet which disappears from sight.  ") ;
	}
else printf("You swallow one atropine pill.  ") ;
		i_poison += 10 ;
		if (i_poison >= 30) {
printf("\nAfter a moment you have a violent seizure and die.\n") ;
			ender(F_died) ;
		}
		if (i_poison >= 20) {
printf("\nYou begin to shake violently and can barely stand.\n") ;
			return ;
		}
		if (i_poison >= 15) {
printf("\nYour hands become a bit jittery and your vision blurred.\n") ;
			return ;
		}
		printf("The drug has no ill effect.\n") ;
	return ;
}
else 
printf("I am not inclined towards putting that into my mouth!\n") ;

} /* --- end of the "eater" subroutine --- */
