#define ACTOR
#include "dink_sym.h"
#include "dink_glb.h"
 
void actor(n)
/********************************************************************/
/*                                                                  */
/*  Software by Gary A. Allen, Jr.  12 March 1989,  Version: Mk 1.1 */
/*           (c) Copyright 1989 by Gary A. Allen, Jr.               */
/*                                                                  */
/********************************************************************/
int n ;
{
#ifdef __TURBOC__
void objector(int) ;
#endif

int i ;
static int sw_door_kick = FALSE ;

switch(n) {

	/* mine elevator */
	case R_lift_entr:
		if (room[R_lift_entr][M_rm_status] == S_closed) {
printf("The lift doors are closed and the lift call button ");
printf("is not glowing. It \nseems the electrical power has ");
printf("been turned off at the main switch. \n"); }
		if (room[R_lift_entr][M_rm_status] == S_flashing) {
printf("The lift doors are closed.  However the call button");
printf(" is flashing. There \nis the sound of electrical equipment ");
printf("humming within the mine lift. \n"); }
		if (room[R_lift_entr][M_rm_status] == S_open) {
printf("The lift doors are standing open. \n");
		}
		break;
 
	/* office building door */
	case R_office_entr:
		switch(room[R_office_entr][M_rm_status]) {
			case S_open:
printf("      --- The office front door is open. --- \n");
				break;
			case S_kicked:
				if (!sw_door_kick) {
printf("The lock of the front door has been shot at several times.\n"); 
printf("The door itself has been kicked in and is broken off at\n") ;
printf("the hinges.  The passage way is free to enter.\n");
				sw_door_kick = TRUE ;
				}
				else {
printf("The front door of the office has been kicked in. \n") ;
				}
				break ;
			default:
printf("The office has a front door with a sun faded sign \n"); 
printf("upon which is written:  \"Sorry, We are CLOSED\". \n");
printf("      --- The office door is shut. --- \n");
				break ;
		}
		break ;
 
	/* Site Managers Office */
	case R_office_mang:
		if (room[R_office_mang][M_rm_status] == S_closed) {
printf("On the wall is a picture of a platypus wearing a hat with");
		printf(" corks \ndangling from the hat's rim.\n");
			break;
		}
if ((room[R_office_mang][M_rm_status] == S_revealed)||
	(room[n][M_rm_status] ==S_dialed)) {
printf("Before you is a picture hinged to the wall that has been ");
printf("swung \nopen revealing a closed combination dial wall safe.\n");
			break;}
		if (room[n][M_rm_status] == S_open) {
printf("Before you is a picture hinged to the wall that has been");
printf(" swung \nout revealing a wall safe with an open door.\n");
		for (i=0; i <= objcnt; i++) {
			if (object[i][J_loc] == B_in_safe) 
				goto safelist;
		}
		if (gleep_safe != 0) {
printf("There is nothing in the safe except ") ;
			if (gleep_safe == 1) 
				printf("a single gleep.\n") ;
			else
				printf("%d gleeps.\n",gleep_safe) ;
			break ;
		}
		printf("---The safe is empty.--- \n");
		break ;
safelist:
		printf ("You see the following inside the safe: \n");
		for (i=0; i <= objcnt; i++) {
			if (object[i][J_loc] == B_in_safe) {
				printf ("        ");
				objector(i) ;
				printf ("\n") ;
			}
		}				
		if (gleep_safe != 0) {
			printf ("        ");
			if (gleep_safe == 1) 
				printf("one gleep\n") ;
			else
				printf("%d gleeps\n",gleep_safe) ;
		}
			break;
		}

	/* store room */
	case R_store_room:
printf("There is a 1500 Volt circuit breaker box on the wall");
		if (room[n][M_rm_status] == S_off) 
printf(" which has \na switch set in the \"off\" position. \n"); 
		else
printf(" which has \na switch set in the \"on\" position. \n"); 
		break;

	/* lift compartment */
	case R_lift_inside:
		if (room[n][M_rm_status] == S_L0) 
printf("The level button with the number zero is flashing. \n"); 
		if (room[n][M_rm_status] == S_L49) 
printf("The level button with the number forty-nine is flashing. \n"); 
		if (room[n][M_rm_status] == S_L67) 
printf("The level button with the number sixty-seven is flashing. \n");
		if (room[n][M_rm_status] == S_L82) 
printf("The level button with the number eighty-two is flashing. \n"); 
		break;

} 
} /* --- end of subroutine "actor"--- */

void objector(i)
int i ;
{
static char *obj[] = {
"an empty can of Fourex beer",
"a cigarette butt",
"an empty bottle of Black Swan Lager",
"an old doormat with \"ACME Gold Mines Ltd.\" written on it",
"a large brass key",
"a ripped and bent up umbrella",
"a two meter length of fishing tackle without a hook",
"a broken drill bit",
"a very old but detailed map of the ACME Mine",       /*  5  */
"a fragment of a map showing the ACME Mine",
"a sheet of paper with some writing on it",
"a gold bar weighing ten kilograms",
"a hydraulic jack which is rusted solid",
"a large stick of dynamite",
"an M16 ammo clip designed to hold up to 200 rounds",
"a fountain pen which is dried up and useless",
"an orange M16 ammo clip which is glowing a faint pale blue",
"a mechanical pencil without any leads",
"an unloaded, fully automatic M16 infantry rifle",    /*  10 */
"a piece of copper wire",
"a short length of galvanized iron pipe",
"a blasting cap with 20 cm. of fuse attached",
"a box of \"Red Head\" matches",
"a diamond ring with a three carat flawless blue diamond",
"a can opener",
"a bright red ruby the size of an egg",               /*  15 */
"an antique sterling silver teapot with \"N.K.\" engraved on it",
"a silver Syracusian Dekadrachma coin",
"an electrical extension cord",
"a $100 dollar bill",
"an autographed photo of Sir Joh",
"an old folding chair",
"a burned out light bulb",
"a packet containing atropine pills",
"a high quality artificial saphire",
"a huge uncut emerald",
"an oily rag",
"a burned out fluorescent tube",
"a filthy worn out carpet",
"a branch from a gum tree",
"a thick airmail letter, marked \"Postage Due\"",
"a cork from a wine bottle",
"a high intensity battery powered torch",
"an old cockroach trap",
"an empty butane cigarette lighter",
"a small black cube with a blue push button on one side", 
"an ancient and priceless gong clapper made of ivory and gold",
"a Semtex explosive detector with a push button switch",
"a broken shoe lace",
"a dirty old comb",
"a Cornetto ice cream cone wrapper",
"a bald automobile tyre",
"an empty broken egg shell",
"a broken piece of brick",
"a one meter length of rope",
"an empty package of Stradbroke cigarettes",
"a broken automobile fan belt",
"a used automobile oil filter",
"a short piece of string"
};

/* Deal with transformed objects */
if (object[i][J_type] == Z_alias) {
	if (i == O_rifle) {
printf("an M16 infantry rifle with an ammunition clip inserted") ;
		return ;
	}
	if (i == O_dynamite) {
printf("a large stick of dynamite with a fuse type blasting cap") ;
		return ;
	}
}
else printf("%s",obj[i]) ;
} /* --- end of subroutine "objector"--- */
 
void killer(n)
/********************************************************************/
/*                                                                  */
/*  Software by Gary A. Allen, Jr. 22 January 1989  Version: Mk 1.3 */
/*           (c) Copyright 1989 by Gary A. Allen, Jr.               */
/*                                                                  */
/********************************************************************/
int n ;
{
#ifdef __TURBOC__
void ender(int) ;
#endif
register int i, j ;
int hits, j_point, i_10, i_fract ;
int sw_kill, target_k_flag, sw_see, sw_other_object ;
static int sw_hurt = FALSE ;

if (tag[V_VERB_ONLY]&&(verb == V_kill)) {
printf("It may be obvious to you, but you are going to have to tell\n");
printf("me exactly what it is you want to have killed, and \n") ;
printf("with what sort of weapon. \n") ;
	return;
}

/* set the subroutine local flags */
if (verb == V_kill) sw_kill = FALSE ;
if (verb == V_shoot) sw_kill = TRUE;
target_k_flag = V_NULL ;
sw_see =  FALSE ;
sw_other_object = FALSE ;
 
if (tag[V_ned]) {
	if (enemy[N_ned][E_location] == B_destroyed) {
printf("Forget it, you drongo!! Ned Kelly is already dead!\n") ;
		return ;
	}
	if (enemy[N_ned][E_status] == F_asleep) {
printf("There is no Ned Kelly here for me to kill! \n") ;
		return ;
	}
	j_point = 0 ; 
	sw_see =  TRUE ;
	target_k_flag = V_ned ;
}

if (tag[V_bear]) {
	for (j = 2; j <= 5; j++) {
		if (enemy[j][E_status] != F_asleep) {
			j_point = j ; 
			goto bear_see ;
		}
	}
	printf("I see no drop bear for me to kill! \n") ;
	return ;
bear_see:
	sw_see =  TRUE ;
	target_k_flag = V_bear ;
}

if (tag[V_wombat]) {
	if (enemy[N_wombat][E_status] == F_asleep) {
		printf("I see no wombat for me to kill!\n");
		return ;
	}
	j_point = N_wombat ; 
	sw_see =  TRUE ;
	target_k_flag = V_wombat ;
}

if (tag[V_snake]) {
	for (j = 6; j <= 13; j++) {
		if (enemy[j][E_status] != F_asleep) {
			j_point = j ; 
			goto hoop_see ;
		}
	}
	printf("I see no hoop snake for me to kill! \n") ;
	return ;
hoop_see:
	sw_see =  TRUE ;
	target_k_flag = V_snake ;
}

if (tag[V_rifle]) sw_kill = TRUE ;

/* see if the safe is being shot at */
if (tag[V_safe]&&(n == R_office_mang)) {
printf("The safe is made out of harden steel.  You'll only waste ") ;
printf("ammunition \nshooting at it.  Try to open it instead. \n") ;
return ;
}

/* see if the target is in the room or holding it */
for (j=0; j <= objcnt; j++) {
	if (tag[object[j][J_parse_id]]){
 		if (object[j][J_parse_id] == V_rifle) continue ;
		sw_other_object = TRUE ;
		if (object[j][J_loc] == n) {
			sw_see =  TRUE ;
			target_k_flag = object[j][J_parse_id] ;
			break ;
		}
		if (object[j][J_loc] == B_have) {
printf("I will ***NOT*** shoot at something that I'm holding!!\n");
			return ;
		}
	}
}

if (tag[V_rifle] && (!sw_other_object)) tag[V_VERB_ONLY] = TRUE ;

if ((!tag[V_VERB_ONLY]) && (!tag[V_DIRECTION])) {
	if (!sw_see) {
		printf("I don't see it here to shoot at it. \n") ;
		return; 
	}

	if (target_k_flag == V_NULL) {
printf("It may be obvious to you, but you are going to have to tell\n");
printf("me exactly what it is you want to have killed.\n");
		return ;
	}
}

/* resolve killing errors */
if (!sw_kill) {
	printf("What weapon am I suppose to use? \n") ;
	return ;
}

if (object[O_rifle][J_loc] != B_have) {
printf("I would do that.  Only there is one small problem.... \n") ;
	printf("You don't have a rifle in your possesion! \n") ;
	return ;
}
 
/* Shoot the gun (or at least try to) */
printf("You pull the trigger... \n\n") ;
 
if (clip_flag == F_no_clip) {
printf("Nothing happens!  \n") ;
printf("Your rifle doesn't have an ammunition clip in it.\n") ;
	return ;
}
 
if (object[O_rifle][J_property] <= 0) {
	printf("Nothing happens!  The ammo clip is out of bullets.\n") ;
	return ;
}
 
switch(rifle_flag) {
case F_safety:
	printf("Nothing happens!  The rifle's safety is still on.\n");
	return ;
			
case F_single:
	printf("Bam! \n\n") ;
	--object[O_rifle][J_property] ;
	if (clip_flag == F_normal_clip) hits = 1;
		else hits = 100 ;
	break ;

case F_triple:
	if (object[O_rifle][J_property] >= 3) {
		printf("Bam! Bam! Bam! \n\n") ;
		object[O_rifle][J_property] -= 3 ;
		if (clip_flag == F_normal_clip) hits = 3;
			else hits = 300 ;
	}
	else {
		for (i = 1; i <= object[O_rifle][J_property]; i++) 
			printf("Bam! ") ;
			printf("\n\nYou've run out of bullets. \n\n") ;
		if (clip_flag == F_normal_clip) 
			hits = object[O_rifle][J_property];
			else hits = object[O_rifle][J_property]*100 ;
		object[O_rifle][J_property] = 0 ;
	}
	break ;

case F_auto:
	if (object[O_rifle][J_property] >= 30) {
		for (i = 1; i <= 3; i++) 
printf("Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! \n") ;
		object[O_rifle][J_property] -= 30 ;
		hits = 30;
	}
	else {
		i_10 = object[O_rifle][J_property]/10 ;
		i_fract = object[O_rifle][J_property]-(i_10*10) ;
		for (i = 1; i <= i_10; i++) 
printf("Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! Bam! \n") ;
		for (i = 1; i <= i_fract; i++) 
			printf("Bam! ") ;
			printf("\n\nYou've run out of bullets. \n") ;
		if (clip_flag == F_normal_clip) 
			hits = object[O_rifle][J_property];
			else hits = object[O_rifle][J_property]*100 ;
		object[O_rifle][J_property] = 0 ;
	}
	printf("\n") ;
	break ;
}
 

/* Target Seen block */
if (sw_see) {
	/* Toggle the hurt switch if this is the first hit */
	if (enemy[j_point][E_hits] == 0)  sw_hurt = FALSE ;
	enemy[j_point][E_hits] += hits ;

	switch(target_k_flag) {
	case V_ned:
printf("Ned Kelly keels over dead.  His body suddenly glows a bright ");
printf("orange like it\nis being consummed by a heatless flame ");
printf("and then the late Ned Kelly disappears\ninto a puff of ") ;
printf("blue smoke. \n\n") ;
printf("By the way, the recently deceased bushranger ***was*** ");
printf("wearing iron body\narmour.  However thin sheets of iron ");
printf("would just barely work against nineteenth\ncentury firearms ");
printf("at long range.  Against a modern infantry rifle, Ned's\n");
printf("armour offered about as much protection as a dunny paper ");
printf("bandage. \n") ;
		enemy[N_ned][E_location] = B_destroyed ;
		enemy[N_ned][E_status] = F_asleep ;
		monster_flag = F_no_monster ;
		room[R_hideout][M_monster] = 0 ;
	
		/* create Ned Kelly's silver teapot */
		++room[R_hideout][M_obj_cnt] ;
		object[O_teapot][J_loc] = R_hideout ;
		return ;

	/* shoot the drop bear */
	case V_bear:
		if (enemy[j_point][E_hits] < 30) {
			if (enemy[j_point][E_hits] == 1) {
printf("Your bullet hit the drop bear causing it to howl in ");
printf("anguish.  However drop\n");
printf("bears are pretty tough and just one bullet isn't ");
printf("going to kill it.\n") ;
			}
			else {
				if (!sw_hurt) {
printf("You've hit the drop bear and it is bleeding fairly ");
printf("heavily.\n");
printf("Unfortunately it is still alive and kicking and wants ") ;
printf("your blood \n");
printf("in payment for its.\n") ;
					sw_hurt = TRUE ;
				}
				else {
printf("You've hit the drop bear again.  It is weakening but still ");
printf("alive.\n");
				}
			}
			monster_flag = F_wounded ;
			goto mad_bear ;
		}

		if (rifle_flag == F_single) {
printf("That last bullet was the straw which broke the drop ") ;
printf("bear's back.\n") ;
printf("The blasted thing is finally dead! \n") ;
		}
		else {
printf("The bullets riddled the drop bear with holes, killing it ") ;
printf("instantly. \n") ; 
		}
printf("Suddenly the drop bear's corpse turns into a cloud of greasy ");
printf("blue smoke,\n") ;
printf("which floats away without a trace.\n") ;
		sw_hurt = FALSE ;
		enemy[j_point][E_location] = B_destroyed ;
		enemy[j_point][E_status] = F_asleep ;
		monster_flag = F_no_monster ;
		room[n][M_monster] = 0 ;
		return ;
 
		/* shoot the mutant wombat */
	case V_wombat:
		if (enemy[N_wombat][E_hits] < 300) {
			if (enemy[N_wombat][E_hits] == 1) {
printf("Your bullet hit the wombat causing it some minor discomfort.");
printf("  Judging from its \n");
printf("behavior, killing this beast is going to be tough! \n") ;
			}
			else {
				if (!sw_hurt) {
printf("You've hit the wombat and gotten its attention ") ;
printf("but you've not\n");
printf("seriously wounded it.  In fact, you've made it more fierce ");
printf("than before.\n");
					sw_hurt = TRUE ;
				}
				else {
printf("You've hit the wombat again, but it is still going ");
printf("strong.\n");
				}
			}
			monster_flag = F_wounded ;
			return ;
		}

		if (rifle_flag == F_single) {
printf("That last bullet was the straw which broke the ") ;
printf("wombat's back.\n") ;
printf("The blasted thing is finally dead!\n\n") ;
		}
		else {
printf("The bullets did the trick on the wretched thing.  It's ") ;
printf("dead as a doornail.\n\n") ;
		}
printf("Suddenly the wombat's corpse starts to glow with an intense");
printf(" white light.\n") ;
printf("There is then a crackling sound as its body starts to burn.");
printf("  You can\n");
printf("smell the stench of burning hair.  Then the white light");
printf(" begins to dim,\n");
printf("leaving no trace left of the once formidable monster.\n");
		sw_hurt = FALSE ;
		enemy[N_wombat][E_location] = B_destroyed ;
		enemy[N_wombat][E_status] = F_asleep ;
		monster_flag = F_no_monster ;
		room[n][M_monster] = 0 ;
		return ;
 
	/* shoot the hoop snake */
	case V_snake:
		if ((rifle_flag == F_single)&&
			(enemy[j_point][E_hits] < 3)) {
			if (enemy[j_point][E_hits] == 1) {
printf("Your bullet hit the hoop snake.  However the hoop snake's ");
printf("thick scales \n");
printf("slowed the bullet down.  The hoop snake is now hissing ");
printf("furiously. \n") ;
			}
			else {
printf("You've hit the hoop snake again, and it's hurting.  However ");
printf("it is still \n");
printf("alive and full of venom. \n") ;
			}
			monster_flag = F_wounded ;
			return ;
		}

		if (rifle_flag == F_single) {
printf("The bullet hit the hoop snake finishing the horrible ") ;
printf("creature off. \n") ;
		}
		else {
printf("The bullets hit the hoop snake splatting it into a mass of ") ;
printf("mince meat. \n") ; 
		}
printf("Suddenly the bullet holed snake glows red and whooshes ");
printf("into a cloud \n") ;
printf("steam, leaving no traces behind.\n\n") ;
		enemy[j_point][E_location] = B_destroyed ;
		enemy[j_point][E_status] = F_asleep ;
		monster_flag = F_no_monster ;
		room[n][M_monster] = 0 ;
		return ;

	case V_can:
	case V_beer:
	case V_fourex:
	case V_Fourex:
printf("The can is hit by a bullet and flies off out of sight.\n");
		object[O_can][J_loc] = B_destroyed ;
		return;


	case V_bottle:
	case V_lager:
printf("It is hit by a bullet and shatters into a million pieces.\n");
		object[O_bottle][J_loc] = B_destroyed ;
		return;

	} /* end of target switch group */
} /* end of the "target seen" block */
 
/* There was no target specified so the shot was wasted */
if (tag[V_VERB_ONLY]) { 
printf("You didn't specify a target. So the rifle was pointed\n") ;
printf("in a random direction and the ammunition wasted.\n") ;
}
else 
printf("Except for wasting ammunition, nothing much happened.\n") ;
return ;

mad_bear:
if (enemy[j_point][E_hits] < 10) return ;
printf("\nThe drop bear has been shot at so many times, that it ");
printf("has gone mad\n") ;
printf("with rage.  It leaps three meters and rips out your ") ;
printf("throat with a\n");
printf("single swish of its claws.  You die instantly. \n") ;
ender(F_died) ;
} /* --- end of the 'killer' subroutine --- */
