/******************************************************************************
***									    ***
***			CU - Connect Unix system			    ***
***			       Version 1.1				    ***
***			(C) by Nils M. Holm, 1991			    ***
***			    Released 05/05/91				    ***
***									    ***
***			       Version 1.2				    ***
***			Modifyed by Udo Munk, 1992			    ***
***			    Released 04/08/92				    ***
***									    ***
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <sgtty.h>
#include <time.h>
#include <access.h>
#include <sys/stat.h>
#include "modemcap.h"

#define SHELL		"/bin/sh"
#define LSYS		"/usr/lib/uucp/L.sys"
#define ALTSYS		"/usr/local/lib/Cu.sys"
#define LDEV		"/usr/lib/uucp/L-devices"
#define UULOCK		"/usr/spool/uucp/LCK.."
#define LOGFILE		"./cu.log"
#define ERASEDISP	"\033[2J"
#define CRLF		"\r\n"
#define BELL	0x07
#define DIRECT	"DIR"
#define ACU	"ACU"
#define CR	0x0d
#define LF	0x0a
#define RUBOUT	0x08
/*	#define MAPCRLF	*/

#define DFLTLINE	"/dev/modem"
#define DFLTSPEED	"2400"

#define UNLOCK		0
#define LOCK		1

#define rawmode()	stty(term, &rawtty)
#define oldmode()	stty(term, &oldtty)
#define whitespace(c)	(c == ' ' || c == '\t') ? 1 : 0


char	*Pname;
struct  sgttyb	oldtty, rawtty;
int	term;
int	ttyid;
char    mtype[80];
char	dialstr[80];
char	baud[80];

int	Debugmode = 0;
int	Nowait = 0;
int	Directmode = 0;
int	Noconnect = 0;
int	Outputlog = 0;

int	Locked = 0;
char	*Site;

#ifdef  MAPCRLF
int	Mapcrlf = 1;
#else
int	Mapcrlf = 0;
#endif

char	m_attention[40],
	m_startcmd[40],
	m_startdial[40],
	m_enddial[40],
	m_endcmd[40],
	m_connect[20];

int	m_delay;

char	ttyline[81];
char	*Syslib;


void msg(m, n)
char  *m, *n;
{
   if (Locked)
	lockdev(ttyline, Site, UNLOCK);
   fprintf(stderr, "%s: %s: %s\n", Pname, m, n);
   exit(1);
}


char *nextfield(p)
char  *p;
{
   while ((!whitespace((char) *p)) && (char) *p != 0 && (char) *p != '\n')
	p++;
   while (whitespace((char) *p) && (char) *p != 0 && (char) *p != '\n')
	p++;
   return(p);
}


char *getfield(p)
char  *p;
{
   static char  field[128];
   int  i = 0;

   while ((!whitespace((char) *p)) && (char) *p != 0 && (char) *p != '\n')
	field[i++] = (char) *p++;
   field[i] = 0;
   return(field);
}


void gethost(sitename)
char   *sitename;
{
   FILE  *lsys;
   char  Buffer[256];
   char  *p;
   int   i;

   if (!(lsys = fopen(Syslib, "r")))
	msg("cannot open", Syslib);
   fgets(Buffer, 256, lsys);
   while (!feof(lsys) && strncmp(Buffer, sitename, strlen(sitename)))
	fgets(Buffer, 256, lsys);
   fclose(lsys);
   if (strncmp(Buffer, sitename, strlen(sitename)))
	msg("unknown site", sitename);
   p = Buffer;
   for (i=0; i<2; i++)
	p = nextfield(p);
   strncpy(mtype, getfield(p), 80);
   p = nextfield(p);
   strncpy(baud, getfield(p), 80);
   p = nextfield(p);
   strncpy(dialstr, getfield(p), 80);
   if (Debugmode)
   {
	printf( "remote site:     %s\n"
		"modem type:      %s\n"
		"line speed:      %s\n",
		sitename, mtype, baud);
   }
}


void getmodemcap()
{
   char   *modemcap, *p;
   FILE   *ldev;
   char   buf[128];
   int    mfound = 0, i;
   char   *brand;
   int    dialreq;

   if (!(ldev = fopen(LDEV, "r")))
	msg("cannot open", LDEV);
   fgets(buf, 128, ldev);
   if (!strncmp(mtype, buf, strlen(mtype)))
	mfound = 1;
   while (!feof(ldev) && !mfound)
   {
	fgets(buf, 128, ldev);
	if (!strncmp(mtype, buf, strlen(mtype)))
	   mfound = 1;
   }
   fclose(ldev);

   if (strncmp(mtype, buf, strlen(mtype)))
	msg("no L-device entry", mtype);

   p = buf;
   p = nextfield(p);
   sprintf(ttyline, "/dev/%s", getfield(p));
   for (i=0; i<3; i++)
	p = nextfield(p);
   brand = getfield(p);
   if (Debugmode)
   {
	printf( "com line:        %s\n"
		"modem brand:     %s\n",
			ttyline, brand);
   }

   if (!strcmp(mtype, ACU))
	dialreq = 1;
   else
	dialreq = 0;

   if (dialreq)
   {
	modemcap = (char *) getmcap(brand);
	if (modemcap == 0)
	   msg("no modemcap entry", brand);

	if (!mgetflag("di"))
	   msg("modem has no dialer", brand);

	strcpy(m_attention, mgetstr("at"));
	   if (m_attention == 0)
		msg("modemcap entry not found", "at");
	strcpy(m_startcmd, mgetstr("cs"));
	   if(m_startcmd == 0)
		strcpy(m_startcmd, "");
	strcpy(m_startdial, mgetstr("ds"));
	   if (m_startdial == 0 && dialreq)
		msg("modemcap entry not found", "ds");
	strcpy(m_enddial, mgetstr("de"));
	   if (m_enddial == 0 && dialreq)
		msg("modemcap entry not found", "de");
	strcpy(m_endcmd, mgetstr("ce"));
	   if(m_endcmd == 0)
		strcpy(m_endcmd, "");
	strcpy(m_connect, mgetstr("co"));
	   if (m_connect == 0)
		m_connect[0] = 0;
	m_delay = mgetnum("ad");
	   if (m_delay == -1)
		msg("modemcap entry not found", "ad");
   }
   else
	m_delay = 0;
}


void mkdialstr(dialstr)
char  *dialstr;
{
   char  dstr[80];
   int   i, j;

   if (!strncmp(mtype, DIRECT, strlen(DIRECT)))
   {
	dialstr[0] = 0;
	if (Debugmode)
	   printf("line is direct - no dial string\n");
   }
   else if (!strncmp(mtype, ACU, strlen(ACU)))
   {
	sprintf(dstr, "%s%s%s%s%s", m_startcmd, m_startdial,
				dialstr, m_enddial, m_endcmd);
	for (i=0, j=0; dstr[i] != 0; i++)
	{
	   if (dstr[i] == '\\')
	   {
		switch (dstr[i+1])
		{
		   case 'r':	dialstr[j++] = CR; i++; break;
		   case 0:	dialstr[j++] = '\\'; break;
		   default:	dialstr[j++] = dstr[++i];
		}
	   }
	   else
	      dialstr[j++] = dstr[i];
	}
	dialstr[j] = 0;
	if (Debugmode)
	   printf("dial string:     %s\n", dstr);
   }
   else
	msg("unknown modem type", mtype);
}


void print(str)
char  *str;
{
   puts(str); fflush(stdout);
}


void opentty()
{
   int  bdrate;
   int  lspeed;
   struct sgttyb  rline;

   if ((ttyid = open(ttyline, 2)) < 0)
	msg("unable to open", ttyline);
   if (ioctl(ttyid,TIOCEXCL,0))
	msg("Cannot lock %s", ttyline);

   bdrate = atoi(baud);

   switch(bdrate)
   {
	case 110:	lspeed = B110; break;
	case 150:	lspeed = B150; break;
	case 300:	lspeed = B300; break;
	case 600:	lspeed = B600; break;
	case 1200:	lspeed = B1200; break;
	case 2400:	lspeed = B2400; break;
	case 4800:	lspeed = B4800; break;
	case 9600:	lspeed = B9600; break;
	case 19200:	lspeed = B19200; break;
	default:	msg("invalid line speed", baud);
   }

   gtty(ttyid, &rline);
   rline.sg_flags |= (RAW|TANDEM);
   rline.sg_flags &= ~(ECHO|CRMOD);
   rline.sg_ispeed = rline.sg_ospeed = lspeed;
   stty(ttyid, &rline);

   term = fileno(stdout);
   gtty(term, &oldtty);
   gtty(term, &rawtty);
   rawtty.sg_flags |= (RAW|TANDEM);
   rawtty.sg_flags &= ~(ECHO|CRMOD);
   stty(term, &rawtty);

   if (Debugmode)
	print("tty opened");
}

closetty()
{
   stty(term, &oldtty);
   close(ttyid);
   if (Debugmode)
	printf("\ntty reset to origin mode");
}


void bell()
{
   putchar(0x07); fflush(stdout);
}


char *getline()
{
   int   cp = 0;
   char  c;
   static char  line[61];

   do
   {
	read(term, &c, 1);
	switch(c)
	{
	   case RUBOUT:	if (cp > 0)
			{
			   write(1, "\b \b", 3);
			   cp--;
			}
			else
			   bell();
			break;
	   case CR:	break;
	   case '~':	write(1, CRLF, 1);
			return;
	   default:	if (cp<60)
			{
			   line[cp++] = c;
			   write(1, &c, 1);
			}
			else
			   bell();
	}
   }
   while (c != CR);
   line[cp] = 0;
   return(line);
}


void sendfile()
{
   char  *file;
   FILE  *f;
   char  ch;
   
   printf("\rsend: "); fflush(stdout);
   file = getline();
   if (file[0] == 0)
   {
	print("\raborted.\n\r");
   }

   if ((f = fopen(file, "r")) == NULL)
   {
	printf("\rno file: %s\n\r", file);
	fflush(stdout);
	return;
   }
   puts("\r"); fflush(stdout);

   ch = (char) fgetc(f);
   while (!feof(f))
   {
	write(ttyid, &ch, 1);
	ch = (char) fgetc(f);
   }

   fclose(f);
}


void genbrk()
{
   struct sgttyb  ttyb;
   char   lspeed;

   gtty(ttyid, &ttyb);
   lspeed = ttyb.sg_ospeed;
   ttyb.sg_ospeed = B50;
   stty(ttyid, &ttyb);
   write(ttyid, "\0\0\0", 3);
   ttyb.sg_ospeed = lspeed;
   stty(ttyid, &ttyb);
}


void subshell(sitename)
char  *sitename;
{
   register int pid, rpid;
   int status;

   oldmode();
   printf("\n[Local system]\n");
   if ((pid = fork()) == 0) {
      setuid(getuid());
      setgid(getgid());
      execlp(SHELL, SHELL, NULL);
   } else if (pid > 0) {
      while ((rpid = wait(&status)) != pid)
         ;
   }
   printf("\n[%s]\n", sitename);
   rawmode();
}


void wait_connect()
{
   char  connect[20], ch = 0;
   int   ci = 0;
   char  msg[80];

   if (Nowait)
   {
	if (Debugmode)
	   print("raw connection");
	print("connected\t\t\t");
	return;
   }

   if (!m_connect[0])
   {
	if (Debugmode)
	   print("No connect string - connection assumed\n");
	return;
   }

   while (ch != CR)	/* CR = m_endcmd */
	read(ttyid, &ch, 1);

   if (Debugmode)
   {
	sprintf(msg, "expecting: %s", m_connect);
	print(msg);
   }

   for (;;)
   {
	read(ttyid, &ch, 1);
	if (ch != m_connect[ci] && ch != CR && ch != LF)
	{
	   putchar(BELL);
	   printf("Modem says: %c", ch);
	   fflush(stdout);
	   return;
	}
	if (ch != CR && ch != LF)
	   connect[ci++] = ch;
	connect[ci] = 0;
	if (!strcmp(connect, m_connect))
	{
	   putchar(BELL);
	   print("connected\t\t\t");
	   return;
	}
   }
}


int lockdev(tty, site, action)
char  *tty, *site;
int   action;
{
   char   *p;
   char   lockfile[256];
   int    lck;
   struct stat st;

   if ((p = strrchr(tty, '/')) == NULL)
	p = tty;
   else
	p++;

   sprintf(lockfile, "/dev/%s", p);
   if (stat(lockfile, &st) == -1)
      msg("cannot stat device", lockfile);
   sprintf(lockfile, "%s%d.%d", UULOCK, major(st.st_rdev), minor(st.st_rdev) & 077);  
   if (action == LOCK)
   {
	if ((lck = open(lockfile, 0)) != -1)
	{
	   close(lck);
	   return(1);
	}
	if ((lck = creat(lockfile, 0644)) == -1)
	   msg("cannot create lock file", lockfile);
	close(lck);
   }
   else
	unlink(lockfile);

   sprintf(lockfile, "%s%s", UULOCK, site);
   if (action == LOCK)
   {
	if ((lck = open(lockfile, 0)) != -1)
	{
	   close(lck);
	   sprintf(lockfile, "%s%s", UULOCK, p);
	   unlink(lockfile);
	   return(1);
	}
	if ((lck = creat(lockfile, 0644)) == -1)
	{
	   sprintf(lockfile, "%s%s", UULOCK, p);
	   unlink(lockfile);
	   msg("cannot create lock file", lockfile);
	}
	close(lck);
   }
   else
	unlink(lockfile);

   if (action == LOCK)
	Locked = 1;
   else
	Locked = 0;
   return(0);
}


void rconnect(sitename)
char  *sitename;
{
   int  cpid;
   int  connected = 1;
   char ch;
   char logbuf[256];
   int  outptr = 0;
   int  logf;
   char loghdr[80];
   time_t  t;
   char    *ct;

   if (Noconnect)
   {
	if (Debugmode)
	   printf("test mode - no connection.\n");
	return;
   }

   if (lockdev(ttyline, sitename, LOCK))
	msg("Device locked", ttyline);

   if (Outputlog)
   {
	if (Debugmode)
	   print("creating logfile.");
	if ((logf = creat(LOGFILE, 0600)) == -1)
	   msg("cannot create logfile", LOGFILE);
	time(&t);
	ct = ctime(&t);
	ct[strlen(ct)-1] = 0;
	sprintf(loghdr, "*** cu Log -- Site: %s -- Date %s ***\n\n",
		sitename, ct);
	write(logf, loghdr, strlen(loghdr));
   }

   opentty();
   if (Directmode)
   {
	putchar(BELL);
	print("connected\t\t\t");
   }
   else
   {
	if (Debugmode)
	   print("dialing");
	write(ttyid, dialstr, strlen(dialstr));
   }
   cpid = fork();

   if (cpid)
   {
	while (connected)
	{
	   read(term, &ch, 1);
	   if (ch == '~')
	   {
		write(1, "~", 1);
		read(term, &ch, 1);
		write(1, &ch, 1);
		switch(ch)
		{
		   case '.':	connected = 0; break;
		   case 'c':	printf(ERASEDISP); fflush(stdout); break;
		   case 'b':	genbrk(); print("\r~BREAK"); break; 
		   case 's':	sendfile(); break;
		   case '!':	subshell(sitename); break;
		   case '~':	write(ttyid, "~", 1); break;
		   default:	bell();
		}
	   }
	   else
		if (Mapcrlf)
		{
		   if (ch == '\n')
			write(ttyid, CRLF, 2);
		   else
			write(ttyid, &ch, 1);
		}
		else
		   write(ttyid, &ch, 1);
	}
   }
   else
   {
	wait_connect();
	for(;;)
	{
	   read(ttyid, &ch, 1);
	   if (Mapcrlf)
	   {
		if (ch == '\n')
		   write(1, CRLF, 2);
		else
		   write(1, &ch, 1);
	   }
	   else
		write(1, &ch, 1);
	   if (Outputlog)
	   {
		if (outptr > 255 || ch == '\n')
		{
		   logbuf[outptr] = 0;
		   write(logf, logbuf, strlen(logbuf));
		   write(logf, "\n", 1);
		   outptr = 0;
		}
		else if (ch == RUBOUT)
		{
		   if (outptr > 0)
			outptr--;
		}
		else
		   logbuf[outptr++] = ch;
	   }
	}
   }

   kill(cpid, 9);
   ioctl(ttyid, TIOCHPCL);

   closetty();
   lockdev(ttyline, sitename, UNLOCK);
   printf("\ndisconnected\n");

   if (Outputlog)
   {
	if (Debugmode)
	   printf("closing logfile.\n");
	if (outptr != 0)
	{
	   logbuf[outptr] = 0;
	   write(logf, logbuf, strlen(logbuf));
	   write(logf, "\n", 1);
	}
	close(logf);
   }
}


void usage()
{
#ifndef MAPCRLF
   fprintf(stderr, "Usage: %s [-dtmo{a|c}] [-b baud] [-l line] [sitename]\n",
	Pname);
#else
   fprintf(stderr, "Usage: %s [-dto{a|c}] [-b baud] [-l line] [sitename]\n",
	Pname);
#endif
}


void long_usage()
{
   fprintf(stderr, "cu  v1.1   (c) by Nils M. Holm, 1991\n\n");
#ifndef MAPCRLF
   fprintf(stderr, "Usage: %s [-dtmo{a|c}] [-b baud] [-l line] [sitename]\n"
#else
   fprintf(stderr, "Usage: %s [-dto{a|c}] [-b baud] [-l line] [sitename]\n\n"
#endif
		   "d - debug mode\n"
		   "t - test mode (no connection)\n"
		   "c - direct connection (no dial)\n"
		   "b - baud rate (with -c, default: %s)\n"
		   "l - comm. line (with -c, default: %s)\n"
		   "o - write output to log file (./cu.log)\n"
		   "r - raw connection (display modem echo)\n"
#ifndef MAPCRLF
		   "m - map LF to CRLF\n"
#endif
		   "a - use alternate library %s\n",
   		Pname, DFLTSPEED, DFLTLINE, ALTSYS);
   exit(1);
}


int main(argc, argv)
int   argc;
char  *argv[];
{
   int   parm, i;
   char  *pbaud = 0, *pline = 0;
   char  altlib = 0;

   Pname = argv[0];

   if (argc < 2)
	usage();

   Syslib = 0;

   for (parm = 1; argv[parm][0] == '-'; parm++)
   {
	for (i=1; argv[parm][i] != 0; i++)
	{
	   switch(argv[parm][i])
	   {
		case 'd':	Debugmode = 1; break;
		case 't':	Noconnect = 1; break;
		case 'b':	pbaud = argv[++parm];
				i=strlen(argv[parm])-1;
				break;
		case 'l':	pline = argv[++parm];
				i=strlen(argv[parm])-1;
				break;
		case 'c':	Directmode = 1; break;
		case 'a':	altlib = 1; break;
		case 'o':	Outputlog = 1; break;
		case 'r':	Nowait = 1; break;
#ifndef MAPCRLF
		case 'm':	Mapcrlf = 1; break;
		case '?':	long_usage();
				exit(0);
#endif
		default:	argv[parm][i+1] = 0;
				msg("invalid parameter",
					(char *) &argv[parm][i]);
	   }
	}
   }

   if (parm >= argc && !Directmode)
	usage();

   if (altlib)
	Syslib = ALTSYS;
   else
	Syslib = LSYS;
   
   if (Directmode)
   {
	if (!pline)
	   strcpy(ttyline, DFLTLINE);
	else
	   strcpy(ttyline, pline);
	if (!pbaud)
	   strcpy(baud, DFLTSPEED);
	else
	   strcpy(baud, pbaud);
	if (Debugmode)
	   printf("Direct connection to %s at %s baud\n", ttyline, baud);
   }
   else
   {
	if (setuid(0) == -1)
	   msg("cannot set uid", "root");
	gethost(argv[parm]);
	getmodemcap();
	mkdialstr(dialstr);
   }

   if (Directmode)
	Site = "(direct)";
   else
	Site = argv[parm];
   rconnect(Site);
}
