/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          setcolor.cr                                        */
/*  Author:        P. D. Fox                                          */
/*  Created:       28 Mar 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Macro to allow user to set up colors                */
/*                                                                    */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */

/**********************************************************************/
/*   List  of  all  available  colors  corresponding to the internal  */
/*   color codes.						      */
/**********************************************************************/
# define	ALL_COLORS	\
		"black", 		\
		"blue", 		\
		"green", 		\
		"cyan", 		\
		"red", 			\
		"magenta", 		\
		"brown", 		\
		"white", 		\
		"dark-grey",		\
		"light-blue", 		\
		"light-green", 		\
		"light-cyan",		\
		"light-red", 		\
		"light-magenta", 	\
		"light-yellow",		\
		"light-white"
/**********************************************************************/
/*   List of colors when we are only allowed to specify foreground.   */
/**********************************************************************/
# define	FG_COLORS	\
		"black", 		\
		"blue", 		\
		"green", 		\
		"cyan", 		\
		"red", 			\
		"magenta", 		\
		"brown", 		\
		"white"
		
/**********************************************************************/
/*   Description of the popup menu.				      */
/**********************************************************************/
list col_list = {
	"Background         : ", 	{FG_COLORS},
	"Normal window Text : ",	{FG_COLORS},
	"Selected window    : ",	{ALL_COLORS},
	"Normal messages    : ",	{ALL_COLORS},
	"Error messages     : ",	{ALL_COLORS},
	"Hilight foreground : ",	{ALL_COLORS},
	"Hilight background : ",	{FG_COLORS}
	};

void
setcolor()
{
	list	result_list;
	list	current_list;
	int	background, normal, selected, messages, errors, hilite;

	get_color(background, normal, selected, messages, errors, hilite);
	result_list[0] = background;
	result_list[1] = normal;
	result_list[2] = selected;
	result_list[3] = messages;
	result_list[4] = errors;
	result_list[5] = hilite & 0x0f;
	result_list[6] = (hilite >> 4) & 7;
	current_list = col_list;
	result_list = field_list("Screen Colors", result_list, current_list);

	background = result_list[0];
	normal = result_list[1];
	selected = result_list[2];
	messages = result_list[3];
	errors = result_list[4];
	hilite = result_list[5] | (result_list[6] << 4);
	/***********************************************/
	/*   Set up the new color mapping.	       */
	/***********************************************/
	if (background == normal) {
		error("Background and normal colors are the same.");
		}
	else
		color(background, normal, selected, messages, errors, hilite);
}
