/* cc.c - Translate Unix like 'cc' command args to Microsoft C5.1 */
/* style command args. This obviates the need to change all the makefiles */

# include <stdio.h>
# include	<process.h>
# include	<malloc.h>

# define	MAX_ARGS	1024

# define	TRUE	1
# define	FALSE	0

char	*args[MAX_ARGS];
int	arg_cnt = 1;
int	verbose = FALSE;

main(argc, argv)
char **argv;
{	int	i;
	char *cp, *cp1;
	int	len;

	for (i = 1; i < argc; i++) {
		if (strcmp(argv[i], "-g") == 0) {
			args[arg_cnt++] = "-Zi";
			continue;
			}
		if (strcmp(argv[i], "-#") == 0) {
			verbose = TRUE;
			continue;
			}
		if (strncmp(argv[i], "/NO", 3) == 0) {
			args[arg_cnt++] = argv[i];
			continue;
			}
		if (strcmp(argv[i], "/F") == 0) {
			args[arg_cnt++] = argv[i];
			continue;
			}
		/*----------------------------------------
		/*   Convert all '.a' extensions to '.lib'
		/*   extensions.
		/*----------------------------------------*/
		cp = argv[i];
		len = strlen(cp);
		if (len > 2) {
			cp = cp + len - 2;
			if (strcmp(cp, ".a") == 0) {
				cp = malloc(len + 4);
				strcpy(cp, argv[i]);
				strcpy(cp + len - 1, "lib");
				}
			else
				cp = argv[i];
			}
		/*----------------------------------------
		/*   Convert all forward slashes to backslashes
		/*----------------------------------------*/
		for (cp1 = cp; *cp1; cp1++)
			if (*cp1 == '/')
				*cp1 = '\\';
		args[arg_cnt++] = cp;
		}
	args[0] = "cl";
	if (verbose) {
		for (i = 0; i < arg_cnt; i++)
			printf("%s ", args[i]);
		printf("\n");
		}
	exit(spawnvp(P_WAIT, "cl", args));
}
