/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          makeman.cr                                         */
/*  Author:        P. D. Fox                                          */
/*  Created:       15 Apr 1991                     		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Make manual for v1.9 crisp                          */
/*                                                                    */
/*   This  macro  file  is now antiquated by the new help system and  */
/*   is subject to deletion in some later release.		      */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */

# include	"crisp.h"

# define	ME		1			/* nroff -me */
# define	MM		2			/* nroff -mm */
# define	MS		3			/* nroff -ms */

# define	INDEXING		TRUE		/* Set to FALSE to turn index page generation */
										/* off.													 */
/****************************************************************************/
/*----------------------------------------
/*    Values you need to configure.
/*----------------------------------------*/
# define	MACROS			MM
# define	PAGE_LENGTH			".pl 10.5i"		/* European page size. */
/*# define	PAGE_LENGTH		""					/* American page size. */
														/* I dont know what goes in here, */
														/* but possibly leaving it blank will */
														/* do.										*/
/*----------------------------------------
/*    The ROFF_COMMAND is the troff/nroff
/*    command used to generate the output.
/*    It can contain all the normal shell
/*    syntax characters since it is passed
/*    to the shell. It should NOT contain
/*    any pipe characters.
/*
/*    This definition is needed so that the
/*    index table can be generated.
/*----------------------------------------*/
# define ROFF_COMMAND	"troff -Tps -mm"

/*----------------------------------------
/*    Name of file to create containing
/*    nroff/troff source.
/*----------------------------------------*/
# define	OUTPUT_FILE		"/tmp/crispman"

/************************************************************************/
string	START_SECTION,
	END_SECTION,
	LINE_LENGTH,
	NEW_PARA;
main()
{

	switch (MACROS) {
	  case ME:	nroff_me_macros();
	  case MM:	nroff_mm_macros();
	  case MS:	nroff_ms_macros();
	  default: 
		error("Must specify -me, -mm or -ms macro package");
		exit();
		return;
	  }
}
nroff_mm_macros()
{
	START_SECTION = ".H";
	END_SECTION = ".sp\n";
	LINE_LENGTH = ".ll 6.5i";
	NEW_PARA = ".P";
}
nroff_me_macros()
{
	START_SECTION = ".sh";
	END_SECTION = ".sp\n";
	LINE_LENGTH = ".ll 6.5i";
	NEW_PARA = ".lp";
}
nroff_ms_macros()
{
	START_SECTION = ".NH";
	END_SECTION = ".LP\n";
	LINE_LENGTH = ".nr LL 6.5i\n.nr LT 6.5i";
	NEW_PARA = ".LP";
}
me_end_processing()
{
	message("nroff -me Special Processing.");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.H ", ".sh ");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.P$", ".lp");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.PF \"{*}\"$", ".fo \\0");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.PH \"{*}\"$", ".he \\0");
}
ms_end_processing()
{
	message("nroff -ms Special Processing.");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.H {?}, \"{*}\"$", ".NH \\0\n\\1\n.LP");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.NH {?} \"{*}\"$", ".NH \\0\n\\1\n.LP");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.P$", ".LP");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.PF *'{*}'{*}'{*}'*$", ".ds LF \\0\n.ds CF \\1\n.ds RF \\2\n");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^.PH *'{*}'{*}'{*}'*$", ".ds LH \\0\n.ds CH \\1\n.ds RH \\2\n");
}
/*************************************************************
This  is  a  macro  to take the CRISP help files, put them into
some  form  of  order  and  convert the files to troff with the
.mm  files  so  that  the  manual  can be printed off on a nice
printer.
 **************************************************************/

makeman()
{
	string	buf, BHELP, index_file;
	int	curbuf;
	int	manbuf;
	int	v, old_msg_level;

	BHELP = inq_environment("BHELP") + "/";

	old_msg_level = inq_msg_level();
	set_msg_level(1);
	v = version();
	curbuf = inq_buffer();
	manbuf = create_buffer(OUTPUT_FILE, NULL, 1);
	set_buffer(manbuf);
	attach_buffer(manbuf);
	clear_buffer();

	read_file(BHELP + "roff/ms.mac");
	read_file(BHELP + "roff/page1.mm");
	save_position();
	top_of_buffer();
	re_translate(SF_GLOBAL, ".ll 6i", LINE_LENGTH);
	restore_position();

	sprintf(buf, ".Fc \"CRISP Reference Manual\" %d.%02d \"May, 1989\"\n",
		v / 100, v % 100);
	insert(buf);
	read_file (BHELP + "roff/intro.mm");

	chapter_2();
	chapter_3();
	chapter_4();
	chapter_5();

	process_sections();
	save_position();
	read_file(BHELP + "prim/misc.cmd");
	read_file(BHELP + "prim/a.cmd");
	read_file(BHELP + "prim/b.cmd");
	read_file(BHELP + "prim/c.cmd");
	read_file(BHELP + "prim/d.cmd");
	read_file(BHELP + "prim/e.cmd");
	read_file(BHELP + "prim/f.cmd");
	read_file(BHELP + "prim/g.cmd");
	read_file(BHELP + "prim/i.cmd");
	read_file(BHELP + "prim/k.cmd");
	read_file(BHELP + "prim/l.cmd");
	read_file(BHELP + "prim/m.cmd");
	read_file(BHELP + "prim/n.cmd");
	read_file(BHELP + "prim/o.cmd");
	read_file(BHELP + "prim/p.cmd");
	read_file(BHELP + "prim/q.cmd");
	read_file(BHELP + "prim/r.cmd");
	read_file(BHELP + "prim/s.cmd");
	read_file(BHELP + "prim/t.cmd");
	read_file(BHELP + "prim/u.cmd");
	read_file(BHELP + "prim/v.cmd");
	read_file(BHELP + "prim/w.cmd");
	process_prim();

	end_processing();
	
	write_buffer();

	make_index();

	write_buffer();
	
	/*----------------------------------------
	/*   Now we need to format the manual to
	/*   get the index entries.
	/*----------------------------------------*/
	sprintf(buf, "sh -cfe '%s %s >%s.roff 2>%s.index'",
		  ROFF_COMMAND, OUTPUT_FILE, OUTPUT_FILE, OUTPUT_FILE);

	if (INDEXING) {
		message(buf);
		shell(buf, 1);
		sprintf(index_file, "%s.index", OUTPUT_FILE);
		edit_file(index_file);
		format_index();
		message(buf);
		sprintf(buf, "sh -cfe '%s %s.index >>%s.roff'",
			ROFF_COMMAND, OUTPUT_FILE, OUTPUT_FILE);
		shell(buf, 1);
		}

	message("Finished making manual.");

	delete_buffer(manbuf);
	set_buffer(curbuf);
	attach_buffer(curbuf);
	set_msg_level(old_msg_level);
}
chapter_2()
{	extern string BHELP;

	read_file (BHELP + "roff/env.mm");
	insert("\n" + START_SECTION + " 2 \"Command Line Switches\"\n" + END_SECTION);
	process_file("env/switches.hlp");
	insert("\n" + START_SECTION + " 2 \"Environment Variables\"\n" + END_SECTION);
	process_file("env/env.hlp");
	insert("\n" + START_SECTION + " 2 \"Starting Up\"\n" + END_SECTION);
	process_file("env/startup.hlp");
	insert("\n" + START_SECTION + " 2 \"Details on Keyboard Mappings\"\n" + END_SECTION);
	process_file("env/kbd.hlp");
	insert("\n" + START_SECTION + " 2 \"Directory Tree\"\n" + END_SECTION);
	process_file("env/tree.hlp");
}			
chapter_3()
{	extern string BHELP;

	read_file(BHELP + "roff/concepts.mm");
	insert ("\n" + START_SECTION 
		+ " 2 \"Anchors, Blocks and Regions\"\n" + END_SECTION);
	process_file("concept/blocks.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Text Buffers\"\n" + END_SECTION);
	process_file("concept/buffers.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Files\"\n" + END_SECTION);
	process_file("concept/files.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Windows\"\n" + END_SECTION);
	process_file("concept/windows.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macros\"\n" + END_SECTION);
	process_file("concept/macros.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Process Buffers and PTYs\"\n" + END_SECTION);
	process_file("concept/proc.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Regular Expressions\"\n" + END_SECTION);
	process_file("concept/regexp.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Registered Macros\"\n" + END_SECTION);
	process_file("concept/register.hlp");
}
chapter_4()
{	extern string BHELP;

	read_file(BHELP + "roff/features.mm");
	insert ("\n" + START_SECTION 
		+ " 2 \"Displaying List of Active Buffers\"\n" + END_SECTION);
	process_file("features/buflist.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macros for Compiling and Linting .c Files\"\n" + END_SECTION);
	process_file("features/compile.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Displaying the current Filename\"\n" + END_SECTION);
	process_file("features/filename.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macro Interface to GREP\"\n" + END_SECTION);
	process_file("features/grep.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"The Options Menu\"\n" + END_SECTION);
	process_file("features/options.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macros to help writing Programs\"\n" + END_SECTION);
	process_file("features/program.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macros for Manipulating Regions\"\n" + END_SECTION);
	process_file("features/region.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macros for accessing sub-shells\"\n" + END_SECTION);
	process_file("features/shell.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macro for Counting Words.\"\n" + END_SECTION);
	process_file("features/wc.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Calculator\"\n" + END_SECTION);
	process_file("features/calc.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Ascii Wall Chart.\"\n" + END_SECTION);
	process_file("features/ascii.hlp");
}
chapter_5()
{	extern string BHELP;

	read_file(BHELP + "roff/lang.mm");
	insert ("\n" + START_SECTION 
		+ " 2 \"Macros and their Syntax\"\n" + END_SECTION);
	process_file("lang/macros.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"Language Data Types\"\n" + END_SECTION);
	process_file("lang/vars.hlp");
	insert ("\n" + START_SECTION 
		+ " 2 \"The Macro Compiler\"\n" + END_SECTION);
	process_file("lang/Compiler.hlp");
}
end_processing()
{

	top_of_buffer();
	re_translate(NULL, "^.page_size$", PAGE_LENGTH);
	top_of_buffer();
	re_translate(SF_GLOBAL, "CRISP", "\\\\fBCRISP\\\\fR");
	top_of_buffer();
	re_translate(SF_GLOBAL, "BRIEF", "\\\\fBBRIEF\\\\fR");
	top_of_buffer();
	while (re_search(NULL, "^.H") > 0) {
		down();
		delete_line();
		insert(".sp\n");
		}
	end_of_buffer();
	insert("\n.TC\n");
	switch (MACROS) {
		case ME:	me_end_processing();
		case MS:	ms_end_processing();
		}
}
# define	WORDFILE	"/tmp/wordfile"

make_index()
{	extern string BHELP;
	int	srcbuf;
	 
	if (!INDEXING)
		return;
	srcbuf = inq_buffer();
	
	edit_file(WORDFILE);
	clear_buffer();
	message("Inserting index entries...");
	
	read_file(BHELP + "/sections/arith");
	read_file(BHELP + "/sections/buffer");
	read_file(BHELP + "/sections/debug");
	read_file(BHELP + "/sections/env");
	read_file(BHELP + "/sections/file");
	read_file(BHELP + "/sections/kbd");
	read_file(BHELP + "/sections/list");
	read_file(BHELP + "/sections/macro");
	read_file(BHELP + "/sections/misc");
	read_file(BHELP + "/sections/movement");
	read_file(BHELP + "/sections/proc");
	read_file(BHELP + "/sections/scrap");
	read_file(BHELP + "/sections/screen");
	read_file(BHELP + "/sections/search");
	read_file(BHELP + "/sections/string");
	read_file(BHELP + "/sections/var");
	read_file(BHELP + "/sections/window");
	sort_buffer();
	uniq();
	gen_index(srcbuf, WORDFILE);
	set_buffer(srcbuf);
}
gen_index(int srcbuf, string wordfile)
{
	string	
		word,
		raw_word,	/* Word before quote_regexp gets hold of it*/
		regexp1, 	/* Used for fast find of possible match */
		regexp2, 	/* Used to locate exact match.			 */
		index_string;
				
	int	word_line;

	edit_file(wordfile);
	
	/*----------------------------------------
	/*   For each word in the index file,
	/*   scan the source file and insert .tm
	/*   requests into the source buffer.
	/*----------------------------------------*/
	for (word_line = 1; word_line <= inq_lines(); ++word_line) {
		goto_line(word_line);
		raw_word = trim(ltrim(read()));
		word = quote_regexp(raw_word);
		message("Indexing '%s'...", word);
		
		set_buffer(srcbuf);
		top_of_buffer();

		regexp1 = "B" + word + "\\\\";
		regexp2 = "B" + word + "\\";
		index_string = ".tm " + "(\\f(HB" + raw_word + "\\fR) \\n%\n";
		while (re_search(NULL, regexp1) > 0) {
			beginning_of_line();
			down();
			beginning_of_line();
			insert(index_string);
			}
		edit_file(wordfile);
		}
	set_buffer(srcbuf);
	attach_buffer(srcbuf);
}
uniq()
{
	string str1, str2;
	/*----------------------------------------
	/*    Remove all duplicate lines.
	/*----------------------------------------*/
	top_of_buffer();
	str1 = read();
	str2 = "xx";
	message("Removing duplicates...");
	while (str2 != "\n") {
		str2 = read();
		if (str1 == str2)
			delete_line();
		else {
			str1 = str2;
			down();
			}
		}
}
format_index()
{
	string	str1,
		str2,
		token1,
		token2,
		word,
		page_list;
				
	/*----------------------------------------
	/*    First sort all lines into order.
	/*    We have to make all single and double
	/*    digit numbers have leading zero's other
	/*    wise the sort comes out wrong.
	/*----------------------------------------*/
	top_of_buffer();
	re_translate(SF_GLOBAL, " {[0-9]}$", " 0\\0");
	top_of_buffer();
	re_translate(SF_GLOBAL, " {[0-9][0-9]}$", " 0\\0");
	sort_buffer();
	uniq();
	
	top_of_buffer();
	str1 = read();
	str2 = "xx";
	message("Merging duplicates...");
	while (str2 != "\n") {
		str2 = read();
		token1 = substr(str1, 1, index(str1, " "));
		token2 = substr(str2, 1, index(str2, " "));
		if (token1 != token2) {
			str1 = str2;
			down();
			continue;
			}
		word = token1;
		page_list = trim(substr(str1, index(str1, " ") + 1));
		page_list += "," + trim(substr(str2, index(str2, " ")));
		str1 = word +page_list;
		up();
		delete_line();
		delete_line();
		insert(str1 + "\n");
		}
	/*----------------------------------------
	/*   Now remove all leading zeros.
	/*----------------------------------------*/
	top_of_buffer();
	re_translate(SF_GLOBAL, " 0+", " ");
	top_of_buffer();
	re_translate(SF_MAXIMAL | SF_GLOBAL, " 0+{[1-9]}", " \\0");
	top_of_buffer();
	re_translate(SF_GLOBAL, ") ", ")  . . . ");
	top_of_buffer();
	re_translate(SF_GLOBAL, "^", ".br\n");
	top_of_buffer();
	insert(".2C\n");
	write_buffer();
	message("Index table generated.");
}
process_file(string filename)
{	extern string BHELP;

	message("Processing %s...", filename);
	filename = BHELP + filename;
	save_position();
	read_file(filename);
	restore_position();
	convert_buffer();
}
convert_buffer()
{
	int	line;
	
	inq_position(line);
	
	/*----------------------------------------
	/* First make all multiple spaces into single spaces.
	/* This unformats the justified text.
	/*----------------------------------------*/
	re_translate(SF_GLOBAL, "   @", " ");
	/*----------------------------------------
	/*    Make section headings into nroff section headings.
	/*----------------------------------------*/
	goto_line(line);
	re_translate(SF_GLOBAL, "^\\> {*$}", ".H 3 \"\\0\"");
	/*----------------------------------------
	/*    Put in paragraph marks.
	/*----------------------------------------*/
	goto_line(line);
	re_translate(SF_GLOBAL, "^$", NEW_PARA);
	/*----------------------------------------
	/*    Now make indented blocks into lists.
	/*----------------------------------------*/
	goto_line(line);
	do_DL_list();
	goto_line(line);
	do_VL_list();
	goto_line(line);
	do_AL_list();
	/*----------------------------------------
	/*    Create fixed displays.
	/*----------------------------------------*/
	goto_line(line);
	while (re_search("^ ") > 0) {
		insert(NEW_PARA);
		insert("\n.in +1i\n");
		insert(".ft CW\n");
		while (1) {
			down();
			if (read(1) != " ")
				break;
			insert(".br\n");
			}
		insert(".ft R\n");
		insert(".in -1i\n");
		}
	/*----------------------------------------
	/*    Translate all funny characters.
	/*----------------------------------------*/
	goto_line(line);
	re_translate(SF_GLOBAL, "\\\\", "\\\\\\\\");
	/*----------------------------------------
	/*    Translate all funny characters.
	/*----------------------------------------*/
	goto_line(line);
	re_translate(SF_GLOBAL, "^'", "\\\\'");
	goto_line(line);
	re_translate(SF_GLOBAL, "~", "\\\\~");
	/*----------------------------------------
	/*    Boldify all CRISP macro names.
	/*----------------------------------------*/
	re_translate(SF_GLOBAL, "({[a-z_]+})", "(\\\\fB\\0\\\\fR)");
	end_of_buffer();
}
do_DL_list()
{
	int	line;
	
	while (re_search(NULL, "^\t-[ \t]") > 0) {
		insert(".DL\n");
		/*----------------------------------------
		/*  Mark the region containing the current
		/*  list.
		/*----------------------------------------*/
		inq_position(line);
		if (re_search(NULL, "^[A-Z.]") <= 0) {
			end_of_buffer();
			next_char();
			}
		insert(".LE\n");
		up();
		drop_anchor(MK_LINE);
		/*----------------------------------------
		/*  Now modify the entries.
		/*----------------------------------------*/
		move_abs(line, 1);
		re_translate(SF_GLOBAL | SF_BLOCK, "^\t-?", ".LI\n");
		move_abs(line, 1);
		re_translate(SF_GLOBAL | SF_BLOCK, "^\t\t", "");
		raise_anchor();
		}
}
do_VL_list()
{
	int	line;

	while (re_search(NULL, "^\t-[^\t ]") > 0) {
		insert(".VL 10\n");
		/*----------------------------------------
		/*  Mark the region containing the current
		/*  list.
		/*----------------------------------------*/
		inq_position(line);
		if (re_search(NULL, "^[A-Z]") <= 0) {
			end_of_buffer();
			next_char();
			}
		insert(".LE\n");
		up();
		drop_anchor(MK_LINE);
		/*----------------------------------------
		/*  Now modify the entries.
		/*----------------------------------------*/
		move_abs(line, 1);
		re_translate(SF_GLOBAL | SF_BLOCK, "^\t{-*}\t{*$}", ".LI \\0\n\\1");
		move_abs(line, 1);
		re_translate(SF_GLOBAL | SF_BLOCK, "^\t\t", "");
		raise_anchor();
		}
}
do_AL_list()
{
	int	line;

	while (re_search(NULL, "^\t[1-9]") > 0) {
		insert(".AL\n");
		/*----------------------------------------
		/*  Mark the region containing the current
		/*  list.
		/*----------------------------------------*/
		inq_position(line);
		if (re_search(NULL, "^[A-Z]") <= 0) {
			end_of_buffer();
			next_char();
			}
		insert(".LE\n");
		up();
		drop_anchor(MK_LINE);
		/*----------------------------------------
		/*  Now modify the entries.
		/*----------------------------------------*/
		move_abs(line, 1);
		re_translate(SF_GLOBAL | SF_BLOCK, "^\t[1-9]+. ", ".LI\n");
		move_abs(line, 1);
		re_translate(SF_GLOBAL | SF_BLOCK, "^\t  @", "");
		raise_anchor();
		}
}
process_sections()
{	extern string BHELP;
	string section;
	
	save_position();
	read_file (BHELP + "roff/Prim.mm");
	restore_position();
	while (re_search(NULL, "<##") > 0) {
		section = substr(trim(read()), 3);
		delete_line();
		insert(".sp 2\n");
		drop_anchor(MK_LINE);
		read_file (BHELP + "sections/" + section);
		insert("\n");
		up();
		message(BHELP + "sections/" + section);
		re_translate(SF_GLOBAL | SF_BLOCK, "^{?*}$", ".ce\n(\\\\f(HB\\0\\\\fR)");
		raise_anchor();
		down();
		}
	end_of_buffer();
	down();
	beginning_of_line();
}
process_prim()
{
	int	line;
	string	str;
	
	restore_position();
	insert(".in +.5i\n");
	insert("\\s-2\n");
	inq_position(line);
	
	/*----------------------------------------
	/*    Make sections stand out.
	/*----------------------------------------*/
	message("Removing multiple spaces.");
	goto_line(line);
	re_translate(SF_GLOBAL, "   @", " ");
	goto_line(line);
	message("Removing tabs at beginning of lines.");
	re_translate(SF_GLOBAL, "^\t", "");
	goto_line(line);
	message("Center macro name.");
	while (re_search(NULL, "<.HU") > 0) {
		delete_line();
		re_translate(NULL, "S*(", "(");
		beginning_of_line();
		insert(".sp 1\n");
		insert(".DS CB\n");
		insert("\\s+3\\f(HB\n.ce\n");
		insert("___________________________________________________\n\n");
		while ((str = read()) != "\n") {
			insert(".ce\n");
			insert(ltrim(str));
			delete_line();
			}
		insert("\\s0\\fR\n");
		insert(".DE");
		}
	message("Processing lists.");
	goto_line(line);
	while (re_search(NULL, "^\t") > 0) {
		insert(".in +.5i\n");
		insert(".VL 20\n");
		while (read(1) == "\t") {
			delete_char();
			insert(".LI \"");
			re_search(NULL, "\t|$");
			if (read(1) == "\t") {
				delete_char();
				insert("\"\n");
				down();
				}
			else {
				
				insert("\"");
				next_char();
				}
			while (read(2) == "\t\t") {
				delete_char(2);
				while (read(1) == "\t")
					delete_char();
				down();
				}
			}
		insert(".LE\n");
		insert(".in -.5i\n");
		}
	message("Rearranging descriptions and return.");
	goto_line(line);
	while (re_search(NULL, "<RETURN") > 0) {
		delete_line();
		delete_line();
		
		save_position();
		drop_anchor(MK_LINE);
		insert(".sp\n.Fo \"RETURN\\ VALUE\"\n");
		re_search(NULL, "<{.sp 1}|{DESC}");
		up();
		cut();
		re_search(NULL, "<{.sp 1}|{EX}");
		paste();
		restore_position();
		delete_line();
		insert(".Fo \"DESCRIPTION\"");
		}
	message("Making examples into Courier.");
	goto_line(line);
	re_translate(SF_GLOBAL, "^ {*$}", "\\\\f(CW\\0\\\\fR\n.br");
	goto_line(line);
	message("Renaming Examples heading.");
	re_translate(SF_GLOBAL, "EXAMPLES:", ".Fo \"EXAMPLES\"");
	goto_line(line);
	message("Making macros stand out.");
	re_translate(SF_GLOBAL, "({[a-z_]+}){?}", "(\\\\fB\\0\\\\fR)\\1");
	goto_line(line);
	end_of_buffer();
	down();
	beginning_of_line();
	insert(".in -.5i\n");
	insert("\\s+2\n");
}
