/************************************************************************
 *                                                                      *
 *        CRISP - Custom Reduced Instruction Set Programmers Editor     *
 *                                                                      *
 *        (C) Paul Fox, 1989, 1991                                      *
 *                                                                      * 
 *  File:  machine.h                                                    * 
 *                                                                      * 
 *  This file contains the #defines necessary to configure different	*
 *  machine architectures.                                              *
 *									*
 ************************************************************************/

# define	CR_ACORN	0	/* Acorn running Risc IX 	*/
# define	CR_AIX_3	0	/* AIX v3 -- not tested.      	*/
# define	CR_DOS		0	/* MS-DOS C5.1 and OS2		*/
# define	CR_SUN_OS3	0	/* Sun running SunOS 3.x	*/
# define	CR_SUN_OS40	0	/* Sun running SunOS 4.0	*/
# define	CR_SUN_OS41	0	/* Sun running SunOS 4.1	*/
# define	CR_SYSV 	0	/* Generic System V.		*/
# define	CR_SYSV_3_2	0	/* Generic System V.3.2 	*/
# define	CR_SYSV_32_PTY	0	/* Generic System V.3.2 with PTY*/
# define	CR_COH42	1	/* Coherent 4.2			*/
# define	CR_VMS		0	/* VMS 4.7 and above.		*/
# define	CR_XENIX 	0	/* Xenix 2.2 and above.		*/

/************************************************************************
 *    									*
 *    The  following  describes  the various parameters which control	*
 *    compilation   of   CRISP.   After  the  comments  are  separate	*
 *    sections    for    the   different   machine/operating   system	*
 *    conbinations  already  supported. If you are producing your own	*
 *    description  then  you  should  first  try to determine whether	*
 *    your machine is a mostly System V variant or BSD variant.		*
 *    									*
 *   BSD                This is used to indicate that the system is 	*
 *			more a BSD derivative than a System V. It 	*
 *			affects certain features which may actually 	*
 *			only be true of SunOS.				*
 *    									*
 *   CANNOT_UNLINK_OPEN_FILES 						*
 *    			System doesnt support Unix unlink() on an open  *
 *    			file semantic.  				*
 *    									*
 *   DIRSIZ_DEFINED     This should be define'd if the POSIX directory	*
 *    			access include files are wrong. (Are they wrong *
 *			or right ? - I'm not sure - basically if you 	*
 *			have problems with this defined try undeffing it. *
 *    									*
 *   EGA43		If this is defined, then code for supporting 	*
 *			the EGA in 43 line mode on a PC is compiled in. *
 *			This is only supported for Unix V.3.2.		*
 *    									*
 *   HAVE_MOUSE         Define this if you want the mouse code compiled *
 *			in. (Only do this if the mouse code is          *
 *			supported for your system).             	*
 *    									*
 *   HAVE_PTY		This is used to compline in the code for	*
 *			process buffers. If your machine has the 	*
 *			Berkeley /dev/pty driver, then define this.	*
 *			Otherwise CRISP will try and used pipes.	*
 *									*
 *   HAVE_SGTTY 	System supports old style terminal interface.   *
 *									*
 *   HAVE_SIGINTERRUPT  System supports Sun compatible siginterrupt()	*
 *			system call.        				*
 *									*
 *   HAVE_SIGSETMASK    The system call sigsetmask is defined. TRUE     *
 *			under some versions of SunOS. Used for job      *
 *			control.					*
 *									*
 *   HAVE_TERMIO	System supports old style terminal interface    *
 *			System V terminal interface.    		*
 *									*
 *   HAVE_TERMIOS       System supports POSIX style terminal interface. *
 *									*
 *   HAVE_WAITPID       System has System V (POSIX) waitpid() call with *
 *			<sys/wait.h> to get the definitions.    	*
 *			On systems which dont have this, CRISP may hang *
 *			if we get SIGCHLD signals when we're not        *
 *			expecting them. Please read comment in def.h    *
 *			about why we don't actually include the 	*
 *			include file.   				*
 *									*
 *   LINEFEED_DOES_CR	Defined on systems where \n outputs a \r as well*
 *									*
 *   MONOCASE_FILENAMES Define this if operating system ignores case    *
 *			in filenames.   				*
 *									*
 *   NO_FLOAT_MATH      Define this if you dont want the floating       *
 *			point primitives to be included, i.e. sin(),    *
 *			cos(), etc. (You still have access to raw       *
 *			floating point). This setting should be machine *
 *			independent so you shoudl check your s-machine  *
 *			file first.                                     *
 *			                                                *
 *   NO_SYS_DIR_H	The file <sys/dir.h> does not exist.    	*
 *    									*
 *   ONLY_ONE_EXTENSION System only allows one '.' in filename.         *
 *    									*
 *   MALLOC		This tells the code that there is no 		*
 *    			<malloc.h> file and that the malloc() library   *
 *			may behave in strange ways which may force us   *
 *			to optimise our usage. It is really only 	*
 *			necessary if your system doesn't support the 	*
 *			SVID mallopt() call. 				*
 *    									*
 *   OPCODE		This is used to control the use of the enum	*
 *    			OPCODE typedef in the list.h. It doesn't matter *
 *			if you set this to 'int' as below, but if it is *
 *			undefined then it is easier to debug the CRISP  *
 *			lisp-code. Older Unix C compilers do not treat  *
 *			enum's and int's as the same type and will	*
 *    			complain during compilation.			*
 *    									*
 *   SELECT		SELECT should be defined if we can do a 	*
 *			select() on the	keyboard and on the process     *
 *			pty's/pipes. This will tend to be true on BSD   *
 *			systems, and Sys V.4. Alas, poll() isn't	*
 *    			generally applicable on V.3 because the 	*
 *			standard pipe and tty drivers are streams 	*
 *			modules.					*
 *    									*
 *   SPAWN      	System supports a 'spawn' primitive rather      *
 *    			than fork/exec. 				*
 *    									*
 *   SUN		Operating system is SunOS 3.x or SunOS 4.x.	*
 *    									*
 *   SYSV		Operating is a System V derivative.		*
 *    									*
 *   U_CHAR		CRISP defines a typedef called u_char. Some     *
 *			Unix systems also define this type in one of    *
 *			the system header files	(<sys/types.h>) which   *
 *			causes a compilation error. If you have this    *
 *			typedef in your system header file, then	*
 *    			#define U_CHAR. 				*
 *    									*
 *   VERSION    	Set this to a number representing the operating *
 *    			system version number. Used for major           *
 *    			differences in working, eg Xenix versions.      *
 *    									*
 *   WANT_SYS_SOCKET_H  Interactive Unix wants <sys/socket.h> when	*
 *    			using the select() system call. 		*
 *    									*
 *   WANT_GETCWD	This define causes us to load our own getcwd()  *
 *    			function. The standard Unix/Xenix one works     *
 *    			by forking a '/bin/pwd' process and reading     *
 *    			the output from it. This is not only bloody     *
 *    			awful, but causes problems with process buffers *
 *    			when the sub-process dies. (We get an unwanted  *
 *    			SIGCHLD).       				*
 *    									*
 *   WINDOW_SIZE_SUPPORTED                                              *
 *    			Define this if system supports TIOCGWINSZ       *
 *    			ioctl to get size of pty window.		*
 *    									*
 *   WORD_SIZE_16       TRUE for 16 bit machines. It simply restricts   *
 *    			the size of chunks read in from input files.    *
 *    									*
 ************************************************************************/
 
# if CR_COH42
#	define	HAVE_TERMIO
#	define	HAVE_WAITPID
#	define	MALLOC
/*#	define	SELECT*/
#	define	U_CHAR
#	define	SYSV
# endif

# if CR_AIX_3
	/***********************************************/
	/*   This  entry  not  tested  but  based  on  */
	/*   updates  I  received  for  v1.9  & v2 by  */
	/*   Warren Jones			       */
	/***********************************************/
#	define	DIRSIZ_DEFINED
#	define	GOT_STDLIB
#	define	HAVE_PTY
#	define	HAVE_TERMIO
#	define	SELECT
#	define	SYSV
#	define	U_CHAR
#	define	VERSION	31
#	define	WANT_GETCWD
#	define  WINDOW_SIZE_SUPPORTED
# endif

# if	CR_DOS
#	define	CANNOT_UNLINK_OPEN_FILES
#	define	DIRSIZ_DEFINED
#	define	FOPEN_R_BINARY	"rb"
#	define	FOPEN_W_BINARY	"wb"
#	define	LINEFEED_DOES_CR
#	define	MONOCASE_FILENAMES
#	define	OPEN_R_BINARY	O_BINARY
#	define	OPEN_W_BINARY	O_BINARY
#	define	SYSV 
#	define 	ONLY_ONE_EXTENSION
# 	define	SPAWN
# 	define	WORD_SIZE_16
#	define	GOT_STDLIB
# endif  

# if	CR_SUN_OS3
	/***********************************************/
	/*   This  entry  has  not been verified, and  */
	/*   is subject to removal.		       */
	/***********************************************/
#	define	SUN
#	define	BSD
#	define	HAVE_SIGINTERRUPT
#	define	DIRSIZ_DEFINED
#	define	OPCODE	int 
/*#	define	HAVE_PTY	*//* Not tried under SunOS 3.x */ 
#	define	WINDOW_SIZE_SUPPORTED
#	define	SELECT 
# 	define	U_CHAR
#	define	WANT_GETCWD
#	define	HAVE_SGTTY
# endif 

# if	CR_ACORN
#	define	BSD
#	define	HAVE_PTY
#	define	HAVE_SGTTY
#	define	HAVE_SIGSETMASK
#	define	NO_SYS_DIR_H
#	define	SELECT 
#	define	SUN
#	define	WANT_GETCWD
#	define	WINDOW_SIZE_SUPPORTED
# 	define	U_CHAR
# endif 
# if	CR_SUN_OS40
#	define	BSD
#	define	DIRSIZ_DEFINED
#	define	HAVE_PTY
#	define	HAVE_SIGINTERRUPT
#	define	HAVE_SIGSETMASK
#	define	HAVE_TERMIO
#	define	SELECT 
#	define	SUN
#	define	U_CHAR
#	define	WANT_GETCWD
#	define	WINDOW_SIZE_SUPPORTED
# endif 

# if	CR_SUN_OS41
#	define	BSD
#	define	DIRSIZ_DEFINED
#	define	GOT_STDLIB
#	define	HAVE_PTY
#	define	HAVE_SIGINTERRUPT
#	define	HAVE_SIGSETMASK
#	define	SELECT 
#	define	SUN
#	define	WINDOW_SIZE_SUPPORTED
#	define	WANT_GETCWD
#	define  HAVE_TERMIO
#	define  HAVE_WAITPID
# 	define	U_CHAR
# endif 

# if	CR_SYSV
#	define	SYSV 
#	define  HAVE_TERMIO
#	define	WANT_GETCWD
#	define	GOT_STDLIB
# endif 

# if	CR_SYSV_3_2
#	define	SYSV
#	define	WANT_GETCWD
#	define  HAVE_TERMIO
#	define	EGA43
#	define	GOT_STDLIB
# endif 

/**********************************************************************/
/*   Following  entry  works  for  Interactive  Unix  V.3.2 with TCP  */
/*   support.							      */
/**********************************************************************/
# if	CR_SYSV_32_PTY
#	define	EGA43
#	define	GOT_STDLIB
#	define	HAVE_MOUSE
#	define	SELECT
#	define	SYSV
#	define	WANT_GETCWD
#	define  HAVE_PTY
#	define  HAVE_TERMIO
#	define  HAVE_WAITPID
#	define	WANT_SYS_SOCKET_H
# 	define	U_CHAR
# endif
 
# if	CR_VMS
#	define	VMS
#	define	DIRSIZ_DEFINED
#	define	MALLOC
#	define  CANNOT_UNLINK_OPEN_FILES
# endif

# if 	CR_XENIX
#	define	WANT_GETCWD
# 	define	SYSV
#	define	OPCODE	int 
#	define  HAVE_TERMIO
#	define	VERSION	23
#	if	VERSION < 23
#		define	DIRSIZ_DEFINED
#	else
#		define	SELECT
#		define	PTY
#	endif
# endif 

/**********************************************************************/ 
/*   This section gives some default values to various definitions.   */
/**********************************************************************/
 
# if	!defined(OPEN_W_BINARY)
#	define	OPEN_W_BINARY	0
#	define	OPEN_R_BINARY	0
# endif
# if	!defined(FOPEN_W_BINARY)
#	define	FOPEN_W_BINARY	"w"
#	define	FOPEN_R_BINARY	"r"
# endif
