.TH make 1 "23 April 1991"
.fi
.SH NAME
Make -- compile programs in a window
.SH DESCRIPTION
The make macro is designed to get over the problem of issuing
a make command to a shell prompt, only to have any error
messages get scrolled off the screen. The usual solution to
this is to redirect the output of make to a file. However,
Murphy usually strikes and the one time you forget to
redirect output is the one time when you have a million and
one errors.
.P
The make macro not only captures the output of a make command
but also is designed to understand the error messages coming
from the standard Unix C compiler. (Other C compilers can be
catered for by modifying the make macro to understand the
syntax of the error messages).
.P
The make macro pops up a window which contains the output
from the running make. Note that whilst this is happening it
is not possible to use CRISP. If any keys are struck whilst
the make window is on the screen, then CRISP closes the pop
up window, and continues where it left off. This is a bug
which at the moment has not been fixed. The reason this bug
exists is that I am debating about providing a user interface
for supporting pop-up windows in an Xwindows style of window
manager. Currently the user interface is designed around
tiling, which is insufficient for macros which take a long
time, like (make). If a key is accidentally hit, the
compilation continues in the process buffer allocated for the
make. In this case the thing to do is to switch to the buffer
named 'Compilation-Buffer' (eg try <Alt-B>). Then the
progress of the make can still be viewed.
.P
When the make finishes (ie the sub-shell terminates), CRISP
will search the log buffer to see if there are any error or
warning messages from the compiler. If so, the make macro
will put the cursor on the line of the first error in the
appropriate file. The actual error which appeared in the log
file will appear on the status line (slightly trimmed to make
it fit).

The make macro cannot cope with syntax errors in files which
do not appear in the current directory. This is a limitation
due to the syntax of the error messages generated by the C
compiler.

After the make macro has finished execution, it reassigns the
macro for the <Ctrl-P> and <Ctrl-N> keys. Typing <Ctrl-N>
will take you to the next line which has an error; <Ctrl-P>
will take you to the previous error. When the last error has
been displayed, the message 'No more errors.' will be
displayed on the status line. Pressing <Ctrl-P> or <Ctrl-N>
again will continue to loop through the errors.

If the make completes successfully, then the message 'Make
completed successfully.' will appear in the status line.

The make macro understands about making different targets in
the make file. To make a target different to the default,
type the target name after the '\fImake\fR' command. For example,
to compile and install the software might be achieved by
typing:
.DS
    	<F10> make install<CR>
.DE
.SH MENU/KEYS
This macro can be accessed from the CRISP features menu or by typing
\f(HBmake\fR at the command prompt followed by any required arguments.

