/**********************************************************************/
/*   This  file  contains the header file definitions for chkalloc.c  */
/*   These  routines  aid in debugging, and performance. The code in  */
/*   this  file  is  part  of  the CRISP package which is (C) P Fox.  */
/*   This  code  may be freely used in any product but the copyright  */
/*   remains  that  of  the author. This copyright notice is present  */
/*   to  avoid  a  conflict of interest and to ensure that CRISP can  */
/*   continue to be a part of the public domain.		      */
/*   								      */
/*   (C) 1991 Paul Fox						      */
/**********************************************************************/
# if	!defined(_CHK_ALLOC_H)
# define	_CHK_ALLOC_H

/**********************************************************************/
/*   Following  macro  used  to  allow  compilation  with ANSI C and  */
/*   non-ANSI C compilers automatically.			      */
/**********************************************************************/
# if !defined(PROTO)
#	if	defined(__STDC__)
#		define	PROTO(x)	x
#	else
#		define	PROTO(x)	()
#	endif
# endif

void	*check_alloc PROTO((int, char *, int));
void	*chk_alloc PROTO((int));
void	*check_realloc PROTO((char *, int));
void	*chk_realloc PROTO((char *, int));
void	chk_free PROTO((void *));
void	check_free PROTO((char *));
void	*vm_alloc PROTO((int, void **));
void	vm_free PROTO((void *, void **));

/**********************************************************************/
/*   Set  this  to  1 if you want to find out where things are being  */
/*   allocated from.						      */
/**********************************************************************/
# define	WHERE	0
			
/**********************************************************************/
/*   Set this to 1 to perform tail end of malloc area checking.	      */
/**********************************************************************/
# define	TAIL	0

			
/**********************************************************************/
/*   Set  to  0  to  force  vm_alloc() to use chk_alloc() for better  */
/*   error checking.						      */
/**********************************************************************/
# define	VM_ALLOC	1
			
/**********************************************************************/
/*   Set following to 0 if machine requires proper alignment.	      */
/**********************************************************************/
# if defined(i386)
# 	define	BYTE_ALIGNED	1
# else
# 	define	BYTE_ALIGNED	0
# endif

# define	chk_alloc(size)		check_alloc(size, __FILE__, __LINE__)
# define	chk_realloc(ptr, size)  check_realloc(ptr, size)
# define	chk_free(ptr)		check_free(ptr)
# if	VM_ALLOC == 0
# define	vm_alloc(size, ptr)	chk_alloc(size)
# define	vm_free(ptr, chain)	chk_free(ptr)
# endif
# endif	/* _CHK_ALLOC_H */
