/**************************************************************
 *
 *	CRISP - Custom Reduced Instruction Set Programmers Editor
 *
 *	(C) Paul Fox, 1989, 1990, 1991
 *
 *    Please See COPYRIGHT notice.
 *
 **************************************************************/

# if	!defined(PROTO)
# 	if	defined(__STDC__) || defined(__GNUC__)
#		define	PROTO(x)	x
# 	else
#		define	PROTO(x) 	()
# 	endif
# endif

# if	!defined(LGET16)
	u_int16	LGET16();
# endif

# include	"ansic.h"

#ifndef _DECLS
void	add_input_device PROTO((int));
void	remove_input_device PROTO((int));
void	bookmark_list PROTO((void));
char	*find_macro_name PROTO((int));
void	find_macro PROTO((void));
void	ttwinch PROTO((void));
void	enter_graphics_mode PROTO((void));
void	exit_graphics_mode PROTO((void));
void	set_binary_size PROTO((void));
void	u_replace PROTO((char *, RSIZE, RSIZE));
void	init_bookmarks PROTO((void));
int	system_call PROTO((int));
void	do_acos PROTO((void));
void	do_asin PROTO((void));
void	do_atan PROTO((void));
void	redraw_echo_line PROTO((void));
void	do_atan2 PROTO((void));
void	do_ceil PROTO((void));
void	do_cos PROTO((void));
void	do_cosh PROTO((void));
void	do_exp PROTO((void));
void	set_window_cmap PROTO((void));
void	set_buffer_cmap PROTO((void));
WINDOW	*find_window PROTO((int));
void	create_char_map PROTO((void));
void	do_fabs PROTO((void));
void	do_floor PROTO((void));
void	inq_keystroke_macro PROTO((void));
void	load_keystroke_macro PROTO((void));
char	*code_to_keyname PROTO((int));
void	init_playback PROTO((void));
void	do_fmod PROTO((void));
void	init_cmap PROTO((void));
void	do_frexp PROTO((void));
void	do_ldexp PROTO((void));
void	do_log PROTO((void));
void	do_log10 PROTO((void));
void	do_modf PROTO((void));
void	do_pow PROTO((void));
void	do_sin PROTO((void));
void	do_sinh PROTO((void));
void	do_sqrt PROTO((void));
void	do_tan PROTO((void));
void	do_tanh PROTO((void));
void	clear_timers PROTO((void));
void	inq_assignment PROTO((void));
void	suspend PROTO((void));
void	backup_level PROTO((char *, int));
void	trace_list PROTO((LIST *));
int	parse_str_number PROTO((char *, double *, long *, int *));
void	acc_assign_lit PROTO((char *));
void	cvt_to_object PROTO((void));
SYMBOL *sym_lookup PROTO((char *));
char	*get_str_ptr PROTO((LIST *));
void	copy_keyboard PROTO((void));
int	set_re_syntax PROTO((int));
void	re_search PROTO((void));
void	re_translate PROTO((void));
void	u_soft_start PROTO((void));
char	*instr PROTO((char *, char *));
BUFFER	*bfind PROTO((char *, int));
BUFFER	*findbuffer PROTO((char *, int *));
void	infof_truncated PROTO((char *, char *));
int	get_typeahead PROTO((int *));
BUFFER	*numberb PROTO((int));
BUFFER *buf_create PROTO((char *));
void	trace_sym_ref PROTO((SYMBOL *));
BUILTIN	*lookup_builtin PROTO((char *));
void	input_mode PROTO((void));
int	sys_enable_char PROTO((int, int));
int	sys_getchar PROTO((int, int *, long));
DISPLAY	*p_create PROTO((int, int));
LINE	*lalloc PROTO((RSIZE));
void	upd_row PROTO((int));
vbyte_t	disp_get_ch PROTO((void));
LINE	*linep PROTO((int));
void	acc_assign_argv PROTO((LISTV *));
ref_t	*acc_get_list PROTO((void));
LIST	*next_atom PROTO((LIST *));
LIST	*get_list PROTO((int));
ref_t	*acc_get_ref PROTO((void));
LIST	*next_linear_atom PROTO((LIST *));
LIST *	copy_list PROTO((LIST *, int));
MACRO	*lookup_macro PROTO((char *));
OPCODE	acc_get_type PROTO((void));
REGEXP	*regcomp PROTO((char *));
SYMBOL	*lookup PROTO((char *));
WINDOW	*get_edge PROTO((int));
WINDOW	*get_window PROTO((int));
WINDOW	*splitwind PROTO((void));
WINDOW	*vsplitwind PROTO((void));
char	*acc_get_sval PROTO((void));
char	*aitokey PROTO((int));
char	*backslash_to_fwd PROTO((char *));
char	*bname PROTO((char *));
char	*c_string PROTO((char *));
char	*c_string PROTO((char *));
char	*do__prntf PROTO((int));
char	*filename PROTO((char *));
char	*get_arg1 PROTO((char *, char *, int));
char	*get_cwd PROTO((void));
char	*get_shell PROTO((void));
char	*get_str PROTO((int));
char	*ggetenv PROTO((char *));
char	*next_block PROTO((char *));
char	*strdup PROTO((char const *));
char	*tcopy_string PROTO((char *, char *, int));
char	*tgetstr PROTO((char *, char **));
char **shell_expand PROTO((char *));
double	acc_get_fval PROTO((void));
int	anycb PROTO((void));
int	atomic_fileedit PROTO((char *));
int	bclear PROTO((BUFFER *));
int	charcost PROTO((char *));
int	check_key PROTO((unsigned short *, int *));
void	kbd_flush PROTO((void));
int	check_mark PROTO((void));
int	copyregion PROTO((FILE *, char *));
int	current_col PROTO((int));
int	current_offset PROTO((int, int));
int	delete_macro PROTO((LIST *));
int	edefreply PROTO((char *, char *, char *, int));
int	ereply PROTO((char *, char *, int));
int	eval PROTO((LIST *, LISTV *));
int	eyesno PROTO((char *));
int	eyorn PROTO((char *));
int	get_current_drive PROTO((void));
int	get_iarg1 PROTO((char *, long *));
int	get_len PROTO((int));
int	get_longest_line PROTO((void));
int	get_marked_areas PROTO((WINDOW *));
int	get_push PROTO((ref_t *, int));
int	gputenv PROTO((char *));
int	grab_char PROTO((int));
int	init_fp PROTO((int, char *));
int	ins_macro PROTO((char *, LIST *, int));
int	k_read PROTO((char **));
int	k_numlines PROTO((void));
int	k_type PROTO((void));
int	killbuffer PROTO((int));
int	l_insert PROTO((int));
int	ld_macro PROTO((char *));
int	length_of_list_in_bytes PROTO((LIST *));
int	linsert PROTO((char *, int));
int	llinsert PROTO((char *, u_int32, int));
int	lnewline1 PROTO((LINE *, u_int32));
int	lreadin_file PROTO((int, unsigned long, char *));
int	lrealloc PROTO((LINE *, int, u_int32));
int	lreplace PROTO((char *, int, RSIZE, int));
int	main_thread_read_kbd PROTO((long));
int	message PROTO((void));
int	new_akeytoi PROTO((char *));
int	next_tab_stop PROTO((int));
int	numlines PROTO((void));
int	printable_char PROTO((int));
int	proc_wait PROTO((int));
void	push_back PROTO((void));
int	key_define_key_seq PROTO((int, char *));
int	rdonly PROTO((void));
int	read_macro PROTO((char *));
int	read_macro1 PROTO((char *));
int	readin PROTO((BUFFER *, char *));
int	regexec PROTO((REGEXP *, char *, int));
int	second_passed PROTO((void));
int	space_fill PROTO((LINE *, int, int, int));
int	space_fill PROTO((LINE *, int, int, int));
int	sys_checkc PROTO((void));
int	sys_read PROTO((int, char *, int));
int	sys_write PROTO((int, char *, int));
int	tab_replace PROTO((void));
int	tgetent PROTO((char *, char *));
int	tgetflag PROTO((char *));
int	tgetnum PROTO((char *));
int	tputs PROTO((char *, int, int (*)()));
int	ttdell PROTO((int, int, int));
int	typeahead PROTO((void));
int	wild_match PROTO((char *, char *));
int	writeout PROTO((BUFFER *, char *, int, int));
long	LGET32 PROTO((LIST *));
long	acc_get_ival PROTO((void));
ref_t	*r_inc PROTO((ref_t *));
ref_t	*r_cat PROTO((ref_t *, char *));
ref_t	*r_append PROTO((ref_t *, char *, int, int));
ref_t	*r_inc PROTO((ref_t *));
ref_t	*r_init PROTO((OPCODE, char *, int));
void	acc_assign_ref PROTO((ref_t *));
short	getkey PROTO((long));
int	get_rawkey PROTO((long));
void	LGET_FLOAT PROTO((LIST *, double *));
void	LPUT16 PROTO((LIST *, int));
void	LPUT32 PROTO((LIST *, long));
void	LPUT_FLOAT PROTO((LIST *, double));
void	vtputb PROTO((int));
void	acc_assign_float PROTO((double));
void	acc_assign_int PROTO((long));
void	acc_assign_ref PROTO((ref_t *));
void	acc_assign_list PROTO((LIST *, int));
void	acc_donate_list PROTO((LIST *, int));
void	acc_assign_str PROTO((char *, int));
void	acc_assign_str PROTO((char *, int));
void	acc_trace PROTO((void));
void	append PROTO((void));
LIST	*append_list PROTO((LIST *, int, LISTV *, int *));
void	inq_char_map PROTO((void));
void	acc_assign_null PROTO((void));
void	ttwinch1 PROTO((int, int));
void	backchar PROTO((int));
void	check_exit PROTO((void));
void	check_exit PROTO((void));
void	close_termcap PROTO((void));
void	com_equ1 PROTO((int, SYMBOL *));
void	cpp PROTO((void));
void	cr_exit PROTO((void));
void	del_to_eol PROTO((void));
void	delete_buffer_symbols PROTO((BUFFER *));
void	delete_local_symbols PROTO((void));
void	delete_symbols PROTO((SPTREE *));
void	delete_window PROTO((WINDOW *));
void	detach_buffer PROTO((WINDOW *));
void	do_define PROTO((void));
void	do_include PROTO((void));
void	draw_title PROTO((int, int, WINDOW *));
void	drop_anchor PROTO((void));
void	dump_all_lines PROTO((void));
void	edinit PROTO((void));
void	eputc PROTO((int));
void	errorf();
void	eval_expr PROTO((LISTV *));
void	ewprintf();
void	ewputs PROTO((char *, char *));
void	exec1 PROTO((LIST *, LIST *));
void	exec_key PROTO((int));
void	execute_macro PROTO((LIST *));
void	write_buffer PROTO((void));
void	find_file PROTO((void));
void	flush_cache PROTO((BUFFER *));
void	flush_col_cache PROTO((void));
void	forwline PROTO((int));
void	free_key PROTO((int));
void	free_line PROTO((LINE *));
void	free_list PROTO((LIST *));
void	get_ready_to_stop PROTO((int));
void	get_until PROTO((char *, int));
void	gotoline PROTO((int));
void	harden_windows PROTO((void));
void	infof();
void	init_builtin PROTO((void));
void	init_macros PROTO((void));
void	init_register PROTO((void));
void	ins_mode PROTO((void));
void	int_assign PROTO((SYMBOL *, long));
void	int_assign PROTO((SYMBOL *, long));
void	k_delete PROTO((int));
void	k_end PROTO((void));
void	k_init PROTO((void));
void	k_newline PROTO((void));
void	k_seek PROTO((void));
void	k_undo PROTO((void));
void	k_write PROTO((u_char *, int));
void	key_init PROTO((void));
void	key_list PROTO((void));
void	ladjust PROTO((void));
void	lchange PROTO((int));
void	ldelete PROTO((RSIZE));
void	ldelete PROTO((RSIZE));
void	lfree PROTO((BUFFER *, int));
void	lfree_line PROTO((BUFFER *, LINE *, int));
void	line_col PROTO((int));
void	list_acc PROTO((LIST *, int));
void	list_assign PROTO((SYMBOL *, LIST *, int));
void	list_macro PROTO((int, LIST *));
void	lnewline PROTO((void));
void	lnormal PROTO((LINE *, u_int32));
void	mouse_init PROTO((char *));
void	move_abs PROTO((void));
void	next_char PROTO((void));
void	noinherit PROTO((int));
void	p_addstr PROTO((BUFFER *, char *));
void	p_cleanup PROTO((BUFFER *));
void	p_destroy PROTO((BUFFER *));
void	p_escape PROTO((DISPLAY *, int));
void	p_poll PROTO((void));
void	p_update PROTO((BUFFER *, char *));
void	p_wait PROTO((void));
void	p_write PROTO((char *, int));
void	panic PROTO((char *));
void	percentage PROTO((unsigned long, unsigned long, char *, char *));
void	phex PROTO((char *, int));
void	prev_char PROTO((void));
void	print_cursor PROTO((int));
void	print_line PROTO((LINE *));
void	proc_add PROTO((int, char *));
void	process PROTO((void));
void	push_back1 PROTO((ref_t *, int));
void	push_back2 PROTO((ref_t *, int, int, int));
void	putpad PROTO((char *));
void	r_dec PROTO((ref_t *));
void	raise_anchor PROTO((void));
void	read_file PROTO((void));
void	reg_idle PROTO((void));
void	set_idle_default PROTO((void));
void	regerror PROTO((char *));
void	remember PROTO((void));
void	remember_macro PROTO((char *));
void	renumber_lines PROTO((BUFFER *));
void	restore_position PROTO((void));
void	resume_after_stopping PROTO((int));
void	save_position PROTO((void));
void	set_buffer_bottom PROTO((WINDOW *));
void	set_buffer_parms PROTO((WINDOW *, BUFFER *));
void	set_corners PROTO((void));
void	set_current_drive PROTO((int));
void	set_cursor PROTO((void));
void	set_hooked PROTO((void));
void	set_top_left PROTO((void));
void	set_window_parms PROTO((WINDOW *, BUFFER *));
void	setttysize PROTO((void));
void	showbuffer PROTO((BUFFER *, WINDOW *));
void	sort_buffer_list PROTO((void));
void	sort_windows PROTO((void));
int	startupfile PROTO((void));
void	store_char PROTO((int));
void	str_acc_assign PROTO((char *, int));
void	str_assign PROTO((SYMBOL *, char *));
int	str_exec PROTO((char *));
void	str_rassign PROTO((SYMBOL *, ref_t *));
void	swap_words PROTO((u_int32 *, int));
void	sym_assign_fval PROTO((SYMBOL *, double));
void	sym_init PROTO((void));
void	sys_close PROTO((void));
void	sys_open PROTO((void));
void	trace_ilog();
void	trace_list();
void	trace_log();
void	trace_sym PROTO((SYMBOL *));
void	trace_refs PROTO((void));
void	trace_trigger PROTO((int));
int	trigger PROTO((int));
void	ref_assign PROTO((SYMBOL *, ref_t *));
void	ttbeep PROTO((void));
void	ttclose PROTO((void));
void	ttcolor PROTO((int));
void	tteeol PROTO((void));
void	tteeop PROTO((void));
void	ttflush PROTO((void));
void	ttinit PROTO((void));
void	ttinit1 PROTO((int));
void	ttinti1 PROTO((int));
void	ttmove PROTO((int, int));
void	ttopen PROTO((int));
void	ttputc PROTO((int));
void	ttputpad PROTO((int));
void	ttputs PROTO((char *));
void	ttresize PROTO((void));
void	ttspace PROTO((int, int, int));
void	tttidy PROTO((void));
void	ttwindow PROTO((int, int));
void	u_chain PROTO((void));
void	u_close PROTO((void));
void	u_delete PROTO((RSIZE));
void	u_dot PROTO((void));
void	u_drop PROTO((void));
void	u_init PROTO((void));
void	u_insert PROTO((RSIZE, int));
void	u_raise PROTO((void));
void	u_scrap PROTO((void));
void	u_terminate PROTO((void));
void	ucopy PROTO((vbyte_t *, vbyte_t *));
void	uline PROTO((int, vbyte_t *, vbyte_t *));
void	undo PROTO((int));
void	update PROTO((void));
void	usage PROTO((void));
void	vtblanks PROTO((void));
void	vtinit PROTO((int *, char **));
void	x11_init PROTO((int *, char **));
void	vtinit1 PROTO((void));
void	vtleft PROTO((int, int));
void	vtmove PROTO((int, int));
void	vtputs PROTO((unsigned char *, int));
void	vttidy PROTO((int));
void	vtupdate PROTO((int, int, int, int));
void	w_title PROTO((WINDOW *, char *, char *));
void	win_modify PROTO((int));
void	write_block PROTO((void));
void	wwin_modify PROTO((WINDOW *, int));
void	yyerror();
int	read_char_timeout PROTO((int, int *, long));
void	kbd_push PROTO((void));
void	kbd_pop PROTO((void));
void	detach_local_keyboard PROTO((BUFFER *));
void	setup_pty_mode PROTO((int));
void	argv_assign PROTO((int, long));
unsigned short *cvt_string_to_code PROTO((char *, int *));
char	*expand_filename PROTO((char *));
#endif
