/**************************************************************
 *
 *	CRISP - Custom Reduced Instruction Set Programmers Editor
 *
 *	(C) Paul Fox, 1989, 1990, 1991
 *
 *    Please See COPYRIGHT notice.
 *
 *   This file contains machine independent configuration variables.
 *
 *    Machine dependent ones appear in unix.c or vms.c
 *
 **************************************************************/
# include	"list.h"
# include	"alt.h"

char	*bfile = "BFILE=newfile";
char	*bflags = "BFLAGS=-i60";

# if defined(MSDOS)
char	*default_term = "TERM=dos";
# else
char	*default_term = "TERM=ansi";
# endif
char	*bpackages = "BPACKAGES=c,h:t";

int	strip_cr_flag = TRUE;	/* Set to FALSE if dont want <CR> stripped */
				/* by default.				   */
color_t	col_table = {
		0,		/* Background.		*/
		2,		/* Normal text.		*/
		11,		/* Selected window title*/
		14,		/* Normal messages.	*/
		12,		/* Error messages.	*/
		4,		/* Hi-lite background.  */
		10,		/* Hi-lite foreground.  */
		};

struct k_tbl k_tbl[] = {
		CTRL_X,		"exit",
		F(1),		"change_window",
		F(2),		"move_edge",
		F(3),		"create_edge",
		F(4),		"delete_edge",
		F(5),		"search_fwd",
		F(6),		"translate",
		F(7),		"remember",
		F(8),		"playback",
		F(9),		"load_macro",
		F(10),		"execute_macro",
		KEYPAD_0,	"paste",
		KEY_END,	"end_of_line",
		KEY_DOWN,	"down",
		KEY_PAGEDOWN,	"page_down",
		KEY_LEFT,	"left",
		KEY_RIGHT,	"right",
		KEY_HOME,	"beginning_of_line",
		KEY_UP,		"up",
		KEY_PAGEUP,	"page_up",
		KEY_DEL,	"delete_block",
		KEY_COPY,	"copy",
		KEY_CUT,	"cut",
		KEY_UNDO,	"undo",
		SF(7),		"pause",
		SHIFT_KEYPAD_2,	"change_window 2",
		SHIFT_KEYPAD_4,	"change_window 3",
		SHIFT_KEYPAD_6,	"change_window 1",
		SHIFT_KEYPAD_8,	"change_window 0",
		CTRL_KEYPAD_1,	"end_of_window",
		CTRL_KEYPAD_3,	"end_of_buffer",
		CTRL_KEYPAD_7,	"top_of_window",
		CTRL_KEYPAD_9,	"top_of_buffer",
		ALT_A,		"mark 4",
		ALT_B,		"_case",
		ALT_C,		"mark 2",
		ALT_D,		"delete_line",
		ALT_E,		"edit_file",
		ALT_G,		"goto_line",
		ALT_I,		"insert_mode",
		ALT_J,		"goto_bookmark",
		ALT_K,		"delete_to_eol",
		ALT_L,		"mark 3",
		ALT_M,		"mark",
		ALT_O,		"output_file",
		ALT_P,		"_print",
		ALT_R,		"read_file",
		ALT_S,		"search_fwd",
		ALT_T,		"translate",
		ALT_U,		"undo",
		ALT_V,		"version",
		ALT_W,		"write_buffer",
		ALT_X,		"exit",
		ALT_Z,		"shell",
		0,		NULL
		};

scrfn_t scrfn;			/* Somewhere to define this. */
				/* sys_open() function can write to */
				/* this structure to override functions. */
