/*	this is to supplement the environment()	*/
/*	procedure currently in utility.c	*/
/*	the idea is to put user-defines in	*/
/*	a file .combrc instead of environment	*/
/*	variables.				*/
/*						*/
/*	march 03, 1991 rick nickle		*/
#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	"comb.h"

static	FILE	*mailfile;

extern	char	editor[];
extern	char	pager[];
extern	char	shell[];
extern	char	printer[];
extern	char	signature[];
extern	char	organization[];
extern	char	quotechar[];
extern	char	homedir[];

extern	int	disp_pref;
extern	int	sort_pref;
extern	int	bell_pref;

char	rcfile[MAXLINE];

#define NUMRC	10
char	rc_fields[NUMRC][20] = {
		"editor",	/* 0 */
		"pager",	/* 1 */
		"shell",	/* 2 */
		"printer",	/* 3 */
		"signature",	/* 4 */
		"organization",	/* 5 */
		"sort",		/* 6 */	/* ignore this for now */
		"display-size",	/* 7 */
		"bell",		/* 8 */
		"quote"		/* 9 */
	};

lcase(s)
char *s;
{
	while ((*s = tolower(*s)) != '\0') *s++;
}

rc()
{
	int	epos;

	char	rcbuf[MAXLINE];
	char	field[MAXLINE];
	char	valu[MAXLINE];
	char	*v;
	int	i;

	strcpy(rcfile,homedir);
	strcat(rcfile,"/.combrc");
	if ((mailfile = fopen(rcfile,"r")) == NULL)
		{
			return;
		}
	while (fgets(rcbuf,MAXLINE,mailfile) != NULL)
	{
		if (rcbuf[0] != '#')
		{
		v = strstr(rcbuf,"=");
		*v++;
		strcpy(valu,v);
		epos = strlen(rcbuf) - strlen(valu) -1;
		strncpy(field,rcbuf,epos);
		field[epos] = '\0';
		lcase(field);
		/* not a comment, process data */
		for (i = 0; i <= NUMRC; i++)
		     {
		     if (strncmp(field,rc_fields[i],strlen(rc_fields[i])) == 0)
			{
			switch(i)
			   {
			   case 0 : { strncpy(editor,valu,strlen(valu)-1);
					break;
					}
			   case 1 : { strncpy(pager,valu,strlen(valu)-1);
					break;
					}
			   case 2 : { strncpy(shell,valu,strlen(valu)-1);
					break;
					}
			   case 3 : { strncpy(printer,valu,strlen(valu)-1);
					break;
					}
			   case 4 : { strncpy(signature,valu,strlen(valu)-1);
					break;
					}
			   case 5 : { strncpy(organization,valu,strlen(valu)-1);
					break;
					}
			   case 6 : { /* sort */
				lcase(valu);
				if (valu[0] == 'r') sort_pref = SORTCHRONO;
				if (valu[0] == 'c') sort_pref = SORTRECEIVED;
				break;
			   }
			   case 7 : { /* size */
				lcase(valu);
			/*	if (valu[0] == 'k') disp_pref = SHOWKILO; */
			/* kilobytes not supported yet			   */
				if (valu[0] == 'l') disp_pref = SHOWLINE;	
				if (valu[0] == 'b') disp_pref = SHOWBYTE;	
				break;
				}
			   case 8 : { /* bell */
				lcase(valu);
				if (valu[0] == 'y') bell_pref = BELLRINGIT;
				if (valu[0] == 'n') bell_pref = BELLQUIET;
				if (valu[0] == 'v') bell_pref = BELLVISIBLE;
				break;
				}
			   case 9 : { /* quote */
				strncpy(quotechar,valu,strlen(valu)-1);	
				quotechar[strlen(valu) -1] = '\0';
				break;
				}
			   } /* switch */
			break;
			} /* match on field */
		     } /* for */
		}
	}
	return;
	fclose(mailfile);
}

/* left here for now for testing purposes.
main()
{
	printf("Testing rc():\n\n");
	printf("Return status: %d\n",rc());	
	printf("Editor       : %s\n",editor);
	printf("Pager        : %s\n",pager);
	printf("Organization : %s\n",organization);
	printf("Printer      : %s\n",printer);
	printf("Shell        : %s\n",shell);
	printf("Signature    : %s\n",signature);
	printf("Bell         : %d\n",bell_pref);
	printf("Display      : %o\n",disp_pref);
	printf("Sorting      : %o\n",sort_pref);
}
*/
