#define	VERSION "1.40"
/*	this is the default path to search for mail.  actually, right	*/
/*	now it's the only path search, and it's appended by the result	*/
/*	of getlogin() so whatever you put here will be appended with	*/
/*	your username.  unless you moved your mail directory don't 	*/
/*	change it.							*/
/*	NOTE:  check permissions of mailboxes in /usr/spool/mail	*/
/*	they should be 722, or else you won't be able to send local	*/
/*	mail.  this is because of a bug in /etc/newusr.			*/
#define DEF_MAILPATH "/usr/spool/mail/"

/*	this is the default pager to use if the user hasn't defined	*/
/*	one in the shell variable $PAGER				*/
#define	DEF_PAGER "exec /bin/scat"

/*	this is the default character to put prepend to each line	*/
/*	in a quoted message						*/
#define	DEF_QUOTE ">"

/*	'organization' field in sent mail.  this is the default for 	*/
/*	your site.							*/
#define DEF_ORGANIZATION ""

/*	default editor if user didn't define EDITOR shell variable	*/
#define	DEF_EDITOR "me"

/*	default printdev (overridden by $PRINTDEV if exported)		*/
/*	used for destination of print command.				*/
/*									*/
/*	NOTE:  this is PIPED through a system() command, not written	*/
/*	       directly to the device through file i/o.			*/
/*									*/
/*	I prefer piping it through a smart printer server like		*/
/*	epson, it will also work with a spooler.  If you want it 	*/
/*	to go directly to the output device, use 'cat > /dev/lpt'	*/
/*	instead...but it has to go through a program somehow.		*/
#define DEF_PRINTER "lpr -B"

/*	what to put in the X-Mailer line on replied/sent messages.	*/
#define XMAILER "[Coherent 4.0 Mailbox]"

/*	smart-host is a the path-name of the closest site to you that	*/
/*	can understand domain addressing and other sundry net-stuff.	*/
/*	ex:  for me, the closest, most-freq.-polled smart host is	*/
/*	'think.com'.  i reach them through:  fcsys!think.... so i	*/
/*	define my smart-host as:  fcsys!think! and mail that is routed	*/
/*	through comb that contains a '@' domain address, but does not	*/
/*	have a traceable bang-path will be sent to there for routing.	*/
/*	SMAIL NOTE:	make this field blank if you use smail2.5	*/
/*			and it shouldn't bug you.			*/
#define SMARTHOST "easix!"

#define MAXLINE 128
#define MAXBUF 256
#define	FAIL -1
#define	YES 1
#define NO -1
#define	ESCAPE -2
#define ERROR -2
#define	QUOTEIT 1
#define DONTQUOTE -1
#define LSUBJ 45	/* length of subject: on screen. don't fiddle. */

/* anything that says 'not supported' means i haven't gotten around to
   implementing it. */

/*	sorting keys, for future use.	*/
#define	SORTMSGS	0100 	/* not supported */
#define	SORTRVRS	0040	/* not supported */
#define	SORTNAME	0020	/* not supported */
#define	SORTCHRONO	0010
#define	SORTRECEIVED	0004

/*	user preference keys, audio	*/
#define	BELLQUIET	0000
#define	BELLVISIBLE	0001	/* not supported..yet */
#define	BELLRINGIT	0002

/*	user preference keys, display	*/
#define	SHOWBYTE	0100	/* display size in bytes	*/
#define	SHOWLINE	0040	/* display size in lines	*/
#define	SHOWKILO	0020	/* display size in kilobytes (not supported)*/

/*	move, clrtoeol	*/
#define	MVCEOL(y,x) move(y,x); clrtoeol()
/*	mvaddstr, clrtoeol	*/
#define	MVADDCEOL(y,x,s) mvaddstr(y,x,s); clrtoeol()
/*	move, clrtoeol, then get s and copy to d */
#define	MVCGETS(y,x,s,d) MVCEOL(y,x); refresh(); getst(s); strcpy(d,s)

extern  int stat();
extern	char *getlogin();
extern	char *getenv();
extern	char *mktemp();

typedef struct {
	char	*when_sent;	/* grok routines will fill these in	*/
	char	*from_who;
	char	*from_path;
	char	*subject;	
	long	position;	/* byte offset into mailbox for fseek() */
	long	size;		/* size of message in bytes		*/
	int	lines;		/* size of message in lines		*/
	int	status;		/* 0 == unread 1 == read 2 == delete	*/
	struct HEADER	*next;
	struct HEADER	*prev;
} HEADER;

