/*	checking address and routing mail to smart-host	*/
/*	25-Jan-90 rick nickle				*/
/*							*/

/*	return true if local address			*/
/*	i.e., 'root' or 'trystro!root' on my system	*/
/*	would be a local address			*/
/*	also, return "real name" if available.		*/
#include	<stdio.h>
#include	<string.h>
#include	<pwd.h>
#include	"comb.h"

#define	LOCAL1 1
#define	LOCAL2 2
#define USERAL 1
#define SYSTAL 2

static FILE	*mailpipe;
static FILE	*mailfile;

extern char	sitename[];	/* defined in comb */
extern char	homedir[];

char	*getalias(check,path)
char	*check;	/* check this alias file */
char	*path;	/* grok this path	 */
{
	char	bufr[MAXBUF];
	char	*b;
	char	colon[MAXBUF];

	/* will try to see if it can find an alias, and do substitution */
	if ((mailfile = fopen(check,"r")) != NULL)
	{
		while(fgets(bufr,MAXBUF,mailfile) != NULL)
		{
		strcpy(colon,path);
		strcat(colon,":");
		if (strncmp(bufr,colon,strlen(colon)) == 0)
			{
			fclose(mailfile);
			b = &bufr[0];
			while (*b++ != ':');
			while ((*b == '\t') || (*b == ' '))
				(*b++);
			return b;
			}
		}
	}
	fclose(mailfile);
	return NULL;
}

int	isalias(r,info)
char	*r;
char	*info;
{
	char	analias[MAXBUF];
	char	alidir[MAXLINE];

	strcpy(alidir,homedir);
	strcat(alidir,"/.aliases");
	/* alright, we need to scan both /usr/lib/mail/aliases	*/
	/* AND $HOME/.aliases to re-interpret desitination	*/
	strcpy (analias,getalias("/usr/lib/mail/aliases",r));
	if (analias[0] != '\0')
		{
		strcpy(info,analias);
		return SYSTAL;
		}
	strcpy (analias,getalias(alidir,r));
	if (analias[0] != '\0')
		{
		strcpy(info,analias);
		return USERAL;
		}
	return NO;
}

int	islocal(r)
char	*r;
{

	struct passwd	*pwent;

	/*	case 1:  route-path contains no ! @ %	*/
	/*	characters, definitely a local user.	*/
	if ((strstr(r,"@") == NULL) &&
	   (strstr(r,"!") == NULL) &&
	   (strstr(r,"%") == NULL))
	{
		if ((pwent = getpwnam(r)) == NULL) return ERROR;
			else return LOCAL1;
	}
	/*	case 2:  'sitename' is local sitename	*/
	if (strncmp(r,sitename,strlen(sitename)) == 0)
	{
		return LOCAL2;
	}
	return NO;
}

int	isasite(r)
char	*r;
{

	char ubuf[20];

	if (strlen(r) > strlen(sitename))
	{
		if ((mailpipe = popen("/usr/bin/uuname","r")) != NULL)
		{
			while (fgets(ubuf,20,mailpipe) != NULL)
			{
			if (strncmp(ubuf,r,strlen(ubuf)-1) == 0)
				{
				pclose(mailpipe);
				return YES;
				}
			}
		}
		pclose(mailpipe);
	}
	/* okay, it wasn't in the list of available adjacent sites */
	/* could it be a uucp address prepended to a domain add.?  */
	if ((strstr(r,"@")) == NULL) return ERROR;
	return NO;
	/* must be headed for re-route by a domain */
}

/*	figure out if the route given is on the local system,	*/
/*	if it is being routed to an adjacent site, or if it is	*/
/*	being routed to an unknown site.  if it is unknown,	*/
/*	prepend the path for the 'smart host' and let him do	*/
/*	the dirty work.						*/
char	*route(path,info)
char	*path;
char	*info;
{
	char	smart[MAXBUF];
	char	dumb[MAXBUF];
	struct passwd *pwent;


	strcpy(dumb,path);	/* strtok is destructive */

	strcpy(smart,SMARTHOST);
	strcat(smart,path);

	if((strstr(path,"@") == NULL) &&
	   (strstr(path,"!") == NULL) &&
	   (strstr(path,"%") == NULL))
	   {
		switch (isalias(path,dumb)) {
		case USERAL	: {
			strcpy(info,"User-defined Alias");
			return &dumb[0]; break; }
		case SYSTAL	: {
			strcpy(info,"System-defined Alias");
			return &dumb[0]; break;	}
		default		: break;
		}
	}

	switch (islocal(path)) {
	case LOCAL2	: {
				/* if it's a local user, but dummy */
				/* (or reply-parse) prepended the  */
				/* local sitename, strip it before */
				/* falling through to get-pwname & */
				/* returning.			   */
				while (*path++ != '!');
			}
	case LOCAL1 	: {
				/* look up users "real" name in	   */
				/* password file.		   */
				if ((pwent = getpwnam(path)) != NULL)
					strcpy(info,pwent->pw_gecos);
				else {
					info = NULL;
					return NULL;
				}
				return &dumb[0];
				break;
			}

	case ERROR  	: {
				info = NULL;
				return NULL;
			}
	case NO		:
	default		: break;
	}
	switch (isasite(path)) {
	case YES	: {
				strcpy(info,"Routed to adjacent site");
				return &dumb[0];
			}
	case ERROR	: {	
				info = NULL;
				return NULL;
			}
	default		: {
				strcpy(info,"Routed to Smart-Host");
				return &smart[0];
			}
	}
}
