

CAWF(1)                    Unix Programmer's Manual                    CAWF(1)


NAME
     cawf - C version of the nroff-like, Amazingly Workable (text) Formatter

SYNOPSIS
     cawf [ -macros ] [ file ... ]

DESCRIPTION
     Cawf formats the text from the input file(s) (standard input if none)  in
     an  approximation  of nroff.  It comes closest to duplicating nroff's man
     or ms macro package styles.  The -macro argument is optional, and it must
     be  first.   (The  standard  cawf  distribution  supplies  macro files to
     support `-man' or `-ms'.)

     Cawf accepts the following raw nroff requests:

          .\"  .ad  .bp  .br  .ce  .de  .ds  .el  .fi
          .ft  .i0  .ie  .if  .in  .it  .lg  .li  .ll
          .ls  .na  .ne  .nf  .nr  .ns  .pl  .po  .ps
          .rm  .rr  .rs  .so  .sp  .ta  .ti  .tm

     and the following in-text codes:

          \$   \%   \*   \c   \f   \h   \n   \s

     plus the full list of nroff/troff special characters in the  original  V7
     troff manual.

     Many restrictions are present; the behavior in general  is  a  subset  of
     nroff's.  Of particular note are the following:

     o Point sizes do not exist; .ps is ignored.

     o Special vertical spacing - the .vs command included - is ignored.

     o Conditionals cover only numeric comparisons on  \n(.$,  string  compar-
       isons  between a macro parameter and a literal, and n (always true) and
       t (always false).

     o The handling of strings is generally primitive.

     o Horizontal motion via \h  must  be  supplied  with  a  number  register
       interpolation and must be positive - e. g., \w\n(NN, where the value in
       NN is >= 0.

     o Expressions - e. g., .sp - are reasonably general, but the |, &, and  :
       operators  do  not  exist, there must be white space between the end of
       the nroff command and the beginning of the expression, and \w  requires
       that  quote  (')  be  used as the delimiters.  \w counts the characters
       inside the quotes and scales the result in ens, so that,  for  example,
       \w'\(bu' equals 4n, and \w'\(bu'/1n equals 4.

     o The only acceptable count for  the  .it  command  is  one,  and  it  is
       effective only with man or ms macros.





Purdue University                       February, 1991                       1




CAWF(1)                    Unix Programmer's Manual                    CAWF(1)


     o The default scaling factor is `v' for the .ne, .sp, and .pl  raw  nroff
       requests;  it  is  `u' for .nr; and `n' for .in, .ll, .ls, .po, .ta and
       .ti.  (A different scaling factor may  be  specified  with  a  trailing
       character.)

     o Some obsolete or meaningless commands - .i0, .lg and .li - are silently
       ignored.

     White space at the beginning of lines, and embedded  white  space  within
     lines  is dealt with properly.  Sentence terminators at ends of lines are
     understood to imply extra space afterward in filled lines.  Tabs are  im-
     plemented  crudely  and  not  exactly,  although  usually  they  work  as
     expected.  Hyphenation is done only at explicit hyphens,  em-dashes,  and
     nroff  discretionary  hyphens.   Bolding  and italicization are done with
     backspacing and overprinting.

MAN MACROS
     The man macro set replicates the full V7 manual macros, plus a few  semi-
     random oddballs.  The full list is:

          .AT  .B   .BI  .BR  .BY  .DE  .DS  .DT  .HP  .I
          .IB  .IP  .IR  .IX  .LP  .NB  .P   .PD  .PP  .RB
          .RE  .RI  .RS  .SH  .SM  .TH  .TP  .UC

     .BY and .NB each take a single string argument  (respectively,  an  indi-
     cation  of authorship and a note about the status of the manual page) and
     arrange to place it in the page footer.  .AT and .IX do nothing.

MS MACROS
     The ms macro set is a substantial subset of  the  V7  manuscript  macros.
     The macros are:

          .AB  .AE  .AI  .AU  .B   .CD  .DA  .DE  .DS  .I
          .ID  .IP  .LD  .LG  .LP  .ND  .NH  .NL  .PP  .QE
          .QP  .QS  .R   .RE  .RP  .RS  .SH  .SM  .TL  .TP
          .UL  .UX

     Size changes are recognized but ignored, as are .RP and  .ND.   .UL  just
     prints  its  argument in italics.  .DS/.DE does not do a keep, nor do any
     of the other macros that normally imply keeps.

     The DY string variable is available.  The PD, PI, and LL number registers
     exist and can be changed.

HEADERS AND FOOTERS
     Cawf can do limited header and footer processing from the LH, CH, RF, LF,
     CF, and RF string variables, via the control of the .^b command:

     .^b fh 1   enables a header on the first page
     .^b fh 0   disables the header on the first page
     .^b HF 1   enables header/footer processing
     .^b HF 0   enables header/footer processing






Purdue University                       February, 1991                       2




CAWF(1)                    Unix Programmer's Manual                    CAWF(1)


     There are appropriate .^b commands in the distribution man and  ms  macro
     files.   (The  ms  macro file uses another .^b command, .^b NH, to enable
     numbered header processing.)

OUTPUT
     The only output format supported by cawf, in  its  distributed  form,  is
     that  appropriate to a dumb terminal, using overprinting for italics (via
     underlining) and bold.  The nroff special characters are printed as  some
     vague  approximation  (it's  sometimes  extremely vague) to their correct
     appearance.

     Cawf's knowledge of the output device is established by  a  device  file,
     which  is  read  before  the  user's  input.  The search for it begins in
     cawf's library directory, under the name  term.dev  (where  term  is  the
     value  of  the  TERM  environment  variable).  Failing to find that, cawf
     searches for dumb.dev.  The device file uses special internal commands to
     set up resolution, special characters, fonts, etc., and more normal nroff
     commands to set up page length, etc.

FILES
     All files are located in c:/sys/lib/cawf (the author's MS-DOS environment
     default).   This  default  can  be  overridden by the CAWFLIB environment
     variable, or changed in the source code.

     common   common device-independent initialization
     *.dev    device-specific initialization
     m*.mac   macro package files

SEE ALSO
     bsfilt(1), colcrt(1), nroff(1), man(7), and ms(7).

DIAGNOSTICS
     Unlike nroff, cawf  complains  whenever  it  sees  unknown  commands  and
     macros.   All  diagnostics  (these  and some internal ones) appear on the
     standard error file.

HISTORY
     Vic Abell of Purdue University <abe@mace.cc.purdue.edu> derived cawf from
     awf,  ``the  Amazingly  Workable  (text)  Formatter'' that was written by
     Henry Spencer of the University of  Toronto.   The  Toronto  work  was  a
     supplement  to  the  C  News  project.   The  Purdue  effort was aimed at
     producing  a  C  language  version  that  would  run  on  small  systems,
     particularly MS-DOS ones.

     The MS-DOS version of cawf has been  compiled  with  Microsoft's  Quick-C
     compiler.   It  runs  under  the  Mortis  Kern Systems Toolkit KornShell,
     ksh(1), and COMMAND.COM.

BUGS
     Nroff and  troff  mavens  will  have  many  complaints.   Some  may  even
     represent bugs and not deliberate omissions.

     Watch out for scaling factors - especially on commands like \w.





Purdue University                       February, 1991                       3




CAWF(1)                    Unix Programmer's Manual                    CAWF(1)


     The overprinting required to create bold  and  italicized  characters  is
     tiresome  on  a  slow  printer.   Use bsfilt(1) from this distribution to
     remove all the backspacing from cawf's output.

     Cawf has a small amount of  built-in  code  for  the  man  and  ms  macro
     packages, but none for any others.

     The stacking for the .so command is limited.


















































Purdue University                       February, 1991                       4


