# include <curses.h>

# include "INCLUDE/castle.h"
# include "INCLUDE/items.h"
# include "INCLUDE/windows.h"
/*

	This is a public domain program, I have no objection to modifications
made on it or use for some other reason so long as this notice remains intact.

	
		Part of:  castle 	Ted Wisniewski
		Author:			Plymouth State College
					Plymouth NH,
						    03264
		Copyright() PSC

		Ported to Coherent by Udo Munk		Oberstr. 21
							4040 Neuss 1
							Germany
		mwcbbs!umunk!udo
*/

static char store[12][27] = {

	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,92,92,92,47,124,32,62,45,45,45,45,45,
	45,45,45,45,60,32,124,92,47,47,47,35,35},
	{35,35,92,92,47,61,124,32,124,84,104,101,32,83,
	116,111,114,101,124,32,124,61,92,47,47,35,35},
	{35,35,92,47,61,61,124,32,62,45,45,45,45,45,
	45,45,45,45,60,32,124,61,61,92,47,35,35},
	{35,35,47,95,95,95,124,32,32,32,32,37,37,37,
	37,37,32,32,32,32,124,95,95,95,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,41,124,79,32,
	79,124,40,32,32,32,32,32,32,32,32,35,35},
	{35,35,94,94,94,94,94,94,32,32,32,33,32,34,
	32,33,32,32,32,94,94,94,94,94,94,35,35},
	{35,35,124,124,124,124,124,124,32,32,32,92,32,61,
	32,47,32,32,32,124,124,124,124,124,124,35,35},
	{35,35,124,124,124,124,124,124,32,47,45,45,40,61,
	41,45,45,92,32,124,124,124,124,124,124,35,35},
	{35,35,124,124,124,124,124,124,32,124,124,32,47,42,
	92,32,124,124,32,124,124,124,124,124,124,35,35},
	{35,35,124,124,124,124,124,124,32,124,124,32,92,42,
	47,32,124,124,32,124,124,124,124,124,124,35,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       };
the_store()
{
	prt_store();
	print_mess("Enter the store (y/n)?");
	wrefresh(message_win);
	if(getch() == 'y')
	  buy_it();	
	else{
	  showit = TRUE;
	  wclear(message_win);
	  wrefresh(message_win);
	}
}

prt_store()
{
	int x,y;
	
	wmove(view_win,0,0);
	for(y=0;y<=11;y++)
	  for(x=0;x<=26;x++)
	     wprintw(view_win,"%c",store[y][x]);
        wrefresh(view_win);
}

buy_it()
{
    int on_sale = (rand()%NUM_ITEMS);
    char choice;
    int value,price = 100;

    price = (armor[on_sale].armor_val + armor[on_sale].dam_val) * 100;
    if(armor[on_sale].item_type == 1)
       price = price * 3;
    while(choice != 'L'){
	print_mess("Restore A Stat to full? 'L' to leave ",0,0);
	print_mess("S)tr D)ex C)on W)is I)nt ",1,0);
	print_mess("1)hitpoints 2)spellpoints",2,0);
	sprintf(wrk_buf,"3)Sale item %s for %d gold.",armor[on_sale].item,price);
	print_mess(wrk_buf,3,0);
	wmove(message_win,3,(strlen(wrk_buf)+1));
	wrefresh(message_win);
	wmove(message_win,3,0);
	choice = wgetch(message_win);
	wclear(message_win);
	switch(choice){
	  case 'S' : if(char_stats.strength < char_stats.m_str){
		       value = (char_stats.m_str - char_stats.strength)*100;
			if(value > char_stats.gold)
			  print_mess("Not Enough Gold, Sorry.",0,0);
			else{
			  sprintf(wrk_buf,"It will cost %d gold.",value);
			  print_mess(wrk_buf,0,0);
			  char_stats.strength = char_stats.m_str;
			  char_stats.gold -= value;
			  print_stats();
			}
		      }
		break;
	  case 'D' :
	             if(char_stats.dexterity < char_stats.m_dex){
		       value = (char_stats.m_dex - char_stats.dexterity)*100;
			if(value > char_stats.gold)
			  print_mess("Not Enough Gold, Sorry.",0,0);
			else{
			  sprintf(wrk_buf,"It will cost %d gold.",value);
			  print_mess(wrk_buf,0,0);
			  char_stats.dexterity = char_stats.m_dex;
			  char_stats.gold -= value;
			  print_stats();
			}
		      }
		break;
	  case 'C' :
	  case 'W' :
	  case 'I' :
		     break;
	  case '1' :if(char_stats.hitpoints < char_stats.max_hp){
		      value = (char_stats.max_hp - char_stats.hitpoints) * 10;
			if(value > char_stats.gold)
			   print_mess("Not enough gold.",0,0);
			else{
		           sprintf(wrk_buf,"It will cost %d gold.",value);
			   print_mess(wrk_buf,0,0);
			   char_stats.hitpoints = char_stats.max_hp;
		           char_stats.gold -= value;
			   print_stats();
			  }
			}
	    	      break;
	  case '2' :if(char_stats.spellpoints < char_stats.max_spt){
		     value = (char_stats.max_spt - char_stats.spellpoints) * 20;
			if(value > char_stats.gold)
			   print_mess("Not enough gold.",0,0);
			else{
		           sprintf(wrk_buf,"It will cost %d gold.",value);
		           print_mess(wrk_buf,0,0);
		           char_stats.spellpoints = char_stats.max_spt;
		           char_stats.gold -= value;
			   print_stats();
	    	         }
		     }
		   break;
	  case '3' : if(char_stats.gold >= price){
			add_item(on_sale);
			char_stats.gold -= price;
			print_stats();
		     }else
			print_mess("Costs too much.",4,0);
		     break;
	}
     wrefresh(message_win);
     sleep(1);
     }
     switch(p->face){
	case EAST: p->face = WEST;
		   break;
	case WEST: p->face = EAST;
		   break;
	case NORTH: p->face = SOUTH;
		   break;
	case SOUTH: p->face = NORTH;
		   break;
     }
     showit = TRUE;
}

help_list()
{
	clear();
	mvaddstr(1,20,"Command Summary");
	mvaddstr(3,5,"(h,4) - turn left           (l,6) - turn right");
	mvaddstr(4,5,"(j,2) - back up             (k,8) - move forward");
	mvaddstr(5,5,"(.)   - Turn around         (c,C) - Cast spells");
	mvaddstr(6,5,"(r,R) - Rest                (i,I) - Goto Inventory");
	mvaddstr(7,5,"(d,D) - Disarm a trap       (<,>) - Go up/down stairs");
	mvaddstr(8,5,"(L)   - Lookup a spell      (S)   - Known spells");
	mvaddstr(9,5,"(N)   - Change Name         ");
	mvaddstr(11,17,"(?)  - This Help Summary.");
	mvaddstr(13,17,"(ctrl e)  - save game");
	mvaddstr(14,17,"(ctrl r)  - redraw screen");
	mvaddstr(16,17,"Press a key to continue.");
	refresh();
	getch();
	redraw();
}

get_str(row,col)
int row,col;
{
	int i = 0,j;
	char in;

	for(j=0;j<20;j++)
	   string[j] = '\0';
	wmove(message_win,row,col);
	wrefresh(message_win);
	do
	  {
	   in = string[i] = getch();
	   if(in == 0x08 || in == 0x7f){
	     if(i == 0)
	       continue;
	     i--;
	     wmove(message_win,row,col+i);
	     wprintw(message_win,"%c",' ');
	     wmove(message_win,row,col+i);
	     wrefresh(message_win);
	     string[i] = ' ';
	   }else{
	     wmove(message_win,row,col+i);
	     wprintw(message_win,"%c",string[i]);
	     wrefresh(message_win);
	     i++;
	   }
	}
	while(in != 0x0a && in != 0x0d);
}

ask_ques(q)
int q;
{
	switch(q){
	  case 1: 
	 	print_mess("What is anti life?",0,0);
		wrefresh(message_win);
		get_str(0,20);
		strcpy(wrk_buf,string);
		if(strcmp(wrk_buf,"death")){
		  levels[p->level-1][p->row][p->col] = DOWN;
	          print_mess("The Stairs are now visible.",2,0);
		  wrefresh(message_win);
		}else{
		  print_mess("Too bad.",2,0);
		  wrefresh(message_win);
		} 
		sleep(2);
		wclear(message_win);
		wrefresh(message_win);
		break;
	  case 2:
	 	print_mess("What holds the power?",0,0);
		wrefresh(message_win);
		get_str(0,23);
		strcpy(wrk_buf,string);
		if(strcmp(wrk_buf,"lance")){
		  levels[p->level-1][p->row][p->col] = DOWN;
	          print_mess("The Stairs are now visible.",2,0);
		  wrefresh(message_win);
		}else{
		  print_mess("Too bad.",2,0);
		  wrefresh(message_win);
		} 
		sleep(2);
		wclear(message_win);
		wrefresh(message_win);
		break;
	  case 3:
	 	print_mess("What is the key to survival?",0,0);
		wrefresh(message_win);
		get_str(0,30);
		strcpy(wrk_buf,string);
		if(strcmp(wrk_buf,"armor")){
		  levels[p->level-1][p->row][p->col] = DOWN;
	          print_mess("The Stairs are now visible.",2,0);
		  wrefresh(message_win);
		}else{
		  print_mess("Too bad.",2,0);
		  wrefresh(message_win);
		} 
		sleep(2);
		wclear(message_win);
		wrefresh(message_win);
		break;
	}
}
