# include <curses.h>
# include "INCLUDE/windows.h"
# include "INCLUDE/castle.h"
# include "INCLUDE/monst.h"
/*
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+                                                                             +
+  Routines in this Module:                                                   +
+                                                                             +
+    spells()        -  Determines the spell chosen and executes it.          +
+    compass()       -  Creates a magic compass for the player to tell        +
+                       which direction he faces.                             +
+    spell_counts()  -  Keeps a running total of the number of moves made     +
+                       since the spell was invoked, to determine when it     +
+                       should end.                                           +
+    detect_trap()   -  Notifies the player if a trap is ahead of him.        +
+                       Must be cast by the player.                           +
+    fing_fire()     -  Does damage to a monster that is opposing the player. +
+    shock_em()      -  Does shock damage to an opposing monster.             +
+    exp_spell()     -  Give spell descriptions to the player upon request.   +
+    print_mess()    -  Prints messages to the player via the message window. +
+                                                                             +
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	This is a public domain program, I have no objection to modifications
made on it or use for some other reason so long as this notice remains intact.

	
		Part of:  castle 	Ted Wisniewski
		Author:			Plymouth State College
					Plymouth NH,
						    03264
		Copyright() PSC

		Ported to Coherent by Udo Munk		Oberstr. 21
							4040 Neuss 1
							Germany
		mwcbbs!umunk!udo
*/

spells()
{
	unsigned char spell;

	wmove(message_win,0,0);
	print_mess("Cast which spell (a-k). ",0,0);	
	wrefresh(message_win);
	spell = getch();
	wclear(message_win);
	wrefresh(message_win);
	switch (spell) {
	case 'a'  : 		/* Spell choice "a" tell where you are.  */
		if(char_stats.spellpoints > 0){
			sprintf(wrk_buf,"Dungeon Coordinates are :");
			print_mess(wrk_buf,0,0);
			sprintf(wrk_buf,"row: %d ",p->row);
			print_mess(wrk_buf,1,0);
			sprintf(wrk_buf,"col: %d ",p->col);
			print_mess(wrk_buf,2,0);
			sprintf(wrk_buf,"level: %d ",p->level);
			print_mess(wrk_buf,3,0);
			sprintf(wrk_buf,"Hit any Key to Continue.");
			print_mess(wrk_buf,4,0);
			char_stats.spellpoints--;
			print_stats();
			print_mess("",4,25);
			wrefresh(message_win);
			wgetch(message_win);
		}
		else{
			clr_mess_win();
			wmove(message_win,0,0);
			waddstr(message_win,"Not Enough Spellpoints.    ");
		}
		break;

	case 'b': 		/* Turn on the compass.    */
		if(char_stats.spellpoints > 1){
			char_stats.spellpoints -= 2; 
			print_stats();
			clr_mess_win();
			ct_compass = 100;
			compass();
			p->compass_on = TRUE;
		}
		else{
			clr_mess_win();
			sprintf(wrk_buf,"Not Enough Spellpoints.");
			print_mess(wrk_buf,0,0);
			p->compass_on = FALSE;
		}
		break;
	case 'c': 		/* teleport player.        */
		if(!known[2])
		   print_mess("You do not know that spell.",0,0);
		else
		   if(char_stats.spellpoints > 2){
		     teleport();
		     char_stats.spellpoints -= 3; 
		     print_stats();
		   }else{
			clr_mess_win();
			print_mess("Not Enough Spellpoints.",0,0);	
		}
		break;
	case 'd': 		/*   Cure some minor damage.  */
		if(!known[3])
		  print_mess("You do not know that spell.",0,0);
		else
		  if(char_stats.spellpoints < 2 ){
			clr_mess_win();
			print_mess("Not Enough Spellpoints.",0,0);
		}
		else{
			clr_mess_win();
			char_stats.spellpoints -= 2;
			print_mess("You feel Better.",0,0);
			if(char_stats.hitpoints + 5 >= char_stats.max_hp){
				char_stats.hitpoints = char_stats.max_hp;
				print_stats();
			}
			else{
				char_stats.hitpoints += 5;
				print_stats();
			}
		}
		wrefresh(message_win);
		break;
	case 'e':		/* detect traps on  */
		if(!known[4])
		  print_mess("You do not know that spell.",0,0);
		else
	          if(char_stats.spellpoints < 2 ){
		   clr_mess_win();
		   print_mess("Not Enough Spellpoints.",0,0);
	        }else{
		   detect_trap();
		   char_stats.spellpoints -= 2;
		   print_stats();
		   ct_dtrap = 100;
		   detect = ON;
		}
	        break;
	case 'f':		/* hit monster with finger fire  */
		if(!known[5])
		  print_mess("You do not know that spell.",0,0);
		else
	 	  if(char_stats.spellpoints < 3){
		  clr_mess_win();
		  print_mess("Not Enough Spellpoints.",0,0);
	        }else{
		  if(mon_faced)
		    fing_fire();
		  else
		    print_mess("Oops No Monster",0,0);
		  char_stats.spellpoints -= 2;
		  }
		  print_stats();
		break;
	case 'g': if(!known[6])
		    print_mess("You Do not Know that Spell.",0,0);
		  else
		    shock_em();	         /* Give the monster a shock    */
		 break;
	case 'h': 
		   if(char_stats.spellpoints >= 4 && known[7])
		    med_heal();
		   else{
		    if(!known[8])
		      print_mess("You Do not Know that Spell.",0,0);
		    else
		      print_mess("Not Enough Spellpoints.",0,0);
		  }
		break;
	case 'i': 
		   if(char_stats.spellpoints >= 6 && known[10]){
		   switch(p->face){
		     case 0: if(p->row != 1)
   			       p->row--;	
		     break;
		     case 1: if(p->col != 72)
			       p->col++;
		     break;
		     case 2: if(p->row != 22)
			       p->row++;
		     break;
		     case 3: if(p->col != 1)
			       p->col--;
		     break;
		   }
		   char_stats.spellpoints -= 6;
		   print_stats();
		   showit = TRUE;
		   }else{
		      if(!known[1])
		       print_mess("You do not know this spell.",0,0);
		      else
		       print_mess("Not Enough spellpoints.",0,0);
		      wrefresh(message_win);
		   }
		break;
	case 'j': 
		   if(char_stats.spellpoints >= 8 && known[14]){
		     if(rand()%100 < (70 + char_stats.level)){
			char_stats.spellpoints -= 8;
			flame();
			print_stats();
		     }else{
			print_mess("The Spell Failed.",0,0);
			wrefresh(message_win);
			char_stats.spellpoints -= 4;
			print_stats();
		     }
		}
	        break;
	case 'k':
		if(char_stats.spellpoints >= 11 && known[16]){
	          if(rand()%100 < (70 + char_stats.strength)){
		    char_stats.spellpoints -= 11;
		    char_stats.hitpoints = char_stats.max_hp;
		    print_mess("YOU FEEL GREAT!!",0,0);
		    wrefresh(message_win);
		    char_stats.spellpoints -= 11;
		    print_stats();
		  }else{
		    print_mess("Your spell did not work.",0,0);
		    wrefresh(message_win);
		    char_stats.spellpoints -= 6;
		    print_stats();
		  }
		}
	break;
		 
	default:
		clr_mess_win();
		sprintf(wrk_buf,"Selection not found.");
		print_mess(wrk_buf,0,0);
	}
	wrefresh(message_win);
	sleep(1);
	clr_mess_win();
}

compass()
{
	wmove(compass_win,0,0);
	wprintw(compass_win,"#########");
	wmove(compass_win,1,0);
	wprintw(compass_win,"#   N   #");
	wmove(compass_win,2,0);
	wprintw(compass_win,"#       #");
	wmove(compass_win,3,0);
	wprintw(compass_win,"#       #");
	wmove(compass_win,4,0);
	wprintw(compass_win,"#W  +  E#");
	wmove(compass_win,5,0);
	wprintw(compass_win,"#       #");
	wmove(compass_win,6,0);
	wprintw(compass_win,"#       #");
	wmove(compass_win,7,0);
	wprintw(compass_win,"#   S   #");
	wmove(compass_win,8,0);
	wprintw(compass_win,"#########");

	switch (p->face) {
	case NORTH: 
		wmove(compass_win,2,4);
		waddch(compass_win,'^');
		wmove(compass_win,3,4);
		waddch(compass_win,'|');
		break;
	case EAST: 
		wmove(compass_win,4,5);
		waddch(compass_win,'-');
		wmove(compass_win,4,6);
		waddch(compass_win,'>');
		break;
	case SOUTH: 
		wmove(compass_win,5,4);
		waddch(compass_win,'|');
		wmove(compass_win,6,4);
		waddch(compass_win,'v');
		break;
	case WEST: 
		wmove(compass_win,4,3);
		waddch(compass_win,'-');
		wmove(compass_win,4,2);
		waddch(compass_win,'<');
		break;
	}
	wrefresh(compass_win);
}

med_heal()
{
	if((char_stats.hitpoints += ((rand()%5)+1)+11) >= char_stats.max_hp)
	   char_stats.hitpoints = char_stats.max_hp;
	print_stats();
	print_mess("You feel Much better.",0,0);
}

teleport()
{
	int row,col;
	clr_mess_win();
	sprintf(wrk_buf,"Teleport to: ");
	print_mess(wrk_buf,0,0);
	sprintf(wrk_buf,"row : ");
	print_mess(wrk_buf,1,0);
	wrefresh(message_win);
	row = getint(1,7);
	sprintf(wrk_buf,"col : ");
	print_mess(wrk_buf,2,0);
	wrefresh(message_win);
	col = getint(2,7);
	wrefresh(message_win);
	if((row < 1) || (col < 1) || (row > 22) || (col > 72)){
	  print_mess("Cannot teleport here.",4,0);
	  wrefresh(message_win);
	}else
	if(levels[p->level-1][row][col] == WALL){
	  clr_mess_win();
	  wrefresh(message_win);
  	  print_mess("Spell failed.",0,0);
	}else{
	  p->row = row;
	  p->col = col;
	  showit = TRUE;
	  run_away = TRUE;
	}
}

flame()
{
	if(mon_faced){
	  damag = 15 + make_dam(5,4);
	  m_temp.m_hp -= damag;
	  sprintf(wrk_buf,"You Toasted him for %d points",damag);
	  print_mess(wrk_buf,2,0);
	  print_mess("of damage.",3,0);
	  wrefresh(message_win);
	}else{
	  print_mess("Oops, You are not facing a monster.");
	  wrefresh(message_win);
	}
}

spell_counts()
{
	if(ct_compass == 1){
	  wclear(compass_win);
	  wrefresh(compass_win);
	  ct_compass = 0;
	  p->compass_on = FALSE;
 	}
	else
	    ct_compass--;

	if(ct_dtrap == 1){
	  ct_dtrap = 0;
	  detect = OFF;
 	}
	else
	    ct_dtrap--;
}

detect_trap()
{
	int row,col;

	row = p->row;
	col = p->col;
	switch (p->face){
	   case NORTH:
		     row--;
	   break;
	   case EAST :
		     col++;
	   break;
	   case SOUTH:
		     row++;
	   break;
	   case WEST :
		     col--;
	   break;
	}
	if(levels[p->level-1][row][col] == TRAP){
	  print_mess("Trap Ahead, Beware.",0,0);
	  beep();
	}
	if(levels[p->level-1][row][col] == T_DOOR){
	  print_mess("Trap Door Ahead, Beware.",0,0);
	  beep();
	}
	if(levels[p->level-1][row][col] == SPIN)
	  print_mess("Spinner Ahead.",0,0);
	if(levels[p->level-1][row][col] == H_DRAIN)
	  print_mess("Something Ahead.",0,0);
	
	wrefresh(message_win);
}

fing_fire()
{
	int damag;

	m_temp.m_hp -= damag = (1 * char_stats.level); 
	wclear(message_win);
	wrefresh(message_win);
	sprintf(wrk_buf,"He is Fried for %d points.",damag);
	print_mess(wrk_buf,0,0);
	wrefresh(message_win);
	sleep(1);
}

shock_em()
{
	if(char_stats.spellpoints < 5 && mon_faced){
	  wclear(message_win);
	  print_mess("Not Enough Spellpoints.",0,0);
	}else{
	  if(rand()%100 < (75 + char_stats.intelligence)){
	    damag = ((rand()%5)+1)+((rand()%5)+1)+((rand()%5)+1)+((rand()%5)+1);
	    m_temp.m_hp -= damag;
	    char_stats.spellpoints -= 5;
	    print_stats();
	    wclear(message_win);
	    wrefresh(message_win);
	    sprintf(wrk_buf,"He is Shocked for %d points.",damag);
	    print_mess(wrk_buf,0,0);
	    wrefresh(message_win);
	  }else{
	      print_mess("The Spell Fizzled.",0,0);
	      char_stats.spellpoints -= 3;
	      print_stats();
	  }
        }
        sleep(1);
}


exp_spell()
{
	wclear(message_win);
	print_mess("Lookup which spell? (a-k) ",1,0);
	wmove(message_win,1,27);
	wrefresh(message_win);
	switch(wgetch(message_win)){
	  case 'a': print_mess("Detect Location : display",2,0);
		    print_mess("current dungeon coordinates.",3,0);
		    print_mess("Cost is 1 point.",4,0);
	  break;
	  case 'b': print_mess("Compass : display a magical",2,0);
		    print_mess("compass, with limited duration.",3,0);
		    print_mess("Cost is 2 points.",4,0);
	  break;
	  case 'c': print_mess("Teleport self : Move yourself to",2,0);
		    print_mess("a new dungeon location.  Fails if",3,0);
		    print_mess("you try to teleport into a wall.",4,0);
		    print_mess("Cost is 3 points.",5,0);
	  break;
	  case 'd': print_mess("Cure Light Wounds : Heal for",2,0);
		    print_mess("Exactly 5 hipoints.",3,0);
		    print_mess("Cost is 3 points.",4,0);
	  break;
	  case 'e': print_mess("Detect :  Warns you if something",2,0);
		    print_mess("harmful or strange is near",3,0);
		    print_mess("Cost is 3 points.",4,0);
	  break;
	  case 'f': print_mess("Finger fire : Does 1 hitpoint",2,0);
		    print_mess("times the casters level in damage",3,0);
		    print_mess("to a creature if successful.",4,0);
		    print_mess("Cost is 2 points.",5,0);
	  break;
	  case 'g': print_mess("Shocker : Does 4-20 points of",2,0);
		    print_mess("damage to a creature if successful.",3,0);
		    print_mess("Cost is 5 points.",4,0);
	  break;
	  case 'h': print_mess("Cure Medium : Restore 10-15 hitpoints",2,0);
		    print_mess("of damage, cost is 4 points.",3,0);
	  break;
	  case 'i': print_mess("Tunnel: Move through a wall in the ",2,0);
		    print_mess("direction you are facing.",3,0);
		    print_mess("Cost is 6 points. 10th level spell.",4,0);
		    break;
	  case 'j': print_mess("Flame: Does 15-35 points of",2,0);
		    print_mess("flame damage to a creature if",3,0);
		    print_mess("successful.  Cost is 8 points.",4,0);
		    print_mess("14th level spell.",5,0);
	  break;
	  case 'k': print_mess("Restore: Heals you to max hitpoints.",2,0);
		    print_mess("Cost is 11 points. 16th level spell.",3,0);
	  break;
	  default: break;
	}
	print_mess("Hit a key to continue. ",6,0);
	wrefresh(message_win);
	wgetch(message_win);
	wclear(message_win);
	wrefresh(message_win);
}

print_mess(ary,y,x)
char *ary;
int y,x;
{
	wmove(message_win,y,x);
	wprintw(message_win,"%s",ary);
}
