#include <curses.h>
#include "INCLUDE/castle.h"
#include "INCLUDE/items.h"
#include "INCLUDE/monst.h"
/*

	This is a public domain program, I have no objection to modifications
made on it or use for some other reason so long as this notice remains intact.

	
		Part of:  castle 	Ted Wisniewski
		Author:			Plymouth State College
					Plymouth NH,
						    03264
		Copyright() PSC

		Ported to Coherent by Udo Munk		Oberstr. 21
							4040 Neuss 1
							Germany
		mwcbbs!umunk!udo
*/

WINDOW *view_win,*message_win,*stat_win;
WINDOW *compass_win,*inv_win,*command_win;
#ifdef DEBUG
WINDOW *debug_win;
#endif

stats char_stats;
pos_stats *p;
pos_stats posi;

struct user_stats user;

struct io out[20];
struct io in[20];
struct io tmp;

/*  counters for spell durations */

int ct_compass;
int ct_dtrap;

/*  True or False operations */
int showit;	
int detect;
int which_one;
int mon_faced;
int m_killed;
int run_away;

/*  other info */
int d_val;
int d_mod;

/*  Array information    */
char wrk_buf[1750];		/* working buffer */

char levels[6][24][76];
char string[20];
int known[20];
short lvl_att[36];
long exp[37] = {
	0L,0L,15L,35L,85L,115L,150L,195L,270L,380L,450L,500L,650L,850L,1100L,
	1400L,1800L,2300L,2900L,3600L,4400L,5400L,6800L,8400L,10200L,
	12500L,17500L,25000L,35000L,50000L,75000L,100000L,150000L,
	200000L,350000L,500000L,1000000L
};

char *clues[15] = {
	"Seek the Wizard in the Deepest Level.",
	"The Lance Holds Great Power.",
	"At The Store You can buy many things.",
	"Let your head clear if you feel strange.",
	"Beware, Traps may do unexpected things.",
	"Ninjas hold a grudge.",
	"There is a way to get away from The Wiz.",
	"You may find yourself in strange places.",
	"Priests Heal themselves.",
	"Seek out the many Fountains.",
	"Find great reward in hidden places.",
	"All is attainable.",
	"Level 31 is quite cool.",
	"Be sure to have full spellpoints.",
	"Teleportation is limited on level 6."
};

struct inv_list *firstnode, *oldnode, *newnode, *start, *temp;

inventory s_inven[15];

inventory armor[NUM_ITEMS] = {

	    /* Item       Type   A_val  D_val  D_mod  Item_no  Spec  used */
	    /* ---------------------------------------------------------- */
	    {"LEATHER",    1,      2,     0,     0,     0,       0,    0  },
	    {"CAP",        2,      1,     0,     0,     1,       0,    0  },
	    {"GLOVES",     3,      1,     0,     0,     2,       0,    0  },
	    {"DAGGER",     6,      0,     4,     1,     3,       0,    0  },
 	    {"SCALE",      1,      3,     0,     0,     4,       0,    0  },
	    {"HELM",       2,      2,     0,     0,     5,       0,    0  },
	    {"Shield",     5,      1,     0,     0,     6,       0,    0  },
	    {"GAUNTLETS",  3,      2,     0,     0,     7,       0,    0  },
	    {"SMALL Sword",6,      0,     4,     2,     8,       0,    0  },
	    {"PLATE",      1,      5,     0,     0,     9,       0,    0  },
	    {"LONG Sword", 6,      0,     5,     2,     10,      0,    0  },
	    {"HALBERD",    6,      0,     6,     2,     11,      0,    0  },
	    {"AVENGER",    6,      0,     5,     4,     12,      0,    0  },
	    {"Death Lance",6,      0,     6,     6,     13,      0,    0  },
/*  Special Items  */
	    {"Compass",    9,      0,     0,     0,     14,      5,    0  },
	    {"Detector",   10,     0,     0,     0,     15,      4,    0  },
	    {"Health Ring",11,     0,     0,     0,     16,      3,    0  },
	    {"Flame Wand", 12,     0,     0,     0,     17,      2,    0  },
	    {"Tele Ring",  13,     0,     0,     0,     18,      3,    0  }
};

monster m[MAX_MON];

monster m_temp;
int damag;

char mon_scr[16][12][27] = {

	   /*#0  Wizard or Magician   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,44,45,32,32,32,32,
	96,32,32,32,32,46,32,32,32,32,39,32,35},
	{35,32,32,32,32,32,32,47,124,32,32,32,32,32,
	32,32,92,32,32,124,32,32,47,32,32,32,35},
	{35,32,32,32,32,47,42,40,124,32,32,32,32,32,
	32,96,32,46,92,124,47,46,32,39,32,32,35},
	{35,32,32,32,47,47,32,44,32,95,95,95,32,64,
	45,45,42,32,32,79,32,45,45,45,45,32,35},
	{35,32,32,32,39,40,40,45,45,45,45,64,124,32,
	32,46,32,39,47,124,92,96,32,46,32,32,35},
	{35,32,32,32,47,32,32,41,44,32,124,92,124,32,
	32,32,47,32,32,124,32,32,92,32,32,32,35},
	{35,32,32,47,32,32,32,32,40,92,124,32,32,46,
	32,32,32,32,32,46,32,32,32,32,32,46,35},
	{35,32,47,32,32,32,32,32,32,32,92,32,32,32,
	32,32,32,32,32,46,32,32,32,32,32,32,35},
	{35,47,32,32,32,32,32,32,32,32,32,124,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,92,47,92,47,92,47,92,47,92,47,47,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	  /*  #1  Spider    */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,47,45,92,32,32,32,47,45,124,32,
	124,45,92,32,32,47,47,45,92,32,32,32,35},
	{35,32,92,47,32,32,32,92,32,47,32,32,124,32,
	124,32,32,92,47,47,32,32,32,92,32,32,35},
	{35,32,47,32,92,32,32,32,47,32,32,32,124,32,
	124,32,32,47,92,32,32,32,32,32,92,32,35},
	{35,47,32,32,32,32,92,47,32,92,32,32,124,32,
	124,32,47,47,32,92,32,32,32,32,32,92,35},
	{35,32,32,32,32,32,47,32,92,32,92,32,124,95,
	124,47,47,32,32,32,92,32,32,32,32,32,35},
	{35,95,95,95,95,47,95,95,95,95,92,92,40,94,
	41,47,95,95,95,95,95,92,95,95,95,95,35},
	{35,32,32,32,47,32,32,32,32,32,32,47,32,123,
	125,32,32,32,32,32,32,32,92,32,32,32,35},
	{35,32,32,47,32,32,32,32,32,32,124,32,32,32,
	32,124,32,32,32,32,32,32,32,92,32,32,35},
	{35,95,47,32,32,32,32,32,32,32,32,92,95,95,
	47,32,32,32,32,32,32,32,32,32,92,95,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	     /*#2  Dragon fly or Serpent */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,92,92,92,92,32,32,32,32,32,32,92,32,32,
	124,32,32,32,47,32,32,32,32,32,47,47,35},
	{35,92,45,45,45,92,32,32,32,32,32,32,92,92,
	124,47,94,47,32,32,32,32,32,47,32,45,35},
	{35,45,45,45,32,32,32,92,32,32,45,45,45,42,
	124,32,42,32,45,45,45,32,47,32,32,32,35},
	{35,92,45,45,45,32,32,32,92,32,32,32,47,32,
	94,32,32,32,92,32,32,47,32,32,32,45,35},
	{35,92,92,45,45,45,32,32,92,32,32,40,79,32,
	32,79,41,124,32,47,32,32,45,45,45,47,35},
	{35,32,32,92,92,92,45,45,45,32,92,32,47,96,
	45,45,94,47,32,32,32,45,45,47,47,47,35},
	{35,32,32,32,32,92,92,92,45,45,47,32,32,32,
	32,47,45,45,32,45,47,47,47,47,32,32,35},
	{35,92,124,124,32,32,32,92,92,124,32,32,32,47,
	45,47,47,47,47,32,32,32,32,32,32,32,35},
	{35,92,32,124,32,32,32,32,32,124,32,32,32,124,
	95,95,95,32,32,32,32,32,32,32,32,32,35},
	{35,95,92,124,95,32,32,32,32,47,92,32,32,32,
	92,32,32,92,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	    /* #3 Group of civilians or people  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,64,64,
	32,96,59,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,60,95,
	32,32,32,92,32,32,32,32,32,32,32,32,35},
	{35,126,126,44,32,32,32,32,32,32,32,32,32,32,
	32,47,32,32,92,32,32,32,32,32,32,32,35},
	{35,32,64,64,32,32,32,32,32,32,32,32,32,32,
	47,32,32,32,32,92,32,32,32,32,44,126,35},
	{35,32,95,62,32,32,32,32,44,126,126,59,32,32,
	32,32,32,32,32,32,32,32,32,32,64,64,35},
	{35,92,32,32,32,32,32,32,64,64,32,96,59,32,
	32,59,126,126,44,32,32,32,32,32,60,95,35},
	{35,32,92,59,126,126,44,32,60,95,32,32,92,32,
	59,39,32,64,64,32,32,44,126,126,59,32,35},
	{35,32,59,39,32,64,64,32,32,32,47,32,32,32,
	47,32,32,95,62,32,32,64,64,32,96,59,35},
	{35,32,47,32,32,95,62,32,32,47,32,32,32,47,
	32,32,92,32,32,32,32,60,95,32,32,92,35},
	{35,47,32,32,92,32,32,32,32,32,32,32,47,32,
	32,32,32,92,32,32,32,32,32,47,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	   /*#4 warrior      */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,124,32,32,32,
	32,32,124,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,124,92,95,33,
	95,47,124,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,92,47,95,32,
	95,92,47,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,47,92,32,95,
	32,47,92,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,44,42,32,42,32,42,46,92,95,
	47,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,42,39,32,32,32,32,32,32,32,96,42,
	32,92,95,95,95,32,32,32,32,32,32,32,35},
	{35,32,42,32,32,32,32,32,118,32,32,32,32,32,
	42,32,32,32,32,92,32,32,32,32,32,32,35},
	{35,32,42,32,32,32,32,62,42,60,32,32,32,32,
	42,37,32,33,32,124,32,32,32,32,32,32,35},
	{35,32,32,42,32,32,32,32,94,32,32,32,32,42,
	32,32,32,124,32,124,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	    /* #5  priest		*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,45,124,45,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,47,32,92,
	32,32,32,32,32,32,32,46,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,47,45,124,45,
	92,32,32,96,32,32,32,32,32,32,32,39,35},
	{35,32,32,32,32,32,32,32,32,40,95,95,118,95,
	95,41,32,32,32,92,32,124,32,47,32,32,35},
	{35,32,32,32,32,32,32,32,32,123,32,64,32,64,
	41,32,32,42,32,45,40,43,41,45,32,42,35},
	{35,32,32,32,32,32,32,32,33,47,32,32,45,32,
	92,32,32,32,32,47,32,124,32,92,32,32,35},
	{35,32,32,32,32,32,32,40,42,41,32,32,32,32,
	32,92,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,124,47,47,32,32,32,
	32,124,32,39,32,32,32,46,32,32,32,96,35},
	{35,32,32,32,32,32,32,47,45,32,32,32,32,118,
	92,47,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,47,32,32,32,32,32,32,32,
	124,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

		/*#6  Headhunter or Cannibal  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,92,92,92,124,124,
	124,47,47,47,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,46,32,32,61,61,61,61,
	61,61,61,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,47,94,92,124,32,79,32,124,
	32,79,32,124,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,92,32,47,32,92,32,95,95,
	95,32,47,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,35,32,32,32,95,124,32,
	124,95,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,40,35,41,32,40,32,32,32,
	32,32,41,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,35,92,47,47,124,42,32,
	42,124,92,92,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,35,92,47,40,32,32,42,
	32,32,41,47,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,35,32,32,32,61,61,61,
	61,61,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,35,32,32,32,40,32,94,
	32,41,32,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },
		/*  #7  Sphinx or Demon  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,41,32,32,32,40,32,32,
	32,32,32,32,32,32,32,96,32,32,96,40,35},
	{35,32,32,32,32,32,32,124,92,124,47,124,32,32,
	32,32,32,32,32,32,32,32,96,32,41,96,35},
	{35,32,32,32,32,32,123,96,64,32,64,39,125,32,
	32,32,32,32,32,32,32,96,32,41,95,96,35},
	{35,32,95,95,32,32,32,40,47,94,92,41,32,32,
	32,32,32,32,32,32,32,32,32,32,92,95,35},
	{35,40,40,40,92,32,32,124,96,45,39,124,32,32,
	32,32,32,32,32,32,32,32,32,32,32,64,35},
	{35,32,32,92,32,92,47,56,45,56,45,56,92,32,
	32,32,95,95,32,32,32,32,32,32,32,96,35},
	{35,32,32,32,92,124,32,96,96,44,39,39,44,32,
	92,47,32,32,92,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,124,124,32,32,32,32,32,124,47,
	92,32,92,32,32,92,32,32,32,32,32,32,35},
	{35,32,32,32,32,124,124,92,32,44,32,47,45,45,
	45,45,41,41,41,92,92,45,45,45,45,45,35},
	{35,32,32,32,40,40,40,124,95,95,95,95,124,32,
	32,32,32,32,32,32,41,41,41,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	   /*  #8   Cloud Beast	*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,44,44,32,44,32,32,32,32,35},
	{35,32,32,32,32,32,44,44,96,44,44,32,44,96,
	44,32,44,96,32,39,96,44,32,32,32,32,35},
	{35,32,32,32,44,96,32,64,64,32,32,96,64,64,
	32,96,39,64,64,32,39,44,96,32,32,32,35},
	{35,32,44,96,39,111,111,96,39,46,32,32,96,39,
	32,46,32,96,39,32,39,44,96,32,32,32,35},
	{35,96,96,39,32,96,39,32,32,32,32,39,46,32,
	32,64,64,32,39,39,44,96,32,32,32,32,35},
	{35,32,64,64,46,32,46,32,64,64,32,32,32,32,
	46,96,39,39,44,96,96,32,32,32,32,32,35},
	{35,32,96,39,32,64,64,32,96,39,32,39,64,64,
	32,44,44,96,32,32,32,32,32,32,32,32,35},
	{35,32,46,32,32,96,39,39,46,39,32,44,96,39,
	96,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,64,64,32,39,32,46,44,44,44,96,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,96,96,96,96,96,96,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	   /* #9  Devilish Character  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,96,32,32,32,32,40,32,32,32,41,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,123,32,32,32,32,40,32,96,32,47,32,
	41,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,123,125,32,32,32,44,40,64,32,64,41,
	96,44,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,40,40,41,41,32,32,96,123,123,45,125,125,
	96,125,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,92,92,32,32,40,45,123,123,123,125,
	45,41,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,92,92,47,47,32,123,123,125,32,
	32,92,92,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,92,92,47,32,32,123,41,32,
	32,92,47,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,92,92,32,32,125,32,32,
	32,32,124,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,124,92,92,32,32,32,32,
	32,32,124,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	   /*  # 10  Robot	*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,40,92,47,41,32,32,32,32,32,32,118,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,40,41,32,32,32,40,32,32,40,32,41,32,
	32,41,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,40,41,32,32,124,92,40,32,32,32,41,
	47,124,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,40,41,32,96,40,32,42,32,42,32,
	41,39,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,40,41,32,62,32,32,118,32,32,
	60,32,32,32,32,32,32,47,92,32,32,32,35},
	{35,32,32,32,32,32,40,40,32,32,40,45,41,32,
	32,41,41,41,41,41,41,32,32,41,32,32,35},
	{35,32,32,32,32,32,32,40,95,32,32,32,32,32,
	95,41,32,32,32,32,32,92,47,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,40,32,94,32,41,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,40,95,124,95,41,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	   /*  #11    Griffon	*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,41,41,32,32,32,32,32,32,92,92,32,32,32,
	32,32,32,94,92,41,41,47,94,32,32,32,35},
	{35,41,41,41,41,32,32,32,32,92,92,92,92,32,
	32,40,47,32,32,68,32,95,68,32,32,32,35},
	{35,41,41,41,41,32,32,95,95,92,92,92,32,92,
	40,47,32,32,32,32,41,41,41,41,32,32,35},
	{35,41,124,41,39,46,39,32,44,32,92,92,92,32,
	92,32,32,32,32,92,41,45,39,41,32,32,35},
	{35,32,41,92,39,32,32,32,32,96,32,32,32,92,
	32,39,32,32,32,124,92,95,32,32,32,32,35},
	{35,32,32,32,124,95,95,95,95,41,41,41,32,32,
	32,124,95,95,95,95,95,95,41,41,41,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	   /*  #12   Druid		*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,47,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,47,124,
	32,32,32,32,32,32,39,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,47,32,124,
	46,32,96,32,46,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,47,40,42,124,
	32,92,124,47,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,61,61,61,61,61,61,
	45,45,64,45,45,32,45,32,32,45,32,32,35},
	{35,32,32,32,32,32,32,32,123,64,34,64,96,125,
	32,47,124,92,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,44,39,45,96,41,96,
	39,32,36,32,96,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,47,40,32,96,32,39,
	92,32,36,32,32,32,96,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,47,32,32,41,41,32,32,
	32,92,36,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,124,32,124,32,32,32,32,32,
	32,40,36,41,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	    /* #13     Wizard #2   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,47,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,47,124,
	32,32,32,32,32,32,39,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,47,32,124,
	46,32,96,32,46,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,47,40,42,124,
	32,92,124,47,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,61,61,61,61,61,61,
	45,45,64,45,45,32,45,32,32,45,32,32,35},
	{35,32,32,32,32,32,32,32,123,64,34,64,96,125,
	32,47,124,92,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,44,39,45,96,41,96,
	39,32,36,32,96,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,47,40,32,96,32,39,
	92,32,36,32,32,32,96,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,47,32,32,41,41,32,32,
	32,92,36,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,124,32,124,32,32,32,32,32,
	32,40,36,41,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },

	   /*  # 14    Fighter  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,92,
	47,94,92,47,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,33,124,
	95,118,95,124,33,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,124,
	111,32,111,124,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,40,
	39,95,96,41,32,32,32,32,32,32,32,32,35},
	{35,32,32,92,124,47,32,32,32,32,32,95,95,95,
	47,32,92,95,95,95,32,32,32,32,32,32,35},
	{35,45,45,45,42,45,45,123,40,92,32,124,32,32,
	95,32,95,32,32,124,32,32,32,32,32,32,35},
	{35,32,32,47,124,92,32,32,32,92,92,124,124,92,
	86,32,86,47,124,124,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,92,95,124,32,
	124,32,124,32,124,124,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,47,61,45,45,45,45,45,
	124,32,124,32,92,47,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,47,32,32,95,95,95,95,46,
	44,32,32,92,32,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       },
		/* #15     Dragon	   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,32,32,32,32,32,32,44,124,
	32,32,32,32,32,32,32,32,32,32,32,32,35},
	{35,32,32,32,92,92,32,32,32,32,32,32,124,32,
	92,32,32,32,32,32,47,32,32,32,32,32,35},
	{35,32,32,32,92,32,92,32,32,32,46,32,32,92,
	32,46,92,32,32,47,47,32,32,32,32,32,35},
	{35,32,32,32,92,32,32,32,92,40,64,96,34,39,
	39,64,41,47,32,32,47,32,32,32,32,32,35},
	{35,32,32,32,32,92,32,32,44,96,46,32,96,45,
	45,39,47,32,32,47,32,32,32,32,32,32,35},
	{35,32,32,32,32,32,92,39,32,32,96,44,40,41,
	40,41,32,47,32,124,32,32,32,32,32,32,35},
	{35,32,32,32,44,39,32,32,32,32,32,32,34,32,
	34,92,47,32,32,124,32,32,32,32,32,32,35},
	{35,32,32,32,124,32,32,32,32,32,32,32,32,32,
	32,32,124,32,47,32,32,32,32,32,32,32,35},
	{35,32,32,40,40,40,32,95,95,95,95,95,95,95,
	95,47,41,41,41,32,32,32,32,32,32,32,35},
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35}
       }
};

char screens[34][12][27] = {

	/*#0 Wall 		*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,45,32,32,32,32,32,32,32,32,32,95,
	95,95,95,32,32,32,32,95,95,95,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,95,32,32,32,
	124,32,32,32,32,32,32,32,124,32,32,35,35},
	{35,35,32,95,95,95,95,32,32,32,32,32,32,32,
	32,32,32,32,32,45,32,32,32,32,32,35,35},
	{35,35,32,32,124,32,32,32,32,32,32,95,95,95,
	32,32,95,32,32,32,32,32,32,95,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,124,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,45,32,32,32,32,32,32,
	32,32,32,32,95,95,95,95,95,95,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	95,32,32,32,32,124,32,32,32,32,32,35,35},
	{35,35,32,32,32,95,95,95,95,95,95,95,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,45,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

/*#1	View down Hall	*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,32,124,32,32,124,32,32,32,32,32,
	32,32,32,32,124,32,32,124,32,32,32,35,35},
	{35,35,124,47,32,32,47,32,124,32,32,32,32,32,
	32,32,32,32,124,32,92,32,32,92,124,35,35},
	{35,35,32,32,32,124,32,32,124,32,32,32,32,32,
	32,32,32,32,124,32,124,32,124,32,32,35,35},
	{35,35,124,47,32,32,47,32,124,95,95,95,95,95,
	95,95,95,95,124,32,92,32,32,92,124,35,35},
	{35,35,32,32,32,124,32,47,32,32,32,32,32,32,
	32,32,32,32,32,92,32,32,124,32,32,35,35},
	{35,35,124,32,47,32,47,32,32,32,32,32,32,32,
	32,32,32,32,32,32,92,32,92,32,124,35,35},
	{35,35,32,124,32,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,32,32,35,35},
	{35,35,47,32,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,124,92,35,35},
	{35,35,124,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },


/*     #2  Another passage screen   		*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,32,124,32,32,124,32,32,32,32,32,
	32,32,32,32,124,32,32,124,32,32,32,35,35},
	{35,35,32,47,32,32,47,32,124,32,32,32,32,32,
	32,32,32,32,124,32,92,32,32,92,124,35,35},
	{35,35,124,32,124,32,32,32,124,32,32,32,32,32,
	32,32,32,32,124,32,32,32,124,32,32,35,35},
	{35,35,32,47,32,32,47,32,124,95,95,95,95,95,
	95,95,95,95,124,32,92,32,32,92,32,35,35},
	{35,35,32,32,32,124,32,47,32,32,32,32,32,32,
	32,32,32,32,32,92,124,32,124,32,32,35,35},
	{35,35,124,32,47,32,47,32,32,32,32,32,32,32,
	32,32,32,32,32,32,92,32,92,32,124,35,35},
	{35,35,32,124,32,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,92,32,35,35},
	{35,35,47,32,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,124,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/*#3 View of left corner 	*/
       {

	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,95,95,45,32,32,95,95,95,95,45,32,95,
	95,95,95,45,95,95,124,32,92,32,32,35,35},
	{35,35,124,32,32,32,32,32,124,32,32,45,32,124,
	32,32,32,32,32,124,124,32,124,32,32,35,35},
	{35,35,32,95,95,32,32,32,32,95,95,95,32,32,
	32,95,95,95,45,32,124,32,32,32,92,35,35},
	{35,35,32,124,32,32,32,32,45,32,124,32,32,32,
	45,32,124,32,32,32,124,32,124,32,124,35,35},
	{35,35,32,32,32,45,32,32,32,32,32,32,32,45,
	32,32,32,32,32,45,124,32,92,32,32,35,35},
	{35,35,95,95,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,124,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,32,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,32,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/*#3  View of corner to Right   	*/
       {

	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,47,32,124,95,95,95,95,45,32,95,
	95,95,95,45,95,95,95,95,32,45,95,35,35},
	{35,35,32,32,124,32,124,32,124,32,32,45,32,124,
	32,32,32,32,32,124,32,32,32,32,124,35,35},
	{35,35,47,32,32,32,124,32,32,95,95,95,32,32,
	32,95,95,95,45,32,95,95,95,95,95,35,35},
	{35,35,124,32,124,32,124,32,45,32,124,32,32,32,
	45,32,124,32,32,32,32,32,124,32,32,35,35},
	{35,35,32,32,47,32,124,32,32,32,32,32,32,45,
	32,32,32,32,32,45,32,32,32,45,32,35,35},
	{35,35,32,32,124,32,124,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,95,95,35,35},
	{35,35,47,32,32,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,32,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	/*#5  A "T" in the Passage	*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,124,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,95,95,95,124,32,35,35},
	{35,35,32,124,32,32,32,32,32,95,95,95,95,124,
	95,32,32,45,32,32,32,124,32,124,32,35,35},
	{35,35,47,124,45,32,32,32,32,32,32,124,32,32,
	32,32,32,32,32,32,32,45,32,124,32,35,35},
	{35,35,124,124,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,124,124,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	
       /*#5   Dead End	*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,47,32,124,32,95,95,95,95,32,32,
	45,32,32,124,32,32,124,32,32,92,32,35,35},
	{35,35,32,32,124,32,124,32,32,124,32,32,45,32,
	32,32,32,32,32,32,124,32,32,124,32,35,35},
	{35,35,47,32,32,32,124,32,32,32,32,32,32,32,
	95,95,95,95,32,32,124,32,32,92,32,35,35},
	{35,35,124,32,124,32,124,32,32,45,32,32,32,32,
	32,124,32,32,32,32,124,32,124,32,124,35,35},
	{35,35,32,32,47,32,124,95,95,32,32,32,32,32,
	32,32,32,32,32,45,124,32,92,32,32,35,35},
	{35,35,32,32,124,32,124,95,95,95,95,95,95,95,
	95,95,95,95,95,95,124,32,124,32,32,35,35},
	{35,35,47,32,32,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,32,92,35,35},
	{35,35,124,32,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,32,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	  /*#7  Blank Screen (No walls in sight)    */

       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/*  #8  Wall Left   */
       {

	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,39,47,32,32,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,32,32,39,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,47,32,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,47,124,39,47,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,47,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,39,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/* #9   Wall Right   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,32,32,92,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,92,32,124,96,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,124,92,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,32,32,32,96,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,92,32,32,92,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,92,32,124,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,96,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/*#10 Wall alone out in front    */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,32,32,124,32,95,95,95,95,32,32,
	45,32,32,124,32,32,124,32,32,32,32,35,35},
	{35,35,32,32,32,32,124,32,32,124,32,32,45,32,
	32,32,32,32,32,32,124,32,32,32,32,35,35},
	{35,35,32,32,32,32,124,32,32,32,32,32,32,32,
	95,95,95,95,32,32,124,32,32,32,32,35,35},
	{35,35,32,32,32,32,124,32,32,45,32,32,32,32,
	32,124,32,32,32,32,124,32,32,32,32,35,35},
	{35,35,32,32,32,32,124,95,95,32,32,32,32,32,
	32,32,32,32,32,45,124,32,32,32,32,35,35},
	{35,35,32,32,32,32,124,95,95,95,95,95,95,95,
	95,95,95,95,95,95,124,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },	
	
	/* #11 4-Way intersection		*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,45,124,32,124,39,124,32,32,32,32,
	32,32,32,124,92,124,32,32,95,124,32,35,35},
	{35,35,124,124,32,46,32,124,47,124,32,32,32,32,
	32,32,32,124,124,124,32,124,32,124,32,35,35},
	{35,35,32,124,124,45,32,124,124,124,32,32,32,32,
	32,32,32,124,32,124,32,95,32,124,92,35,35},
	{35,35,39,124,32,32,32,124,39,124,32,32,32,32,
	32,32,32,124,96,124,32,32,124,124,124,35,35},
	{35,35,32,124,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,92,124,95,95,95,124,32,35,35},
	{35,35,39,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/* #12   Going out into a big room, adj walls only  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,39,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,39,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/*   #13     2 Way room to right from a hall    */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,45,124,32,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,124,124,32,46,32,124,47,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,124,124,45,32,124,124,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,39,124,32,32,32,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,124,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,39,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	/*#14   *same as above not from hall */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,45,124,32,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,124,32,46,32,124,47,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,124,45,32,124,124,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,39,124,32,32,32,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,39,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/* #15  Solid wall ahead no gaps      */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,95,32,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,95,95,95,32,32,35,35},
	{35,35,32,124,32,32,32,32,32,95,95,95,95,124,
	95,32,32,45,32,32,32,124,32,32,95,35,35},
	{35,35,32,32,45,32,32,32,32,32,32,124,32,32,
	32,32,32,32,45,32,32,45,32,32,32,35,35},
	{35,35,95,95,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,95,95,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
        },

	/* #16  One wall left with partial to right */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,39,47,32,32,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,32,47,32,32,32,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,124,32,32,39,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,32,32,32,47,32,124,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,32,47,124,39,47,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,32,32,32,47,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,47,39,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,32,124,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/* #17  Right wall  partial of left  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,32,32,92,32,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,92,32,124,96,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,124,92,32,32,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,124,32,32,32,96,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,92,32,32,92,32,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,92,32,124,92,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,32,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,96,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/* #18   Corner to left in a hall     */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,45,32,32,95,95,95,95,45,32,95,
	95,95,95,45,95,95,124,32,92,32,32,35,35},
	{35,35,124,124,32,32,32,32,124,32,32,45,32,124,
	32,32,32,32,32,124,124,32,124,32,32,35,35},
	{35,35,32,124,95,32,32,32,32,95,95,95,32,32,
	32,95,95,95,45,32,124,32,32,32,92,35,35},
	{35,35,39,124,32,32,32,32,45,32,124,32,32,32,
	45,32,124,32,32,32,124,32,124,32,124,35,35},
	{35,35,32,124,32,45,32,32,32,32,32,32,32,45,
	32,32,32,32,32,45,124,32,92,32,32,35,35},
	{35,35,39,124,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,124,32,32,124,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,32,92,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,32,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	
	/*  #19   Turn in passage to Right  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,47,32,124,95,95,95,95,45,32,95,
	95,95,95,45,95,95,95,95,32,124,92,35,35},
	{35,35,32,32,124,32,124,32,124,32,32,45,32,124,
	32,32,32,32,32,124,32,32,32,124,124,35,35},
	{35,35,47,32,32,32,124,32,32,95,95,95,32,32,
	32,95,95,95,45,32,95,95,95,124,32,35,35},
	{35,35,124,32,124,32,124,32,45,32,124,32,32,32,
	45,32,124,32,32,32,32,32,124,124,96,35,35},
	{35,35,32,32,47,32,124,32,32,32,32,32,32,45,
	32,32,32,32,32,45,32,32,32,124,32,35,35},
	{35,35,32,32,124,32,124,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,124,96,35,35},
	{35,35,47,32,32,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,124,32,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,96,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/*#20        # 
		     ##
	
	            @#
        */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,124,92,124,32,32,95,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,124,124,124,32,124,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,124,32,124,32,95,32,124,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,124,96,124,32,32,124,124,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,92,124,95,95,95,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	
	/*   #21    		*/
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,45,124,32,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,124,32,46,32,124,47,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,124,45,32,124,124,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,39,124,32,32,32,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,39,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

        /*  #22   passage entry from ahead  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,45,124,32,124,39,124,32,32,32,32,
	32,32,32,124,92,124,32,32,95,32,124,35,35},
	{35,35,124,32,32,46,32,124,47,124,32,32,32,32,
	32,32,32,124,124,124,32,124,32,46,32,35,35},
	{35,35,32,46,124,45,32,124,124,124,32,32,32,32,
	32,32,32,124,32,124,32,95,32,32,124,35,35},
	{35,35,45,32,32,32,46,124,39,124,32,32,32,32,
	32,32,32,124,96,124,46,32,124,32,46,35,35},
	{35,35,95,95,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,92,124,95,95,95,95,95,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	
	/* #23  Left front wall only      */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,45,124,32,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,32,32,46,32,124,47,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,46,124,45,32,124,124,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,45,32,32,32,46,124,39,124,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,95,95,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

       {   /* #24     #####

		        ^##
			|
           */
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,45,32,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,95,95,95,124,32,35,35},
	{35,35,32,45,32,32,32,32,32,95,95,95,95,124,
	95,32,32,45,32,32,32,124,32,124,32,35,35},
	{35,35,124,32,45,32,32,32,32,32,32,124,32,32,
	32,32,32,32,32,32,32,45,32,124,32,35,35},
	{35,35,95,95,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,124,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	  /* # 25  solid wall forward partial on left  */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,124,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,95,95,95,32,32,35,35},
	{35,35,32,124,32,32,32,32,32,95,95,95,95,124,
	95,32,32,45,32,32,32,124,32,32,45,35,35},
	{35,35,47,124,45,32,32,32,32,32,32,124,32,32,
	32,32,32,32,32,32,32,45,32,124,32,35,35},
	{35,35,124,124,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,95,95,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/* # 26 goes with config 10010  */

       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,124,45,32,32,95,95,95,95,45,32,95,
	95,95,95,45,95,95,124,32,92,32,32,35,35},
	{35,35,32,124,32,32,32,32,124,32,32,45,32,124,
	32,32,32,32,32,124,124,32,124,32,32,35,35},
	{35,35,32,124,95,32,32,32,32,95,95,95,32,32,
	32,95,95,95,45,32,124,32,32,32,92,35,35},
	{35,35,32,124,32,32,32,32,45,32,124,32,32,32,
	45,32,124,32,32,32,124,32,124,32,124,35,35},
	{35,35,32,124,32,45,32,32,32,32,32,32,32,45,
	32,32,32,32,32,45,124,32,92,32,32,35,35},
	{35,35,32,124,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,124,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,92,32,32,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,92,32,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },
	
	  /* #27    screen for   10011    */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,47,32,124,95,95,95,95,45,32,95,
	95,95,95,45,95,95,95,95,32,124,32,35,35},
	{35,35,32,32,124,32,124,32,124,32,32,45,32,124,
	32,32,32,32,32,124,32,32,32,124,32,35,35},
	{35,35,47,32,32,32,124,32,32,95,95,95,32,32,
	32,95,95,95,45,32,95,95,95,124,32,35,35},
	{35,35,124,32,124,32,124,32,45,32,124,32,32,32,
	45,32,124,32,32,32,32,32,124,124,32,35,35},
	{35,35,32,32,47,32,124,32,32,32,32,32,32,45,
	32,32,32,32,32,45,32,32,32,124,32,35,35},
	{35,35,32,32,124,32,124,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,124,32,35,35},
	{35,35,47,32,32,47,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,32,47,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	/* # 28   config = 1101010    */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,124,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,124,32,32,124,32,35,35},
	{35,35,32,124,32,32,32,32,32,95,95,95,95,124,
	95,32,32,45,32,32,124,32,32,124,32,35,35},
	{35,35,47,124,45,32,32,32,32,32,32,124,32,32,
	32,32,32,32,32,32,124,32,32,124,32,35,35},
	{35,35,124,124,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,124,32,32,124,124,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	   /* #29    config = 1110010   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,124,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,95,95,95,124,32,35,35},
	{35,35,32,124,32,32,124,32,32,95,95,95,95,124,
	95,32,32,45,32,32,32,124,32,124,32,35,35},
	{35,35,47,124,32,32,124,32,32,32,32,124,32,32,
	32,32,32,32,32,32,32,45,32,124,32,35,35},
	{35,35,124,124,32,32,124,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,124,124,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	  /*  # 30  config == 1011000   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,47,124,45,124,32,124,39,124,32,32,32,32,
	32,32,32,124,92,124,32,32,95,32,32,35,35},
	{35,35,124,124,32,46,32,124,47,124,32,32,32,32,
	32,32,32,124,124,124,32,124,32,32,124,35,35},
	{35,35,32,124,124,45,32,124,124,124,32,32,32,32,
	32,32,32,124,32,124,32,95,32,45,32,35,35},
	{35,35,39,124,32,32,32,124,39,124,32,32,32,32,
	32,32,32,124,96,124,32,32,124,32,45,35,35},
	{35,35,32,124,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,92,124,95,95,95,95,95,35,35},
	{35,35,39,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	   /* #31   config == 110010   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,124,32,32,124,32,35,35},
	{35,35,32,45,32,32,32,32,32,95,95,95,95,124,
	95,32,32,45,32,32,124,32,32,124,32,35,35},
	{35,35,124,32,45,32,32,32,32,32,32,124,32,32,
	32,32,32,32,32,32,124,32,32,124,32,35,35},
	{35,35,95,95,95,95,95,95,95,95,95,95,95,95,
	95,95,95,95,95,95,124,32,32,124,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	   /*  #32   config == 101010   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,124,32,32,124,32,45,32,32,32,32,32,
	32,45,124,32,32,95,95,95,95,32,32,35,35},
	{35,35,32,124,32,32,124,32,32,95,95,95,95,124,
	95,32,32,45,32,32,32,124,32,32,45,35,35},
	{35,35,47,124,32,32,124,32,32,32,32,124,32,32,
	32,32,32,32,32,32,32,45,32,32,95,35,35},
	{35,35,124,124,32,32,124,95,95,95,95,95,95,95,
	95,95,95,95,95,95,95,95,95,95,95,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,124,124,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,32,47,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{35,35,47,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,32,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       },

	   /* #33  config == 1011000   */
       {
	{35,35,35,35,35,35,35,35,35,35,35,35,35,35,
	35,35,35,35,35,35,35,35,35,35,35,35,35},
	{35,35,32,32,45,124,32,124,39,124,32,32,32,32,
	32,32,32,124,92,124,32,32,95,124,32,35,35},
	{35,35,124,32,32,46,32,124,47,124,32,32,32,32,
	32,32,32,124,124,124,32,124,32,124,32,35,35},
	{35,35,45,32,124,45,32,124,124,124,32,32,32,32,
	32,32,32,124,32,124,32,95,32,124,92,35,35},
	{35,35,32,95,32,32,32,124,39,124,32,32,32,32,
	32,32,32,124,96,124,32,32,124,124,124,35,35},
	{35,35,95,95,95,95,95,124,47,32,32,32,32,32,
	32,32,32,32,92,124,95,95,95,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,92,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,124,124,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,92,32,35,35},
	{35,35,32,32,32,32,32,32,32,32,32,32,32,32,
	32,32,32,32,32,32,32,32,32,32,92,35,35},
	{45,45,45,45,45,45,45,45,45,45,45,45,45,45,
	45,45,45,45,45,45,45,45,45,45,45,45,45}
       }
};
