#ifndef lint
static char Sccsid[] = "@(#)keymatch.c	3.1    DeltaDate 8/3/90    ExtrDate 10/6/90";
#endif

/*	KEYMATCH.C      */
/*	This subroutine is used to test if the key in the AK file
**	record matches the input value. Two options are supported,
**	UNIX style regular expressions or simple matches. If 'BSD_RE',
**	'SYSV_RE', or 'PD_RE' is defined regular expressions are allowed.
**	If the input value is enclosed in quotes an exact match is
**	required, otherwise upper/lower case is ignored. If simple
**	matching is being done, 'NO_RE', an '*' at the end of an unquoted
**	string matches everything.
**/
#include "cardfile.h"

#ifdef BSD_RE
extern	char	*re_comp();
extern	int	re_exec();
#endif
#ifdef SYSV_RE
extern	char	*regcmp();
extern	char	*regex();
#endif
#ifdef PD_RE
#include <regexp.h>
extern	regexp	*regcomp();
extern	int	regexec();
#endif

static	strlower();

keymatch(akrcd, val)
char    *akrcd, *val;
{
    register int vlen;
    char	convert[256];
    char	key[256];
    static int	lower;
#ifdef SYSV_RE
    static char	lastval[256];
    static char	*cval;
#endif
#ifdef PD_RE
    static char	lastval[256];
    static regexp *cval;
#endif
#ifdef BSD_RE
    static char	lastval[256];
# endif
#ifdef NO_RE
    register char *cp = convert,
		  *kp = key;
#endif
    
#ifdef NO_RE
    vlen = strlen(val);
    strcpy(convert, val);
    if ((*convert == '"' && convert[vlen-1] == '"')
	|| (*convert == '\'' && convert[vlen-1] == '\'')) {
	strcpy(convert, convert+1);
	convert[vlen-2] = '\0';
	lower = 0;
    } else {
	strlower(convert);
	lower = 1;
    }
    strcpy(key, akrcd);
    *strchr(key, ':') = '\0';
    if (lower) {
	strlower(key);
    }
    while (*cp != '\0' && (lower == 0 || *cp != '*')) {
	if (*cp != *kp)
	    return(0);
	++cp;
	++kp;
    }
    if (*cp == '\0' && *kp != '\0')
	return(0);
    return(1);
#else	/* BSD_RE | SYSV_RE | PD_RE */
    if (strcmp(val, lastval) != 0) {		/* new pattern */
	vlen = strlen(val);
# ifndef BSD_RE		/* SYSV_RE | PD_RE */
	if (cval)		/* free last pattern if any */
	    free (cval);
# endif
	strcpy(lastval, val);
	strcpy(convert, val);
	if ((*convert == '"' && convert[vlen-1] == '"')
	    || (*convert == '\'' && convert[vlen-1] == '\'')) {
	    strcpy(convert, convert+1);
	    convert[vlen-2] = '\0';
	    lower = 0;
	} else {
	    strlower(convert);
	    lower = 1;
	}
# ifdef BSD_RE
	if (re_comp(convert) != 0) {
# endif
# ifdef SYSV_RE
	if ((cval = regcmp(convert, 0)) == 0) {
# endif
# ifdef PD_RE
	if ((cval = regcomp(convert)) == 0) {
# endif
	    msg("Invalid search pattern");
	    return(-1);
	}
    }
    strcpy(key, akrcd);
    *strchr(key, ':') = '\0';
    if (lower) {
	strlower(key);
    }
# ifdef BSD_RE
    if (re_exec(key) != 0) {
# endif
# ifdef SYSV_RE
    if (regex(cval, key) != 0) {
# endif
# ifdef PD_RE
    if (regexec(cval, key) != 0) {
# endif
        return(1);
    }
    return(0);
#endif	/* RE */
}


static
strlower(str)
register char	*str;
{

    while (*str) {
	if (*str >= 'A' && *str <= 'Z')
	    *str = *str - 'A' + 'a';
	++str;
    }
}
