.\"	%W%	%R% (Berkeley) %E%
.\"
.TH BYACC "December 10, 1989"
.SH NAME
.PP
Byacc \- an LALR(1) parser generator
.SH SYNOPSIS
.PP
.B byacc
[ -dltv ] [ -b
.I prefix
.B ]
.I filename
.SH DESCRIPTION
.PP
.I Byacc
reads the grammar specification in the file
.I filename
and generates an LR(1) parser for it.
The parsers consist of a set of LALR(1) parsing tables and a driver routine
written in the C programming language.
.I Byacc
normally writes the parse tables and the driver routine to the file
.I y.tab.c.
.PP
The following options are available:
.RS
\fB-b \fIprefix\fR
.br
The
.B -b
option changes the prefix prepended to the output file names to
the string denoted by
.I prefix.
The default prefix is the character
.I y.
.sp 1
.B -d
.br
The \fB-d\fR option causes the header file
.I y.tab.h
to be written.
.sp 1
.B -l
.br
If the
.B -l
option is not specified,
.I byacc
will insert \#line directives in the generated code.
The \#line directives let the C compiler relate errors in the
generated code to the user's original code.
If the \fB-l\fR option is specified,
.I byacc
will not insert the \#line directives.
Any \#line directives specified by the user will be retained.
.sp 1
.B -t
.br
The
.B -t
option will change the preprocessor directives generated by
.I byacc
so that debugging statements will be incorporated in the compiled code.
.sp 1
.B -v
.br
The
.B -v
option causes a human-readable description of the generated parser to
be written to the file
.I y.output.
.RE
.PP
If the environment variable TMPDIR is set, the string denoted by
TMPDIR will be used as the name of the directory where the temporary
files are created.
.SH FILES
.PP
.I y.tab.c
.br
.I y.tab.h
.br
.I y.output
.br
.I /tmp/yacc.aXXXXXX
.br
.I /tmp/yacc.tXXXXXX
.br
.I /tmp/yacc.uXXXXXX
.SH DIAGNOSTICS
.PP
If there are rules that are never reduced, the number of such rules is
reported on standard error.
If there are any LALR(1) conflicts, the number of conflicts is reported
on standard error.
