#ifdef __TURBOC__
/*	assert.h

	assert macro

	Copyright (c) Borland International 1987,1988
	All Rights Reserved.
*/

#include <stdio.h>	/*  fprintf() prototype & 'stderr' definition */
#include <stdlib.h>	/* abort() prototype */


#if	!defined(NDEBUG)
#define assert(p)	if(!(p)){fprintf(stderr,\
		"Assertion failed: %s, file %s, line %d\n",\
		#p, __FILE__, __LINE__);exit(3);}
#else
#define assert(p)
#endif
#else
/***
*assert.h - define the assert macro
*
*   Copyright (c) 1985-1988, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Defines the assert(exp) macro.
*   [ANSI/System V]
*
*******************************************************************************/


#ifndef _ASSERT_DEFINED

#ifndef NDEBUG

static char _assertstring[] = "Assertion failed: %s, file %s, line %d\n";

#define assert(exp) { \
    if (!(exp)) { \
	fprintf(stderr, _assertstring, #exp, __FILE__, __LINE__); \
	fflush(stderr); \
	exit(3); \
	} \
    }

#else

#define assert(exp)

#endif /* NDEBUG */

#define _ASSERT_DEFINED

#endif /* _ASSERT_DEFINED */
#endif
