/*
 * BASIC by Phil Cockcroft
 */
/*
 * terminal specific configuration routines for SYS V 3B2's
 */
#include "xenix/conf.h"
#include <termio.h>

extern  int     ter_width;
extern  char    noedit;

#ifdef  MCBREAK
static  char    doneset;
#endif

static struct termio ntio, otio;

static  int     got_mode;

setu_term()
{
	register i;

	ioctl(0,TCGETA,&otio);

	ntio=otio;

	ntio.c_cc[VMIN] = 1;
	ntio.c_cc[VTIME] = 0;
	ntio.c_cc[VINTR] = CTRLINT;
	ntio.c_cc[VQUIT] = CTRLQUIT;
	ntio.c_lflag &= ~(ICANON | ECHO);
	ntio.c_iflag |= ICRNL;
	ntio.c_oflag |= OCRNL | ONLCR;

	ioctl(0,TCSETAF,&ntio);

	if(ter_width <= 0)
		ter_width=DEFPAGE;
	got_mode = 1;
}

set_term()
{
	if(noedit || !got_mode)
		return;
	if(doneset)
		return;
	doneset = 1;
	ioctl(0,TCSETAF,&ntio);
}

rset_term(type)
{
	if(noedit || !got_mode)
		return;
	if(!type){
		/* in editing loop */
		if(doneset)
			return;
	} else
		doneset = 0;
	ioctl(0,TCSETAF,&otio);
}
