/* Simple Terminal for ELKS v0.2
 * (c) 1999 by Jacek Lipkowski <sq5bpf@acid.ch.pw.edu.pl>
 * Released under the GPL 
 */
#include <linuxmt/time.h>
#include <termios.h>
#include <termio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include<stdio.h>

#define BIG			/* Comment this out if you wan't a smaller binary */

#define port "/dev/ttys0"

struct termios tty, old_tty, term, old_term;

char flag = 0;

int fd;
int len, tmp;

unsigned char ch = 0;

#ifdef BIG
void
perr (message)			/* poor man's perror() */
     char *message;
{
  write (STDERR_FILENO, message, strlen (message));
  exit (1);
}
#endif

void
reader (ifd)
     int ifd;
{
  unsigned char ich = 0;
  read (ifd, &ich, 1);
  if (ich != 0xa)
    flag = 0;
  if (ich == 0xa)
    flag++;
  flag = flag % 2;
  if ((ich != 0xa) | (flag == 0))
    write (STDOUT_FILENO, &ich, 1);
}

void
main (argc, argv)
     int argc;
     char *argv[];
{

  fd_set *rfd;
  int sel;

#ifdef BIG
  write (STDOUT_FILENO, "Simple Terminal for ELKS v0.2 by sq5bpf\n", 40);
  write (STDOUT_FILENO, "Press ^A to exit\n\n", 17);
#endif

  if (argc > 1)
    {
      fd = open (argv[1], O_RDWR);
    }
  else
    fd = open (port, O_RDWR);

#ifdef BIG
  if (fd < 0)
    perr ("Can't open port\n");
#endif

  tmp = tcgetattr (fd, &tty);


#ifdef BIG
  if (tmp < 0)
    perr ("tcgetattr\n");
#endif

  tcgetattr (fd, &old_tty);
  cfmakeraw (&tty);
  tmp = tcsetattr (fd, TCSANOW, &tty);

#ifdef BIG
  if (tmp < 0)
    perr ("tcsetattr\n");
#endif

  tcgetattr (STDIN_FILENO, &term);
  tcgetattr (STDIN_FILENO, &old_term);
  cfmakeraw (&term);
  tcsetattr (STDIN_FILENO, TCSANOW, &term);


  FD_SET (STDIN_FILENO, rfd);
  FD_SET (fd, rfd);

  while ((sel = select (fd + 1, rfd, 0, 0, 0)) && (sel != -1))
    {
/* why is this fflush needed? without it the process hangs, seems to be 
a bug in the tty code (some queue not flushed or something) */
      fflush (stdout);

      if (FD_ISSET (STDIN_FILENO, rfd))
	{
	  read (STDIN_FILENO, &ch, 1);
	  if (ch == 0xa)
	    ch = 0xd;		/* cr->lf */
	  if (ch != 1)
	    {
	      write (fd, &ch, 1);
	    }
	  else
	    break;

	}
      if (FD_ISSET (fd, rfd))
	{
	  reader (fd);
	}

      FD_SET (STDIN_FILENO, rfd);
      FD_SET (fd, rfd);

    }
  tmp = tcsetattr (fd, TCSANOW, &old_tty);

#ifdef BIG
  if (tmp < 0)
    perr ("tcsetattr\n");
#endif

  tcsetattr (STDIN_FILENO, TCSANOW, &old_term);

  close (fd);

#ifdef BIG
  perr ("\nProgram terminated\n");
#endif

}
