


XDBX(1)                                                   XDBX(1)


NNAAMMEE
       xdbx - X window system interface to the dbx debugger.

SSYYNNOOPPSSIISS
       xxddbbxx [ _-_t_o_o_l_k_i_t_o_p_t_i_o_n _._._. ] [_-_x_d_b_x_o_p_t_i_o_n _._._. ] [_-_d_b_x_o_p_t_i_o_n
       _._._. ] [_o_b_j_f_i_l_e [ _c_o_r_e_f_i_l_e ]]

DDEESSCCRRIIPPTTIIOONN
       _X_d_b_x is a graphical user interface  to  the  _d_b_x  debugger
       under  the  X  Window System.  It provides visual feedback
       and mouse input for the user to control program  execution
       through  breakpoints, to examine and traverse the function
       call stack, to display values of variables and data struc-
       tures, and to browse source files and functions.

       _X_d_b_x  allows initial dbx commands stored in the file _._d_b_x_-
       _i_n_i_t to be executed immediately after the symbolic  infor-
       mation is read.  If _._d_b_x_i_n_i_t does not exist in the current
       directory, the user's home directory is searched  (_~_/_._d_b_x_-
       _i_n_i_t).

       _O_b_j_f_i_l_e  is an object file produced by a compiler with the
       appropriate option (-g) specified to produce symbol  table
       information for dbx.  For Sun dbx, if no _o_b_j_f_i_l_e is speci-
       fied, the ddeebbuugg command can be used later to  specify  the
       program to be debugged.

       If  a file named _c_o_r_e exists in the current directory or a
       _c_o_r_e_f_i_l_e is specified, _x_d_b_x can be  used  to  examine  the
       state of the program when the core dump occurred.

       The  name  of the debugger invoked by _x_d_b_x is, by default,
       dbx, but it can be overridden with the  environment  vari-
       able DEBUGGER.

OOPPTTIIOONNSS
       _X_d_b_x  accepts  all  of the standard X Toolkit command line
       options (see _X(1)), and all the dbx options (see  _d_b_x(1)),
       plus the following xdbx specific options:

       -bigicon
              Uses  a  64x64  icon  instead  of the default 48x48
              icon.

SSUUBBWWIINNDDOOWWSS
       _X_d_b_x consists of the following subwindows:

       File Window         Display the full pathname of the  file
                           displayed  in  the  source window, and
                           the line number of the caret.

       Source Window       Display the contents of a source file.

       Message Window      Display the execution status and error



X Version 11               July 25 1990                         1





XDBX(1)                                                   XDBX(1)


                           messages of _x_d_b_x .

       Command Window      Provide a list of the common dbx  com-
                           mands  which  are  invoked  by  simply
                           clicking the LEFT mouse button.

       Dialogue Window     Provide a typing interface to dbx.

       Display Window      Provide a window for displaying  vari-
                           ables each time execution stops.  (Sun
                           dbx only)

       The relative sizes of the source window,  command  window,
       and  the  dialogue  window can be adjusted by dragging the
       grip (a small square near the right edge of  a  horizontal
       border) with the LEFT mouse button down.

SSEELLEECCTTIIOONN
       Text selection in the source window is modified to make it
       easier to select C expressions.  LEFT  mouse  button  down
       selects  a  C  expression  by  highlighting it in reverse-
       video.  LEFT mouse button down also  positions  the  caret
       and updates the line label accordingly.

       C expression selection is based on the resource _d_e_l_i_m_i_t_e_r_s
       which determines the set of characters that delimits  a  C
       expression.   (The  default word selection behavior in the
       Athena text widget  selects  a  word  delimited  by  white
       spaces.)  Text selection adjustment is possible by holding
       the LEFT mouse button down and dragging.

       A LEFT mouse button  click  with  the  SHIFT  button  down
       prints the value of the expression selected.


SSCCRROOLLLLBBAARR
       Pressing  the  LEFT mouse button scrolls the text forward,
       whereas pressing the RIGHT mouse button scrolls  the  text
       backward.  The amount of scrolling depends on the distance
       of the pointer button away from the top of the  scrollbar.
       If the button is pressed at the top of the scrollbar, only
       one line of text is scrolled.  If the button is pressed at
       the  bottom  of  the  scrollbar,  one screenful of text is
       scrolled.

       Pressing the MIDDLE mouse button changes the  thumb  posi-
       tion  of  the scrollbar.  Dragging the MIDDLE mouse button
       down moves the thumb along and changes the text displayed.

CCOOMMMMAANNDD BBUUTTTTOONNSS
   EExxeeccuuttiioonn CCoommmmaannddss
       rruunn         Begin program execution.

       ccoonntt        Continue execution from where it stopped.



X Version 11               July 25 1990                         2





XDBX(1)                                                   XDBX(1)


       sstteepp        Execute one source line, stepping into a func-
                   tion if the source line  contains  a  function
                   call.

       nneexxtt        Execute one source line, without stepping into
                   any function call.

       rreettuurrnn      (Berkeley dbx only) Continue  execution  until
                   the  selected  procedure  returns; the current
                   procedure is used if none is selected.



   BBrreeaakkppooiinntt CCoommmmaannddss
       ssttoopp aatt   Stop program execution at the line selected.  To
                 set a breakpoint in the program, place the caret
                 on the source line and click the ssttoopp aatt button.
                 A stop sign will appear next to the source line.

       ssttoopp iinn   Stop program execution in the function selected.
                 To  set  a  breakpoint in a function, select the
                 function name and click the ssttoopp iinn  button.   A
                 stop  sign  will  be  placed near the first exe-
                 cutable line of the function.

       ddeelleettee    Remove  the  breakpoint  on  the   source   line
                 selected or the breakpoint number selected.

       ssttaattuuss    Show the current breakpoints and traces.



   SSttaacckk CCoommmmaannddss
       wwhheerree     Show a stack trace of the functions called.

       uupp        Move up one level on the call stack.

       ddoowwnn      Move down one level on the call stack.



   DDaattaa DDiissppllaayy CCoommmmaannddss
       pprriinntt     Print the value of a selected expression.

       pprriinntt **   Print  the  value  of  the  object  the selected
                 expression is pointing to.

       ddiissppllaayy   Display the value of a  selected  expression  in
                 the  display  window,  updating  its value every
                 time execution stops. (Sun dbx only)

       uunnddiissppllaayy Stop  displaying  the  value  of  the   selected
                 expression   in  the  display  window.   If  the
                 selected expression is a constant, it refers  to



X Version 11               July 25 1990                         3





XDBX(1)                                                   XDBX(1)


                 the display number associated with an expression
                 in the display window.  (Sun dbx only)

       dduummpp      Print the names and values  of  local  variables
                 and  parameters in the current or selected func-
                 tion.



   MMiisscceellllaanneeoouuss CCoommmmaannddss
       ffuunncc   Display a selected function on the  source  window,
              and  change  the scope for variable name resolution
              to  the  selected  function.   The  file  scope  is
              changed to the file containing the function.

       ffiillee   Pop  up a directory browser that allows the user to
              move up and down in the directory tree, to select a
              text  file  to  be  displayed,  or  (in Sun dbx) to
              select an  executable  file  to  debug.   Directory
              entries  are marked with a trailing slash (`/') and
              executables with a trailing asterisk (`*').   File-
              names  beginning  with a dot (`.') or ending with a
              tilde (`~') are not listed in the menu.

       sseeaarrcchh Pop up a search panel  which  allows  both  forward
              (>>) and reverse (<<) search of text strings in the
              source file.  Hitting carriage return after  enter-
              ing  the  search string will begin a forward search
              and pop down the search panel.

       qquuiitt   Exit _x_d_b_x.



   DDiissppllaayyiinngg CC DDaattaa SSttrruuccttuurreess ((SSuunn ddbbxx oonnllyy))
       _X_d_b_x provides some primitive support for graphically  dis-
       playing  C  structures and the ability of following point-
       ers.  Pressing the RIGHT mouse button  on  the  pprriinntt  (or
       pprriinntt **) command button displays the value of the selected
       expression (or the value the selected expression is point-
       ing to) in a popup.  If the value is a pointer or a struc-
       ture containing pointers, the user can examine  the  value
       of  the object that pointer is pointing to by clicking the
       pointer value.  This will create another popup  that  dis-
       plays  the  object  the  pointer  points to.  Clicking the
       label of the popup pops down itself and all of its descen-
       dants.

XX DDEEFFAAUULLTTSS
       To  change  the default values of widget resources used in
       _x_d_b_x, you need to reference the  widgets  by  name  or  by
       class.   The  widget  hierarchies for the main window, the
       file menu, the search dialog box, and the popup data  dis-
       play  used  in xdbx are shown as follows, with the name of



X Version 11               July 25 1990                         4





XDBX(1)                                                   XDBX(1)


       the widget followed by the name of its class in  parenthe-
       ses:

       Main window:
           toplevel (ToplevelShell)
             vpane (Paned)
            fileWindow (Form)
              fileLabel (Label)
              lineLabel (Label)
            sourceForm (Form)
              sourceWindow (AsciiText)
            messageWindow (Label)
            commandWindow (Box)
              run (Command)
              cont (Command)
              next (Command)
              return (Command)
              step (Command)
              stop at (Command)
              stop in (Command)
              delete (Command)
              where (Command)
              up (Command)
              down (Command)
              print (Command)
              print * (Command)
              func (Command)
              file (Command)
              status (Command)
              display (Command)
              undisplay (Command)
              dump (Command)
              search (Command)
              quit (Command)
            dialogWindow (AsciiText)
            displayWindow (AsciiText)

       File menu:
           File Directory (TransientShell)
             popup (Paned)
            fileMenuLabel (Label)
            fileMenu (List)
            cancelButton (Command)

       Search dialog box:
           Search (TransientShell)
             searchPopup (Dialog)
            << (Command)
            >> (Command)
            DONE (Command)

       Data display popup:
           Data Popup (TransientShell)
             popup (Form)



X Version 11               July 25 1990                         5





XDBX(1)                                                   XDBX(1)


            label (Label)
            dataDpyWindow (AsciiText)

       In  addition  to  the  standard X resources, _x_d_b_x uses the
       following application-specific  resources  for  user  cus-
       tomization.   The  value  in  parentheses  is  the default
       value.

       bbeellll   If True, the bell is on. (True)

       ddiissppllaayyWWiinnddooww
              If True, the display window appears  on  start  up.
              (False)

       ddeelliimmiitteerrss
              The  set  of  delimiters  for  word  selection.  ("
              !%^&*()+=~|;:{},/#<?

       pprroommpptt The prompt string used in xdbx. ("(xdbx) ")

       ssttoopp__ccoolloorr
              Color of the stop sign. (Red)

       aarrrrooww__ccoolloorr
              Color of the arrow sign. (Blue)

       uuppddoowwnn__ccoolloorr
              Color of the updown sign. (Blue)

       bboommbb__ccoolloorr
              Color of the bomb sign. (Red)

       ddaattaaDDppyyMMaaxxHHeeiigghhtt
              Maximum height of the data display window. (300)

       ddaattaaDDppyyMMaaxxWWiiddtthh
              Maximum width of the data display window. (600)



FFIILLEESS
       a.out          default object file
       core           default core file
       .dbxinit       local initial commands file
       ~/.dbxinit     user's initial commands file

SSEEEE AALLSSOO
       X(1), dbx(1)

LLIIMMIITTAATTIIOONNSS
       Xdbx does not handle all the dbx commands properly.   Only
       a subset of the commands is supported:

               run     stop at     where   print   list   display     return



X Version 11               July 25 1990                         6





XDBX(1)                                                   XDBX(1)


               cont    stop in     up      dump    /      undisplay
               next    delete     down    func    ?
               step    status     use     file    quit


BBUUGGSS
       Sparc dbx does not always return correct source line posi-
       tion after an up or down command.  Also, the file variable
       in  sparc dbx sometimes has an extra slash, as in /file.c,
       which could break what normally works.  One way of getting
       around  the  latter  is  to  specify the current directory
       before the program name, as in 'xdbx  ./a.out'  or  'debug
       ./a.out'.

CCOOPPYYRRIIGGHHTT
       Copyright 1989 The University of Texas at Austin Copyright
       1990 Microelectronics and Computer Technology Corporation

AAUUTTHHOORR
       Po Cheung





































X Version 11               July 25 1990                         7


