


gdb(1)                      GNU Tools                      gdb(1)


NNAAMMEE
       gdb - The GNU Debugger

SSYYNNOOPPSSIISS
       ggddbb    [--hheellpp] [--nnxx] [--qq] [--bbaattcchh] [--ccdd==_d_i_r] [--ff] [--bb _b_p_s]
              [--ttttyy==_d_e_v] [--ss _s_y_m_f_i_l_e] [--ee _p_r_o_g] [--ssee _p_r_o_g] [--cc
              _c_o_r_e] [--xx _c_m_d_s] [--dd _d_i_r] [_p_r_o_g[_c_o_r_e|_p_r_o_c_I_D_]_]

DDEESSCCRRIIPPTTIIOONN
       The  purpose  of a debugger such as GDB is to allow you to
       see what is going on ``inside'' another program  while  it
       executes--or  what another program was doing at the moment
       it crashed.

       GDB can do four main kinds of things (plus other things in
       support of these) to help you catch bugs in the act:


          +o   Start  your program, specifying anything that might
              affect its behavior.


          +o   Make your program stop on specified conditions.


          +o   Examine what has happened, when  your  program  has
              stopped.


          +o   Change  things  in your program, so you can experi-
              ment with correcting the effects of one bug and  go
              on to learn about another.


       You  can  use GDB to debug programs written in C, C++, and
       Modula-2.  Fortran support will be added when a  GNU  For-
       tran compiler is ready.

       GDB  is invoked with the shell command ggddbb.  Once started,
       it reads commands from the terminal until you tell  it  to
       exit  with  the GDB command qquuiitt.  You can get online help
       from ggddbb itself by using the command hheellpp.

       You can run ggddbb with no arguments or options; but the most
       usual way to start GDB is with one argument or two, speci-
       fying an executable program as the argument:

       gdb program


       You can also start with both an executable program  and  a
       core file specified:

       gdb program core



GNU Tools                    4nov1991                           1





gdb(1)                      GNU Tools                      gdb(1)


       You  can,  instead, specify a process ID as a second argu-
       ment, if you want to debug a running process:

       gdb program 1234


       would attach GDB to process 11223344 (unless you also  have  a
       file  named `11223344'; GDB does check for a core file first).

       Here are some of the most frequently needed GDB commands:

       bbrreeaakk [_f_i_l_e::]_f_u_n_c_t_i_o_n
               Set a breakpoint at _f_u_n_c_t_i_o_n (in _f_i_l_e).

       rruunn [_a_r_g_l_i_s_t]
              Start your program (with _a_r_g_l_i_s_t, if specified).

       bbtt     Backtrace: display the program stack.

       pprriinntt _e_x_p_r
               Display the value of an expression.

       cc      Continue running your program (after stopping, e.g.
              at a breakpoint).

       nneexxtt   Execute  next  program  line (after stopping); step
              _o_v_e_r any function calls in the line.

       sstteepp   Execute next program line  (after  stopping);  step
              _i_n_t_o any function calls in the line.

       hheellpp [_n_a_m_e]
              Show information about GDB command _n_a_m_e, or general
              information about using GDB.

       qquuiitt   Exit from GDB.

       For full details on GDB, see _U_s_i_n_g _G_D_B_: _A _G_u_i_d_e _t_o _t_h_e _G_N_U
       _S_o_u_r_c_e_-_L_e_v_e_l  _D_e_b_u_g_g_e_r,  by Richard M. Stallman and Roland
       H. Pesch.  The same text is available online  as  the  ggddbb
       entry in the iinnffoo program.

OOPPTTIIOONNSS
       Any  arguments  other  than  options specify an executable
       file and core file (or process ID);  that  is,  the  first
       argument  encountered  with  no  associated option flag is
       equivalent to a `--ssee' option, and the second, if  any,  is
       equivalent  to  a  `--cc' option if it's the name of a file.
       Many options have both long  and  short  forms;  both  are
       shown  here.   The  long  forms are also recognized if you
       truncate them, so long as enough of the option is  present
       to  be  unambiguous.   (If you prefer, you can flag option
       arguments with `++' rather than `--', though  we  illustrate
       the more usual convention.)



GNU Tools                    4nov1991                           2





gdb(1)                      GNU Tools                      gdb(1)


       All  the  options  and command line arguments you give are
       processed in sequential order.  The order makes a  differ-
       ence when the `--xx' option is used.


       --hheellpp

       --hh     List all options, with brief explanations.


       --ssyymmbboollss==_f_i_l_e

       --ss _f_i_l_e
               Read symbol table from file _f_i_l_e.


       --eexxeecc==_f_i_l_e

       --ee _f_i_l_e
                Use  file  _f_i_l_e as the executable file to execute
              when appropriate, and for examining  pure  data  in
              conjunction with a core dump.


       --ssee==_f_i_l_e
               Read symbol table from file _f_i_l_e and use it as the
              executable file.


       --ccoorree==_f_i_l_e

       --cc _f_i_l_e
               Use file _f_i_l_e as a core dump to examine.


       --ccoommmmaanndd==_f_i_l_e

       --xx _f_i_l_e
               Execute GDB commands from file _f_i_l_e.


       --ddiirreeccttoorryy==_d_i_r_e_c_t_o_r_y

       --dd _d_i_r_e_c_t_o_r_y
               Add _d_i_r_e_c_t_o_r_y to the path  to  search  for  source
              files.



       --nnxx

       --nn     Do  not  execute  commands from any `..ggddbbiinniitt' ini-
              tialization files.  Normally, the commands in these
              files  are  executed  after all the command options



GNU Tools                    4nov1991                           3





gdb(1)                      GNU Tools                      gdb(1)


              and arguments have been processed.



       --qquuiieett

       --qq     ``Quiet''.  Do not print the introductory and copy-
              right messages.  These messages are also suppressed
              in batch mode.


       --bbaattcchh Run in batch mode.  Exit with status 00  after  pro-
              cessing  all  the command files specified with `--xx'
              (and `..ggddbbiinniitt',  if  not  inhibited).   Exit  with
              nonzero  status if an error occurs in executing the
              GDB commands in the command files.

              Batch mode may be useful for running GDB as a  fil-
              ter,  for  example to download and run a program on
              another computer; in order to make this  more  use-
              ful, the message

              Program exited normally.


              (which is ordinarily issued whenever a program run-
              ning under GDB control terminates)  is  not  issued
              when running in batch mode.


       --ccdd==_d_i_r_e_c_t_o_r_y
                Run GDB using _d_i_r_e_c_t_o_r_y as its working directory,
              instead of the current directory.


       --ffuullllnnaammee

       --ff     Emacs sets this option when it runs GDB as  a  sub-
              process.  It tells GDB to output the full file name
              and line number in a standard, recognizable fashion
              each   time  a  stack  frame  is  displayed  (which
              includes each time the program stops).  This recog-
              nizable  format  looks  like  two ` 3322' characters,
              followed by the file name, line number and  charac-
              ter  position  separated  by colons, and a newline.
              The Emacs-to-GDB interface  program  uses  the  two
              ` 3322'  characters as a signal to display the source
              code for the frame.


       --bb _b_p_s  Set the line speed (baud rate or bits per  second)
              of  any  serial  interface  used  by GDB for remote
              debugging.




GNU Tools                    4nov1991                           4





gdb(1)                      GNU Tools                      gdb(1)


       --ttttyy==_d_e_v_i_c_e
               Run using _d_e_v_i_c_e for your program's standard input
              and output.



SSEEEE AALLSSOO
       `ggddbb' entry in iinnffoo; _U_s_i_n_g _G_D_B_: _A _G_u_i_d_e _t_o _t_h_e _G_N_U _S_o_u_r_c_e_-
       _L_e_v_e_l _D_e_b_u_g_g_e_r, Richard M. Stallman and Roland  H.  Pesch,
       July 1991.

CCOOPPYYIINNGG
       Copyright (c) 1991 Free Software Foundation, Inc.

       Permission  is  granted  to  make  and distribute verbatim
       copies of this manual provided the  copyright  notice  and
       this permission notice are preserved on all copies.

       Permission is granted to copy and distribute modified ver-
       sions of this manual under  the  conditions  for  verbatim
       copying,  provided  that the entire resulting derived work
       is distributed under the  terms  of  a  permission  notice
       identical to this one.

       Permission  is granted to copy and distribute translations
       of this manual into another language, under the above con-
       ditions for modified versions, except that this permission
       notice may be included in  translations  approved  by  the
       Free  Software  Foundation  instead  of  in  the  original
       English.



























GNU Tools                    4nov1991                           5


