/*
 * xvfish.c  -  the required-by-law 'fish' portion of 'xv' 
 *
 * StartFish();
 * StopFish();
 */

/*
 * Copyright 1989, 1990 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any express or implied warranty.
 */


#define DELAY 200000L   /* delay between fish increments, in microseconds */
#define NEEDSTIME

#include "xv.h"
     
/* size of fish */
#define fwide 32
#define fhigh 16
     

static char lfish_bits[] = {
   0x00, 0xc0, 0x07, 0x00, 0x00, 0xb0, 0x06, 0x00, 0x80, 0x7f, 0x03, 0xe0,
   0x60, 0x82, 0x03, 0xb0, 0x18, 0x00, 0x0c, 0x68, 0x64, 0x02, 0xf0, 0x37,
   0x62, 0x00, 0x00, 0x28, 0x01, 0xaa, 0xaa, 0x36, 0x46, 0x00, 0x00, 0x28,
   0x38, 0x03, 0xc0, 0x5f, 0xb0, 0x28, 0x30, 0xb0, 0xc0, 0x39, 0x0e, 0xe0,
   0x00, 0xee, 0x01, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00,
   0x00, 0xc0, 0x00, 0x00};
     
static char rfish_bits[] = {
   0x00, 0xe0, 0x03, 0x00, 0x00, 0x60, 0x0d, 0x00, 0x07, 0xc0, 0xfe, 0x01,
   0x0d, 0xc0, 0x41, 0x06, 0x12, 0x30, 0x00, 0x18, 0xec, 0x0f, 0x40, 0x26,
   0x14, 0x00, 0x00, 0x46, 0xac, 0xaa, 0x4a, 0x80, 0x14, 0x00, 0x00, 0x62,
   0xfa, 0x03, 0xc0, 0x1c, 0x0d, 0x0c, 0x14, 0x0d, 0x07, 0x70, 0x9c, 0x03,
   0x00, 0x80, 0x77, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x05, 0x00,
   0x00, 0x00, 0x03, 0x00};
     
     
typedef struct fishstr { short x,y,dx,dy; } FISH;
     

#define MAXFISH 100
FISH fishdat[MAXFISH];

Pixmap lfishP, rfishP;
int numfish=7;
int w,h;
static int firsttime=1;


static void dofish(), setfishtimer();

     
/**************/
StartFish()
/**************/
{
  int i;

  if (!fish) return;

#if defined(NOTIMER) || defined(USLEEP)
  /* MUST have 'setitimer()' for fish to work */
  return;
#endif

#ifndef __COHERENT__
  if (useroot || fishrunning || !mainW) return;
  w = eWIDE;  h = eHIGH;

  if (firsttime) {
    lfishP=XCreateBitmapFromData(theDisp,mainW,lfish_bits,fwide,fhigh);
    rfishP=XCreateBitmapFromData(theDisp,mainW,rfish_bits,fwide,fhigh);

    for (i=0; i<numfish; i++) {
      fishdat[i].x  = rand()%w;
      fishdat[i].y  = rand()%h;
      fishdat[i].dx = (abs(rand()%3)+4);
      
      if (rand()&0x10) fishdat[i].dx = -fishdat[i].dx;
     
      fishdat[i].dy=rand()%7-3;  if (fishdat[i].dy==0) fishdat[i].dy=1;
    }
    firsttime = 0;
  }

  fishrunning = 1;
  setfishtimer();
#endif /*__COHERENT__ */
}   


/**************/
StopFish()
/**************/
{
#if defined(NOTIMER) || defined(USLEEP)
  /* MUST have setitimer() for fish to work */
  return;
#endif

#ifndef __COHERENT__

  struct itimerval it;
#ifdef POSIX
  struct sigaction act;
#endif

  if (!fish) return;
  if (!fishrunning) return;


#ifndef POSIX
  HOLD_SIG;              /* block ALRM signal while we turn everything off */
#endif


  bzero(&it, sizeof(it));
  it.it_interval.tv_usec = 0L;
  it.it_value.tv_usec = 0L;

  setitimer(ITIMER_REAL, &it, (struct itimerval *)0);

#ifdef POSIX
  act.sa_handler=SIG_DFL;
  sigaction(SIGALRM,&act,NULL);
#else
  signal(SIGALRM,SIG_DFL);
  RELEASE_SIG;          /* allow ALRM signals to happen (we don't get them) */
  fishrunning = 0;
#endif /* POSIX */  

#endif /* __COHERENT__ */
}



/*******************************/
static void dofish()
{
  int i;
  FISH *fp;

  XSetForeground(theDisp, theGC, infofg);
  XSetBackground(theDisp, theGC, infobg);

  for (i=0; i<numfish; i++) {
    fp = &fishdat[i];    
    XClearArea(theDisp, mainW, fp->x, fp->y, fwide, fhigh, True);

    fp->x += fp->dx;
    fp->y += fp->dy;
    if (fp->x < -50)    fp->dx = abs(fp->dx);
    if (fp->x > (w+50)) fp->dx = -abs(fp->dx);

    if (fp->y < 10)     fp->dy = abs(fp->dy);
    if (fp->y > (h-20)) fp->dy = -abs(fp->dy);
     
    if (fp->dx<0)
      XCopyPlane(theDisp,lfishP,mainW,theGC,0,0,fwide,fhigh,fp->x,fp->y,1L);
    else
      XCopyPlane(theDisp,rfishP,mainW,theGC,0,0,fwide,fhigh,fp->x,fp->y,1L);
  }

  XFlush(theDisp);
  setfishtimer();
}
     

     
     
/*******/
static void setfishtimer()
/*******/
{

#if defined(NOTIMER) || defined(NOSLEEP)
return;
#endif

#ifndef __COHERENT__

  struct itimerval it;
#ifdef POSIX
  struct sigaction act;
#endif
     
  bzero(&it, sizeof(it));
  it.it_value.tv_usec = DELAY;

#ifdef POSIX
  act.sa_handler=dofish;
  sigaction(SIGALRM,&act,NULL);
#else
  signal(SIGALRM,dofish);
  RELEASE_SIG;               /* enable ALRM signals */
  setitimer(ITIMER_REAL, &it, (struct itimerval *)0);
#endif /* POSIX */

#endif /*__COHERENT__*/
}






