.TH bggen l
.SH NAME
bggen \- generates colored backgrounds on X11 displays
.SH SYNTAX
\fBbggen\fP [-w width] [-s size] [-b bits] r1 g1 b1 [r2 g2 b2 ... rn gn bn]
.SH DESCRIPTION
\fBbggen\fP is a program that generates a width-pixel wide by size-pixels high
vertical stripe.  The top of the stripe is in color (r1,g1,b1), and the
bottom of the stripe is in color (rn,gn,bn).  Intermediate colors are 
interpolated between these colors.  If you specify more than 2 colors, the
stripe passes through all the specified colors, in the order specified.
.PP
The '-b' option specifies the number of significant bits in the (output)
color specifications.  It must range between 1 and 8, inclusive.  Use
values less than 8 (the default) to limit color use by increasing the color
granularity.
.PP
Values for 'r', 'g', and 'b' should range between 0 and 255, inclusive.  0
means 'off', and 255 means 'fully on'.
.PP
\fBbggen\fP doesn't actually affect your background directly.  \fBbggen\fP
merely generates a small PPM (Portable Pixmap Format) datafile that XV can
read and display.
.PP
To use \fBbggen\fP, you should pipe its output into an XV command, such as:
"xv -root -quit -slow24"
.PP
The default 'size' is 1024 pixels, which should be as tall as your display.  
If your display is taller than that, you should specify its actual height,
otherwise you will get a bizarre repeating effect, that you probably didn't 
want.  Note:  If you specify small values of '-s', you can get some neat
effects.
.PP
The '-w' argument has been added to improve the performance of various
stippling algorithms (as in XV).  More information to work with, and such.
Try using '-w 16' on these command lines to see what is meant.
.SH "TRY THESE"
.nf
Light Blue to Dark Blue
	bggen 100 100 255  50 50 150  | xv -ro -q -s
RGB Rainbow
	bggen 0 0 255  0 255 0  255 0 0 | xv -ro -q -s
Green Cylinders
	bggen 0 0 0  0 255 0  0 0 0 -s 128 | xv -ro -q -s
Blue to Magenta
	bggen 0 0 255  200 0 100 | xv -ro -q -s
Full Rainbow
	bggen 0 0 255  0 255 255  0 255 0  255 255 0  255 0 0 | xv -ro -q -s
Repeating Rainbow
	bggen 0 0 255  0 255 255  0 255 0  255 255 0  255 0 0 
	      255 0 255  0 0 255 -s 256 | xv -ro -q -s
.fi
.PP BUGS
It'd probably be nice if the program used some X calls to determine screen
size.  It'd also probably be nice if the program could take colors by 'name',
and also by hexadecimal value.
.SH AUTHOR
John Bradley  -  bradley@cis.upenn.edu

