/*
 * Xmore - Version 1.0
 * 
 * Copyrighted by Ove Kalkan in 1993 - all rights reserved
 */
#include <stdio.h>
#ifndef COHERENT
#include <unistd.h>
#include <stdlib.h>
#endif
#include <sys/stat.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xresource.h>

#ifndef COHERENT
#include <X11/Xt/Intrinsic.h>
#include <X11/Xt/StringDefs.h>
#else
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#endif

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SmeLine.h>

#include "config.h"

/* Variablen und Defines */
Display		*display;
GC		gc;
Widget		toplevel;
XtAppContext	app;

Widget	text,			/* Das Textfeld */
	butt,			/* Der Next-Button */
	name,			/* Das Filename-feld */
	pbutt,			/* Previous Button */
	fm,			/* Filemenu */
	cbutt,			/* Compress Button */
	ebutt,			/* Editor Button */
	lbutt,			/* ShowLinenumber Button */
	hbutt,			/* ShowHexdump Button */
	abutt,			/* AddExtracted Button */
	xbutt,			/* Extract from Archive Button */
	browser,		/* Browser for add-file */
	browser_text,		/* Filename-box for file browser */
#ifdef HAVE_TXT2TEX
	tbutt,			/* Texbutton */
#endif
	last;			/* Zuletzt angewaehltes Menu */

char	*txt;			/* Zeiger auf den Inhalt eines Files */
int	files,			/* Zeiger auf das derzeitige File */
	filestoread,		/* Zahl der Files die gelesen werden */
	filesstart;		/* Anfang der Filekette in argv */
char	**filenames;		/* Feld mit den Filenamen */

char	*EDITOR;		/* Editor */
Boolean	SLN;			/* Show Line Numbers */
Boolean	HEX;			/* Als Hexdump zeigen */
Boolean	ADDEXT = FALSE;		/* Extracted Files zur Fileliste addieren */

XawTextSelectType  def_sel[] = {XawselectPosition,XawselectWord,
				XawselectLine,XawselectParagraph,
				XawselectAll,XawselectNull};
XawTextSelectType  lin_sel[] = {XawselectLine,XawselectParagraph,XawselectNull};
XawTextSelectType  dir_sel[] = {XawselectLine,XawselectNull};


/*
 * File-Eintrag struktur
 */

#define	FILE_COMPRESSED		1	/* .z oder .Z files */
#define	FILE_ARCHIVE		2	/* .tar files */
#define	FILE_SOURCE		4	/* Fuer Sourcefiles */
#define	FILE_OBJECT		8	/* Fuer Binaries */
#define	FILE_DIR		16	/* Directories */
#define	FILE_EXEC		32	/* Executables */
#define	FILE_ROFF		64	/* Roff-Files -> Extracbutton */
#define	FILE_PS			128	/* PS-File -> Extrabutton */
#define	FILE_DVI		256	/* DVI-File -> Extrabutton */
#define	FILE_F77		512	/* Fuer Fortran */

typedef	struct {
	char	*filename;	/* Filename -> argv */
	Widget	menu;		/* Widget */
	char	FLAG;	/* Ob das File komprimiert ist oder nicht */
} mem_struct;

mem_struct	*mem;		/* Speicher fuer alle Files */

char	*dir_file = NULL;	/* Name des Files, das in einem Directory angewaehlt
				   wurde -> fuer compress, etc. */

/*
 * Resource Struktur
 */
typedef	struct {
	char	*editor;
	Boolean	show_ln;
	Boolean	show_hex;
} xmore_struct;

/*
 * Function prototypes
 */
XtCallbackProc	file_but_cb(Widget w),
		quit_cb(void),
		next_cb(void),
		prev_cb(void),
		edit_cb(void),
		ext_cb(void),
		sln_cb(void),
		hex_cb(void),
#ifdef HAVE_TXT2TEX
		tex_cb(void),
#endif
		comp_cb(void),
		add_cb(void),
		addext_cb(void),
		browser_ok_cb(void),
		browser_cancel_cb(void),
		del_cb(void);
XtActionProc	get_file_from_text(Widget w, XEvent *e, String *s, Cardinal *c);

void	AddEntryToList(char *filename, Boolean show);

void	file_status(void),
	read_file(void),
	Create_GUI(void),
	parsetoolsrc(void);
void	main(int argc, char **argv);
char	identify_file(char *name);

/*
 * Actiontable
 */
static	XtActionsRec	actions[] =
       {{"quit-xmore",		(XtActionProc) quit_cb},
 	{"next-file",		(XtActionProc) next_cb},
 	{"previous-file",	(XtActionProc) prev_cb},
 	{"editor",		(XtActionProc) edit_cb},
#ifdef HAVE_TXT2TEX
 	{"latex",		(XtActionProc) tex_cb},
#endif
 	{"remove-file",		(XtActionProc) del_cb},
 	{"add-file",		(XtActionProc) add_cb},
 	{"extract-file",	(XtActionProc) ext_cb},
 	{"compress-file",	(XtActionProc) comp_cb},
	{"get-file",		(XtActionProc) get_file_from_text},
       };


/*
 * Resources
 */
static XtResource	resources[] =
       {{"editor", "Editor", XtRString, sizeof(String), XtOffsetOf(xmore_struct,editor),
	 XtRString,DEFAULT_EDITOR},
	{"showLineNumbers", "ShowLineNumbers", XtRBoolean, sizeof(Boolean),
	 XtOffsetOf(xmore_struct,show_ln),XtRImmediate,(XtPointer) FALSE},
	{"showHexdump", "ShowHexdump", XtRBoolean, sizeof(Boolean),
	 XtOffsetOf(xmore_struct,show_hex),XtRImmediate,(XtPointer) FALSE},
       };

/*
 * Options
 */
static XrmOptionDescRec	options[] =
       {{"-editor", ".editor", XrmoptionSepArg, (caddr_t) NULL},
	{"-showLineNumbers", ".showLineNumbers", XrmoptionNoArg, (caddr_t) "TRUE"},
	{"-showHexdump", ".showHexdump", XrmoptionNoArg, (caddr_t) "TRUE"},
       };


/*
 * main - initialisieren der Strukturen und Aufrufen der GUI-Erzeugung 
 */
void main(int argc, char **argv)
{	xmore_struct	Res;	/* Dummy-Feld fuer die Resourcen */

	/*
	 * Die Applicationcontext initialisieren
	 */
	toplevel = XtAppInitialize(&app,"Xmore",options,XtNumber(options),
				   &argc,argv,NULL,NULL,0);

	/*
	 * Nur ein Argument -> von stdin lesen
	 */
	filestoread = argc;
	filenames = argv;

	/*
	 * Filezeiger auf erstes File setzen
	 */
	files = 1;
	filesstart = files;

	if (argc == 1) {
		if (!(filenames = (char **) malloc(sizeof(char *) * 2))) {
			fprintf(stderr,"Memory Error\n");
			exit(1);
		}
		filenames[1] = "-";
		filenames[0] = "nothing";
		filestoread = 2;
	}

	/*
	 * Memoryfield holen
	 */
	if (!(mem = (mem_struct *) malloc(sizeof(mem_struct)*filestoread))) {
		fprintf(stderr,"Memory Error\n");
		exit(1);
	}

	/*
	 * Resourcen setzen
	 */
	XtVaGetApplicationResources(toplevel,&Res,resources,3,NULL);
	EDITOR = Res.editor;
	SLN = Res.show_ln;
	HEX = Res.show_hex;
	if (HEX)
		SLN = FALSE;
	/*
	 * Actions setzen
	 */
	XtAppAddActions (app, actions, XtNumber (actions));

	/*
	 * GUI erzeugen
	 */
	Create_GUI();

	/*
	 * Buttons auf insensitive setzen falls erforderlich
	 */
	if (files+1 == filestoread)
		XtSetSensitive(butt,FALSE);
	XtSetSensitive(pbutt,FALSE);

	/*
	 * Filenamen zum Menu packen
	 */
	{	int	i;
		Arg	args[1];
		Widget	w;

		for (i = 1; i < filestoread; i++) {
			char	*name = filenames[i];

			/*
			 * Pruefen ob File komprimiert oder nicht
			 */
			mem[i].FLAG = identify_file(name);

			mem[i].filename = name;

			if (!strcmp(filenames[i],"-"))
				XtSetArg(args[0],XtNlabel,"<stdin>");
			else
				XtSetArg(args[0],XtNlabel,filenames[i]);
			w = XtCreateManagedWidget("file_item",smeBSBObjectClass,fm,args,1);
			if (i == 1) {
				XtSetSensitive(w,FALSE);
				last = w;
			}
			XtAddCallback(w,XtNcallback,(XtCallbackProc) file_but_cb,NULL);
			mem[i].menu = w;
		}
	}

	/*
	 * Die Oberflaeche darstellen
	 */
	XtRealizeWidget(toplevel);

	/*
	 * File lesen und Filenamen in das Namefield setzen
	 */
	read_file();

	/* Name des Files in Label schreiben */

	file_status();

	{	Arg	args[1];

		/*
		 * text mit Fenster assozieren
		 */
		XtSetArg(args[0],XtNstring,txt);
		XtSetValues(text,args,1);	
/*		free(txt);
*/	}

	/*
	 * Main Loop
	 */
	XtAppMainLoop(app);
}

/*
 * identify_file - Filetype feststellen
 */
char	identify_file(char *name)
{	int	s = strlen(name);
	char	*d;
	char	FLAG = 0;

	if (s < 2)
		return(FLAG);

	if (!(d = (char *) malloc (s+1))) {
		fprintf(stderr,"Error while allocating memory\n");
		exit(1);
	}
	strncpy(d,name,s);
	d[s] = '\0';
	/*
	 * Pruefen ob directory oder gar executable
	 */
	{	struct stat	stat_buf;

		stat(d,&stat_buf);
		if (stat_buf.st_mode & S_IFDIR)
			FLAG = FILE_DIR;
	}
	if (FLAG)
		return(FLAG);

	/*
	 * Pruefen ob komprimiert
	 */
	if (d[s - 2] == '.' &&
	   (d[s - 1] == 'z' || d[s - 1] == 'Z')) {
		FLAG |= FILE_COMPRESSED;
		s -= 2;
	}
	if (d[s - 3] == '.' && d[s - 2] == 'g' && d[s - 1] == 'z') {
		FLAG |= FILE_COMPRESSED;
		s -= 3;
	}
	if (s < 2)
		return(FLAG);

	if (d[s - 2] == '.' &&
	   (d[s - 1] == 'o' || d[s - 1] == 'a')) {
		FLAG |= FILE_OBJECT;
		s -= 2;
	}
	else if (d[s - 2] == '.' &&
	   (d[s - 1] == 'c' || d[s - 1] == 'h')) {
		FLAG |= FILE_SOURCE;
		s -= 2;
	}
	else if (d[s - 2] == '.' &&
	   (d[s - 1] == 'f')) {
		FLAG |= FILE_F77;
		s -= 2;
	}

	if (s < 3)
		return(FLAG);

	if (!(strncmp(&d[s-3],".c~",3)) ||
	    !(strncmp(&d[s-3],".h~",3))) {
		FLAG |= FILE_SOURCE;
		s -= 3;
	}
	else if (!(strncmp(&d[s-3],".f~",3))) {
		FLAG |= FILE_F77;
		s -= 3;
	}

	if (s < 4)
		return(FLAG);

	/*
	 * Pruefen ob tar archive
	 */
	if (!(strncmp(&d[s - 4],".tar",4))) {
		FLAG |= FILE_ARCHIVE;
	}

	if (!(FLAG & FILE_COMPRESSED || FLAG & FILE_ARCHIVE)) {
		if (!(strncmp(&d[s-4],".tpz",4)) ||
		    !(strncmp(&d[s-4],".taz",4)) ||
		    !(strncmp(&d[s-4],".tgz",4))) {
			FLAG |= (FILE_COMPRESSED | FILE_ARCHIVE);
		}
	}

	free(d);
	return(FLAG);
}

/*
 * file_status - ausgeben des Filenames und des Status
 */
void	file_status(void)
{	Arg	args[1];
	Arg	largs[1];

	/* Name des Files in Label schreiben */
	XtSetArg(largs[0],XtNlabel,"Compress");
	if (strcmp(mem[files].filename,"-")) {
		char	*s;

		if (!(s = (char *) malloc(strlen(mem[files].filename)
					  + (mem[files].FLAG & FILE_COMPRESSED)*30 
					  + (mem[files].FLAG & FILE_ARCHIVE)*30 
					  + 30))) {
			fprintf(stderr,"Memory Error\n");
			exit(1);
		}
		sprintf(s,"%s (\0",mem[files].filename);

#ifdef HAVE_TXT2TEX
		XtSetSensitive(tbutt,TRUE);
#endif
		XtSetSensitive(ebutt,TRUE);
		XtSetSensitive(cbutt,TRUE);
		XtSetSensitive(xbutt,FALSE);

		if (mem[files].FLAG & FILE_COMPRESSED) {
			sprintf(s,"%scompressed file,\0",s);
			XtSetArg(largs[0],XtNlabel,"Uncompress");
			XtSetSensitive(ebutt,FALSE);
		}
		
		if (mem[files].FLAG & FILE_OBJECT) {
			sprintf(s,"%sobject file,\0",s);
#ifdef HAVE_TXT2TEX
			XtSetSensitive(tbutt,FALSE);
#endif
			XtSetSensitive(ebutt,FALSE);
		}
		else if (mem[files].FLAG & FILE_ARCHIVE) {
			sprintf(s,"%star archive,\0",s);
#ifdef HAVE_TXT2TEX
			XtSetSensitive(tbutt,FALSE);
#endif
			XtSetSensitive(ebutt,FALSE);
			XtSetSensitive(xbutt,TRUE);
		}
		else if (mem[files].FLAG & FILE_DIR) {
			sprintf(s,"%sdirectory,\0",s);
#ifdef HAVE_TXT2TEX
			XtSetSensitive(tbutt,FALSE);
#endif
			XtSetSensitive(ebutt,FALSE);
			XtSetSensitive(cbutt,FALSE);
		}
		else if (mem[files].FLAG & FILE_EXEC) {
			sprintf(s,"%sexecutable,\0",s);
#ifdef HAVE_TXT2TEX
			XtSetSensitive(tbutt,FALSE);
#endif
			XtSetSensitive(ebutt,FALSE);
		}

		sprintf(s,"%s%d characters)\0",s,strlen(txt));
		XtSetArg(args[0],XtNlabel,s);
	}
	else {
		XtSetArg(args[0],XtNlabel,"<stdin>");
		XtSetSensitive(cbutt,FALSE);
#ifdef HAVE_TXT2TEX
		XtSetSensitive(tbutt,FALSE);
#endif
		XtSetSensitive(ebutt,FALSE);
		XtSetSensitive(xbutt,FALSE);
	}
	XtSetValues(name,args,1);
	XtSetValues(cbutt,largs,1);
}

/* diese Routine initialisiert alle weitern Widgets */
void	Create_GUI(void)
{	Widget	w[4];
	Arg	args[2];

	/*
	 * Main Pane erzeugen
	 */
	w[0] = XtCreateManagedWidget("main_pane",panedWidgetClass,toplevel,NULL,0);

	/*
	 * Menu_bar erzeugen
	 */
	w[1] = XtCreateManagedWidget("menu_box",boxWidgetClass,w[0],NULL,0);

	/*
	 * Knoepfe der Menu Bar erzeugen
	 */
	w[2] = XtCreateManagedWidget("quit_button",commandWidgetClass,w[1],NULL,0);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) quit_cb,NULL);

	w[2] = XtCreateManagedWidget("tools_button",menuButtonWidgetClass,w[1],NULL,0);
	w[2] = XtCreateManagedWidget("file_button",menuButtonWidgetClass,w[1],NULL,0);
	w[2] = XtCreateManagedWidget("status_label",labelWidgetClass,w[1],NULL,0);

	/*
	 * Den Filenamelabel erzeugen
	 */
	name = XtCreateManagedWidget("name_label",labelWidgetClass,w[0],NULL,0);

	/*
	 * Das Text-Feld erzeugen
	 */
	text = w[1] = XtCreateManagedWidget("text_field",asciiTextWidgetClass,w[0],NULL,0);
	XtOverrideTranslations(text,
		XtParseTranslationTable("<Btn2Motion>: extend-adjust()\n\
					 <Btn2Up>: extend-end(PRIMARY,CUT_BUFFER0)"));

	/*
	 * Das Filemanagement-Menu erzeugen
	 */
	fm = w[0] = XtCreateManagedWidget("file_menu",simpleMenuWidgetClass,toplevel,NULL,0);

	butt = w[1] = XtCreateManagedWidget("next_button",smeBSBObjectClass,w[0],NULL,0);
	XtAddCallback(w[1],XtNcallback,(XtCallbackProc) next_cb,NULL);

	pbutt = w[1] = XtCreateManagedWidget("prev_button",smeBSBObjectClass,w[0],NULL,0);
	XtAddCallback(w[1],XtNcallback,(XtCallbackProc) prev_cb,NULL);

	XtCreateManagedWidget("line",smeLineObjectClass,fm,NULL,0);

	w[1] = XtCreateManagedWidget("add_button",smeBSBObjectClass,fm,NULL,0);
	XtAddCallback(w[1],XtNcallback,(XtCallbackProc) add_cb,NULL);

	w[1] = XtCreateManagedWidget("del_button",smeBSBObjectClass,fm,NULL,0);
	XtAddCallback(w[1],XtNcallback,(XtCallbackProc) del_cb,NULL);

	XtCreateManagedWidget("line",smeLineObjectClass,w[0],NULL,0);

	/*
	 * Das Tools Menu
	 */
	w[0] =
	XtCreateManagedWidget("tools_menu",simpleMenuWidgetClass,toplevel,NULL,0);

	ebutt = w[2] = XtCreateManagedWidget("edit_button",smeBSBObjectClass,w[0],NULL,0);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) edit_cb,NULL);

	/*
	 * Ab hier ein Setupfile lesen und das Menu danach aufbauen
	 */
#ifdef HAVE_TXT2TEX
	tbutt = w[2] = XtCreateManagedWidget("tex_button",smeBSBObjectClass,w[0],NULL,0);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) tex_cb,NULL);
#endif
	cbutt = w[2] = XtCreateManagedWidget("comp_button",smeBSBObjectClass,w[0],NULL,0);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) comp_cb,NULL);

	xbutt = w[2] = XtCreateManagedWidget("ext_button",smeBSBObjectClass,w[0],NULL,0);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) ext_cb,NULL);

	w[2] = XtCreateManagedWidget("line",smeLineObjectClass,w[0],NULL,0);

	if (SLN)
		XtSetArg(args[0],XtNlabel,"Show Linenumbers       yes");
	else
		XtSetArg(args[0],XtNlabel,"Show Linenumbers        no");
	lbutt = w[2] = XtCreateManagedWidget("sln_button",smeBSBObjectClass,w[0],args,1);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) sln_cb,NULL);

	if (HEX)
		XtSetArg(args[0],XtNlabel,"Show Hexdump           yes");
	else
		XtSetArg(args[0],XtNlabel,"Show Hexdump            no");
	hbutt = w[2] = XtCreateManagedWidget("hex_button",smeBSBObjectClass,w[0],args,1);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) hex_cb,NULL);

	if (ADDEXT)
		XtSetArg(args[0],XtNlabel,"Add Extracted to List  yes");
	else
		XtSetArg(args[0],XtNlabel,"Add Extracted to List   no");
	abutt = w[2] =	XtCreateManagedWidget("addext_button",smeBSBObjectClass,w[0],args,1);
	XtAddCallback(w[2],XtNcallback,(XtCallbackProc) addext_cb,NULL);

}



void read_file(void)
{	Arg	args[1];

	if (dir_file)
		free(dir_file);
	dir_file = NULL;

	XtSetArg(args[0],XtNselectTypes,def_sel);
	XtOverrideTranslations(text,
		XtParseTranslationTable("<BtnMotion>: extend-adjust()\n\
					 <BtnUp>: extend-end(PRIMARY,CUT_BUFFER0)\n\
					 <BtnDown>: select-start()"));
	/*
	 * Feststellen ob das File comprimiert ist oder nicht
	 */
	if (mem[files].FLAG & FILE_COMPRESSED || mem[files].FLAG & FILE_ARCHIVE ||
	    SLN || HEX || mem[files].FLAG & FILE_OBJECT || mem[files].FLAG & FILE_DIR) {
		/* Comprimierte Files lesen */
		FILE	*fp;
		char	s[200], *t;
		int	size = 10000000;
		int	did, d = 0;

		t = NULL;
		*s = '\0';

		/* Feststellen ob das File comprimiert ist */
		if (mem[files].FLAG & FILE_COMPRESSED) {
			sprintf(s,"%s %s\0",TYPECOMPRESS_CMD,mem[files].filename);
			t = s;
		}

		/* Feststellen ob es sich ferner um ein Archive oder Source-file */
		if (mem[files].FLAG & FILE_ARCHIVE) {
			sprintf(s,"%s%star -tvf %s\0",s,(t ? " | " : ""),
				(t ? "-" : mem[files].filename));
			XtSetArg(args[0],XtNselectTypes,lin_sel);
			t = s;
		}
		else if (mem[files].FLAG & FILE_DIR) {
			sprintf(s,"%s %s\0",SHOWDIR_CMD,mem[files].filename);
			XtSetArg(args[0],XtNselectTypes,dir_sel);
			XtOverrideTranslations(text,
				XtParseTranslationTable("<BtnMotion>: no-op()\n\
							 <BtnUp>:no-op()\n\
							 <BtnDown>: select-start() get-file()"));
			t = s;
		}
		else if (HEX) {
			sprintf(s,"%s%sfile2hex %s%s\0",(t ? s : ""),(t ? " | " : ""),
				(t ? "" : "<"),(t ? "" : mem[files].filename));
		}
		else if (mem[files].FLAG & FILE_OBJECT) {
			sprintf(s,"%s%s%s %s\0",s,(t ? " | " : ""),
				OBJECTLISTER_CMD,(t ? "\0" : mem[files].filename));
			t = s;
		}

		if (SLN) {
			sprintf(s,"%s%s%s %s\0",s,(t ? " | " : ""),
				LINELISTER_CMD,(t ? "\0" : mem[files].filename));
		}

		if (!(fp = popen(s,"rb"))) {
			perror(mem[files].filename);
			exit(1);
		}
		if (txt)	free(txt);
		if (!(txt = (char *) malloc(size+1))) {
			pclose(fp);
			fprintf(stderr,"Error: No Memory.\n");
			exit(1);
		}
		t = txt;

		do {
			did = fread(t,1,size-1,fp);
			d += did;
			t += did;
		} while (did && d < size);

		txt[d++] = '\0';
		/* Um ein bischen schonender mit dem Speicher umzugehen, wird der nicht
		 * benoetigte Teil wieder frei gegeben. */
		if (!(txt = (char *) realloc((void *) txt,d))) {
			fprintf(stderr,"Error: Memory failure\n");
			exit(1);
		}
		pclose(fp);
	}
	else {
		int	fp,size = 10000000;
		int	did, d = 0;
		char	*t;

		if (strcmp(mem[files].filename,"-")) {
			fp = open(mem[files].filename,O_RDONLY);
			if (fp == -1) {
				perror(mem[files].filename);
				exit(1);
			}
			size = lseek(fp,0,SEEK_END);
		}
		else
			fp = 0;

		if (txt)
			free(txt);

		if (!(txt = (char *) malloc(size+2))) {
			if (fp != 0)
				close(fp);
			fprintf(stderr,"Error: No Memory.\n");
			exit(1);
		}
		t = txt;
		lseek(fp,0,SEEK_SET);

		do {
			did = read(fp,t,size);
			d += did;
			t += did;
		} while (did && d < size);

		txt[d] = '\0';
		if (fp != 0)
			close(fp);
	}
	XtSetValues(text,args,1);
}

XtCallbackProc file_but_cb(Widget w)
{	XtSetSensitive(last,TRUE);
	XtSetSensitive(w,FALSE);
	last = w;
	{	int	i = 1;

		while (i < filestoread && w != mem[i].menu)		
			i++;

		files = i;
		XtSetSensitive(last,TRUE);
		last = mem[files].menu;
		XtSetSensitive(last,FALSE);
		if (files > 1)
			XtSetSensitive(pbutt,TRUE);
		else
			XtSetSensitive(pbutt,FALSE);
		if (files < filestoread-1)
			XtSetSensitive(butt,TRUE);
		else
			XtSetSensitive(butt,FALSE);
	}

	read_file();

	/* Name des Files in Label schreiben */
	file_status();

	{	Arg	args[1];

		/* text mit Fenster assozieren */
		XtSetArg(args[0],XtNstring,txt);
		XtSetValues(text,args,1);
/*		free(txt);
*/	}
}

/* addext_cb */
XtCallbackProc addext_cb(void)
{	Arg	args[1];

	if (ADDEXT) {
		ADDEXT = FALSE;
		XtSetArg(args[0],XtNlabel,"Add Extracted to List   no");
	} else {
		ADDEXT = TRUE;
		XtSetArg(args[0],XtNlabel,"Add Extracted to List  yes");
	}

	XtSetValues(abutt,args,1);
}

/* sln_cb */
XtCallbackProc sln_cb(void)
{	Arg	args[1];

	if (SLN) {
		SLN = FALSE;
		XtSetArg(args[0],XtNlabel,"Show Linenumbers        no");
	} else {
		SLN = TRUE;
		XtSetArg(args[0],XtNlabel,"Show Linenumbers       yes");
		if (HEX) {
			Arg	largs[1];
			HEX = FALSE;
			XtSetArg(largs[0],XtNlabel,"Show Hexdump            no");
			XtSetValues(hbutt,largs,1);
		}
	}

	XtSetValues(lbutt,args,1);
	(void) file_but_cb(mem[files].menu);
}

/* sln_cb */
XtCallbackProc hex_cb(void)
{	Arg	args[1];

	if (HEX) {
		HEX = FALSE;
		XtSetArg(args[0],XtNlabel,"Show Hexdump            no");
	} else {
		HEX = TRUE;
		XtSetArg(args[0],XtNlabel,"Show Hexdump           yes");
		if (SLN) {
			Arg	largs[1];
			SLN = FALSE;
			XtSetArg(largs[0],XtNlabel,"Show Linenumbers        no");
			XtSetValues(lbutt,largs,1);
		}
	}

	XtSetValues(hbutt,args,1);
	(void) file_but_cb(mem[files].menu);
}

/* quit_cb */
XtCallbackProc quit_cb(void)
{	exit(0);
}

XtCallbackProc next_cb(void)
{	if (files+1 == filestoread)
		return;
	files++;
	if (files+1 == filestoread)
		XtSetSensitive(butt,FALSE);
	XtSetSensitive(last,TRUE);
	XtSetSensitive(pbutt,TRUE);
	last = mem[files].menu;
	XtSetSensitive(last,FALSE);

	read_file();

	/* Name des Files in Label schreiben */
	file_status();

	{	Arg	args[1];

		XtSetArg(args[0],XtNstring,txt);
		XtSetValues(text,args,1);			
/*		free(txt);
*/	}
}

XtCallbackProc prev_cb(void)
{	if (files == filesstart)
		return;
	files--;
	if (files == filesstart)
		XtSetSensitive(pbutt,FALSE);
	XtSetSensitive(last,TRUE);
	XtSetSensitive(butt,TRUE);
	last = mem[files].menu;
	XtSetSensitive(last,FALSE);

	read_file();

	/* Name des Files in Label schreiben */
	file_status();

	{	Arg	args[1];

		XtSetArg(args[0],XtNstring,txt);
		XtSetValues(text,args,1);			
/*		free(txt);
*/	}
}


/* editor aufrufen */
XtCallbackProc edit_cb(void)
{	char	*c;
	char	*f;

	if (mem[files].FLAG & FILE_DIR) {
		f = dir_file;
		XawTextUnsetSelection(text);
	}
	else
		f = mem[files].filename;

	if (!f)
		return;

	if (!(c = (char *) malloc(strlen(EDITOR)+2+strlen(f)))) {
		fprintf(stderr,"Memory short\n");
		exit(1);
	}
	sprintf(c,"%s %s&",EDITOR,f);
	system(c);
	free(c);
}

/* comprimieren/decomprimieren aufrufen */
XtCallbackProc comp_cb(void)
{	char	*d;
	int	s = strlen(mem[files].filename);
	char	*name = mem[files].filename;
	Arg	args[1];

	if (!(d = (char *) malloc(s + 30))) {
		fprintf(stderr,"Error while allocating Memory\n");
		exit(1);
	}

	if (mem[files].FLAG & FILE_DIR) {
		if (dir_file) {
			int	FLAG = identify_file(dir_file);

			/* Wenn file comprimiert, dann entcomprimieren */
			if (FLAG & FILE_COMPRESSED) {
				sprintf(d,"%s %s\0",UNCOMPRESS_CMD,dir_file);
				if (!system(d)) {
					(void) file_but_cb(mem[files].menu);
				}
			}
			else {	/* sonst comprimieren */
				sprintf(d,"%s %s\0",COMPRESS_CMD,dir_file);
				if (!system(d)) {
					(void) file_but_cb(mem[files].menu);
				}
			}
			XawTextUnsetSelection(text);
		}
	}
	else {
		/* Wenn file comprimiert, dann entcomprimieren */
		if (mem[files].FLAG & FILE_COMPRESSED) {
			sprintf(d,"%s %s\0",UNCOMPRESS_CMD,name);
			if (!system(d)) {
				mem[files].FLAG &= (~FILE_COMPRESSED);
				name[s - 2] = '\0';
				XtSetArg(args[0],XtNlabel,name);
				XtSetValues(mem[files].menu,args,1);
				file_status();
			}
		}
		else {	/* sonst comprimieren */
			sprintf(d,"%s %s\0",COMPRESS_CMD,name);
			if (!system(d)) {
				char	*nname;

				mem[files].FLAG |= FILE_COMPRESSED;
				if (!(nname = (char *) malloc(s + 4))) {
					fprintf(stderr,"Error while allocating Memory\n");
					exit(1);
				}
				sprintf(nname,"%s.z\0",name);
				mem[files].filename = nname;
				XtSetArg(args[0],XtNlabel,nname);
				XtSetValues(mem[files].menu,args,1);
				file_status();
			}
		}
	}
	free(d);
}


#ifdef HAVE_TXT2TEX
/* text editieren aufrufen */
XtCallbackProc tex_cb()
{	int	l = strlen(mem[files].filename);
	char	s[1000];
	char	d[200];
	char	*f;
	int	FLAG;

	if (mem[files].FLAG & FILE_DIR) {
		f = dir_file;
		FLAG = identify_file(f);
		XawTextUnsetSelection(text);
	}
	else {
		f = mem[files].filename;
		FLAG = mem[files].FLAG;
	}

	if (!f)
		return;

	s[0] = '\0';
	d[0] = '\0';
	if (FLAG & FILE_COMPRESSED) {
		strncpy(d,f,l-2);
		d[l-2] = '\0',
		sprintf(s,"%s %s\0",TYPECOMPRESS_CMD,f);
	}
	
	if (FLAG & FILE_SOURCE) {
		sprintf(s,"%s%stxt2tex -c %s > %s.tex\0",
			s,(d[0] == '\0' ? "" : " | "),(d[0] == '\0' ? f : ""),
			(d[0] == '\0' ? f : d));
	}
	else if (FLAG & FILE_F77) {
		sprintf(s,"%s%stxt2tex -f %s > %s.tex\0",
			s,(d[0] == '\0' ? "" : " | "),(d[0] == '\0' ? f : ""),
			(d[0] == '\0' ? f : d));
	}
	else {
		sprintf(s,"%s%stxt2tex -n %s > %s.tex\0",
			s,(d[0] == '\0' ? "" : " | "),(d[0] == '\0' ? f : ""),
			(d[0] == '\0' ? f : d));
	}

	system(s);
}
#endif

/* file loeschen */
XtCallbackProc del_cb(void)
{	int	i;
	char	*c;

	filestoread--;
	XtDestroyWidget(mem[files].menu);
	for (i = files; i < filestoread; i++) {
		Arg	args[1];

		mem[i].filename = mem[i+1].filename;
		mem[i].FLAG = mem[i+1].FLAG;
		mem[i].menu = mem[i+1].menu;
	}
	if (files < filestoread) {
		if (files == filestoread-1)
			XtSetSensitive(pbutt,FALSE);
		XtSetSensitive(mem[files].menu,FALSE);
		last = mem[files].menu;
	}
	else if (files > 1) {
		files--;
		if (files == 1)
			XtSetSensitive(butt,FALSE);
		XtSetSensitive(mem[files].menu,FALSE);
		last = mem[files].menu;
	}
	else
		quit_cb();

	read_file();

	/* Name des Files in Label schreiben */
	file_status();

	{	Arg	args[1];

		XtSetArg(args[0],XtNstring,txt);
		XtSetValues(text,args,1);			
	}		
}

/* file anhaengen */
XtCallbackProc add_cb(void)
{
	Arg	args[10];
	int	GH = 0;
	XawTextPosition	left,right;

	if (mem[files].FLAG & FILE_DIR && dir_file) {
		/* File zur Liste addieren */
		AddEntryToList(dir_file,FALSE);
		XawTextSetSelection(text,0,0);
	}
	else {
		if (!browser) {
			Widget	form, w, ww;

			/* Browser erzeugen */
			browser = XtCreatePopupShell("xmore_browser",
						transientShellWidgetClass, toplevel,
						NULL, 0);

			/* Form erzeugen */
			form = XtCreateManagedWidget("browser_form", formWidgetClass,
							browser, NULL, 0);

			/* Infolabel darauf erzeugen */
			XtSetArg(args[0],XtNleft,XtChainLeft);
			XtSetArg(args[1],XtNright,XtChainRight);
			XtSetArg(args[2],XtNtop,XtChainTop);
			XtSetArg(args[3],XtNbottom,XtChainTop);
			w = XtCreateManagedWidget("browser_label", labelWidgetClass,
						form, args, 4);

			/* Filename Label */
			XtSetArg(args[1],XtNright,XtChainLeft);
			XtSetArg(args[4],XtNfromVert, w);
			ww = XtCreateManagedWidget("browser_flabel", labelWidgetClass,
							form, args, 5);

			/* Das Filename Widget */
			XtSetArg(args[1],XtNright,XtChainRight);
			XtSetArg(args[5],XtNfromHoriz, ww);
			XtSetArg(args[6],XtNeditType, XawtextEdit);
			XtSetArg(args[7],XtNresize,XawtextResizeWidth);
			XtSetArg(args[8],XtNresizable,TRUE);
			browser_text = XtCreateManagedWidget("browser_text",
							asciiTextWidgetClass, form, args, 9);
			XtOverrideTranslations(browser_text,
				XtParseTranslationTable("<Key>Return: no-op()\n\
							 <Key>Up: beginning-of-line() \n\
							 <Key>Down: end-of-line()"));

			/* Der Ok-Button */
			XtSetArg(args[1],XtNright,XtChainLeft);
			XtSetArg(args[4],XtNfromVert, browser_text);
			ww = XtCreateManagedWidget("browser_ok",commandWidgetClass,
							form, args, 5);
			XtAddCallback(ww,XtNcallback,(XtCallbackProc) browser_ok_cb,NULL);

			/* Der Cancel-Button */
			XtSetArg(args[5],XtNfromHoriz, ww);
			w = XtCreateManagedWidget("browser_cancel",commandWidgetClass,
							form, args, 6);
			XtAddCallback(w,XtNcallback,(XtCallbackProc) browser_cancel_cb,NULL);

			GH = 1;
		}

		/* Browser zeigen */
		XtManageChild(browser);

		if (GH) {
			int	h,w;

			/* Hoehe des Browserwindows holen */
			XtSetArg(args[0],XtNheight,0);
			XtSetArg(args[1],XtNwidth,0);
			XtGetValues(browser,args,2);
			h = args[0].value;
			w = args[1].value;
			XtSetArg(args[0],XtNminHeight,h);
			XtSetArg(args[1],XtNmaxHeight,h);
			XtSetArg(args[2],XtNminWidth,w);
			XtSetValues(browser,args,3);
		}
	}
}

/* Browser wieder wegdruecken */
XtCallbackProc browser_cancel_cb(void)
{	XtUnmanageChild(browser);
}


/* File anhaengen und Browser verstecken */
XtCallbackProc browser_ok_cb(void)
{	char	*nf;
	struct	stat st;
	int	s;
	Arg	args[1];

	/* filenamen holen und Browserfenster schliessen */
	XtSetArg(args[0],XtNstring,&nf);
	XtGetValues(browser_text,args,1);
	XtUnmanageChild(browser);
	/* File existiert ? */
	s = stat(nf, &st);
	if (!s) {
		/* File zur Liste addieren */
		AddEntryToList(nf,TRUE);
	}
	
}


/* files aus einem Archive-file herausholen */
XtCallbackProc ext_cb(void)
{	XawTextPosition	left,right;
/*	{	Arg	args[1];

		XtSetArg(args[0],XtNstring,&txt);
		XtGetValues(text,args,1);	
	}
*/
	XawTextGetSelectionPos(text,&left,&right);
	if (left != right) {
		/* es wurde Text ausgewaehlt */
		char	*t = txt+left;
		char	*s = t;
		int	i = right - left;
		int	j = 0;
		char	file[200];
		char	*f;

		while (i--) {
			if (!i || *t == '\n') {
				struct stat	st;
				if (!i && *t != '\n')
					j++;
				strncpy(file,s,j);
				file[j] = '\0';
				f = strrchr(file,' ') + 1;
				/* Feststellen ob File schon existiert */
				{
					char	ss[200];
					if (mem[files].FLAG & FILE_COMPRESSED)
						sprintf(ss,"zcat %s | tar -xf - %s\0",
								mem[files].filename,f);
					else 
						sprintf(ss,"tar -xf %s %s\0",
								mem[files].filename,f);
					if (!(system(ss))) {
						if (ADDEXT) {
							AddEntryToList(f,FALSE);
						}
					}
				}
				s = t+1;
				j = 0;
			}
			else
				j++;
			t++;
		}
		XawTextUnsetSelection(text);
	}
}


void	AddEntryToList(char *filename, Boolean show)
{	Widget		w,ww;
	WidgetList	wl;
	Cardinal	cl;
	Arg		args[2];

	/* Das Listenfeld erweitern */
	filestoread++;
	if (!(mem = (mem_struct *) realloc((void *) mem,
						sizeof(mem_struct)*filestoread))) {
		fprintf(stderr,"Memory Error\n");
		exit(1);
	}

	/* Den Namen der Datei eintragen */
	if (!(mem[filestoread-1].filename = (char *) malloc(strlen(filename)+1))) {
		fprintf(stderr,"Memory Error\n");
		exit(1);
	}
	strncpy(mem[filestoread-1].filename,filename,strlen(filename));
	mem[filestoread-1].filename[strlen(filename)] = '\0';

	/* Die Fileflag bestimmen */
	mem[filestoread-1].FLAG = identify_file(filename);

	/* Neues Widget erzeugen und an das Menu dranhaengen */
	XtSetArg(args[0],XtNlabel,mem[filestoread-1].filename);
	w = XtCreateManagedWidget("file_item",smeBSBObjectClass,fm,args,1);
	XtAddCallback(w,XtNcallback,(XtCallbackProc) file_but_cb,NULL);
	mem[filestoread-1].menu = w;

	/* Den Inhalt der neuen Datei gleich anzeigen */
	if (show)
		(void) file_but_cb(w);
}


/* File aus einem Directory rauspicken und Filenamen generieren */
XtActionProc	get_file_from_text(Widget w, XEvent *e, String *s, Cardinal *c)
{	XawTextPosition	left,right;

	if (dir_file)
		free(dir_file);
	dir_file = NULL;
	XawTextGetSelectionPos(text,&left,&right);
	if (left && left != right) {
		/* es wurde Text ausgewaehlt */
		char	*t = txt+left;
		int	i = right - left;
		char	file[200];
		char	*f;
		struct	stat	st;

		/* Den Filenamen generieren */
		strncpy(file,t,i);
		file[i] = '\0';
		f = strrchr(file,' ') + 1;
		sprintf(file,"%s%s%s\0",mem[files].filename,
			(mem[files].filename[strlen(mem[files].filename)-1] == '/'
			 ? "" : "/"),f);
		/* Sicherheitshalber checken ob das File existiert und nicht
		   inzwischen geloescht wurde */
		/* File existiert ? */
		i = stat(file, &st);
		if (!i) {
			int	FLAG;
			/* File ist Ok, dann dir_file initialisieren */
			if (!(dir_file = (char *) malloc(strlen(file)+1))) {
				fprintf(stderr,"Malloc Error\n");
				exit(1);
			}
			strncpy(dir_file,file,strlen(file));
			dir_file[strlen(file)] = '\0';
			FLAG = identify_file(dir_file);
			if (!(FLAG & (FILE_COMPRESSED | FILE_ARCHIVE | FILE_OBJECT
				      | FILE_DIR))) {
				XtSetSensitive(ebutt,TRUE);
#ifdef	HAVE_TXT2TEX
				XtSetSensitive(tbutt,TRUE);
#endif
			}
			else {
				XtSetSensitive(ebutt,FALSE);
#ifdef	HAVE_TXT2TEX
				XtSetSensitive(tbutt,FALSE);
#endif
			}
			if (FLAG & FILE_DIR)
				XtSetSensitive(cbutt,FALSE);
			else {
				Arg	args[1];

				if (FLAG & FILE_COMPRESSED)
					XtSetArg(args[0],XtNlabel,"Uncompress");
				else
					XtSetArg(args[0],XtNlabel,"Compress");
				XtSetValues(cbutt,args,1);
				XtSetSensitive(cbutt,TRUE);
			}
			XtSetSensitive(xbutt,FALSE);
		}
		else {
			XtSetSensitive(cbutt,FALSE);
			XtSetSensitive(ebutt,FALSE);
			XtSetSensitive(xbutt,FALSE);
#ifdef	HAVE_TXT2TEX
			XtSetSensitive(tbutt,FALSE);			
#endif
		}
	}
	else {
		XtSetSensitive(cbutt,FALSE);
		XtSetSensitive(ebutt,FALSE);
		XtSetSensitive(xbutt,FALSE);
#ifdef	HAVE_TXT2TEX
		XtSetSensitive(tbutt,FALSE);			
#endif
	}
	if (!left && right)
		XawTextUnsetSelection(text);
}
