/* 
Copyright notice:

This is mine.  I'm only letting you use it.  Period.  Feel free to rip off
any of the code you see fit, but have the courtesy to give me credit.
Otherwise great hairy beasties will rip your eyes out and eat your flesh
when you least expect it.

Jonny Goldman <jgoldman@parc.xerox.com>

Tue Jul 17 1990
*/

/* widget.c -- handle things that make the playing field behave as a widget. */

#include "vaders.h"
#include <X11/Xaw/Paned.h>

typedef struct _BaseRec {
  int x;			/* Location. */
  int v;			/* velocity */
  int width, height;		/* box of this base. */
  XImage *shape_image;		/* an XImage for the spaceship */
} BaseRec, *Base;

extern Base base;

void HandleFocus();
void HandleStruct();
void Pause();

static XtActionsRec actions[] = {
    {"grab-focus",	(XtActionProc) TakeFocus},
    {"left",		MoveLeft},
    {"right",		MoveRight},
    {"stop",		Stop},
    {"fire",		Fire},
    {"pause",		Pause},
    {"quit",		Quit},
};

static char defaultTranslation[] =
     "<Btn1Down>:	left()\n\
     <Btn1Up>:		stop()\n\
     <Btn2Down>:	fire()\n\
     <Btn3Down>:	right()\n\
     <Btn3Up>:		stop()\n\
     <KeyDown>z:	fire()\n\
     <KeyDown>\\,:	left()\n\
     <KeyUp>\\,:	stop()\n\
     <KeyDown>.:	right()\n\
     <KeyUp>.:		stop()\n\
     <KeyDown>\\ :	fire()\n\
     <KeyDown>p:	pause()\n\
     <KeyDown>q:	quit()";


static void ClassInitialize() {}

static void Initialize(request, w)
Widget request, w;
{
    gamewidget = (VadersWidget) w;
    XtAddEventHandler(toplevel, (EventMask) FocusChangeMask, FALSE,
		      HandleFocus, (Opaque) NULL);
    XtAddEventHandler(toplevel, (EventMask) StructureNotifyMask, FALSE,
		      HandleStruct, (Opaque) NULL);
}


static void Realize(w, valueMask, attributes)
Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
  int i;
  XGCValues backvalues;
  XGCValues basevalues;
  XGCValues buildingvalues;
  XGCValues vader1values;
  XGCValues vader2values;
  XGCValues vader3values;
  XGCValues shotvalues;
  XGCValues scorevalues;
  XGCValues spacervalues;

  /*
   * Safety check.
   */

  if (w->core.width == 0) w->core.width = 1;
  if (w->core.height == 0) w->core.height = 1;

  XtCreateWindow(w, (unsigned int) InputOutput, (Visual *) CopyFromParent,
		 *valueMask, attributes);

  gamewidth = w->core.width;
  gameheight = w->core.height;
  gamewindow = w->core.window;

  backvalues.background = defaultback;
  backvalues.foreground = defaultback;
  backgc = XCreateGC(dpy, gamewindow,
		     (XtGCMask) GCForeground | GCBackground, &backvalues);
  XSetFunction(dpy, backgc, GXcopy);
  basevalues.background = defaultback;
  basevalues.foreground = basepixel;
  basegc = XCreateGC(dpy, gamewindow,
		     (XtGCMask) GCForeground | GCBackground, &basevalues);
  XSetFunction(dpy, basegc, GXcopy);
  buildingvalues.background = defaultback;
  buildingvalues.foreground = buildingpixel;
  buildinggc = XCreateGC(dpy, gamewindow,
		     (XtGCMask) GCForeground | GCBackground, &buildingvalues);
  XSetFunction(dpy, buildinggc, GXcopy);
  vader1values.background = defaultback;
  vader1values.foreground = vader1pixel;
  vadergc[0] = XCreateGC(dpy, gamewindow,
			 (XtGCMask) GCForeground | GCBackground, &vader1values);
  XSetFunction(dpy, vadergc[0], GXcopy);
  vader2values.background = defaultback;
  vader2values.foreground = vader2pixel;
  vadergc[1] = XCreateGC(dpy, gamewindow,
			 (XtGCMask) GCForeground | GCBackground, &vader2values);
  XSetFunction(dpy, vadergc[1], GXcopy);
  vader3values.background = defaultback;
  vader3values.foreground = vader3pixel;
  vadergc[2] = XCreateGC(dpy, gamewindow,
			 (XtGCMask) GCForeground | GCBackground, &vader3values);
  XSetFunction(dpy, vadergc[2], GXcopy);
  shotvalues.background = defaultback;
  shotvalues.foreground = shotpixel;
  shotgc = XCreateGC(dpy, gamewindow,
		     (XtGCMask) GCForeground | GCBackground, &shotvalues);
  XSetFunction(dpy, shotgc, GXcopy);
  scorevalues.background = defaultback;
  scorevalues.foreground = scorepixel;
  scoregc = XCreateGC(dpy, gamewindow,
		     (XtGCMask) GCForeground | GCBackground, &scorevalues);
  XSetFunction(dpy, scoregc, GXcopy);
  shotvalues.background = defaultback;
  shotvalues.foreground = vshotpixel;
  vshotgc = XCreateGC(dpy, gamewindow,
		      (XtGCMask) GCForeground | GCBackground, &shotvalues);
  XSetFunction(dpy, vshotgc, GXcopy);
  spacervalues.background = defaultback;
  spacervalues.foreground = spacerpixel;
  spacergc = XCreateGC(dpy, gamewindow,
		       (XtGCMask) GCForeground | GCBackground, &spacervalues);
  XSetFunction(dpy, spacergc, GXcopy);

  InitBase();
  InitBuildings();
  InitVaders();
  InitSpacers();
  InitShot();
  InitScore();
}

void SuspendTimers()
{
  if (basetimerid) 
    XtRemoveTimeOut(basetimerid);
  basetimerid = NULL;
  if (vadertimerid)
    XtRemoveTimeOut(vadertimerid);
  vadertimerid = NULL;
  if (shottimerid)
    XtRemoveTimeOut(shottimerid);
  shottimerid = NULL;
  if (vshottimerid)
    XtRemoveTimeOut(vshottimerid);
  vshottimerid = NULL;
  if (spacertimerid)
    XtRemoveTimeOut(spacertimerid);
  spacertimerid = NULL;
}

void EnableTimers()
{
  if (basetimerid == NULL)
    basetimerid = XtAddTimeOut(basewait, MoveBase, (Opaque) MoveBase);
  if (vadertimerid == NULL)
    vadertimerid = XtAddTimeOut(vaderwait, MoveVaders,
			       (Opaque) MoveVaders);
  if(spacertimerid == NULL)
    spacertimerid = XtAddTimeOut(spacerwait, MoveSpacer,
				 (Opaque) MoveSpacer);
  if (shottimerid == NULL)
    shottimerid = XtAddTimeOut(shotwait, MoveShots,
			       (Opaque) MoveShots);
  if (vshottimerid == NULL)
    vshottimerid = XtAddTimeOut(vshotwait, MoveVshots,
				(Opaque) MoveVshots);
}

static void HandleExpose(w, event)
Widget w;
XEvent *event;
{
 /*  if (event->xexpose.count) return; */
  XSync(dpy, 0);
  /* suspend events */
  SuspendTimers();
  /* rebuild the display */
  XSync(dpy, 0);
  XClearWindow(dpy, gamewindow);
  if (!basedestroyed)
    PaintBase(basegc);
  if(spacer_shown)
    PaintSpacer(spacergc);
  PaintAllVaders();
  PaintAllShots();
  PaintBasesLeft();
  DrawBuildings();
  PaintScore();
  XSync(dpy, 0);
  /* enable events */
  if(!paused) 
    EnableTimers();
}

void Quit()
{
    XCloseDisplay(dpy);
    exit(0);
}

int paused = 1;

static void HandleFocus(w, closure, event)
Widget w;
Opaque closure;
XEvent *event;
{
}

void Pause(w, closure, event)
Widget w;
Opaque closure;
XEvent *event;
{
  if (paused) {
    paused = 0;
    EnableTimers();
  } else {
    paused = 1;
    SuspendTimers();
  }
}


static void HandleStruct(w, closure, event)
Widget w;
Opaque closure;
XEvent *event;
{
}

static void Destroy() {}

static void Resize(w) 
Widget w;
{
  /* 
   * Resize the playing field.
   */
  gamewidth = w->core.width-3*(base->width+2);
  gameheight = w->core.height;
}

static Boolean SetValues() {}

static Boolean TakeFocus()
{
    XSetInputFocus(dpy, gamewindow, RevertToPointerRoot, CurrentTime);
    return TRUE;
}

VadersClassRec vadersClassRec = {
  {
/* core_class fields      */
    /* superclass         */    (WidgetClass) &widgetClassRec,
    /* class_name         */    "XVaders",
    /* widget_size        */    sizeof(VadersRec),
    /* class_initialize   */    ClassInitialize,
    /* class_part_initiali*/	NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook	  */	NULL,
    /* realize            */    Realize,
    /* actions            */    actions,
    /* num_actions        */    XtNumber(actions),
    /* resources          */    NULL,
    /* num_resources      */    (Cardinal) 0,
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    Destroy,
    /* resize             */    Resize,
    /* expose             */    HandleExpose,
    /* set_values         */    SetValues,
    /* set_values_hook	  */	NULL,
    /* set_values_almost  */	NULL,
    /* get_values_hook	  */	NULL,
    /* accept_focus       */    TakeFocus,
    /* version		  */	XtVersion,
    /* callback_private	  */	NULL,
    /* tm_table		  */	defaultTranslation,
    /* query_geometry	  */	NULL,
    /* display_accelerator*/	NULL,
    /* extension`	  */	NULL,
  },{
    /* mumble             */    0       /* Make C compiler happy   */
  }
};

WidgetClass vadersWidgetClass = (WidgetClass)&vadersClassRec;
