/* 
Copyright notice:

This is mine.  I'm only letting you use it.  Period.  Feel free to rip off
any of the code you see fit, but have the courtesy to give me credit.
Otherwise great hairy beasties will rip your eyes out and eat your flesh
when you least expect it.

Jonny Goldman <jgoldman@parc.xerox.com>

Tue Jul 17 1990
*/

/* base.c - handle movement, etc. of the base. */

#include "vaders.h"

extern int paused;
Boolean basedestroyed;

static int ex, ey;		/* Where we're painting an explosion. */
static Boolean showingexplosion = FALSE;

void DrawBuildings();

#define BASEY (gameheight-base->height)

typedef struct _BaseRec {
  int x;			/* Location. */
  int v;			/* velocity */
  int width, height;		/* box of this base. */
  XImage *shape_image;		/* an XImage for the spaceship */
} BaseRec, *Base;

BaseRec baserec;

Base base = &baserec;

XImage *explosion;

#define BaseNearPoint(base, x, y)	\
  ((base)->x <= (x) && (x) < (base)->x + (base)->width  && \
   y <= BASEY + (base)->height && y > BASEY)

int ReadBaseImage()
{
  unsigned int width, height;
  int x_hot, y_hot;
  char *data;
  int i, status;

  status = XmuReadBitmapDataFromFile ("base.bit",
				      &width, &height, &data,
				      &x_hot, &y_hot);

  if (status != BitmapSuccess) return status;

  base->shape_image = XCreateImage(dpy,
				   DefaultVisual(dpy, DefaultScreen(dpy)),
				   1,
				   XYBitmap,
				   0,
				   data,
				   width, height,
				   8, 0);
  
  base->width = width;
  base->height = height;
  base->shape_image->bitmap_bit_order = LSBFirst;
  base->shape_image->byte_order = LSBFirst;

  status = XmuReadBitmapDataFromFile ("explode.bit",
				      &width, &height, &data,
				      &x_hot, &y_hot);

  if (status != BitmapSuccess) return status;

  explosion = XCreateImage(dpy,
			   DefaultVisual(dpy, DefaultScreen(dpy)),
			   1,
			   XYBitmap,
			   0,
			   data,
			   width, height,
			   8, 0);
  explosion->bitmap_bit_order = LSBFirst;
  explosion->byte_order = LSBFirst;
  
  return BitmapSuccess;
}

void InitBase()
{
    if( ReadBaseImage() != BitmapSuccess) {
      fprintf(stderr, "Error reading base image.\n");
      exit(20);
    }
    basedestroyed = TRUE;
    showingexplosion = FALSE;
    basetimerid = NULL;
    base->v = 0;
}



void PaintBase(gc)
GC gc;
{
  XPutImage(dpy, gamewindow, gc, base->shape_image,
	    0, 0, base->x, gameheight-base->height, base->width, base->height);
}


ShowBase(i, gc)
int i;
GC gc;
{
  XPutImage(dpy, gamewindow, gc, base->shape_image,
	    0, 0, gamewidth+i*(base->width+2), 70,
	    base->width, base->height);
}

PaintBasesLeft()
{
  int i;
  XDrawString(dpy, gamewindow, scoregc, gamewidth, 55, "Bases", 5);
  for(i = 0; i < basesleft; i++) {
    ShowBase(i, basegc);
  }
}


void ShowExplosion(gc)
GC gc;
{
  XPutImage(dpy, gamewindow, gc, explosion,
	      0, 0, base->x, gameheight-base->height, explosion->width, explosion->height);
}

void DestroyBase()
{
  if(!paused) {
    PaintBase(backgc);
    basedestroyed = TRUE;
    showingexplosion = TRUE;
    ShowExplosion(basegc);
    if (basetimerid) XtRemoveTimeOut(basetimerid);
    basetimerid = XtAddTimeOut(1000, MoveBase, (Opaque) MoveBase);
  }
}


Boolean ShotHitsBase(x,y)
int x,y;
{
  if(!basedestroyed && BaseNearPoint(base, x, y)) {
    DestroyBase();
    return TRUE;
  }
  return FALSE;
}

ResetGame()
{
  spacer_shown = 0;
  SuspendTimers();
  XClearWindow(dpy, gamewindow);
  paused = 1;
  InitScore();
  basesleft--;
  level = 1;
  CreateVaders(level);
  spacer_counter = 1000;
  numshots = 0;
  numvshots = 0;
  PaintAllVaders();
  PaintBasesLeft();
  InitBuildings();
  DrawBuildings();
  lastscore = 0;
  PaintScore();
  XSync(dpy, 0);
  basedestroyed = FALSE;
  base->x = base->v = 0;
  showingexplosion = FALSE;
  PaintBase(basegc);
}

void MoveBase(closure, id)
Opaque closure;
XtIntervalId id;
{
  int i, j, newx, newy;
  if (closure != (Opaque) MoveBase) return;
  if(!paused) {
    if (basedestroyed) {
      if (showingexplosion) {
	ShowExplosion(backgc);
	showingexplosion = FALSE;
	basetimerid = XtAddTimeOut(2000, MoveBase, (Opaque) MoveBase);
	return;
      }
      if (basesleft <= 0) {
	ResetGame();
	return;
      }
      base->x = 0;
      basesleft--;
      ShowBase(basesleft, backgc);
      PaintBase(basegc);
      PaintScore();
      basedestroyed = FALSE;
      base->v = 0;
    }

    if (!paused)
      basetimerid = XtAddTimeOut(basewait, MoveBase, (Opaque) MoveBase);
    if(base->v) {
      PaintBase(backgc);
      base->x += base->v;
      base->x = (base->x < 0) ? 0 :
      ((base->x > gamewidth-base->width) ? gamewidth-base->width : base->x);
      PaintBase(basegc);
    }
  }
}

void MoveLeft()
{
  if(!paused) base->v= -1;
}


void MoveRight()
{
  if(!paused) base->v = 1;
}


void Stop()
{
  if(!paused)
    base->v = 0;
}


void Fire()
{
    if (!basedestroyed&&!paused) AddShot(base->x+base->width/2, gameheight-base->height);
}

/* this part is for the buildings */

#define NUMBUILDINGS 4
#define HUNKROWS 4
#define NUMHUNKS 10
#define HUNKWIDTH 2
#define HUNKHEIGHT 4
#define buildingwidth HUNKWIDTH*NUMHUNKS
#define buildingheight HUNKHEIGHT*HUNKROWS

typedef struct {
  int x,y;
  Boolean hunks[HUNKROWS][NUMHUNKS];
} BuildingRec, *Building;

BuildingRec buildings[NUMBUILDINGS];


void DrawBuildingHunk(building, r, c, gc)
Building building;
int r,c;
GC gc;
{
  int x, y, w, h;

  x = building->x+c*HUNKWIDTH;
  y = gameheight-45+r*HUNKHEIGHT;

  XFillRectangle(dpy, gamewindow, gc, x, y, HUNKWIDTH, HUNKHEIGHT);
}

void ToastHunk(building,r,c)
Building building;
int r,c;
{
  building->hunks[r][c] = FALSE;
  DrawBuildingHunk(building, r, c, backgc);
}

Boolean ShotHitsBuilding(x, y)
int x,y;
{
  int i, r, c;
  Building building;

  for(i=0; i< NUMBUILDINGS; i++) {
    building = &buildings[i];
    if(x>=building->x && x<building->x+buildingwidth &&
       y>=gameheight-45 && y<gameheight-45+buildingheight) {
      r = (y-(gameheight-45))/HUNKHEIGHT;
      c = (x-building->x)/HUNKWIDTH;
      if (r<0 || r>=HUNKROWS)
	printf("Error in row");
      if (c<0 || c>=NUMHUNKS)
	printf("Error in column");
      if(building->hunks[r][c]) {
	ToastHunk(building, r,c);
	return TRUE;
      }
      return FALSE;
    }
  }
  return FALSE;
}

InitBuildings()
{
  int i, j, k;

  for(i=0; i< NUMBUILDINGS; i++) {
    buildings[i].x = i*((gamewidth ?
			 (VWIDTH -(3*(base->width+3))-70) :
			 (gamewidth-(3*(base->width+3))-70)))/4+35;
    for (j=0; j<HUNKROWS; j++)
      for (k = 0; k < NUMHUNKS; k++) 
	buildings[i].hunks[j][k] = TRUE;
  }
  j--;

  for(i=0; i< NUMBUILDINGS; i++) {
    buildings[i].hunks[0][0] = FALSE;
    buildings[i].hunks[0][NUMHUNKS-1] = FALSE;
    for (k = 3; k < NUMHUNKS-3; k++) 
	buildings[i].hunks[j][k] = FALSE;
  }
}

void DrawBuildings()
{
  int i, j, k;

  for(i=0; i< NUMBUILDINGS; i++) {
    for (j=0; j<HUNKROWS; j++)
      for (k = 0; k < NUMHUNKS; k++) 
	if(buildings[i].hunks[j][k]) DrawBuildingHunk(&buildings[i], j, k, buildinggc);
  }
}
