/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */


#include <stdio.h>
#include <unistd.h>
#ifndef COHERENT
#include <stdlib.h>
#endif

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "struct.h"
#include "config.h"

/*
 * Global variables
 */
extern	Widget	dialog;			/* Das Dialogwidget */
extern	Widget	text_1, text_2;		/* Zum Verschieben braucht man 2 Text,
					   sonst nur einen */
#ifdef	HAS_QUOTA
extern	Widget	quota_label;		/* Fuer die Quotas einen Label */
#endif
extern	Pixmap	Icon_Move_PM;		/* Pixmap mit dem MoveIcon */
extern	Pixmap	icon_pixmap;		/* Zeiger auf die Pixmap fuer das IconsWidget */

extern	Boolean		FILE_CHANGED;
extern	Boolean		DIR_CHANGED;
extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Dir_Glyph	*selc_g;

/*
 * Function Prototypes
 */
void	init_move      (char *from, char *to);
void	exec_move_cb   (void);
void	exec_move      (char *from, char *to);

extern	Widget		makeDialog     (Dimension text,
					char *label1, char *label2,
					char *text1, char *text2,
					char *title, Boolean cancel, Boolean OVERRIDE);
extern	XtActionProc	refresh_files  (Widget w, XExposeEvent *e,
					String *s, Cardinal *c);
extern	void		hide_dialog    (void);
extern	void		WARNING	       (char *text);
extern	void		setSize	       (void);

extern	void		refreshFolderByPathname (char *path);
#ifdef	HAS_QUOTA
extern	void		showQuota      (Widget w);
#endif


/*********************************************************
 * name:	init_move
 * description:	Files verschieben
 * input:	char *from	- Quellfile
 *		char *to	- Zielfile
 * output:	none
 * date:	10.6.93
 *********************************************************/
void	init_move (char *from, char *to)
{
	Widget	but;

	/*
	 * Das Dialogfenster erzeugen
	 */
	icon_pixmap = Icon_Move_PM;
	but = makeDialog(2,"From :","To   :",from,to,"Moving & Renaming Files",TRUE,
				FALSE);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) exec_move_cb,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);

	/*
	 * Max und Minsize setzen
	 */
	setSize();
}


/*********************************************************
 * name:	exec_move_cb
 * description:	Ausfuehren der Verschiebeoperation
 * input:	nichts
 * output:	nichts
 * date:	14.6.93
 *********************************************************/
void	exec_move_cb (void)
{
	char	*from, *to;
	Arg	args[1];
	char	buf[1024];

	/*
	 * Die Texte der beiden Textfelder holen
	 */
	XtSetArg(args[0],XtNstring,&from);
	XtGetValues(text_1,args,1);

	XtSetArg(args[0],XtNstring,&to);
	XtGetValues(text_2,args,1);

	/*
	 * Ueberpruefen ob in beiden ein Text steht, sonst
	 * Warnung ausgeben
	 */
	if (!strlen(from) || !strlen(to)) {
		WARNING ("Insuffisant Arguments.\nOperation aborted.");
		return;
	}
	exec_move(from,to);
}

/*********************************************************
 * name:	exec_move
 * description:	Ausfuehren der Verschiebeoperation
 * input:	nichts
 * output:	nichts
 * date:	14.6.93
 *********************************************************/
void	exec_move (char *from, char *to)
{
	char	buf[1024];

	/*
	 * Befehl generieren und ausfuehren
	 */
	sprintf(buf,"mv -f %s %s",from,to);

	if (SYSTEM(buf)) {
		WARNING ("Moving files failed.\nNo changes made.");
		return;
	}
	else {
		/*
		 * Dialogfenster loeschen
		 */
		if (dialog)
			XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig
		 */
		/* Zielfolder oder Dir refreshen falls dargestellt */
		refreshFolderByPathname (from);

		/* Quellfolder oder Dir refreshen falls dargestellt */
		refreshFolderByPathname (to);
#ifdef	HAS_QUOTA
		showQuota(quota_label);
#endif
	}
}

