.TH XBOING 6 "August 1993" "X Version 11"
.SH NAME

\fIxboing\fP \- An X Window System based blockout clone. V1.6

.SH SYNOPSIS

\fIxboing\fP [-version] [-usage] [-help] [-sync] [-display <displayName>] [-speed <1-10>] [-scores] [-keys] [-sound] [-setup] [-nosfx] [-pointergrab] [-maxvol <1-100>] [-startlevel <1-MAXLEVELS>]

    -speed <n>         - The game speed, 1 - 9. 9=Fast
    -maxvol <n>        - The maximum volume as percentage
    -startlevel <n>    - The starting level for game.
    -help              - Produce this help message.
    -sync              - Turn on X synchronisation.
    -usage             - Print a brief help message.
    -version           - Print out the current version.
    -scores            - Print out current highscores.
    -keys              - Use keys instead of mouse control.
    -sound             - Turn audio ON for game.
    -setup             - Print setup information.
    -nosfx             - Turn off special effects.
    -pointergrab       - Turn pointer grabbing on.
    -display <display> - Set the display for the game.

.SH DESCRIPTION

\fIXBoing\fP is a simple blockout type game where you have a paddle which you control to bounce a ball around the game area destroying blocks with the proton ball. 

Each block carries a different point value. The more blocks you destroy, the better your score. The person with the highest score wins.

The play area is filled with blocks and other objects. You have a paddle that
can move from left to right at the bottom of the arena. You move the paddle
so that the proton ball bounces around blowing up blocks does not go past the
paddle and out the bottom, much like a pinball game.

The blocks exhibit different behaviour. The bomb block when hit will explode all
blocks around it. If another bomb is beside it then it will go off also. The
solid wall brick will not explode unless next a bomb. The ammunition block will
give you four bullets and so on. Special blocks such as reverse and machine gun will only last for one level.

There are random blocks that change their colour and therefore their points every now and then. They add a bit of change to the levels.

There is a pirate symbol that will kill your ball if touched. You can shoot this block 3 times to kill it but you will lose 1000 points. Keep away from the Death block, it kills your ball!
 
The walls off block will turn the wall bounce off on both the left and right side of the playing area. This will mean the ball will not bounce off but continue through the wall and wrap around to the other side respectively.

The reverse block will when hit reverse the controls to the paddle. This block should be avoided as it makes the game really hard. Hitting another reverse while already in reverse mode will turn it off.

The teleport block will teleport the ball somewhere else on that level. It will not place you too close to the bottom of the screen or on another block.

The sticky paddle block will stick the ball to your paddle each time it is hit and wait until you press space to shoot it off again. This can be a #$%$#@! and also useful for lining up shots for hard bricks.

There is a machine gun block that allows you to shoot much faster. Note that you will also go through your bullets at a great rate. Can be fun to let off a burst every now and then. Erases counter blocks very fast.

An extra ball symbol may appear and when shot or hit with another ball it will give you an extra ball!

There is a shrink paddle block that will shrink you paddle to a smaller size for the level. If you currently have the smallest paddle then it has no effect.

There is an expand paddle block that will grow you paddle to a larger size for the level. If you currently have the largest paddle then it has no effect.

You can use the bullets to shoot the last pesky blocks or to collet lots of
You can use the bullets to shoot the last pesky blocks or to collet lots of
bonus coins. You will be given 4 bullets when a new level starts. If you lose
a ball you will be given a token 2 bullets. Use bullets wisely as you will
hate yourself when there is one brick left and the ball is missing it for ever.

Throughout the game the bonus coins will appear. Collect these for bonus points when the level is finished. Sometimes the coin may appear as a x2 or x4 symbol which will indicate that the scoring from now onwards will be multiplied by 2 or 4 respectively. Note: if you get a x2 then x4 then x2 you will go back to x2 mode. Also note that this x2 or x4 mode will be disabled after each ball death.

If you collect more than 10 bonuses during a level the killer mode is activated which will turn the ball red and the ball will plough through all blocks except the solid ones and finish off the level very quickly. You will also receive the SUPER BONUS on the bonus screen.

The bonus screen will tell you how you went in the last level. Your bonuses
will be added and the bullet and level bonus will be added. You get 500 points
for each bullet not used. You get 3000 points for each bonus and if you get
more than 10 bonuses you get a SUPER BONUS of 50000 points. You also get a new
ball every 100,000 points. Pressing space will skip the bonus animations when
the bonus screen appears. Your bonus score will still be added.

There is a level timer that counts down while playing the level. If you don't
complete the level in time you will not get the time bonus which is 100 points
per second remaining. You will also miss out on the level bonus if your time runs out.

The ball will be automatically shot off the paddle after about 5 seconds unless you press the space bar. You can always press P to pause the game.

If the ball gets stuck in an infinite loop it will automatically tilt the board if the ball hasn't hit the paddle after a certain time span. The time span is about 8 seconds I think.

XBoing was started like many other projects to learn Xlib better. I had the
XPM library and was already using it in a Motif application. I thought that it
would be cool to have nice colour pictures/animations in an Xlib game. So I
did. Without the XPM library I would be still playing with the colours I think.

.SH OPTIONS

The \fIspeed\fP option will adjust the speed of the overall game. It will except integer numbers between 1 and 9. This option is a little dodgy. The speed of the game can be changed from within the game as well. See Game Control. The default value is 1.

The \fImaxvol\fP option allows you to adjust the maximum volume to be used for the sound effects if sound is supported. It doesn't mean all sounds will be this volume but they will use that volume as the top volume to scale against.

The \fIstartlevel\fP option allows you to set the starting level for your games. Note that when your score is placed in the highscore table the level number is the number of levels completed and not the level number attained. Also, in the bonus screen your level bonus will be the number of levels completed multiplied by the level bonus value and not the current level number!

The \fIhelp\fP option will display a brief one line description of all the command line options used with xboing.

The \fIsync\fP option will turn on the X Window System synchronisation of all Xlib calls which means that all calls are flushed by the X server before continuing. This will cause the game to become slower but enable some debugging. The default is OFF.

The \fIusage\fP option will print a very brief synopsis of all the command line options and there value ranges.

The \fIversion\fP option prints the version of xboing that you are running.

The \fIscores\fP option will print both the roll of honour and your personal best scores to standard out. This can be useful if you are not running the program on an X window display and still want to see what the scores are.

The \fIkeys\fP option will enable the use of the keyboard for game control. Within the game you may press <g> to toggle between mouse and key control. The default is MOUSE control.

The \fIsound\fP option will enable sound to be turned on if possible. The default is OFF.

The \fIsetup\fP option is useful when you have just compiled the program. It will display the paths of the level & sound directories and also give you some information on other things.

The \fInosfx\fP option will turn OFF special effects. The special effect in question at this stage is the explosion shake. Turning it off will speed the game up a little bit. The default is ON. Servers without backing store will have it turn off automatically as the shaking is shocking.

The \fIpointergrab\fP option will grab the pointer when the game is visible. This has the effect of stopping you move the pointer outside the game window. This is useful as it constrains the mouse and you don't get colourmap flashes. The default is OFF.

The \fIdisplay\fP option will allow you to force the game to be viewed on another display. The format of the display name is <xserver:0.0> like most other programs where xserver is the name of the display. The default is your display of course.

You may also set three environment variables used by xboing. They specify the location of the level files, sounds and the highscore file. They are listed below.

XBOING_SCORE_FILE = the highscore file to be used.
XBOING_LEVELS_DIR = the directory containing the levels.
XBOING_SOUND_DIR  = the directory containing the sounds.

They will override the settings that are compiled into the program.

.SH "GAME CONTROL"
.PP
You must have specified "-keys" on the command line to use the keys for
the paddle control. The default is to use the mouse control method.
.nf

J = Paddle Left
LeftArrow = Paddle Left
K = Shoot bullet
L = Paddle Right
RightArrow = Paddle Right

All Mouse Buttons = Shoot Bullet/Start ball

Use the mouse to move the paddle left and right by moving the mouse 
left and right. The paddle will follow the mouse pointer. This is
the best method and easiest to use by far.

Space   = Start game
Escape  = End game and return to introduction.
i       = iconify the game and pause.
H       = View roll of honour.
h       = View personal highscores.
p       = Pause game.
d       = Kill the ball.
a       = Toggle audio on/off
s       = Toggle special effects on/off
c       = Cycle through the intro screens.
1-9    = Game speed where 9 is fastest.
q       = Quit XBoing

Note: Highscores are saved at the end of each game.
.fi
.PP
.SH SCORING

Each blocks has a certain point score. Some blocks such as the counter block will have more than one score associated with it.

.nf
red = 100
blue = 110
green = 120
yellow = 140
tan = 130
purple = 150
bomb = 50 plus the surrounding blocks points
wall = 0
pirate = 100
reverse = 100
ammo = 50 plus bullets
counter = 200 (each number). 
.fi

Each time the paddle is hit with the ball your earn 10 points. I'm nice.

There are death symbols (a pirate) that when hit by a ball will kill the ball. You can shoot them but you will lose 1000 points.

The bonus coins are 3000 points - but only added to score if you reach the end of the level and go through the bonus screen.

If you collect more than 10 bonus coins you get a Super Bonus of 50,000 points. Each remaining bullet after a level is worth 500 points.

At the end of each level you are awarded a level bouns which is level <n> x 1000 points. So for level 20 you get 20,000 points! If you fail to complete the level in the time allotted you will not receive a level bonus.

There are now two highscore files. One displays the global scores which will be your best score to date. The other is a personal high score table with all your attempts.

.SH "SOUND SUPPORT"

Xboing has limited support for sound. It has sound code for the following machines :-

HP, SUN, NCD Xterminals, LINUX PC Soundblaster

Most support and use the SUN .au format sound files. The linux version just sends the data down to the audio device which may cause slight clicking sounds due to the audio file header. Future versions of xboing will support other machines if patches are sent to me or if I learn the sound format. SGI will be next but they have their own format, argghh. I am not going to have heaps of converted files all over the place in different formats as the archive would be HUGE.

.SH LEVELS

The levels are not increasingly harder to play - some are but some are easy. This is because it takes ages to create and design levels. The paddle does get smaller as the game goes on. This makes it REALLY hard. I may also add a ball speedup feature.

The level data is a simple ASCII file format that can be edited. The levels
are loaded when required from the directory specified when the game was made.

You can create more levels if you like making sure that they are in the correct
format and that they have a correct filename format.

Copy level0.data to level??.data and use that for the editing of new levels.

level format:	(case sensitive)

    w = wall block
    r = red block
    g = green block
    b = blue block
    t = tan block
    p = purple block
    y = yellow block
    X = Bomb
    B = Ammo
    . = blank
    D = Death
    R = Reverse
    H = Teleport
    L = Extra ball
    M = Machine Gun
    W = Walls off
    ? = Random block
    m = Multiple balls
    s = sticky block
    < = Shrink paddle block
    > = Grow paddle block

The format of the level is shown in the newlevel.data file in the source distribution in the levels directory.

Make sure you have a level title and a time bonus in seconds.

.SH NOTES

Obatin all new versions from export.lcs.mit.edu or a mirror site.

.SH REDISTRIBUTION 

(c) Copyright 1993, Justin C. Kibell, All Rights Reserved

Permission to use, copy, modify, and distribute this software and its documentation without written agreement is hereby granted. You cannot sell this software without written permission from the author. This entire copyright notice must appear in all copies of this software.

IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE AUTHOR HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

.SH AUTHOR

Justin C. Kibell - Systems Programmer - CATT Centre CITRI Melbourne - Victoria - Australia.  email: jck@citri.edu.au
SnailMail: 1/17 Albert Road, North Warrandyte, Victoria, Australia, 3113

Computer Science Graduate - Royal Melbourne Institute of Technology (RMIT) - Australia

.SH BUGS

See TODO and CHANGES documents in source distribution for list of bugs and bug fixes. 

Mail all bug reports/suggestions to jck@citri.edu.au specifying the version and machine type you are using. Use 'uname -a' to explain the machine type. Please note the version of X11 that you have installed as well, ie: X11R5, X11R4, etc.

Please note that xboing will run like a pig on the xnews X server distributed with Sun machines. Please try to use the MIT X Server that comes with the X Window System.
