#ifndef _SFX_H_
#define _SFX_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>

/*
 *  Constants and macros:
 */

#define SFX_NONE        0
#define SFX_SCROLL_ON   1
#define SFX_SCROLL_OFF  2
#define SFX_DOTS        3
#define SFX_SHAKE      	4
#define SFX_BLOCKFILL  	5
#define SFX_SCATTER  	6

/*
 *  Type declarations:
 */

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void SetSfxEndFrame(int endFrame);
void changeSfxMode(int newMode);
int oldSfxMode(void);
int currentSfxMode(void);
int WindowShakeEffect(Display *display, Window window);
int getSpecialEffects(Display *display);
void useSpecialEffects(int state);
#else
void useSpecialEffects();
int getSpecialEffects();
void SetSfxEndFrame();
void changeSfxMode();
int oldSfxMode();
int currentSfxMode();
int WindowShakeEffect();
#endif


#endif
