#include "copyright.h"

/*
 *  Include file dependencies:
 */

#include <stdio.h>
#ifndef COHERENT
#include <stdlib.h>
#include <stddef.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <xpm.h>

#include "error.h"
#include "init.h"
#include "stage.h"
#include "score.h"
#include "blocks.h"
#include "ball.h"
#include "main.h"
#include "mess.h"
#include "intro.h"

#include "sfx.h"

/*
 *  Internal macro definitions:
 */

#define SHAKE_DELAY			5
#define SCROLL_ON_DELAY		3
#define SCROLL_OFF_DELAY	3
#define SCROLL_ON_INC		11
#define SCROLL_OFF_INC		11

/*
 *  Internal type declarations:
 */

/*
 *  Internal variable declarations:
 */

static int sfxEndFrame, useSfx;
int modeSfx, oldModeSfx;

#if NeedFunctionPrototypes
void useSpecialEffects(int state)
#else
void useSpecialEffects(state)
	int state;
#endif
{
	/* Set the state of the special effects - True = use */
	/* Of course - if the sfx are not possible then no effect */
	useSfx = state;
}

#if NeedFunctionPrototypes
int getSpecialEffects(Display *display)
#else
int getSpecialEffects(display)
	Display *display;
#endif
{
	/* Only shake around if the server has backing store on */
	if (DoesBackingStore(XDefaultScreenOfDisplay(display)) != Always)
		return -1;

	/* Return special effects state - on or off */
	return useSfx;
}

#if NeedFunctionPrototypes
void changeSfxMode(int newMode)
#else
void changeSfxMode(newMode)
	int newMode;
#endif
{
	oldModeSfx = modeSfx;
	modeSfx = newMode;
}

#if NeedFunctionPrototypes
int currentSfxMode(void)
#else
int currentSfxMode()
#endif
{
	/* Return the current special effects mode */
	return modeSfx;
}

#if NeedFunctionPrototypes
int oldSfxMode(void)
#else
int oldSfxMode()
#endif
{
	/* Return the previous special effects mode */
	return oldModeSfx;
}

#if NeedFunctionPrototypes
static void resetEffect(Display *display)
#else
static void resetEffect(display)
	Display *display;
#endif
{
	/* Just re-centre window and return */
	modeSfx = SFX_NONE;
	XMoveWindow(display, playWindow, 35, 60);
}

#if NeedFunctionPrototypes
int WindowShakeEffect(Display *display, Window window)
#else
int WindowShakeEffect(display, window)
	Display *display;
	Window window;
#endif
{
	static int x = 35;
	static int y = 60;
	int xi, yi;

	/* Does the user want special effects */
	if (useSfx == False)
	{
		/* No - Just return out */
		resetEffect(display);
		return False;
	}

	/* Only shake around if the server has backing store on */
	if (DoesBackingStore(XDefaultScreenOfDisplay(display)) != Always)
	{
		resetEffect(display);
		return False;
	}

	if (frame >= sfxEndFrame) 
	{
		resetEffect(display);
		return False;
	}
	
	if ((frame % SHAKE_DELAY) != 0) return True;

	XMoveWindow(display, window, x, y);
	XFlush(display);

	xi = (rand() % 6) - 3; 
	yi = (rand() % 6) - 3; 
	x = xi + 35; y = yi + 60;

	return True;
}

#if NeedFunctionPrototypes
void SetSfxEndFrame(int endFrame)
#else
void SetSfxEndFrame(endFrame)
	int endFrame;
#endif
{
	sfxEndFrame = endFrame;
}
