#include "copyright.h"

/*
 *  Include file dependencies:
 */

#include <stdio.h>
#ifndef COHERENT
#include <stdlib.h>
#include <stddef.h>
#endif
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <xpm.h>

#include "error.h"
#include "misc.h"
#include "gun.h"
#include "main.h"
#include "init.h"
#include "inst.h"
#include "stage.h"
#include "blocks.h"
#include "special.h"
#include "ball.h"
#include "score.h"
#include "paddle.h"
#include "level.h"
#include "mess.h"
#include "audio.h"
#include "version.h"

#include "bitmaps/titleBig.xpm"

#include "bitmaps/star1.xpm"
#include "bitmaps/star2.xpm"
#include "bitmaps/star3.xpm"
#include "bitmaps/star4.xpm"
#include "bitmaps/star5.xpm"
#include "bitmaps/star6.xpm"
#include "bitmaps/star7.xpm"
#include "bitmaps/star8.xpm"
#include "bitmaps/star9.xpm"
#include "bitmaps/star10.xpm"
#include "bitmaps/star11.xpm"

#include "intro.h"

/*
 *  Internal macro definitions:
 */

#define GAP 10

/*
 *  Internal type declarations:
 */

#if NeedFunctionPrototypes
void SetIntroWait(int newMode, int waitFrame);
void DoIntroWait(void);
#else
void SetIntroWait();
void DoIntroWait();
#endif

/*
 *  Internal variable declarations:
 */

static int nextFrame = 0;
static int nextFrame2 = 0;
static int endFrame = 0;
static int startFrame = 0;
static int explodeIndex = 0;
static int explodeBlock = 0;
enum IntroStates IntroState;
Pixmap bigtitlePixmap, bigtitlePixmapM;
Pixmap stars[12], starsM[12];
static int waitingFrame, waitMode;

#if NeedFunctionPrototypes
void SetUpIntroduction(Display *display, Window window, Colormap colormap)
#else
void SetUpIntroduction(display, window, colormap)
	Display *display;
	Window window;
	Colormap colormap;
#endif
{
	XpmAttributes   attributes;
	int             XpmErrorStatus;

    attributes.valuemask = XpmColormap;
	attributes.colormap = colormap;

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, titleBig_xpm,
		&bigtitlePixmap, &bigtitlePixmapM, &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro()");

    /* Create the stars for the letter shine */
	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star1_xpm,
		&stars[0], &starsM[0], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star1)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star2_xpm,
		&stars[1], &starsM[1], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star2)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star3_xpm,
		&stars[2], &starsM[2], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star3)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star4_xpm,
		&stars[3], &starsM[3], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star4)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star5_xpm,
		&stars[4], &starsM[4], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star5)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star6_xpm,
		&stars[5], &starsM[5], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star6)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star7_xpm,
		&stars[6], &starsM[6], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star7)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star8_xpm,
		&stars[7], &starsM[7], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star8)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star9_xpm,
		&stars[8], &starsM[8], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star9)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star10_xpm,
		&stars[9], &starsM[9], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star10)");

	XpmErrorStatus = XpmCreatePixmapFromData(display, window, star11_xpm,
		&stars[10], &starsM[10], &attributes);
	HandleXPMError(display, XpmErrorStatus, "InitialiseIntro(star11)");

    /* Free the xpm pixmap attributes */
	XpmFreeAttributes(&attributes);

	ResetIntroduction();
}

#if NeedFunctionPrototypes
void DrawIntroTitle(Display *display, Window window, int x, int y)
#else
void DrawIntroTitle(display, window, x, y)
	Display *display;
	Window window;
	int x;
	int y;
#endif
{
	RenderShape(display, window, bigtitlePixmap, bigtitlePixmapM,
		x, y, 474, 74, True);
}

#if NeedFunctionPrototypes
void DoIntroTitle(Display *display, Window window)
#else
void DoIntroTitle(display, window)
	Display *display;
	Window window;
#endif
{
	char string[80];

	/* Clear and draw background pattern */
    DrawStageBackground(display, window, BACKGROUND_0);

	/* Draw the intro title bitmap XBOING */
	DrawIntroTitle(display, window, 10, 10);

	/* Construct a copyright message leaving space for the copyright circle */
	strcpy(string, "  Copyright 1993 Justin C. Kibell, All Rights Reserved");
	string[0] = 0xa9;  /* Copyright circle */
	DrawShadowCentredText(display, window, copyFont, string, 90, white, 
		PLAY_WIDTH);

	/* Be very friendly */
	SetCurrentMessage(display, messWindow, "Welcome to XBoing", False);
}

#if NeedFunctionPrototypes
static void DoBlocks(Display *display, Window window)
#else
static void DoBlocks(display, window)
	Display *display;
	Window window;
#endif
{
	int y = 120;
	int x = 40;

	/* Now draw the blocks on the screen */
	DrawTheBlock(display, window, x, y, RED_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- 100 points", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, BLUE_BLK, 0);	
	DrawShadowText(display, window, textFont, 
		"- 110 points", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, GREEN_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- 120 points", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, TAN_BLK, 0);	
	DrawShadowText(display, window, textFont, 
		"- 130 points", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, YELLOW_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- 140 points", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, PURPLE_BLK, 0);	
	DrawShadowText(display, window, textFont, 
		"- 150 points", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, BULLET_BLK, 0);	
	DrawShadowText(display, window, textFont, 
		"- Ammunition", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+5, y-5, HYPERSPACE_BLK, 0);	
	DrawShadowText(display, window, textFont, 
		"- Teleport", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+5, y+5, REVERSE_BLK, 0);	
	DrawShadowText(display, window, textFont, 
		"- Reverse Control", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+5, y+5, MGUN_BLK, 0);	
	DrawShadowText(display, window, textFont, 
		"- Machine Gun", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, MULTIBALL_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- Multi Balls", x + 60, y, green);
	y += 40;

	/* New line from top again on right */
	y = 120;
	x = 260;

	DrawTheBlock(display, window, x+5, y, BONUS_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- 3000 points", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, COUNTER_BLK, 5);
	DrawShadowText(display, window, textFont, 
		"- 200 points", x + 60, y, green);
	y += 40;

	DrawTheBall(display, window, x + 20, y+10, 0); 
	DrawShadowText(display, window, textFont, 
		"- The Ball!", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x, y, BLACK_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- Solid wall", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+9, y, BOMB_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- Bomb!", x + 60, y, green);
	y += 40;

	DrawPaddle(display, window, x+20, y, PADDLE_SMALL);
	DrawShadowText(display, window, textFont, 
		"- The Paddle", x + 60, y, green);
	y += 40;

	DrawTheBullet(display, window, x+20, y+5);
	DrawShadowText(display, window, textFont, 
		"- Bullet", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+8, y, DEATH_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- Instant Death!", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+10, y, EXTRABALL_BLK, 1);
	DrawShadowText(display, window, textFont, 
		"- Extra Ball", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+10, y, WALLOFF_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- Walls Off", x + 60, y, green);
	y += 40;

	DrawTheBlock(display, window, x+10, y - 5, STICKY_BLK, 0);
	DrawShadowText(display, window, textFont, 
		"- Sticky Ball", x + 60, y, green);
	y += 40;
}

#if NeedFunctionPrototypes
static void DoText(Display *display, Window window)
#else
static void DoText(display, window)
	Display *display;
	Window window;
#endif
{
	char string[80];
	int y;

	y = PLAY_HEIGHT - 27;

	strcpy(string, "Press <Space> to start the game.");
	DrawShadowCentredText(display, window, textFont, 
		string, y, tann, PLAY_WIDTH);
}

#if NeedFunctionPrototypes
static void DoSparkle(Display *display, Window window)
#else
static void DoSparkle(display, window)
	Display *display;
	Window window;
#endif
{
	static Pixmap store;
	static int x = 100;
	static int y = 20;
	static int in = 0;

	if (!store)
	{
		store = XCreatePixmap(display, window, 20, 20,
			DefaultDepth(display, XDefaultScreen(display)));
	}

	if (in == 0) 
		XCopyArea(display, window, store, gc, x, y, 20, 20, 0, 0);

	if (frame == startFrame)
	{
		RenderShape(display, window, stars[in], starsM[in],
			x, y, 20, 20, False);

	 	in++;
		startFrame = frame + 15;

		if (in == 11) 
		{
			XCopyArea(display, store, window, gc, 0, 0, 20, 20, x, y);
			in = 0;
			startFrame = frame + 500;
			x = (rand() % 474) + 5;
			y = (rand() % 74) + 5;
		}	
	}
}

#if NeedFunctionPrototypes
static void DoExplodeLeft(Display *display, Window window)
#else
static void DoExplodeLeft(display, window)
	Display *display;
	Window window;
#endif
{
	int y = 120;
	int x = 40;

	if (frame == endFrame) IntroState = INTRO_FINISH;

	if (frame == nextFrame)
	{
		if (explodeIndex == 0 && explodeBlock != 0)
			DrawTheBlock(display, window, x, 
				y + ((explodeBlock-1) * 40), explodeBlock-1, 0);

		if (explodeIndex == 0 && explodeBlock == 0)
			DrawTheBlock(display, window, x, y + (6 * 40), 6, 0);

		ExplodeBlockType(display, window, x,
			y + (explodeBlock * 40), explodeBlock, explodeIndex);
			
		explodeIndex++;
		nextFrame = frame + 10;
		if (explodeIndex == 3) 
		{
			XClearArea(display, window, x, 
				y + (explodeBlock * 40), 40, 30, False);
			explodeIndex = 0; 
			explodeBlock++;
			if (explodeBlock == 7) explodeBlock = 0;
			nextFrame += 200;
		}
	}
}

#if NeedFunctionPrototypes
static void DoExplodeRight(Display *display, Window window)
#else
static void DoExplodeRight(display, window)
	Display *display;
	Window window;
#endif
{
	int x = 260;
	int y = 120;
	static int slide = 0;

	if (frame == nextFrame2)
	{
		if (slide == 4) slide = 0;

		DrawTheBlock(display, window, x+5, y, BONUS_BLK, slide);
		DrawTheBlock(display, window, x, y + 40, COUNTER_BLK, slide);
		DrawTheBall(display, window, x + 20, y + 90, slide);
		DrawTheBlock(display, window, x+8, y + 280, DEATH_BLK, slide);

		if (slide == 3)
			DrawTheBlock(display, window, x+9, y + 160, BOMB_BLK, 0);
		else
			ExplodeBlockType(display, window, x+9, y+160, BOMB_BLK, slide);

		nextFrame2 += 90;
		slide++;
	}
}

#if NeedFunctionPrototypes
static void DoFinish(Display *display, Window window)
#else
static void DoFinish(display, window)
	Display *display;
	Window window;
#endif
{
	ResetInstructions();
	mode = MODE_INSTRUCT;

	if (noSound == False)
		playSoundFile("weeek", 100);
}

#if NeedFunctionPrototypes
void Introduction(Display *display, Window window)
#else
void Introduction(display, window)
	Display *display;
	Window window;
#endif
{
	switch (IntroState)
	{
		case INTRO_TITLE:
			DoIntroTitle(display, window);
			IntroState = INTRO_BLOCKS;
			break;

		case INTRO_BLOCKS:
			DoBlocks(display, window);
			IntroState = INTRO_TEXT;
			break;

		case INTRO_TEXT:
			DoText(display, window);
			IntroState = INTRO_EXPLODE;
			break;

		case INTRO_EXPLODE:
			DoExplodeLeft(display, window);
			DoExplodeRight(display, window);
			DoSparkle(display, window);
			if ((frame % FLASH) == 0)
				RandomDrawSpecials(display);
			break;

		case INTRO_FINISH:
			DoFinish(display, window);
			break;

		case INTRO_WAIT:
			DoIntroWait();
			break;

		default:
			break;
	}
}

#if NeedFunctionPrototypes
void RedrawIntroduction(Display *display, Window window)
#else
void RedrawIntroduction(display, window)
	Display *display;
	Window window;
#endif
{
	DoIntroTitle(display, window);
	DoBlocks(display, window);
	DoText(display, window);
	DoExplodeLeft(display, window);
	DoExplodeRight(display, window);
}

#if NeedFunctionPrototypes
void FreeIntroduction(Display *display)
#else
void FreeIntroduction(display)
	Display *display;
#endif
{
	int i;

	for (i = 0; i < 10; i++)
	{
    	if (stars[i])	XFreePixmap(display, stars[i]);         
    	if (starsM[i])	XFreePixmap(display, starsM[i]);         
	}

    if (bigtitlePixmap)		XFreePixmap(display, bigtitlePixmap);         
	if (bigtitlePixmapM)	XFreePixmap(display, bigtitlePixmapM);
}

#if NeedFunctionPrototypes
void ResetIntroduction(void)
#else
void ResetIntroduction()
#endif
{
	IntroState = INTRO_TITLE;
	explodeIndex = 0;
	explodeBlock = 0;
	nextFrame = frame + 10;
	nextFrame2 = frame + 10;
	startFrame = frame + 10;
	endFrame = frame + 3000;
}

#if NeedFunctionPrototypes
void SetIntroWait(int newMode, int waitFrame)
#else
void SetIntroWait(newMode, waitFrame)
	int newMode;
	int waitFrame;
#endif
{
	waitingFrame = waitFrame;
	waitMode = newMode;
	IntroState = INTRO_WAIT;
}

#if NeedFunctionPrototypes
void DoIntroWait(void)
#else
void DoIntroWait()
#endif
{
	if (frame == waitingFrame)
		IntroState = waitMode;
}
