#ifndef _HIGHSCORE_H_
#define _HIGHSCORE_H_

#include "copyright.h"

/*
 *  Dependencies on other include files:
 */

#include <X11/Xlib.h>
#include <sys/time.h>

/*
 *  Constants and macros:
 */

#define PERSONAL 	1
#define GLOBAL 		2

/*
 *  Type declarations:
 */

#ifndef ULONG
#define ULONG 1
typedef unsigned long u_long;
#endif

enum HighScoreStates 
{ 
	HIGHSCORE_TITLE, 
	HIGHSCORE_SHOW, 
	HIGHSCORE_WAIT, 
	HIGHSCORE_SPARKLE, 
	HIGHSCORE_FINISH
};

typedef struct 
{
	u_long score;
	u_long level;
	time_t gameTime;
	time_t time;
	char name[40];
} highScoreEntry;

/*
 *  Function prototypes:
 */

#if NeedFunctionPrototypes
void SetUpHighScore(Display *display, Window window, Colormap colormap);
void HighScore(Display *display, Window window);
void RedrawHighScore(Display *display, Window window);
void FreeHighScore(Display *display);
void ResetHighScore(int type);
int ReadHighScoreTable(int type);
int WriteHighScoreTable(int type);
int CheckAndAddScoreToHighScore(u_long score, u_long level, time_t gameTime, 
	int type);
int GetHighScoreRanking(u_long score);
void CommandlineHighscorePrint(void);
#else
void CommandlineHighscorePrint();
void SetUpHighScore();
void HighScore();
void RedrawHighScore();
void FreeHighScore();
void ResetHighScore();
int ReadHighScoreTable();
int WriteHighScoreTable();
int CheckAndAddScoreToHighScore();
int GetHighScoreRanking();
#endif

extern enum HighScoreStates HighScoreState;

#endif
