.\" @(#)spider.man 2.2 90/05/30; Copyright (c) 1990 - David Lemke & Network Computing Devices Inc
.TH spider 1 "30 Jan 1990"
.SH NAME
spider \- play double deck solitaire

.SH SYNOPSIS
.B spider
[
.BI \-save_file " filename"
]
[
.BI \- toolkitoption ...
]
.SH DESCRIPTION
.I spider
is a particularly challenging double-deck solitaire.  Unlike most
solitaires, it provides extraordinary opportunities for the skillful player
to overcome bad luck in the deal by means of careful analysis and complex
manipulations.  The
.I spider
program does not actually play the game for you,
but rather takes the place of the cards (by displaying the tableau on the
screen) and keeping a record of the game so that you can follow out long
lines of play without losing track of where you started from.
.LP
.I spider
when compiled with XView has a property sheet for defining resources.
The property sheet is on the "File" menu item.  To be sure spot help is
active, set the environment variable HELPDIR for XView version 1.0.1 or
HELPPATH for XView version 2.0 or later to the directory containing
the spider.info file.  See spot help on the property sheet for more details.
.SH OPTIONS
.TP 5
.BI \-save_file " filename"
Start up using the specified save file.
.SH RESOURCES
.I spider
understands all of the core X Toolkit resource names and classes as well as:
.TP 8
.B "bell (\fPclass\fB Bell)"
Boolean which specifies whether 
.I spider
will use the bell to when complaining about illegal moves.  The default
is "true".
.TP 8
.B "confirm (\fPclass\fB Confirm)"
Boolean which specifies whether 
.I spider
will use ask for confirmation before certain actions.  The default
is "true".
.TP 8
.B "replayTime (\fPclass\fB ReplayTime)"
Specifies the time (in microseconds) to pause between each move when
showing a Replay.  The default is 200.
.TP 8
.B "roundsCards (\fPclass\fB RoundCards)"
Specifies whether to use rounded cards are not.  Rounded cards look
better, but are considerably slower.  The default is "on".
.TP 8
.B "deltaMod (\fPclass\fB DeltaMod)"
Specifies the interval at which to recalulate the inter-card spacing.
The default is 1, which means the card stacks are resized every time
they grow or shrink when when they near the bottom of the table.
Setting this to a higher value will cut down on the number of redraws
by limiting visibility when its unnecessary.
.TP 8
.B "squish" (\fPclass\fB Squish)"
Specifies whether to use a different card layout that saves on
screen space but can also be somewhat confusing.  The default
is "off".
.TP 8
.B "helpDir (\fPclass\fB HelpDir)"
Specifies where to look for the help files.
.SH "SEE ALSO"
    xsol(1)
.SH COPYRIGHT
Copyright (c) 1990 by David Lemke & Network Computing Devices, Inc.
.br
(lemke@ncd.com)
.sp 1
Copyright 1990 Heather Rose and Sun Microsystems, Inc.
.sp 1
Copyright (c) 1989, Donald R. Woods and Sun Microsystems, Inc.


Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. 
