/* This program is Copyright (c) 1991 David Allen.  It may be freely
   distributed as long as you leave my name and copyright notice on it.
   I'd really like your comments and feedback; send e-mail to
   allen@viewlogic.com, or send us-mail to David Allen, 10 O'Moore
   Avenue, Maynard, MA 01754. */

/* This file contains a spinning globe animation */

#include "const.h"
#define N ((MAXX / 2) - 1)
#define AREA (MAXX * MAXX)
#define RADIUS 45
#define PI 3.14159
#define TWOPI (2.0 * PI)
#define HALFPI (PI / 2.0)
#define SET(n,x,y,i,j) m[n][(x)+N][(y)+N] = m[0][(i)+N][(j)+N]

unsigned char m[21][MAXX][MAXY];
int rx[] = {0, 0, 0, 0, 0}, ry[] = {0, N, 0, N, 0};
int xofs, prime, xflip, sflip, sxflip, change[1], step = 0;
int MAXSTEP = 10000, PRINTMODE = PRINTMODE_SCALE, XSIZE = MAXX, YSIZE = MAXX;
int ZCOAST = 0;


init (s) char *s; { int i;
   fileinit ();
   if (!s || !(*s)) panic ("no valid filename"); else getparams (s);
   for (i=1, xofs=45; i<6; xofs-=10, i++) {
      prime = 16-i; xflip = i+5;  sflip = 15+i; sxflip = 6-i; compute (); } }


onestep () { static int i = 0;
   draw (DRAW_TEC, LINE_NONE, m[i], 0); i++; step++;
   if (i == 5) i = 6; if (i == 16) i = 17; if (i == 21) i = 1; }


mainpar (s) char *s; { int vec [AREA], index = AREA; register int i, j, k;

   if (CMP ("LAND")) {
      getlvec (&index, vec, 0);
      for (k=0, j=0; j<MAXX; j++) for (i=0; i<MAXX; i++, k++)
         m[0][i][j] = (vec[k] > 16) ? vec[k] : 16;
      return (1); }
   return (0); }


compute () {
   register int i, j, top; int x, y;

   rx[0] = xofs + N; rx[4] = rx[0]; rx[2] = xofs - N;
   for (j=0; j<RADIUS; j++) {
      checkmouse ();
      top = sqrt ((double) (RADIUS * RADIUS - j * j + 0.5));
      for (i=1-top; i<top; i++) {
         point (i, j, &x, &y);
         SET (prime,   i,  j,  x,  y); SET (prime,   i, -j,  x, -y);
         SET (xflip,  -i,  j, -x,  y); SET (xflip,  -i, -j, -x, -y);
         permute (x, y, &x, &y);
         SET (sxflip,  i, -j, -x,  y); SET (sxflip,  i,  j, -x, -y);
         SET (sflip,  -i, -j,  x,  y); SET (sflip,  -i,  j,  x, -y); } } }


point (x, y, i, j) int x, y, *i, *j; {
   double r, theta, topx, topy, botx, boty; int bot, top;

   r = asin (sqrt ((double)(x * x + y * y)) / RADIUS) * 2.0 / PI;
   if (x || y) theta = atan2 ((double)y, (double)x);
   else theta = 0;
   if (theta <= 0) theta += TWOPI;
   bot = 0; while (theta > HALFPI) { bot++; theta -= HALFPI; }
   top = bot + 1; theta = theta / HALFPI;
   mapr (bot, r, &botx, &boty); mapr (top, r, &topx, &topy);
   *i = botx + theta * (topx - botx) + 0.5;
   *j = boty + theta * (topy - boty) + 0.5;
   if (*i >= N) *i = N-1; if (*j >= N) *j = N-1; }


mapr (n, r, x, y) int n; double r, *x, *y; {
   *x = r * (rx[n] - xofs) + xofs;
   *y = r * ry[n];
   if (*x >= N) { *y = *x - N; *x = N; if (n == 4) *y = -(*y); } }


permute (x, y, i, j) int x, y, *i, *j; {
   if ((x >= 0) && (y >= 0)) { *i =  N - y - 1; *j =  x - N + 0; }
   if ((x <  0) && (y >= 0)) { *i =  y - N + 0; *j = -N - x - 1; }
   if ((x >= 0) && (y <  0)) { *i =  y + N + 0; *j =  N - x - 1; }
   if ((x <  0) && (y <  0)) { *i = -N - y - 1; *j =  x + N + 0; } }


greyscale (x) int x; { }
