/*
 *      (c) Copyright 1989 Sun Microsystems, Inc. Sun design patents
 *      pending in the U.S. and foreign countries. See LEGAL_NOTICE
 *      file for terms of the license.
 */

#ident	"@(#)usleep.c	26.8	91/09/14 SMI"

/*
 * usleep() compatibility function
 *
 * Under System V, implements usleep() using the interval timer.  Otherwise,
 * simply calls the library's usleep().  To use this implementation instead of
 * the library's, you must define SYSV.  If you want to this implementation
 * to use BSD-style signals, you must define SYS *and* USE_BSD_SIGNALS, even 
 * if you're not on System V.
 */

#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/time.h>

#ifdef COH42
#include <misc.h>
#endif

void olwm_do_nothing() { }

int
olwm_usleep(usec)
	unsigned int usec;
{
  struct timeval timeout;
  if(usec == 0) 
    return;
  timeout.tv_sec = usec / 1000000;
  timeout.tv_usec = usec - 1000000 * timeout.tv_sec;
  select(1, NULL, NULL, NULL, &timeout);
}
