/*
 * x11.h
 * kirk johnson
 * october 1990
 */

#ifndef _X11_H_
#define _X11_H_

#define TileSize   (20)
#define MainCurs   (XC_dot)
#define BoardCurs  (XC_crosshair)

#define HighScoreTitle    "mosaic high scores"

#define MainWindowName    "mosaic"
#define ScoresWindowName  "mosaic scores"

#define DfltGutterWidth  (2)
#define DfltBorderWidth  (1)
#define DfltForeName     "white"
#define DfltBackName     "black"
#define DfltBrdrName     "white"
#define DfltC0Name       "white"
#define DfltC1Name       "#c44"
#define DfltC2Name       "#4c4"
#define DfltC3Name       "#44c"
#define DfltFontName     "-*-times-bold-r-*-*-*-180-*-*-*-*-*-*"

static char solidbits[] =	/* solid fill */
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
};

static char zerobits[] =	/* one small dot */
{
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

static char onebits[] =		/* diagonal hashing */
{
  0x88, 0x88, 0x08, 0x44, 0x44, 0x04, 0x22, 0x22, 0x02, 0x11, 0x11, 0x01,
  0x88, 0x88, 0x08, 0x44, 0x44, 0x04, 0x22, 0x22, 0x02, 0x11, 0x11, 0x01,
  0x88, 0x88, 0x08, 0x44, 0x44, 0x04, 0x22, 0x22, 0x02, 0x11, 0x11, 0x01,
  0x88, 0x88, 0x08, 0x44, 0x44, 0x04, 0x22, 0x22, 0x02, 0x11, 0x11, 0x01,
  0x88, 0x88, 0x08, 0x44, 0x44, 0x04, 0x22, 0x22, 0x02, 0x11, 0x11, 0x01,
};

static char twobits[] =		/* criss-cross */
{
  0x00, 0x00, 0x00, 0x04, 0x10, 0x00, 0xc4, 0x11, 0x07, 0x04, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x02, 0x8e, 0x38, 0x02,
  0x80, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x10, 0x00,
  0xc4, 0x11, 0x07, 0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x00, 0x02, 0x8e, 0x3c, 0x02, 0x80, 0x00, 0x02, 0x00, 0x00, 0x00,
};

static char threebits[] =	/* bricks */
{
  0x04, 0x10, 0x00, 0x04, 0x10, 0x00, 0xff, 0xff, 0x0f, 0x80, 0x00, 0x02,
  0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0xff, 0xff, 0x0f,
  0x04, 0x10, 0x00, 0x04, 0x10, 0x00, 0x04, 0x10, 0x00, 0x04, 0x10, 0x00,
  0xff, 0xff, 0x0f, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02, 0x80, 0x00, 0x02,
  0x80, 0x00, 0x02, 0xff, 0xff, 0x0f, 0x04, 0x10, 0x00, 0x04, 0x10, 0x00,
};

#endif /* _X11_H_ */
