.TH mosaic 6 "22 January 1991"
.SH NAME
mosaic
.SH SYNOPSIS
mosaic [-options ...] 
.SH DESCRIPTION
.I Mosaic
is a simple adaption to X of the PC/MS-DOS game of the same name. 
.sp
.I Mosaic
is played with a set of 81 two-by-two tiles on a 24-by-24 playing
area. The objective of the game is to place your tiles such that
squares of the same pattern (color) are connected as much as possible. 
.sp
For the purposes of scoring, similarly patterned squares are connected
only if they share a side; touching diagonally on a corner doesn't
count. 
.sp
Each of the 81 tiles is composed of four patterned squares. No two
tiles are the same, and each comes up once a game, in random order. 
.SH "HOW TO PLAY"
When playing
.I mosaic,
the next tile you have to play is shown in a two-by-two window in the
upper right corner of the
.I mosaic
window. By moving the mouse pointer in the playing area window, you
control where that tile will be placed, as indicated by the outline
which tracks the mouse pointer. To place the piece, press any mouse
button. 
.sp
While playing, the following key commands are available:
.TP 4
.B q
Quit
.I mosaic
.TP 4
.B s
Show (or hide, if it's already visible) the high scores window
.TP 4
.B h
Help - show (or hide, if it's already visible) the help window. When
the help window is visible, no pieces may be placed.
.TP 4
.B n
New game (only enabled when the current game is completed)
.TP 4
.B a
Automatic - randomly place any remaining tiles
.SH SCORING
After you place each tile,
.I mosaic
identifies all the connected regions of similarly patterned squares. 
Each region then scores according to the square of the number of
squares in the region. 
.sp
.I Mosaic
displays the total score, the total score broken down by pattern, and
the amount those scores were improved by the most recently played
piece. 
.SH OPTIONS
.TP 8
.B \-help
Prints a brief help message. 
.TP 8
.B "\-display \fIdisplay\fP"
Specifies the name of the X server to contact. 
.TP 8
.B \-expert
By default,
.I mosaic
shows a "quick help" window upon startup. When this flag is used, the
"quick help" window is not shown initially.
.TP 8
.B \-color
Causes
.I mosaic
to run in color mode (the default, except when using StaticGray and
GrayScale visuals).
.TP 8
.B \-mono
Causes
.I mosaic
to run in monochrome mode. When in monochrome mode, only the
foreground (\-fg) and background (\-bg) colors are used (the default
when using StaticGray and GrayScale visuals).
.TP 8
.B \-patterns
Causes
.I mosaic
to use patterned tiles (the default).
.TP 8
.B \-solid
Causes
.I
mosaic
to use unpatterned (solid color) tiles. Probably not a good idea if
you're running in monochrome mode.
.TP 8
.B "\-gw \fInumber\fP"
Specifies the gutter width (in pixels).
.TP 8
.B "\-bw \fInumber\fP"
Specifies the border width (in pixels);
.TP 8
.B "\-fg \fIcolor\fP"
Specifies the foreground color. 
.TP 8
.B "\-bg \fIcolor\fP"
Specifies the background color.
.TP 8
.B "\-bd \fIcolor\fP"
Specifies the border color.
.TP 8
.B "\-c0 \fIcolor\fP"
.TP 8
.B "\-c1 \fIcolor\fP"
.TP 8
.B "\-c2 \fIcolor\fP"
.TP 8
.B "\-c3 \fIcolor\fP"
Specifies the colors used to draw the background and tiles in the
playing area.
.TP 8
.B "\-fn \fIfont\fP"
Specifies the font used for displaying text.
.SH "X DEFAULTS"
.TP 8
.B "Mono (type: boolean)"
Specifies that
.I mosaic
should run in monochrome mode. The default is False.
.TP 8
.B "Expert (type: boolean)"
When true, specifies that the "quick help" window should not be shown
upon startup. The default is False.
.TP 8
.B "Solid (type: boolean)"
Specifies that
.I mosaic
should use unpatterned (solid color) tiles. The default is False.
.TP 8
.B "GutterWidth (type: number)"
Specifies the gutter width (in pixels).
.TP 8
.B "BorderWidth (type: number)"
Specifies the border width (in pixels).
.TP 8
.B "Foreground (type: color)"
Specifies the foreground color. The default is \fIwhite\fP.
.TP 8
.B "Background (type: color)"
Specifies the background color. The default is \fIblack\fP.
.TP 8
.B "BorderColor (type: color)"
Specifies the border color. The default is \fIwhite\fP.
.TP 8
.B "Color0 (type: color)"
Specifies tile color zero. The default is \fIwhite\fP.
.TP 8
.B "Color1 (type: color)"
Specifies tile color one. The default is \fI#c44\fP.
.TP 8
.B "Color2 (type: color)"
Specifies tile color two. The default is \fI#4c4\fP.
.TP 8
.B "Color3 (type: color)"
Specifies tile color three. The default is \fI#44c\fP.
.TP 8
.B "Font (type: color)"
Specifes the font used for displaying text. The default is
\fI-*-times-bold-r-*-*-*-180-*-*-*-*-*-*\fP.
.SH AUTHOR
.I Mosaic
was written by Kirk Johnson <tuna@athena.mit.edu>. It is based on
Joshua Klayman's PC/MS-DOS shareware game of the same name. This
version is a complete rewrite encompasing only the basic
functionality of the original.
.sp
Bug reports and suggestions are welcome.
