/*
 * mosaic.h
 * kirk johnson
 * october 1990
 */

#ifndef _MOSAIC_H_
#define _MOSAIC_H_

#include <stdio.h>

/* #define DEBUG */

#define AppName   "mosaic"

#define BoardSize (24)		/* width, in tiles */
#define NPieces   (81)		/* # pieces per game */

#define NTiles (BoardSize*BoardSize)

#define MaxUnameLen  (8)	/* eight chars per uname, max */
#define MaxScoreLen  (5)	/* five chars per score, max */
#define NHighScores  (10)	/* # of high scores kept */
#define NHelpLines   (10)	/* # of lines in help window */

#define MaxPossibleScore  "34992"


typedef unsigned short Word;

typedef struct
{
  char uname[MaxUnameLen+1];	/* username */
  int  score;			/* score */
} NameAndScore;

extern void InitGame();
extern void QuitGame();
extern int  DropPiece();
extern void UpdateAndScore();
extern void PossiblyMerge();
extern void AutoPlay();
extern void ReadHighScores();
extern void WriteHighScores();
extern void ReadHighScores();
extern void CheckHighScore();

extern void InitDisplay();
extern void MainLoop();
extern void drawBoard();
extern void drawHelp();
extern void drawTile();
extern void drawController();
extern void drawNext();
extern void drawTitle();
extern void drawScore();
extern void drawHighScores();
extern void drawAll();

extern Word tile[NTiles];	/* the board */
extern Word piece[NPieces];	/* the "deck" of pieces */
extern Word nextpiece;		/* index into the deck */

extern Word tscore[3];		/* total score */
extern Word pscore[3];		/* last piece score */
extern Word remain[3];		/* tiles remaining */

extern NameAndScore highscore[NHighScores];

#endif /* _MOSAIC_H_ */
