/*
 * slidehuf.h -- part of LHa for UNIX
 *
 *	modified: Dec. 5, 1991, Masaru Oki.
 */

#include <stdio.h>
#include <errno.h>

#ifdef __STDC__
#include <limits.h>
#else
#ifndef CHAR_BIT
#define CHAR_BIT  8
#endif
#ifndef UCHAR_MAX
#define UCHAR_MAX ((1<<(sizeof(unsigned char)*8))-1)
#endif
#ifndef USHRT_MAX
#define USHRT_MAX ((1<<(sizeof(unsigned short)*8))-1)
#endif
#ifndef SHRT_MAX
#define SHRT_MAX ((1<<(sizeof(short)*8-1))-1)
#endif
#ifndef SHRT_MIN
#define SHRT_MIN (SHRT_MAX-USHRT_MAX)
#endif
#endif /* not __STDC__ */

/* #include "errmes.h" */
/* Your C-Compiler has no 'void' (from lharc.h) */
#ifndef __STDC__  /* NO_VOID */
#define void
#endif

struct encode_option {
#ifdef __STDC__
	void (*output)();
	void (*encode_start)();
	void (*encode_end)();
#else
	int (*output)();
	int (*encode_start)();
	int (*encode_end)();
#endif
};

struct decode_option {
	unsigned short (*decode_c)();
	unsigned short (*decode_p)();
#ifdef __STDC__
	void (*decode_start)();
#else
	int (*decode_start)();
#endif
};

/* from slide.c */
#define MAX_DICBIT    13 
#define MAX_DICSIZ (1 << MAX_DICBIT)
#define MATCHBIT   8    /* bits for MAXMATCH - THRESHOLD */
#define MAXMATCH 256    /* formerly F (not more than UCHAR_MAX + 1) */
#define THRESHOLD  3    /* choose optimal value */

extern int errno;
extern int unpackable;
extern unsigned long origsize, compsize;
extern unsigned short dicbit;
extern unsigned short maxmatch;
extern unsigned long count;
extern unsigned short loc;
extern unsigned char *text;

/* from huf.c */
#define NC (UCHAR_MAX + MAXMATCH + 2 - THRESHOLD)
			/* alphabet = {0, 1, 2, ..., NC - 1} */
#define CBIT 9  /* $\lfloor \log_2 NC \rfloor + 1$ */
#define USHRT_BIT 16	/* (CHAR_BIT * sizeof(ushort)) */

extern unsigned short	left[], right[];
extern unsigned char	c_len[], pt_len[];
extern unsigned short	c_freq[], c_table[], c_code[],
			p_freq[], pt_table[], pt_code[],
			t_freq[];

void output_st1();
unsigned char *alloc_buf(void);
void encode_start_st1(void);
void encode_end_st1(void);
unsigned short decode_c_st1(void);
unsigned short decode_p_st1(void);
void decode_start_st1(void);

/* from shuf.c */
void decode_start_st0(void);
void encode_p_st0(/*unsigned short j*/);
void encode_start_fix(void);
void decode_start_fix(void);
unsigned short decode_c_st0(void);
unsigned short decode_p_st0(void);

/* from dhuf.c */
extern unsigned int n_max;

void start_c_dyn(void);
void decode_start_dyn(void);
unsigned short decode_c_dyn(void);
unsigned short decode_p_dyn(void);
void output_dyn(/*int code, unsigned int pos*/);
void encode_end_dyn(void);

/* from larc.c */
unsigned short decode_c_lzs(void);
unsigned short decode_p_lzs(void);
unsigned short decode_c_lz5(void);
unsigned short decode_p_lz5(void);
void decode_start_lzs(void);
void decode_start_lz5(void);

/* from maketbl.c */
/* void make_table(short nchar, uchar bitlen[],
		   short tablebits, ushort table[]); */
void make_table(/*int nchar, uchar bitlen[],
		int tablebits, ushort table[]*/);

/* from maketree.c */
/* void make_code(short n, uchar len[], ushort code[]);
short make_tree(short nparm, ushort freqparm[], 
                uchar lenparm[], ushort codeparam[]); */
void make_code(/*int n, uchar len[], ushort code[]*/);
short make_tree(/*int nparm, ushort freqparm[], 
                uchar lenparm[], ushort codeparam[]*/);

/* from crcio.c */
extern FILE *infile, *outfile;
extern unsigned short crc, bitbuf;
extern int dispflg;

void make_crctable(void);
unsigned short calccrc(/*uchar *p, uint n*/);
void fillbuf(/*uchar n*/);
unsigned short getbits(/*uchar n*/);
void putcode(/*uchar n, ushort x*/);
void putbits(/*uchar n, ushort x*/);
int fread_crc(/*uchar *p, int n, FILE *f*/);
void fwrite_crc(/*uchar *p, int n, FILE *f*/);
void init_getbits(void);
void init_putbits(void);
